drop database lportal;
create database lportal pagesize 32768 temporary tablespace managed by automatic storage;
connect to lportal;
create table Address (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	externalReferenceCode varchar(75),
	addressId bigint not null,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	classNameId bigint,
	classPK bigint,
	countryId bigint,
	listTypeId bigint,
	regionId bigint,
	city varchar(75),
	description varchar(4000),
	latitude double,
	longitude double,
	mailing smallint,
	name varchar(255),
	primary_ smallint,
	street1 varchar(255),
	street2 varchar(255),
	street3 varchar(255),
	validationDate timestamp,
	validationStatus integer,
	zip varchar(75),
	primary key (addressId, ctCollectionId)
);

create table AnnouncementsDelivery (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	deliveryId bigint not null,
	companyId bigint,
	userId bigint,
	type_ varchar(75),
	email smallint,
	sms smallint,
	website smallint,
	primary key (deliveryId, ctCollectionId)
);

create table AnnouncementsEntry (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	entryId bigint not null,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	classNameId bigint,
	classPK bigint,
	title varchar(75),
	content clob,
	url varchar(4000),
	type_ varchar(75),
	displayDate timestamp,
	expirationDate timestamp,
	priority integer,
	alert smallint,
	primary key (entryId, ctCollectionId)
);

create table AnnouncementsFlag (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	flagId bigint not null,
	companyId bigint,
	userId bigint,
	createDate timestamp,
	entryId bigint,
	value integer,
	primary key (flagId, ctCollectionId)
);

create table AssetCategory (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	externalReferenceCode varchar(75),
	categoryId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	parentCategoryId bigint,
	treePath varchar(4000),
	name varchar(255),
	title clob,
	description clob,
	vocabularyId bigint,
	lastPublishDate timestamp,
	primary key (categoryId, ctCollectionId)
);

create table AssetEntries_AssetTags (
	companyId bigint not null,
	entryId bigint not null,
	tagId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType smallint,
	primary key (entryId, tagId, ctCollectionId)
);

create table AssetEntry (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	entryId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	classNameId bigint,
	classPK bigint,
	classUuid varchar(75),
	classTypeId bigint,
	listable smallint,
	visible smallint,
	startDate timestamp,
	endDate timestamp,
	publishDate timestamp,
	expirationDate timestamp,
	mimeType varchar(75),
	title clob,
	description clob,
	summary clob,
	url varchar(4000),
	layoutUuid varchar(75),
	height integer,
	width integer,
	priority double,
	primary key (entryId, ctCollectionId)
);

create table AssetTag (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	tagId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	name varchar(75),
	assetCount integer,
	lastPublishDate timestamp,
	primary key (tagId, ctCollectionId)
);

create table AssetVocabulary (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	externalReferenceCode varchar(75),
	vocabularyId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	name varchar(75),
	title varchar(4000),
	description varchar(4000),
	settings_ varchar(4000),
	visibilityType integer,
	lastPublishDate timestamp,
	primary key (vocabularyId, ctCollectionId)
);

create table BrowserTracker (
	mvccVersion bigint default 0 not null,
	browserTrackerId bigint not null primary key,
	companyId bigint,
	userId bigint,
	browserKey bigint
);

create table ClassName_ (
	mvccVersion bigint default 0 not null,
	classNameId bigint not null primary key,
	value varchar(200)
);

create table Company (
	mvccVersion bigint default 0 not null,
	companyId bigint not null primary key,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	webId varchar(75),
	mx varchar(200),
	homeURL varchar(4000),
	logoId bigint,
	maxUsers integer,
	active_ smallint,
	name varchar(75),
	legalName varchar(75),
	legalId varchar(75),
	legalType varchar(75),
	sicCode varchar(75),
	tickerSymbol varchar(75),
	industry varchar(75),
	type_ varchar(75),
	size_ varchar(75),
	indexNameCurrent varchar(75),
	indexNameNext varchar(75)
);

create table CompanyInfo (
	mvccVersion bigint default 0 not null,
	companyInfoId bigint not null primary key,
	companyId bigint,
	key_ clob
);

create table Contact_ (
	mvccVersion bigint default 0 not null,
	contactId bigint not null primary key,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	classNameId bigint,
	classPK bigint,
	parentContactId bigint,
	emailAddress varchar(254),
	firstName varchar(75),
	middleName varchar(75),
	lastName varchar(75),
	prefixListTypeId bigint,
	suffixListTypeId bigint,
	male smallint,
	birthday timestamp,
	smsSn varchar(75),
	facebookSn varchar(75),
	jabberSn varchar(75),
	skypeSn varchar(75),
	twitterSn varchar(75),
	employeeStatusId varchar(75),
	employeeNumber varchar(75),
	jobTitle varchar(100),
	jobClass varchar(75),
	hoursOfOperation varchar(75)
);

create table Counter (
	name varchar(150) not null primary key,
	currentId bigint
);

create table Country (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	defaultLanguageId varchar(75),
	countryId bigint not null,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	a2 varchar(75),
	a3 varchar(75),
	active_ smallint,
	billingAllowed smallint,
	groupFilterEnabled smallint,
	idd_ varchar(75),
	name varchar(75),
	number_ varchar(75),
	position double,
	shippingAllowed smallint,
	subjectToVAT smallint,
	zipRequired smallint,
	lastPublishDate timestamp,
	primary key (countryId, ctCollectionId)
);

create table CountryLocalization (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	countryLocalizationId bigint not null,
	companyId bigint,
	countryId bigint,
	languageId varchar(75),
	title varchar(75),
	primary key (countryLocalizationId, ctCollectionId)
);

create table DLFileEntry (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	externalReferenceCode varchar(75),
	fileEntryId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	classNameId bigint,
	classPK bigint,
	repositoryId bigint,
	folderId bigint,
	treePath varchar(4000),
	name varchar(255),
	fileName varchar(255),
	extension varchar(75),
	mimeType varchar(75),
	title varchar(255),
	description varchar(4000),
	extraSettings clob,
	fileEntryTypeId bigint,
	version varchar(75),
	size_ bigint,
	smallImageId bigint,
	largeImageId bigint,
	custom1ImageId bigint,
	custom2ImageId bigint,
	manualCheckInRequired smallint,
	displayDate timestamp,
	expirationDate timestamp,
	reviewDate timestamp,
	lastPublishDate timestamp,
	primary key (fileEntryId, ctCollectionId)
);

create table DLFileEntryMetadata (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	fileEntryMetadataId bigint not null,
	companyId bigint,
	DDMStorageId bigint,
	DDMStructureId bigint,
	fileEntryId bigint,
	fileVersionId bigint,
	primary key (fileEntryMetadataId, ctCollectionId)
);

create table DLFileEntryType (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	fileEntryTypeId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	dataDefinitionId bigint,
	fileEntryTypeKey varchar(75),
	name varchar(4000),
	description varchar(4000),
	scope integer,
	lastPublishDate timestamp,
	primary key (fileEntryTypeId, ctCollectionId)
);

create table DLFileEntryTypes_DLFolders (
	companyId bigint not null,
	fileEntryTypeId bigint not null,
	folderId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType smallint,
	primary key (fileEntryTypeId, folderId, ctCollectionId)
);

create table DLFileShortcut (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	fileShortcutId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	repositoryId bigint,
	folderId bigint,
	toFileEntryId bigint,
	treePath varchar(4000),
	active_ smallint,
	lastPublishDate timestamp,
	status integer,
	statusByUserId bigint,
	statusByUserName varchar(75),
	statusDate timestamp,
	primary key (fileShortcutId, ctCollectionId)
);

create table DLFileVersion (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	fileVersionId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	repositoryId bigint,
	folderId bigint,
	fileEntryId bigint,
	treePath varchar(4000),
	fileName varchar(255),
	extension varchar(75),
	mimeType varchar(75),
	title varchar(255),
	description varchar(4000),
	changeLog varchar(75),
	extraSettings clob,
	fileEntryTypeId bigint,
	version varchar(75),
	size_ bigint,
	checksum varchar(75),
	storeUUID varchar(255),
	displayDate timestamp,
	expirationDate timestamp,
	reviewDate timestamp,
	lastPublishDate timestamp,
	status integer,
	statusByUserId bigint,
	statusByUserName varchar(75),
	statusDate timestamp,
	primary key (fileVersionId, ctCollectionId)
);

create table DLFolder (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	externalReferenceCode varchar(75),
	folderId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	repositoryId bigint,
	mountPoint smallint,
	parentFolderId bigint,
	treePath varchar(4000),
	name varchar(255),
	description varchar(4000),
	lastPostDate timestamp,
	defaultFileEntryTypeId bigint,
	hidden_ smallint,
	restrictionType integer,
	lastPublishDate timestamp,
	status integer,
	statusByUserId bigint,
	statusByUserName varchar(75),
	statusDate timestamp,
	primary key (folderId, ctCollectionId)
);

create table EmailAddress (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	emailAddressId bigint not null,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	classNameId bigint,
	classPK bigint,
	address varchar(254),
	listTypeId bigint,
	primary_ smallint,
	primary key (emailAddressId, ctCollectionId)
);

create table ExpandoColumn (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	columnId bigint not null,
	companyId bigint,
	modifiedDate timestamp,
	tableId bigint,
	name varchar(75),
	type_ integer,
	defaultData clob,
	typeSettings clob,
	primary key (columnId, ctCollectionId)
);

create table ExpandoRow (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	rowId_ bigint not null,
	companyId bigint,
	modifiedDate timestamp,
	tableId bigint,
	classPK bigint,
	primary key (rowId_, ctCollectionId)
);

create table ExpandoTable (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	tableId bigint not null,
	companyId bigint,
	classNameId bigint,
	name varchar(75),
	primary key (tableId, ctCollectionId)
);

create table ExpandoValue (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	valueId bigint not null,
	companyId bigint,
	tableId bigint,
	columnId bigint,
	rowId_ bigint,
	classNameId bigint,
	classPK bigint,
	data_ clob,
	primary key (valueId, ctCollectionId)
);

create table ExportImportConfiguration (
	mvccVersion bigint default 0 not null,
	exportImportConfigurationId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	name varchar(200),
	description varchar(4000),
	type_ integer,
	settings_ clob,
	status integer,
	statusByUserId bigint,
	statusByUserName varchar(75),
	statusDate timestamp
);

create table Group_ (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	externalReferenceCode varchar(75),
	groupId bigint not null,
	companyId bigint,
	creatorUserId bigint,
	modifiedDate timestamp,
	classNameId bigint,
	classPK bigint,
	parentGroupId bigint,
	liveGroupId bigint,
	treePath varchar(4000),
	groupKey varchar(150),
	name varchar(4000),
	description varchar(4000),
	type_ integer,
	typeSettings clob,
	manualMembership smallint,
	membershipRestriction integer,
	friendlyURL varchar(255),
	site smallint,
	remoteStagingGroupCount integer,
	inheritContent smallint,
	active_ smallint,
	primary key (groupId, ctCollectionId)
);

create table Groups_Orgs (
	companyId bigint not null,
	groupId bigint not null,
	organizationId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType smallint,
	primary key (groupId, organizationId, ctCollectionId)
);

create table Groups_Roles (
	companyId bigint not null,
	groupId bigint not null,
	roleId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType smallint,
	primary key (groupId, roleId, ctCollectionId)
);

create table Groups_UserGroups (
	companyId bigint not null,
	groupId bigint not null,
	userGroupId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType smallint,
	primary key (groupId, userGroupId, ctCollectionId)
);

create table Image (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	imageId bigint not null,
	companyId bigint,
	modifiedDate timestamp,
	type_ varchar(75),
	height integer,
	width integer,
	size_ integer,
	primary key (imageId, ctCollectionId)
);

create table Layout (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	externalReferenceCode varchar(75),
	plid bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	parentPlid bigint,
	privateLayout smallint,
	layoutId bigint,
	parentLayoutId bigint,
	classNameId bigint,
	classPK bigint,
	name varchar(4000),
	title clob,
	description clob,
	keywords varchar(4000),
	robots varchar(4000),
	type_ varchar(75),
	typeSettings clob,
	hidden_ smallint,
	system_ smallint,
	friendlyURL varchar(255),
	iconImageId bigint,
	themeId varchar(75),
	colorSchemeId varchar(75),
	styleBookEntryId bigint,
	css clob,
	priority integer,
	faviconFileEntryId bigint,
	masterLayoutPlid bigint,
	layoutPrototypeUuid varchar(75),
	layoutPrototypeLinkEnabled smallint,
	sourcePrototypeLayoutUuid varchar(75),
	publishDate timestamp,
	lastPublishDate timestamp,
	status integer,
	statusByUserId bigint,
	statusByUserName varchar(75),
	statusDate timestamp,
	primary key (plid, ctCollectionId)
);

create table LayoutBranch (
	mvccVersion bigint default 0 not null,
	layoutBranchId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	layoutSetBranchId bigint,
	plid bigint,
	name varchar(75),
	description varchar(4000),
	master smallint
);

create table LayoutFriendlyURL (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	layoutFriendlyURLId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	plid bigint,
	privateLayout smallint,
	friendlyURL varchar(255),
	languageId varchar(75),
	lastPublishDate timestamp,
	primary key (layoutFriendlyURLId, ctCollectionId)
);

create table LayoutPrototype (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	layoutPrototypeId bigint not null,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	name clob,
	description clob,
	settings_ varchar(4000),
	active_ smallint,
	primary key (layoutPrototypeId, ctCollectionId)
);

create table LayoutRevision (
	mvccVersion bigint default 0 not null,
	layoutRevisionId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	layoutSetBranchId bigint,
	layoutBranchId bigint,
	parentLayoutRevisionId bigint,
	head smallint,
	major smallint,
	plid bigint,
	privateLayout smallint,
	name varchar(4000),
	title varchar(4000),
	description varchar(4000),
	keywords varchar(4000),
	robots varchar(4000),
	typeSettings clob,
	iconImageId bigint,
	themeId varchar(75),
	colorSchemeId varchar(75),
	css clob,
	status integer,
	statusByUserId bigint,
	statusByUserName varchar(75),
	statusDate timestamp
);

create table LayoutSet (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	layoutSetId bigint not null,
	groupId bigint,
	companyId bigint,
	createDate timestamp,
	modifiedDate timestamp,
	privateLayout smallint,
	logoId bigint,
	themeId varchar(75),
	colorSchemeId varchar(75),
	faviconFileEntryId bigint,
	css clob,
	settings_ clob,
	layoutSetPrototypeUuid varchar(75),
	layoutSetPrototypeLinkEnabled smallint,
	primary key (layoutSetId, ctCollectionId)
);

create table LayoutSetBranch (
	mvccVersion bigint default 0 not null,
	layoutSetBranchId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	privateLayout smallint,
	name varchar(75),
	description varchar(4000),
	master smallint,
	logoId bigint,
	themeId varchar(75),
	colorSchemeId varchar(75),
	css clob,
	settings_ clob,
	layoutSetPrototypeUuid varchar(75),
	layoutSetPrototypeLinkEnabled smallint
);

create table LayoutSetPrototype (
	mvccVersion bigint default 0 not null,
	uuid_ varchar(75),
	layoutSetPrototypeId bigint not null primary key,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	name clob,
	description clob,
	settings_ varchar(4000),
	active_ smallint
);

create table ListType (
	mvccVersion bigint default 0 not null,
	uuid_ varchar(75),
	listTypeId bigint not null primary key,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	name varchar(75),
	type_ varchar(75)
);

create table MembershipRequest (
	mvccVersion bigint default 0 not null,
	membershipRequestId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	createDate timestamp,
	comments varchar(4000),
	replyComments varchar(4000),
	replyDate timestamp,
	replierUserId bigint,
	statusId bigint
);

create table OrgLabor (
	mvccVersion bigint default 0 not null,
	orgLaborId bigint not null primary key,
	companyId bigint,
	organizationId bigint,
	listTypeId bigint,
	sunOpen integer,
	sunClose integer,
	monOpen integer,
	monClose integer,
	tueOpen integer,
	tueClose integer,
	wedOpen integer,
	wedClose integer,
	thuOpen integer,
	thuClose integer,
	friOpen integer,
	friClose integer,
	satOpen integer,
	satClose integer
);

create table Organization_ (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	externalReferenceCode varchar(75),
	organizationId bigint not null,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	parentOrganizationId bigint,
	treePath varchar(4000),
	name varchar(100),
	type_ varchar(75),
	recursable smallint,
	regionId bigint,
	countryId bigint,
	statusListTypeId bigint,
	comments varchar(4000),
	logoId bigint,
	primary key (organizationId, ctCollectionId)
);

create table PasswordPolicy (
	mvccVersion bigint default 0 not null,
	uuid_ varchar(75),
	passwordPolicyId bigint not null primary key,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	defaultPolicy smallint,
	name varchar(75),
	description varchar(4000),
	changeable smallint,
	changeRequired smallint,
	minAge bigint,
	checkSyntax smallint,
	allowDictionaryWords smallint,
	minAlphanumeric integer,
	minLength integer,
	minLowerCase integer,
	minNumbers integer,
	minSymbols integer,
	minUpperCase integer,
	regex varchar(4000),
	history smallint,
	historyCount integer,
	expireable smallint,
	maxAge bigint,
	warningTime bigint,
	graceLimit integer,
	lockout smallint,
	maxFailure integer,
	lockoutDuration bigint,
	requireUnlock smallint,
	resetFailureCount bigint,
	resetTicketMaxAge bigint
);

create table PasswordPolicyRel (
	mvccVersion bigint default 0 not null,
	passwordPolicyRelId bigint not null primary key,
	companyId bigint,
	passwordPolicyId bigint,
	classNameId bigint,
	classPK bigint
);

create table PasswordTracker (
	mvccVersion bigint default 0 not null,
	passwordTrackerId bigint not null primary key,
	companyId bigint,
	userId bigint,
	createDate timestamp,
	password_ varchar(255)
);

create table Phone (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	phoneId bigint not null,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	classNameId bigint,
	classPK bigint,
	number_ varchar(75),
	extension varchar(75),
	listTypeId bigint,
	primary_ smallint,
	primary key (phoneId, ctCollectionId)
);

create table PluginSetting (
	mvccVersion bigint default 0 not null,
	pluginSettingId bigint not null primary key,
	companyId bigint,
	pluginId varchar(75),
	pluginType varchar(75),
	roles varchar(4000),
	active_ smallint
);

create table PortalPreferenceValue (
	mvccVersion bigint default 0 not null,
	portalPreferenceValueId bigint not null primary key,
	companyId bigint,
	portalPreferencesId bigint,
	index_ integer,
	key_ varchar(1024),
	largeValue clob,
	namespace varchar(255),
	smallValue varchar(255)
);

create table PortalPreferences (
	mvccVersion bigint default 0 not null,
	portalPreferencesId bigint not null primary key,
	companyId bigint,
	ownerId bigint,
	ownerType integer
);

create table Portlet (
	mvccVersion bigint default 0 not null,
	id_ bigint not null primary key,
	companyId bigint,
	portletId varchar(200),
	roles varchar(4000),
	active_ smallint
);

create table PortletItem (
	mvccVersion bigint default 0 not null,
	portletItemId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	name varchar(75),
	portletId varchar(200),
	classNameId bigint
);

create table PortletPreferenceValue (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	portletPreferenceValueId bigint not null,
	companyId bigint,
	portletPreferencesId bigint,
	index_ integer,
	largeValue clob,
	name varchar(255),
	readOnly smallint,
	smallValue varchar(255),
	primary key (portletPreferenceValueId, ctCollectionId)
);

create table PortletPreferences (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	portletPreferencesId bigint not null,
	companyId bigint,
	ownerId bigint,
	ownerType integer,
	plid bigint,
	portletId varchar(200),
	primary key (portletPreferencesId, ctCollectionId)
);

create table RatingsEntry (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	entryId bigint not null,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	classNameId bigint,
	classPK bigint,
	score double,
	primary key (entryId, ctCollectionId)
);

create table RatingsStats (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	statsId bigint not null,
	companyId bigint,
	createDate timestamp,
	modifiedDate timestamp,
	classNameId bigint,
	classPK bigint,
	totalEntries integer,
	totalScore double,
	averageScore double,
	primary key (statsId, ctCollectionId)
);

create table RecentLayoutBranch (
	mvccVersion bigint default 0 not null,
	recentLayoutBranchId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	layoutBranchId bigint,
	layoutSetBranchId bigint,
	plid bigint
);

create table RecentLayoutRevision (
	mvccVersion bigint default 0 not null,
	recentLayoutRevisionId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	layoutRevisionId bigint,
	layoutSetBranchId bigint,
	plid bigint
);

create table RecentLayoutSetBranch (
	mvccVersion bigint default 0 not null,
	recentLayoutSetBranchId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	layoutSetBranchId bigint,
	layoutSetId bigint
);

create table Region (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	defaultLanguageId varchar(75),
	regionId bigint not null,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	countryId bigint,
	active_ smallint,
	name varchar(75),
	position double,
	regionCode varchar(75),
	lastPublishDate timestamp,
	primary key (regionId, ctCollectionId)
);

create table RegionLocalization (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	regionLocalizationId bigint not null,
	companyId bigint,
	regionId bigint,
	languageId varchar(75),
	title varchar(75),
	primary key (regionLocalizationId, ctCollectionId)
);

create table Release_ (
	mvccVersion bigint default 0 not null,
	releaseId bigint not null primary key,
	createDate timestamp,
	modifiedDate timestamp,
	servletContextName varchar(75),
	schemaVersion varchar(75),
	buildNumber integer,
	buildDate timestamp,
	verified smallint,
	state_ integer,
	testString varchar(1024)
);

create table RememberMeToken (
	mvccVersion bigint default 0 not null,
	rememberMeTokenId bigint not null primary key,
	companyId bigint,
	userId bigint,
	createDate timestamp,
	expirationDate timestamp,
	value varchar(255)
);

create table Repository (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	repositoryId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	classNameId bigint,
	name varchar(200),
	description varchar(4000),
	portletId varchar(200),
	typeSettings clob,
	dlFolderId bigint,
	lastPublishDate timestamp,
	primary key (repositoryId, ctCollectionId)
);

create table RepositoryEntry (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	repositoryEntryId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	repositoryId bigint,
	mappedId varchar(255),
	manualCheckInRequired smallint,
	lastPublishDate timestamp,
	primary key (repositoryEntryId, ctCollectionId)
);

create table ResourceAction (
	mvccVersion bigint default 0 not null,
	resourceActionId bigint not null primary key,
	name varchar(255),
	actionId varchar(75),
	bitwiseValue bigint
);

create table ResourcePermission (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	resourcePermissionId bigint not null,
	companyId bigint,
	name varchar(255),
	scope integer,
	primKey varchar(255),
	primKeyId bigint,
	roleId bigint,
	ownerId bigint,
	actionIds bigint,
	viewActionId smallint,
	primary key (resourcePermissionId, ctCollectionId)
);

create table Role_ (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	roleId bigint not null,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	classNameId bigint,
	classPK bigint,
	name varchar(75),
	title varchar(4000),
	description clob,
	type_ integer,
	subtype varchar(75),
	primary key (roleId, ctCollectionId)
);

create table ServiceComponent (
	mvccVersion bigint default 0 not null,
	serviceComponentId bigint not null primary key,
	buildNamespace varchar(75),
	buildNumber bigint,
	buildDate bigint,
	data_ clob
);

create table SocialActivity (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	activityId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	createDate bigint,
	activitySetId bigint,
	mirrorActivityId bigint,
	classNameId bigint,
	classPK bigint,
	parentClassNameId bigint,
	parentClassPK bigint,
	type_ integer,
	extraData varchar(4000),
	receiverUserId bigint,
	primary key (activityId, ctCollectionId)
);

create table SocialActivityAchievement (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	activityAchievementId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	createDate bigint,
	name varchar(75),
	firstInGroup smallint,
	primary key (activityAchievementId, ctCollectionId)
);

create table SocialActivityCounter (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	activityCounterId bigint not null,
	groupId bigint,
	companyId bigint,
	classNameId bigint,
	classPK bigint,
	name varchar(75),
	ownerType integer,
	currentValue integer,
	totalValue integer,
	graceValue integer,
	startPeriod integer,
	endPeriod integer,
	active_ smallint,
	primary key (activityCounterId, ctCollectionId)
);

create table SocialActivityLimit (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	activityLimitId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	classNameId bigint,
	classPK bigint,
	activityType integer,
	activityCounterName varchar(75),
	value varchar(75),
	primary key (activityLimitId, ctCollectionId)
);

create table SocialActivitySet (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	activitySetId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	createDate bigint,
	modifiedDate bigint,
	classNameId bigint,
	classPK bigint,
	type_ integer,
	extraData varchar(4000),
	activityCount integer,
	primary key (activitySetId, ctCollectionId)
);

create table SocialActivitySetting (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	activitySettingId bigint not null,
	groupId bigint,
	companyId bigint,
	classNameId bigint,
	activityType integer,
	name varchar(75),
	value varchar(1024),
	primary key (activitySettingId, ctCollectionId)
);

create table SocialRelation (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	relationId bigint not null,
	companyId bigint,
	createDate bigint,
	userId1 bigint,
	userId2 bigint,
	type_ integer,
	primary key (relationId, ctCollectionId)
);

create table SocialRequest (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	requestId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	createDate bigint,
	modifiedDate bigint,
	classNameId bigint,
	classPK bigint,
	type_ integer,
	extraData varchar(4000),
	receiverUserId bigint,
	status integer,
	primary key (requestId, ctCollectionId)
);

create table SystemEvent (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	systemEventId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	classNameId bigint,
	classPK bigint,
	classUuid varchar(75),
	referrerClassNameId bigint,
	parentSystemEventId bigint,
	systemEventSetKey bigint,
	type_ integer,
	extraData clob,
	primary key (systemEventId, ctCollectionId)
);

create table Team (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	teamId bigint not null,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	groupId bigint,
	name varchar(75),
	description varchar(4000),
	lastPublishDate timestamp,
	primary key (teamId, ctCollectionId)
);

create table Ticket (
	mvccVersion bigint default 0 not null,
	ticketId bigint not null primary key,
	companyId bigint,
	createDate timestamp,
	classNameId bigint,
	classPK bigint,
	key_ varchar(255),
	type_ integer,
	extraInfo clob,
	expirationDate timestamp
);

create table UserNotificationDelivery (
	mvccVersion bigint default 0 not null,
	userNotificationDeliveryId bigint not null primary key,
	companyId bigint,
	userId bigint,
	portletId varchar(200),
	classNameId bigint,
	notificationType integer,
	deliveryType integer,
	deliver smallint
);

create table User_ (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	externalReferenceCode varchar(75),
	userId bigint not null,
	companyId bigint,
	createDate timestamp,
	modifiedDate timestamp,
	contactId bigint,
	password_ varchar(255),
	passwordEncrypted smallint,
	passwordReset smallint,
	passwordModifiedDate timestamp,
	digest varchar(255),
	reminderQueryQuestion varchar(75),
	reminderQueryAnswer varchar(75),
	graceLoginCount integer,
	screenName varchar(75),
	emailAddress varchar(254),
	facebookId bigint,
	googleUserId varchar(75),
	ldapServerId bigint,
	openId varchar(1024),
	portraitId bigint,
	languageId varchar(75),
	timeZoneId varchar(75),
	greeting varchar(255),
	comments varchar(4000),
	firstName varchar(75),
	middleName varchar(75),
	lastName varchar(75),
	jobTitle varchar(100),
	loginDate timestamp,
	loginIP varchar(75),
	lastLoginDate timestamp,
	lastLoginIP varchar(75),
	lastFailedLoginDate timestamp,
	failedLoginAttempts integer,
	lockout smallint,
	lockoutDate timestamp,
	agreedToTermsOfUse smallint,
	emailAddressVerified smallint,
	type_ integer,
	status integer,
	primary key (userId, ctCollectionId)
);

create table UserGroup (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75),
	externalReferenceCode varchar(75),
	userGroupId bigint not null,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	parentUserGroupId bigint,
	name varchar(255),
	description varchar(4000),
	addedByLDAPImport smallint,
	primary key (userGroupId, ctCollectionId)
);

create table UserGroupGroupRole (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	userGroupGroupRoleId bigint not null,
	companyId bigint,
	userGroupId bigint,
	groupId bigint,
	roleId bigint,
	primary key (userGroupGroupRoleId, ctCollectionId)
);

create table UserGroupRole (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	userGroupRoleId bigint not null,
	companyId bigint,
	userId bigint,
	groupId bigint,
	roleId bigint,
	primary key (userGroupRoleId, ctCollectionId)
);

create table UserGroups_Teams (
	companyId bigint not null,
	teamId bigint not null,
	userGroupId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType smallint,
	primary key (teamId, userGroupId, ctCollectionId)
);

create table UserIdMapper (
	mvccVersion bigint default 0 not null,
	userIdMapperId bigint not null primary key,
	companyId bigint,
	userId bigint,
	type_ varchar(75),
	description varchar(75),
	externalUserId varchar(75)
);

create table UserNotificationEvent (
	mvccVersion bigint default 0 not null,
	uuid_ varchar(75),
	userNotificationEventId bigint not null primary key,
	companyId bigint,
	userId bigint,
	type_ varchar(200),
	timestamp bigint,
	deliveryType integer,
	deliverBy bigint,
	delivered smallint,
	payload clob,
	actionRequired smallint,
	archived smallint
);

create table Users_Groups (
	companyId bigint not null,
	groupId bigint not null,
	userId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType smallint,
	primary key (groupId, userId, ctCollectionId)
);

create table Users_Orgs (
	companyId bigint not null,
	organizationId bigint not null,
	userId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType smallint,
	primary key (organizationId, userId, ctCollectionId)
);

create table Users_Roles (
	companyId bigint not null,
	roleId bigint not null,
	userId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType smallint,
	primary key (roleId, userId, ctCollectionId)
);

create table Users_Teams (
	companyId bigint not null,
	teamId bigint not null,
	userId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType smallint,
	primary key (teamId, userId, ctCollectionId)
);

create table Users_UserGroups (
	companyId bigint not null,
	userId bigint not null,
	userGroupId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType smallint,
	primary key (userId, userGroupId, ctCollectionId)
);

create table UserTracker (
	mvccVersion bigint default 0 not null,
	userTrackerId bigint not null primary key,
	companyId bigint,
	userId bigint,
	modifiedDate timestamp,
	sessionId varchar(200),
	remoteAddr varchar(75),
	remoteHost varchar(75),
	userAgent varchar(200)
);

create table UserTrackerPath (
	mvccVersion bigint default 0 not null,
	userTrackerPathId bigint not null primary key,
	companyId bigint,
	userTrackerId bigint,
	path_ varchar(4000),
	pathDate timestamp
);

create table VirtualHost (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	virtualHostId bigint not null,
	companyId bigint,
	layoutSetId bigint,
	hostname varchar(200),
	defaultVirtualHost smallint,
	languageId varchar(75),
	primary key (virtualHostId, ctCollectionId)
);

create table WebDAVProps (
	mvccVersion bigint default 0 not null,
	webDavPropsId bigint not null primary key,
	companyId bigint,
	createDate timestamp,
	modifiedDate timestamp,
	classNameId bigint,
	classPK bigint,
	props clob
);

create table Website (
	mvccVersion bigint default 0 not null,
	uuid_ varchar(75),
	websiteId bigint not null primary key,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	classNameId bigint,
	classPK bigint,
	url varchar(4000),
	listTypeId bigint,
	primary_ smallint,
	lastPublishDate timestamp
);

create table WorkflowDefinitionLink (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	workflowDefinitionLinkId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	classNameId bigint,
	classPK bigint,
	typePK bigint,
	workflowDefinitionName varchar(75),
	workflowDefinitionVersion integer,
	primary key (workflowDefinitionLinkId, ctCollectionId)
);

create table WorkflowInstanceLink (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	workflowInstanceLinkId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75),
	createDate timestamp,
	modifiedDate timestamp,
	classNameId bigint,
	classPK bigint,
	workflowInstanceId bigint,
	primary key (workflowInstanceLinkId, ctCollectionId)
);


insert into Counter (name, currentId) values ('com.liferay.counter.kernel.model.Counter', 20000);



commit;


create index IX_FEAFC68A on Address (companyId, classNameId, classPK, listTypeId);
create index IX_923BD178 on Address (companyId, classNameId, classPK, mailing);
create index IX_9226DBB4 on Address (companyId, classNameId, classPK, primary_);
create unique index IX_C0F7C08D on Address (companyId, externalReferenceCode, ctCollectionId);
create index IX_5A2093E7 on Address (countryId);
create index IX_C8E3E87D on Address (regionId);
create index IX_5BC8B0D4 on Address (userId);
create index IX_381E55DA on Address (uuid_);

create index IX_37B0A8A2 on AnnouncementsDelivery (companyId);
create unique index IX_7EA033 on AnnouncementsDelivery (userId, type_, ctCollectionId);

create index IX_14F06A6B on AnnouncementsEntry (classNameId, classPK, alert);
create index IX_94C04525 on AnnouncementsEntry (classNameId, classPK, companyId, alert);
create index IX_3F376E7C on AnnouncementsEntry (companyId);
create index IX_D49C2E66 on AnnouncementsEntry (userId);
create index IX_1AFBDE08 on AnnouncementsEntry (uuid_);

create index IX_EF1F022A on AnnouncementsFlag (companyId);
create index IX_ED8CE4E8 on AnnouncementsFlag (entryId, userId, value);

create unique index IX_F3842169 on AssetCategory (groupId, ctCollectionId, externalReferenceCode);
create index IX_F67BECAD on AssetCategory (groupId, parentCategoryId);
create unique index IX_AF94405C on AssetCategory (groupId, uuid_, ctCollectionId);
create index IX_2710C64A on AssetCategory (groupId, vocabularyId, name);
create index IX_68169942 on AssetCategory (groupId, vocabularyId, parentCategoryId);
create index IX_9DDD15EA on AssetCategory (parentCategoryId, name);
create index IX_4D37BB00 on AssetCategory (uuid_);
create index IX_3537E488 on AssetCategory (vocabularyId, name);
create unique index IX_8C99329D on AssetCategory (vocabularyId, parentCategoryId, name, ctCollectionId);

create index IX_112337B8 on AssetEntries_AssetTags (companyId);
create index IX_B2A61B55 on AssetEntries_AssetTags (tagId);

create unique index IX_7BF8337B on AssetEntry (classNameId, classPK, ctCollectionId);
create index IX_7306C60 on AssetEntry (companyId);
create index IX_75D42FF9 on AssetEntry (expirationDate);
create index IX_6418BB52 on AssetEntry (groupId, classNameId, publishDate, expirationDate);
create index IX_82C4BEF6 on AssetEntry (groupId, classNameId, visible);
create index IX_1EBA6821 on AssetEntry (groupId, classUuid);
create index IX_FEC4A201 on AssetEntry (layoutUuid);
create index IX_2E4E3885 on AssetEntry (publishDate);
create index IX_9029E15A on AssetEntry (visible);

create index IX_D63322F9 on AssetTag (groupId, name);
create index IX_C43137AF on AssetTag (name);
create unique index IX_A43FBC4 on AssetTag (uuid_, groupId, ctCollectionId);

create index IX_B22D908C on AssetVocabulary (companyId);
create unique index IX_E06DEF51 on AssetVocabulary (groupId, ctCollectionId, externalReferenceCode);
create unique index IX_32F2132B on AssetVocabulary (groupId, ctCollectionId, name);
create index IX_C0AAD74D on AssetVocabulary (groupId, name);
create unique index IX_3966DE44 on AssetVocabulary (groupId, uuid_, ctCollectionId);
create index IX_2F7F11EE on AssetVocabulary (groupId, visibilityType);
create index IX_55F58818 on AssetVocabulary (uuid_);

create unique index IX_E7B95510 on BrowserTracker (userId);

create unique index IX_B27A301F on ClassName_ (value);

create index IX_38EFE3FD on Company (logoId);
create index IX_12566EC2 on Company (mx);
create unique index IX_EC00543C on Company (webId);

create unique index IX_85C63FD7 on CompanyInfo (companyId);

create index IX_791914FA on Contact_ (classNameId, classPK);
create index IX_FD2E9BDD on Contact_ (companyId, userId);
create index IX_42F94F9F on Contact_ (userId);

create index IX_25D734CD on Country (active_);
create index IX_F9CD867E on Country (companyId, active_, billingAllowed);
create index IX_54E98CCD on Country (companyId, active_, shippingAllowed);
create unique index IX_7DA11A6F on Country (companyId, ctCollectionId, a2);
create unique index IX_7DA11E30 on Country (companyId, ctCollectionId, a3);
create unique index IX_B2A91789 on Country (companyId, ctCollectionId, name);
create unique index IX_74AB3DC on Country (companyId, ctCollectionId, number_);
create index IX_B59A9078 on Country (uuid_);

create unique index IX_E22A5911 on CountryLocalization (countryId, languageId, ctCollectionId);

create index IX_4CB1B2B4 on DLFileEntry (companyId);
create index IX_B8526DBE on DLFileEntry (custom1ImageId);
create index IX_AC9BDEDD on DLFileEntry (custom2ImageId);
create index IX_772ECDE7 on DLFileEntry (fileEntryTypeId);
create index IX_8F6C75D0 on DLFileEntry (folderId, name);
create index IX_57FFBBCA on DLFileEntry (folderId, repositoryId);
create unique index IX_761F8629 on DLFileEntry (groupId, ctCollectionId, externalReferenceCode);
create unique index IX_672F1AA0 on DLFileEntry (groupId, ctCollectionId, uuid_);
create unique index IX_1920CC0C on DLFileEntry (groupId, folderId, ctCollectionId, fileName);
create unique index IX_7BDA28F0 on DLFileEntry (groupId, folderId, ctCollectionId, name);
create unique index IX_4ADDCFF7 on DLFileEntry (groupId, folderId, ctCollectionId, title);
create index IX_29D0AF28 on DLFileEntry (groupId, folderId, fileEntryTypeId);
create index IX_1DC796CD on DLFileEntry (groupId, folderId, userId);
create index IX_43261870 on DLFileEntry (groupId, userId);
create index IX_4DB7A143 on DLFileEntry (largeImageId);
create index IX_D9492CF6 on DLFileEntry (mimeType);
create index IX_9EE96CAD on DLFileEntry (repositoryId);
create index IX_25F5CAB9 on DLFileEntry (smallImageId, largeImageId, custom1ImageId, custom2ImageId);
create index IX_64F0FE40 on DLFileEntry (uuid_);

create index IX_4F40FE5E on DLFileEntryMetadata (fileEntryId);
create unique index IX_5DC2B977 on DLFileEntryMetadata (fileVersionId, DDMStructureId, ctCollectionId);
create index IX_D49AB5D1 on DLFileEntryMetadata (uuid_);

create unique index IX_93ED0F06 on DLFileEntryType (groupId, ctCollectionId, dataDefinitionId);
create unique index IX_A5C4723D on DLFileEntryType (groupId, ctCollectionId, fileEntryTypeKey);
create unique index IX_C1518AF6 on DLFileEntryType (groupId, uuid_, ctCollectionId);
create index IX_90724726 on DLFileEntryType (uuid_);

create index IX_2E64D9F9 on DLFileEntryTypes_DLFolders (companyId);
create index IX_6E00A2EC on DLFileEntryTypes_DLFolders (folderId);

create index IX_8571953E on DLFileShortcut (companyId, status);
create index IX_17EE3098 on DLFileShortcut (groupId, folderId, active_, status);
create unique index IX_86FE17F8 on DLFileShortcut (groupId, uuid_, ctCollectionId);
create index IX_4B7247F6 on DLFileShortcut (toFileEntryId);
create index IX_4831EBE4 on DLFileShortcut (uuid_);

create index IX_CF394FE on DLFileVersion (companyId, storeUUID);
create unique index IX_10E504DF on DLFileVersion (fileEntryId, version, ctCollectionId);
create index IX_BC5541ED on DLFileVersion (groupId, folderId, version, title);
create index IX_FFB3395C on DLFileVersion (mimeType);
create index IX_5898E799 on DLFileVersion (status, companyId, expirationDate);
create index IX_92309600 on DLFileVersion (status, displayDate);
create index IX_D50EAA41 on DLFileVersion (status, fileEntryId);
create index IX_799D5D47 on DLFileVersion (status, groupId, folderId);
create unique index IX_350F5CAE on DLFileVersion (uuid_, groupId, ctCollectionId);

create index IX_A74DB14C on DLFolder (companyId);
create unique index IX_F0D74691 on DLFolder (groupId, ctCollectionId, externalReferenceCode);
create unique index IX_4C35E652 on DLFolder (groupId, parentFolderId, ctCollectionId, name);
create index IX_CE360BF6 on DLFolder (groupId, parentFolderId, hidden_, status);
create index IX_2D8D2D2B on DLFolder (groupId, parentFolderId, mountPoint, hidden_, status);
create unique index IX_53E6B584 on DLFolder (groupId, uuid_, ctCollectionId);
create index IX_D6D77780 on DLFolder (mountPoint, repositoryId);
create index IX_51556082 on DLFolder (parentFolderId, name);
create index IX_56F3D47C on DLFolder (parentFolderId, repositoryId);
create index IX_EE29C715 on DLFolder (repositoryId);
create index IX_B199E2A6 on DLFolder (status, companyId);
create index IX_CBC408D8 on DLFolder (uuid_);

create index IX_2A2CB130 on EmailAddress (companyId, classNameId, classPK, primary_);
create index IX_7B43CD8 on EmailAddress (userId);
create index IX_D24F3956 on EmailAddress (uuid_);

create unique index IX_4A7D3605 on ExpandoColumn (tableId, name, ctCollectionId);

create index IX_49EB3118 on ExpandoRow (classPK);
create unique index IX_488E0C53 on ExpandoRow (tableId, classPK, ctCollectionId);

create unique index IX_87D370E2 on ExpandoTable (companyId, classNameId, name, ctCollectionId);

create index IX_CAD04B0D on ExpandoValue (classPK, classNameId);
create unique index IX_E6D98E43 on ExpandoValue (columnId, rowId_, ctCollectionId);
create index IX_9112A7A0 on ExpandoValue (rowId_);
create index IX_1BD3F4C on ExpandoValue (tableId, classPK);
create unique index IX_D8C72C45 on ExpandoValue (tableId, columnId, classPK, ctCollectionId);
create index IX_B71E92D5 on ExpandoValue (tableId, rowId_);

create index IX_1827A2E5 on ExportImportConfiguration (companyId);
create index IX_38FA468D on ExportImportConfiguration (groupId, status);
create index IX_47CC6234 on ExportImportConfiguration (groupId, type_, status);

create index IX_75017452 on Group_ (active_, type_);
create index IX_8257E37B on Group_ (classNameId, classPK);
create index IX_DDC91A87 on Group_ (companyId, active_);
create unique index IX_DBA56EF9 on Group_ (companyId, classNameId, ctCollectionId, classPK);
create index IX_ABE2D54 on Group_ (companyId, classNameId, parentGroupId);
create index IX_DF76A247 on Group_ (companyId, classNameId, site);
create unique index IX_23B1C81D on Group_ (companyId, ctCollectionId, externalReferenceCode);
create unique index IX_3551EED4 on Group_ (companyId, ctCollectionId, friendlyURL);
create unique index IX_42E6E774 on Group_ (companyId, ctCollectionId, groupKey);
create index IX_5D75499E on Group_ (companyId, parentGroupId);
create index IX_B91488EC on Group_ (companyId, site, active_);
create index IX_7B216735 on Group_ (companyId, site, parentGroupId, inheritContent);
create index IX_16218A38 on Group_ (liveGroupId);
create index IX_F981514E on Group_ (uuid_);

create index IX_8BFD4548 on Groups_Orgs (companyId);
create index IX_6BBB7682 on Groups_Orgs (organizationId);

create index IX_557D8550 on Groups_Roles (companyId);
create index IX_3103EF3D on Groups_Roles (roleId);

create index IX_676FC818 on Groups_UserGroups (companyId);
create index IX_3B69160F on Groups_UserGroups (userGroupId);

create index IX_6A925A4D on Image (size_);

create index IX_B8E1E6E5 on Layout (classNameId, classPK);
create index IX_881EABCB on Layout (companyId, layoutPrototypeUuid);
create unique index IX_E81EADC5 on Layout (groupId, ctCollectionId, externalReferenceCode);
create index IX_993CBA31 on Layout (groupId, masterLayoutPlid);
create unique index IX_502B1A93 on Layout (groupId, privateLayout, ctCollectionId, friendlyURL);
create unique index IX_4FBF955A on Layout (groupId, privateLayout, ctCollectionId, layoutId);
create unique index IX_18646B93 on Layout (groupId, privateLayout, ctCollectionId, uuid_);
create index IX_7DAA999F on Layout (groupId, privateLayout, parentLayoutId, hidden_);
create index IX_7399B71E on Layout (groupId, privateLayout, parentLayoutId, priority);
create index IX_8F78BAFA on Layout (groupId, privateLayout, parentLayoutId, system_);
create index IX_8CE8C0D9 on Layout (groupId, privateLayout, sourcePrototypeLayoutUuid);
create index IX_A0364689 on Layout (groupId, privateLayout, status);
create index IX_1A1B61D2 on Layout (groupId, privateLayout, type_);
create index IX_6EDC627B on Layout (groupId, type_);
create index IX_23922F7D on Layout (iconImageId);
create index IX_B529BFD3 on Layout (layoutPrototypeUuid);
create index IX_1D4DCAA5 on Layout (parentPlid);
create index IX_3BC009C0 on Layout (privateLayout, iconImageId);
create index IX_39A18ECC on Layout (sourcePrototypeLayoutUuid);
create index IX_D0822724 on Layout (uuid_);

create index IX_A705FF94 on LayoutBranch (layoutSetBranchId, plid, master);
create unique index IX_FD57097D on LayoutBranch (layoutSetBranchId, plid, name);
create index IX_72FC531D on LayoutBranch (plid);

create index IX_EAB317C8 on LayoutFriendlyURL (companyId);
create index IX_C23A9814 on LayoutFriendlyURL (friendlyURL, companyId);
create index IX_D3B2D6DF on LayoutFriendlyURL (friendlyURL, plid);
create unique index IX_8B1B117C on LayoutFriendlyURL (groupId, friendlyURL, ctCollectionId, privateLayout, languageId);
create index IX_26AE82D3 on LayoutFriendlyURL (groupId, friendlyURL, privateLayout);
create unique index IX_2C37488 on LayoutFriendlyURL (groupId, uuid_, ctCollectionId);
create unique index IX_A4D8B1D0 on LayoutFriendlyURL (plid, ctCollectionId, languageId);
create index IX_9F80D54 on LayoutFriendlyURL (uuid_);

create index IX_557A639F on LayoutPrototype (companyId, active_);
create index IX_CEF72136 on LayoutPrototype (uuid_);

create index IX_9EC9F954 on LayoutRevision (layoutSetBranchId, head, status);
create index IX_538BFC54 on LayoutRevision (layoutSetBranchId, plid, head, layoutBranchId);
create index IX_84668240 on LayoutRevision (layoutSetBranchId, plid, layoutBranchId);
create index IX_F93E5CC3 on LayoutRevision (layoutSetBranchId, plid, parentLayoutRevisionId);
create index IX_70DA9ECB on LayoutRevision (layoutSetBranchId, plid, status);
create index IX_7FFAE700 on LayoutRevision (layoutSetBranchId, status);
create index IX_27F4B32A on LayoutRevision (plid, head);
create index IX_8EC3D2BC on LayoutRevision (plid, status);
create index IX_421223B1 on LayoutRevision (status);

create unique index IX_3F2A9AEF on LayoutSet (groupId, privateLayout, ctCollectionId);
create index IX_C629311 on LayoutSet (layoutSetPrototypeUuid, companyId);
create index IX_1B698D9 on LayoutSet (privateLayout, logoId);

create index IX_CCF0DA29 on LayoutSetBranch (groupId, privateLayout, master);
create unique index IX_5FF18552 on LayoutSetBranch (groupId, privateLayout, name);

create index IX_9178FC71 on LayoutSetPrototype (companyId, active_);
create index IX_C5D69B24 on LayoutSetPrototype (uuid_);

create unique index IX_BF6DBF8A on ListType (companyId, type_, name);
create index IX_56E29D16 on ListType (uuid_);

create index IX_C28C72EC on MembershipRequest (groupId, statusId);
create index IX_35AA8FA6 on MembershipRequest (groupId, userId, statusId);
create index IX_66D70879 on MembershipRequest (userId);

create index IX_6AF0D434 on OrgLabor (organizationId);

create unique index IX_87E47DA9 on Organization_ (companyId, ctCollectionId, externalReferenceCode);
create unique index IX_F1E40A53 on Organization_ (companyId, name, ctCollectionId);
create index IX_4BCBAB21 on Organization_ (companyId, name, parentOrganizationId);
create index IX_418E4522 on Organization_ (companyId, parentOrganizationId);
create index IX_396D6B42 on Organization_ (uuid_);

create index IX_2C1142E on PasswordPolicy (companyId, defaultPolicy);
create unique index IX_3FBFA9F4 on PasswordPolicy (companyId, name);
create index IX_51437A01 on PasswordPolicy (uuid_);

create unique index IX_C3A17327 on PasswordPolicyRel (classNameId, classPK);
create index IX_CD25266E on PasswordPolicyRel (passwordPolicyId);

create index IX_326F75BD on PasswordTracker (userId);

create index IX_812CE07A on Phone (companyId, classNameId, classPK, primary_);
create index IX_F202B9CE on Phone (userId);
create index IX_EA6245A0 on Phone (uuid_);

create unique index IX_7171B2E8 on PluginSetting (companyId, pluginId, pluginType);

create unique index IX_D5E35599 on PortalPreferenceValue (portalPreferencesId, namespace, key_, index_);
create index IX_737DBC36 on PortalPreferenceValue (portalPreferencesId, namespace, key_, smallValue);

create index IX_D1846D13 on PortalPreferences (ownerType, ownerId);

create unique index IX_12B5E51D on Portlet (companyId, portletId);

create index IX_C6246ECD on PortletItem (groupId, classNameId, portletId, name);

create index IX_EE8C5489 on PortletPreferenceValue (name, smallValue, companyId);
create unique index IX_B517784D on PortletPreferenceValue (portletPreferencesId, name, index_, ctCollectionId);
create index IX_8E75AB8C on PortletPreferenceValue (portletPreferencesId, name, smallValue);

create index IX_3EAB5A5A on PortletPreferences (ownerId);
create index IX_6DD4B410 on PortletPreferences (ownerType, ownerId, plid);
create index IX_F15C1C4F on PortletPreferences (plid);
create index IX_CEA05B46 on PortletPreferences (portletId, ownerType, ownerId, companyId);
create unique index IX_8CCEB8CB on PortletPreferences (portletId, ownerType, ownerId, plid, ctCollectionId);
create index IX_EF5FCC07 on PortletPreferences (portletId, ownerType, plid);
create index IX_8DCFD52C on PortletPreferences (portletId, plid);

create index IX_A1A8CB8B on RatingsEntry (classNameId, classPK, score);
create unique index IX_119FF2EF on RatingsEntry (classNameId, classPK, userId, ctCollectionId);
create index IX_C34DEAF2 on RatingsEntry (uuid_);

create unique index IX_C286E0E2 on RatingsStats (classNameId, classPK, ctCollectionId);

create index IX_B91F79BD on RecentLayoutBranch (groupId);
create index IX_351E86E8 on RecentLayoutBranch (layoutBranchId);
create unique index IX_C27D6369 on RecentLayoutBranch (userId, layoutSetBranchId, plid);

create index IX_8D8A2724 on RecentLayoutRevision (groupId);
create index IX_DA0788DA on RecentLayoutRevision (layoutRevisionId);
create unique index IX_4C600BD0 on RecentLayoutRevision (userId, layoutSetBranchId, plid);

create index IX_711995A5 on RecentLayoutSetBranch (groupId);
create index IX_23FF0700 on RecentLayoutSetBranch (layoutSetBranchId);
create unique index IX_4654D204 on RecentLayoutSetBranch (userId, layoutSetId);

create index IX_2D9A426F on Region (active_);
create index IX_11FB3E42 on Region (countryId, active_);
create unique index IX_183BFDBA on Region (countryId, regionCode, ctCollectionId);
create index IX_48A89E9A on Region (uuid_);

create unique index IX_982329B on RegionLocalization (regionId, languageId, ctCollectionId);

create unique index IX_8BD6BCA7 on Release_ (servletContextName);

create index IX_D4C6FBCB on RememberMeToken (expirationDate);
create index IX_291F58D4 on RememberMeToken (userId);

create unique index IX_470608AE on Repository (groupId, ctCollectionId, name, portletId);
create unique index IX_4009E884 on Repository (uuid_, groupId, ctCollectionId);

create unique index IX_B43A3F67 on RepositoryEntry (repositoryId, ctCollectionId, mappedId);
create unique index IX_239165C6 on RepositoryEntry (uuid_, ctCollectionId, groupId);

create unique index IX_EDB9986E on ResourceAction (name, actionId);

create index IX_26284944 on ResourcePermission (companyId, primKey);
create unique index IX_F2237D8E on ResourcePermission (companyId, scope, name, primKey, roleId, ctCollectionId);
create index IX_FA3E7EEB on ResourcePermission (companyId, scope, name, roleId, primKeyId, viewActionId);
create index IX_F6BAE86A on ResourcePermission (companyId, scope, primKey);
create index IX_D5F1E2A2 on ResourcePermission (name);
create index IX_A37A0588 on ResourcePermission (roleId);
create index IX_F4555981 on ResourcePermission (scope);

create unique index IX_CC85CC2C on Role_ (companyId, ctCollectionId, classNameId, classPK);
create unique index IX_D11C3796 on Role_ (companyId, ctCollectionId, name);
create index IX_F436EC8E on Role_ (name);
create index IX_5EB4E2FB on Role_ (subtype);
create index IX_CBE204 on Role_ (type_, subtype);
create index IX_26DB26C5 on Role_ (uuid_);

create unique index IX_4F0315B8 on ServiceComponent (buildNamespace, buildNumber);

create index IX_F542E9BC on SocialActivity (activitySetId);
create unique index IX_7E6A9AAD on SocialActivity (classNameId, classPK, groupId, userId, type_, receiverUserId, ctCollectionId, createDate);
create index IX_85370BF4 on SocialActivity (classNameId, classPK, mirrorActivityId);
create index IX_D0E9029E on SocialActivity (classNameId, classPK, type_);
create index IX_64B1BC66 on SocialActivity (companyId);
create index IX_2A2468 on SocialActivity (groupId);
create index IX_1271F25F on SocialActivity (mirrorActivityId);
create index IX_121CA3CB on SocialActivity (receiverUserId);
create index IX_3504B8BC on SocialActivity (userId);

create index IX_83E16F2F on SocialActivityAchievement (groupId, firstInGroup);
create index IX_8F6408F0 on SocialActivityAchievement (groupId, name);
create index IX_AABC18E9 on SocialActivityAchievement (groupId, userId, firstInGroup);
create unique index IX_5ED94F08 on SocialActivityAchievement (groupId, userId, name, ctCollectionId);

create index IX_A4B9A23B on SocialActivityCounter (classNameId, classPK);
create unique index IX_56195A6B on SocialActivityCounter (groupId, classNameId, classPK, ownerType, name, ctCollectionId, endPeriod);
create unique index IX_379AA3B2 on SocialActivityCounter (groupId, classNameId, classPK, ownerType, name, ctCollectionId, startPeriod);

create index IX_B15863FA on SocialActivityLimit (classNameId, classPK);
create unique index IX_4A636E75 on SocialActivityLimit (groupId, userId, classNameId, classPK, activityType, activityCounterName, ctCollectionId);
create index IX_6F9EDE9F on SocialActivityLimit (userId);

create index IX_9E13F2DE on SocialActivitySet (groupId);
create index IX_5D1FA9E on SocialActivitySet (type_, classNameId, classPK);
create index IX_241D10A4 on SocialActivitySet (userId, type_, classNameId, classPK);
create index IX_6D0C8733 on SocialActivitySet (userId, type_, groupId, classNameId);

create index IX_384788CD on SocialActivitySetting (groupId, activityType);
create index IX_D984AABA on SocialActivitySetting (groupId, classNameId, activityType, name);

create index IX_61171E99 on SocialRelation (companyId);
create index IX_5E1F07A2 on SocialRelation (type_, companyId);
create unique index IX_ECA579C5 on SocialRelation (type_, userId1, userId2, ctCollectionId);
create index IX_C91168D6 on SocialRelation (type_, userId2);
create index IX_B5C9C690 on SocialRelation (userId1, userId2);
create index IX_5A40D18D on SocialRelation (userId2);
create index IX_F0CA24A5 on SocialRelation (uuid_);

create index IX_E8468A49 on SocialRequest (classNameId, classPK, receiverUserId, status, type_);
create index IX_A90FE5A0 on SocialRequest (companyId);
create index IX_D9380CB7 on SocialRequest (receiverUserId, status);
create unique index IX_2FE40453 on SocialRequest (userId, classNameId, classPK, receiverUserId, type_, ctCollectionId);
create index IX_7CFF5CB8 on SocialRequest (userId, classNameId, classPK, status, type_);
create index IX_AB5906A8 on SocialRequest (userId, status);
create unique index IX_87DD8A60 on SocialRequest (uuid_, ctCollectionId, groupId);

create index IX_FFCBB747 on SystemEvent (groupId, classNameId, classPK, type_);
create index IX_A19C89FF on SystemEvent (groupId, systemEventSetKey);

create index IX_93AB8545 on Team (companyId);
create unique index IX_58777164 on Team (groupId, ctCollectionId, name);
create unique index IX_1AAF62D7 on Team (uuid_, groupId, ctCollectionId);

create index IX_DAD135B4 on Ticket (classNameId, classPK, companyId, type_);
create index IX_1E8DFB2E on Ticket (classNameId, classPK, type_);
create index IX_B2468446 on Ticket (key_);

create unique index IX_A33BD191 on UserGroup (companyId, ctCollectionId, externalReferenceCode);
create unique index IX_3F4FC96B on UserGroup (companyId, name, ctCollectionId);
create index IX_69771487 on UserGroup (companyId, parentUserGroupId);
create index IX_5F1DD85A on UserGroup (uuid_);

create index IX_CAB0CCC8 on UserGroupGroupRole (groupId, roleId);
create unique index IX_618D3E5F on UserGroupGroupRole (groupId, userGroupId, roleId, ctCollectionId);
create index IX_1CDF88C on UserGroupGroupRole (roleId);
create index IX_DCDED558 on UserGroupGroupRole (userGroupId);

create index IX_871412DF on UserGroupRole (groupId, roleId);
create unique index IX_5427FB77 on UserGroupRole (groupId, userId, roleId, ctCollectionId);
create index IX_887A2C95 on UserGroupRole (roleId);
create index IX_887BE56A on UserGroupRole (userId);

create index IX_2AC5356C on UserGroups_Teams (companyId);
create index IX_7F187E63 on UserGroups_Teams (userGroupId);

create unique index IX_41A32E0D on UserIdMapper (type_, externalUserId);
create unique index IX_D1C44A6E on UserIdMapper (userId, type_);

create unique index IX_8B6E3ACE on UserNotificationDelivery (userId, portletId, classNameId, notificationType, deliveryType);

create index IX_BF29100B on UserNotificationEvent (type_);
create index IX_6E095243 on UserNotificationEvent (userId, archived, actionRequired);
create index IX_E32CC19 on UserNotificationEvent (userId, delivered, actionRequired);
create index IX_AE54166F on UserNotificationEvent (userId, delivered, archived, actionRequired);
create index IX_7522B7DB on UserNotificationEvent (userId, delivered, deliveryType, actionRequired);
create index IX_3BE9B7B1 on UserNotificationEvent (userId, delivered, deliveryType, archived, actionRequired);
create index IX_2AB8294D on UserNotificationEvent (userId, delivered, deliveryType, archived, type_);
create index IX_105871E3 on UserNotificationEvent (userId, delivered, deliveryType, type_);
create index IX_EBF87241 on UserNotificationEvent (userId, delivered, type_, timestamp);
create index IX_D60FB085 on UserNotificationEvent (userId, deliveryType, archived, actionRequired);
create index IX_ECD8CFEA on UserNotificationEvent (uuid_);

create index IX_29BA1CF5 on UserTracker (companyId);
create index IX_46B0AE8E on UserTracker (sessionId);
create index IX_E4EFBA8D on UserTracker (userId);

create index IX_14D8BCC0 on UserTrackerPath (userTrackerId);

create index IX_BCFDA257 on User_ (companyId, createDate, modifiedDate);
create unique index IX_77D89D58 on User_ (companyId, ctCollectionId, emailAddress);
create unique index IX_6FF64E11 on User_ (companyId, ctCollectionId, externalReferenceCode);
create unique index IX_6B7C3D77 on User_ (companyId, ctCollectionId, screenName);
create index IX_1D731F03 on User_ (companyId, facebookId);
create index IX_B6E3AE1 on User_ (companyId, googleUserId);
create index IX_EE8ABD19 on User_ (companyId, modifiedDate);
create index IX_89509087 on User_ (companyId, openId);
create index IX_F6039434 on User_ (companyId, status);
create index IX_FD06BAAD on User_ (companyId, type_, status);
create unique index IX_E902F853 on User_ (ctCollectionId, contactId);
create index IX_762F63C6 on User_ (emailAddress);
create index IX_A18034A4 on User_ (portraitId);
create index IX_E0422BDA on User_ (uuid_);

create index IX_3499B657 on Users_Groups (companyId);
create index IX_F10B6C6B on Users_Groups (userId);

create index IX_5FBB883C on Users_Orgs (companyId);
create index IX_FB646CA6 on Users_Orgs (userId);

create index IX_F987A0DC on Users_Roles (companyId);
create index IX_C1A01806 on Users_Roles (userId);

create index IX_799F8283 on Users_Teams (companyId);
create index IX_A098EFBF on Users_Teams (userId);

create index IX_BB65040C on Users_UserGroups (companyId);
create index IX_66FF2503 on Users_UserGroups (userGroupId);

create index IX_EECA5FDA on VirtualHost (companyId, layoutSetId, defaultVirtualHost);
create unique index IX_76A64FBE on VirtualHost (hostname, ctCollectionId);
create index IX_774643D1 on VirtualHost (layoutSetId, hostname);

create unique index IX_97DFA146 on WebDAVProps (classNameId, classPK);

create index IX_1AA07A6D on Website (companyId, classNameId, classPK, primary_);
create index IX_F75690BB on Website (userId);
create index IX_76F15D13 on Website (uuid_);

create index IX_EB4D2E32 on WorkflowDefinitionLink (companyId, groupId, classNameId, classPK, typePK);
create index IX_4AE45F6F on WorkflowDefinitionLink (companyId, groupId, classPK);
create index IX_A4DB1F0F on WorkflowDefinitionLink (companyId, workflowDefinitionName, workflowDefinitionVersion);

create index IX_415A7007 on WorkflowInstanceLink (groupId, companyId, classNameId, classPK);



