drop database if exists lportal;
create database lportal character set utf8;
use lportal;

create table Address (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	addressId bigint not null,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	classNameId bigint,
	classPK bigint,
	countryId bigint,
	listTypeId bigint,
	regionId bigint,
	city varchar(75) null,
	description longtext null,
	latitude double,
	longitude double,
	mailing tinyint,
	name varchar(255) null,
	primary_ tinyint,
	street1 varchar(255) null,
	street2 varchar(255) null,
	street3 varchar(255) null,
	validationDate datetime(6) null,
	validationStatus integer,
	zip varchar(75) null,
	primary key (addressId, ctCollectionId)
) engine InnoDB;

create table AnnouncementsDelivery (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	deliveryId bigint not null,
	companyId bigint,
	userId bigint,
	type_ varchar(75) null,
	email tinyint,
	sms tinyint,
	website tinyint,
	primary key (deliveryId, ctCollectionId)
) engine InnoDB;

create table AnnouncementsEntry (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	entryId bigint not null,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	classNameId bigint,
	classPK bigint,
	title varchar(75) null,
	content longtext null,
	url longtext null,
	type_ varchar(75) null,
	displayDate datetime(6) null,
	expirationDate datetime(6) null,
	priority integer,
	alert tinyint,
	primary key (entryId, ctCollectionId)
) engine InnoDB;

create table AnnouncementsFlag (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	flagId bigint not null,
	companyId bigint,
	userId bigint,
	createDate datetime(6) null,
	entryId bigint,
	value integer,
	primary key (flagId, ctCollectionId)
) engine InnoDB;

create table AssetCategory (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	categoryId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	parentCategoryId bigint,
	treePath longtext null,
	name varchar(255) null,
	title longtext null,
	description longtext null,
	vocabularyId bigint,
	lastPublishDate datetime(6) null,
	primary key (categoryId, ctCollectionId)
) engine InnoDB;

create table AssetEntries_AssetTags (
	companyId bigint not null,
	entryId bigint not null,
	tagId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType tinyint,
	primary key (entryId, tagId, ctCollectionId)
) engine InnoDB;

create table AssetEntry (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	entryId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	classNameId bigint,
	classPK bigint,
	classUuid varchar(75) null,
	classTypeId bigint,
	listable tinyint,
	visible tinyint,
	startDate datetime(6) null,
	endDate datetime(6) null,
	publishDate datetime(6) null,
	expirationDate datetime(6) null,
	mimeType varchar(75) null,
	title longtext null,
	description longtext null,
	summary longtext null,
	url longtext null,
	layoutUuid varchar(75) null,
	height integer,
	width integer,
	priority double,
	primary key (entryId, ctCollectionId)
) engine InnoDB;

create table AssetTag (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	tagId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	name varchar(75) null,
	assetCount integer,
	lastPublishDate datetime(6) null,
	primary key (tagId, ctCollectionId)
) engine InnoDB;

create table AssetVocabulary (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	vocabularyId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	name varchar(75) null,
	title longtext null,
	description longtext null,
	settings_ longtext null,
	visibilityType integer,
	lastPublishDate datetime(6) null,
	primary key (vocabularyId, ctCollectionId)
) engine InnoDB;

create table BrowserTracker (
	mvccVersion bigint default 0 not null,
	browserTrackerId bigint not null primary key,
	companyId bigint,
	userId bigint,
	browserKey bigint
) engine InnoDB;

create table ClassName_ (
	mvccVersion bigint default 0 not null,
	classNameId bigint not null primary key,
	value varchar(200) null
) engine InnoDB;

create table Company (
	mvccVersion bigint default 0 not null,
	companyId bigint not null primary key,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	webId varchar(75) null,
	mx varchar(200) null,
	homeURL longtext null,
	logoId bigint,
	maxUsers integer,
	active_ tinyint,
	name varchar(75) null,
	legalName varchar(75) null,
	legalId varchar(75) null,
	legalType varchar(75) null,
	sicCode varchar(75) null,
	tickerSymbol varchar(75) null,
	industry varchar(75) null,
	type_ varchar(75) null,
	size_ varchar(75) null,
	indexNameCurrent varchar(75) null,
	indexNameNext varchar(75) null
) engine InnoDB;

create table CompanyInfo (
	mvccVersion bigint default 0 not null,
	companyInfoId bigint not null primary key,
	companyId bigint,
	key_ longtext null
) engine InnoDB;

create table Contact_ (
	mvccVersion bigint default 0 not null,
	contactId bigint not null primary key,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	classNameId bigint,
	classPK bigint,
	parentContactId bigint,
	emailAddress varchar(254) null,
	firstName varchar(75) null,
	middleName varchar(75) null,
	lastName varchar(75) null,
	prefixListTypeId bigint,
	suffixListTypeId bigint,
	male tinyint,
	birthday datetime(6) null,
	smsSn varchar(75) null,
	facebookSn varchar(75) null,
	jabberSn varchar(75) null,
	skypeSn varchar(75) null,
	twitterSn varchar(75) null,
	employeeStatusId varchar(75) null,
	employeeNumber varchar(75) null,
	jobTitle varchar(100) null,
	jobClass varchar(75) null,
	hoursOfOperation varchar(75) null
) engine InnoDB;

create table Counter (
	name varchar(150) not null primary key,
	currentId bigint
) engine InnoDB;

create table Country (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	defaultLanguageId varchar(75) null,
	countryId bigint not null,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	a2 varchar(75) null,
	a3 varchar(75) null,
	active_ tinyint,
	billingAllowed tinyint,
	groupFilterEnabled tinyint,
	idd_ varchar(75) null,
	name varchar(75) null,
	number_ varchar(75) null,
	position double,
	shippingAllowed tinyint,
	subjectToVAT tinyint,
	zipRequired tinyint,
	lastPublishDate datetime(6) null,
	primary key (countryId, ctCollectionId)
) engine InnoDB;

create table CountryLocalization (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	countryLocalizationId bigint not null,
	companyId bigint,
	countryId bigint,
	languageId varchar(75) null,
	title varchar(75) null,
	primary key (countryLocalizationId, ctCollectionId)
) engine InnoDB;

create table DLFileEntry (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	fileEntryId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	classNameId bigint,
	classPK bigint,
	repositoryId bigint,
	folderId bigint,
	treePath longtext null,
	name varchar(255) null,
	fileName varchar(255) null,
	extension varchar(75) null,
	mimeType varchar(75) null,
	title varchar(255) null,
	description longtext null,
	extraSettings longtext null,
	fileEntryTypeId bigint,
	version varchar(75) null,
	size_ bigint,
	smallImageId bigint,
	largeImageId bigint,
	custom1ImageId bigint,
	custom2ImageId bigint,
	manualCheckInRequired tinyint,
	displayDate datetime(6) null,
	expirationDate datetime(6) null,
	reviewDate datetime(6) null,
	lastPublishDate datetime(6) null,
	primary key (fileEntryId, ctCollectionId)
) engine InnoDB;

create table DLFileEntryMetadata (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	fileEntryMetadataId bigint not null,
	companyId bigint,
	DDMStorageId bigint,
	DDMStructureId bigint,
	fileEntryId bigint,
	fileVersionId bigint,
	primary key (fileEntryMetadataId, ctCollectionId)
) engine InnoDB;

create table DLFileEntryType (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	fileEntryTypeId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	dataDefinitionId bigint,
	fileEntryTypeKey varchar(75) null,
	name longtext null,
	description longtext null,
	scope integer,
	lastPublishDate datetime(6) null,
	primary key (fileEntryTypeId, ctCollectionId)
) engine InnoDB;

create table DLFileEntryTypes_DLFolders (
	companyId bigint not null,
	fileEntryTypeId bigint not null,
	folderId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType tinyint,
	primary key (fileEntryTypeId, folderId, ctCollectionId)
) engine InnoDB;

create table DLFileShortcut (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	fileShortcutId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	repositoryId bigint,
	folderId bigint,
	toFileEntryId bigint,
	treePath longtext null,
	active_ tinyint,
	lastPublishDate datetime(6) null,
	status integer,
	statusByUserId bigint,
	statusByUserName varchar(75) null,
	statusDate datetime(6) null,
	primary key (fileShortcutId, ctCollectionId)
) engine InnoDB;

create table DLFileVersion (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	fileVersionId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	repositoryId bigint,
	folderId bigint,
	fileEntryId bigint,
	treePath longtext null,
	fileName varchar(255) null,
	extension varchar(75) null,
	mimeType varchar(75) null,
	title varchar(255) null,
	description longtext null,
	changeLog varchar(75) null,
	extraSettings longtext null,
	fileEntryTypeId bigint,
	version varchar(75) null,
	size_ bigint,
	checksum varchar(75) null,
	storeUUID varchar(255) null,
	displayDate datetime(6) null,
	expirationDate datetime(6) null,
	reviewDate datetime(6) null,
	lastPublishDate datetime(6) null,
	status integer,
	statusByUserId bigint,
	statusByUserName varchar(75) null,
	statusDate datetime(6) null,
	primary key (fileVersionId, ctCollectionId)
) engine InnoDB;

create table DLFolder (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	folderId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	repositoryId bigint,
	mountPoint tinyint,
	parentFolderId bigint,
	treePath longtext null,
	name varchar(255) null,
	description longtext null,
	lastPostDate datetime(6) null,
	defaultFileEntryTypeId bigint,
	hidden_ tinyint,
	restrictionType integer,
	lastPublishDate datetime(6) null,
	status integer,
	statusByUserId bigint,
	statusByUserName varchar(75) null,
	statusDate datetime(6) null,
	primary key (folderId, ctCollectionId)
) engine InnoDB;

create table EmailAddress (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	emailAddressId bigint not null,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	classNameId bigint,
	classPK bigint,
	address varchar(254) null,
	listTypeId bigint,
	primary_ tinyint,
	primary key (emailAddressId, ctCollectionId)
) engine InnoDB;

create table ExpandoColumn (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	columnId bigint not null,
	companyId bigint,
	modifiedDate datetime(6) null,
	tableId bigint,
	name varchar(75) null,
	type_ integer,
	defaultData longtext null,
	typeSettings longtext null,
	primary key (columnId, ctCollectionId)
) engine InnoDB;

create table ExpandoRow (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	rowId_ bigint not null,
	companyId bigint,
	modifiedDate datetime(6) null,
	tableId bigint,
	classPK bigint,
	primary key (rowId_, ctCollectionId)
) engine InnoDB;

create table ExpandoTable (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	tableId bigint not null,
	companyId bigint,
	classNameId bigint,
	name varchar(75) null,
	primary key (tableId, ctCollectionId)
) engine InnoDB;

create table ExpandoValue (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	valueId bigint not null,
	companyId bigint,
	tableId bigint,
	columnId bigint,
	rowId_ bigint,
	classNameId bigint,
	classPK bigint,
	data_ longtext null,
	primary key (valueId, ctCollectionId)
) engine InnoDB;

create table ExportImportConfiguration (
	mvccVersion bigint default 0 not null,
	exportImportConfigurationId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	name varchar(200) null,
	description longtext null,
	type_ integer,
	settings_ longtext null,
	status integer,
	statusByUserId bigint,
	statusByUserName varchar(75) null,
	statusDate datetime(6) null
) engine InnoDB;

create table Group_ (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	groupId bigint not null,
	companyId bigint,
	creatorUserId bigint,
	modifiedDate datetime(6) null,
	classNameId bigint,
	classPK bigint,
	parentGroupId bigint,
	liveGroupId bigint,
	treePath longtext null,
	groupKey varchar(150) null,
	name longtext null,
	description longtext null,
	type_ integer,
	typeSettings longtext null,
	manualMembership tinyint,
	membershipRestriction integer,
	friendlyURL varchar(255) null,
	site tinyint,
	remoteStagingGroupCount integer,
	inheritContent tinyint,
	active_ tinyint,
	primary key (groupId, ctCollectionId)
) engine InnoDB;

create table Groups_Orgs (
	companyId bigint not null,
	groupId bigint not null,
	organizationId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType tinyint,
	primary key (groupId, organizationId, ctCollectionId)
) engine InnoDB;

create table Groups_Roles (
	companyId bigint not null,
	groupId bigint not null,
	roleId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType tinyint,
	primary key (groupId, roleId, ctCollectionId)
) engine InnoDB;

create table Groups_UserGroups (
	companyId bigint not null,
	groupId bigint not null,
	userGroupId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType tinyint,
	primary key (groupId, userGroupId, ctCollectionId)
) engine InnoDB;

create table Image (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	imageId bigint not null,
	companyId bigint,
	modifiedDate datetime(6) null,
	type_ varchar(75) null,
	height integer,
	width integer,
	size_ integer,
	primary key (imageId, ctCollectionId)
) engine InnoDB;

create table Layout (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	plid bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	parentPlid bigint,
	privateLayout tinyint,
	layoutId bigint,
	parentLayoutId bigint,
	classNameId bigint,
	classPK bigint,
	name longtext null,
	title longtext null,
	description longtext null,
	keywords longtext null,
	robots longtext null,
	type_ varchar(75) null,
	typeSettings longtext null,
	hidden_ tinyint,
	system_ tinyint,
	friendlyURL varchar(255) null,
	iconImageId bigint,
	themeId varchar(75) null,
	colorSchemeId varchar(75) null,
	styleBookEntryId bigint,
	css longtext null,
	priority integer,
	faviconFileEntryId bigint,
	masterLayoutPlid bigint,
	layoutPrototypeUuid varchar(75) null,
	layoutPrototypeLinkEnabled tinyint,
	sourcePrototypeLayoutUuid varchar(75) null,
	publishDate datetime(6) null,
	lastPublishDate datetime(6) null,
	status integer,
	statusByUserId bigint,
	statusByUserName varchar(75) null,
	statusDate datetime(6) null,
	primary key (plid, ctCollectionId)
) engine InnoDB;

create table LayoutBranch (
	mvccVersion bigint default 0 not null,
	layoutBranchId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	layoutSetBranchId bigint,
	plid bigint,
	name varchar(75) null,
	description longtext null,
	master tinyint
) engine InnoDB;

create table LayoutFriendlyURL (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	layoutFriendlyURLId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	plid bigint,
	privateLayout tinyint,
	friendlyURL varchar(255) null,
	languageId varchar(75) null,
	lastPublishDate datetime(6) null,
	primary key (layoutFriendlyURLId, ctCollectionId)
) engine InnoDB;

create table LayoutPrototype (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	layoutPrototypeId bigint not null,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	name longtext null,
	description longtext null,
	settings_ longtext null,
	active_ tinyint,
	primary key (layoutPrototypeId, ctCollectionId)
) engine InnoDB;

create table LayoutRevision (
	mvccVersion bigint default 0 not null,
	layoutRevisionId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	layoutSetBranchId bigint,
	layoutBranchId bigint,
	parentLayoutRevisionId bigint,
	head tinyint,
	major tinyint,
	plid bigint,
	privateLayout tinyint,
	name longtext null,
	title longtext null,
	description longtext null,
	keywords longtext null,
	robots longtext null,
	typeSettings longtext null,
	iconImageId bigint,
	themeId varchar(75) null,
	colorSchemeId varchar(75) null,
	css longtext null,
	status integer,
	statusByUserId bigint,
	statusByUserName varchar(75) null,
	statusDate datetime(6) null
) engine InnoDB;

create table LayoutSet (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	layoutSetId bigint not null,
	groupId bigint,
	companyId bigint,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	privateLayout tinyint,
	logoId bigint,
	themeId varchar(75) null,
	colorSchemeId varchar(75) null,
	faviconFileEntryId bigint,
	css longtext null,
	settings_ longtext null,
	layoutSetPrototypeUuid varchar(75) null,
	layoutSetPrototypeLinkEnabled tinyint,
	primary key (layoutSetId, ctCollectionId)
) engine InnoDB;

create table LayoutSetBranch (
	mvccVersion bigint default 0 not null,
	layoutSetBranchId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	privateLayout tinyint,
	name varchar(75) null,
	description longtext null,
	master tinyint,
	logoId bigint,
	themeId varchar(75) null,
	colorSchemeId varchar(75) null,
	css longtext null,
	settings_ longtext null,
	layoutSetPrototypeUuid varchar(75) null,
	layoutSetPrototypeLinkEnabled tinyint
) engine InnoDB;

create table LayoutSetPrototype (
	mvccVersion bigint default 0 not null,
	uuid_ varchar(75) null,
	layoutSetPrototypeId bigint not null primary key,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	name longtext null,
	description longtext null,
	settings_ longtext null,
	active_ tinyint
) engine InnoDB;

create table ListType (
	mvccVersion bigint default 0 not null,
	uuid_ varchar(75) null,
	listTypeId bigint not null primary key,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	name varchar(75) null,
	type_ varchar(75) null
) engine InnoDB;

create table MembershipRequest (
	mvccVersion bigint default 0 not null,
	membershipRequestId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	createDate datetime(6) null,
	comments longtext null,
	replyComments longtext null,
	replyDate datetime(6) null,
	replierUserId bigint,
	statusId bigint
) engine InnoDB;

create table OrgLabor (
	mvccVersion bigint default 0 not null,
	orgLaborId bigint not null primary key,
	companyId bigint,
	organizationId bigint,
	listTypeId bigint,
	sunOpen integer,
	sunClose integer,
	monOpen integer,
	monClose integer,
	tueOpen integer,
	tueClose integer,
	wedOpen integer,
	wedClose integer,
	thuOpen integer,
	thuClose integer,
	friOpen integer,
	friClose integer,
	satOpen integer,
	satClose integer
) engine InnoDB;

create table Organization_ (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	organizationId bigint not null,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	parentOrganizationId bigint,
	treePath longtext null,
	name varchar(100) null,
	type_ varchar(75) null,
	recursable tinyint,
	regionId bigint,
	countryId bigint,
	statusListTypeId bigint,
	comments longtext null,
	logoId bigint,
	primary key (organizationId, ctCollectionId)
) engine InnoDB;

create table PasswordPolicy (
	mvccVersion bigint default 0 not null,
	uuid_ varchar(75) null,
	passwordPolicyId bigint not null primary key,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	defaultPolicy tinyint,
	name varchar(75) null,
	description longtext null,
	changeable tinyint,
	changeRequired tinyint,
	minAge bigint,
	checkSyntax tinyint,
	allowDictionaryWords tinyint,
	minAlphanumeric integer,
	minLength integer,
	minLowerCase integer,
	minNumbers integer,
	minSymbols integer,
	minUpperCase integer,
	regex longtext null,
	history tinyint,
	historyCount integer,
	expireable tinyint,
	maxAge bigint,
	warningTime bigint,
	graceLimit integer,
	lockout tinyint,
	maxFailure integer,
	lockoutDuration bigint,
	requireUnlock tinyint,
	resetFailureCount bigint,
	resetTicketMaxAge bigint
) engine InnoDB;

create table PasswordPolicyRel (
	mvccVersion bigint default 0 not null,
	passwordPolicyRelId bigint not null primary key,
	companyId bigint,
	passwordPolicyId bigint,
	classNameId bigint,
	classPK bigint
) engine InnoDB;

create table PasswordTracker (
	mvccVersion bigint default 0 not null,
	passwordTrackerId bigint not null primary key,
	companyId bigint,
	userId bigint,
	createDate datetime(6) null,
	password_ varchar(255) null
) engine InnoDB;

create table Phone (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	phoneId bigint not null,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	classNameId bigint,
	classPK bigint,
	number_ varchar(75) null,
	extension varchar(75) null,
	listTypeId bigint,
	primary_ tinyint,
	primary key (phoneId, ctCollectionId)
) engine InnoDB;

create table PluginSetting (
	mvccVersion bigint default 0 not null,
	pluginSettingId bigint not null primary key,
	companyId bigint,
	pluginId varchar(75) null,
	pluginType varchar(75) null,
	roles longtext null,
	active_ tinyint
) engine InnoDB;

create table PortalPreferenceValue (
	mvccVersion bigint default 0 not null,
	portalPreferenceValueId bigint not null primary key,
	companyId bigint,
	portalPreferencesId bigint,
	index_ integer,
	key_ varchar(1024) null,
	largeValue longtext null,
	namespace varchar(255) null,
	smallValue varchar(255) null
) engine InnoDB;

create table PortalPreferences (
	mvccVersion bigint default 0 not null,
	portalPreferencesId bigint not null primary key,
	companyId bigint,
	ownerId bigint,
	ownerType integer
) engine InnoDB;

create table Portlet (
	mvccVersion bigint default 0 not null,
	id_ bigint not null primary key,
	companyId bigint,
	portletId varchar(200) null,
	roles longtext null,
	active_ tinyint
) engine InnoDB;

create table PortletItem (
	mvccVersion bigint default 0 not null,
	portletItemId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	name varchar(75) null,
	portletId varchar(200) null,
	classNameId bigint
) engine InnoDB;

create table PortletPreferenceValue (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	portletPreferenceValueId bigint not null,
	companyId bigint,
	portletPreferencesId bigint,
	index_ integer,
	largeValue longtext null,
	name varchar(255) null,
	readOnly tinyint,
	smallValue varchar(255) null,
	primary key (portletPreferenceValueId, ctCollectionId)
) engine InnoDB;

create table PortletPreferences (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	portletPreferencesId bigint not null,
	companyId bigint,
	ownerId bigint,
	ownerType integer,
	plid bigint,
	portletId varchar(200) null,
	primary key (portletPreferencesId, ctCollectionId)
) engine InnoDB;

create table RatingsEntry (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	entryId bigint not null,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	classNameId bigint,
	classPK bigint,
	score double,
	primary key (entryId, ctCollectionId)
) engine InnoDB;

create table RatingsStats (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	statsId bigint not null,
	companyId bigint,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	classNameId bigint,
	classPK bigint,
	totalEntries integer,
	totalScore double,
	averageScore double,
	primary key (statsId, ctCollectionId)
) engine InnoDB;

create table RecentLayoutBranch (
	mvccVersion bigint default 0 not null,
	recentLayoutBranchId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	layoutBranchId bigint,
	layoutSetBranchId bigint,
	plid bigint
) engine InnoDB;

create table RecentLayoutRevision (
	mvccVersion bigint default 0 not null,
	recentLayoutRevisionId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	layoutRevisionId bigint,
	layoutSetBranchId bigint,
	plid bigint
) engine InnoDB;

create table RecentLayoutSetBranch (
	mvccVersion bigint default 0 not null,
	recentLayoutSetBranchId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	layoutSetBranchId bigint,
	layoutSetId bigint
) engine InnoDB;

create table Region (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	defaultLanguageId varchar(75) null,
	regionId bigint not null,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	countryId bigint,
	active_ tinyint,
	name varchar(75) null,
	position double,
	regionCode varchar(75) null,
	lastPublishDate datetime(6) null,
	primary key (regionId, ctCollectionId)
) engine InnoDB;

create table RegionLocalization (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	regionLocalizationId bigint not null,
	companyId bigint,
	regionId bigint,
	languageId varchar(75) null,
	title varchar(75) null,
	primary key (regionLocalizationId, ctCollectionId)
) engine InnoDB;

create table Release_ (
	mvccVersion bigint default 0 not null,
	releaseId bigint not null primary key,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	servletContextName varchar(75) null,
	schemaVersion varchar(75) null,
	buildNumber integer,
	buildDate datetime(6) null,
	verified tinyint,
	state_ integer,
	testString varchar(1024) null
) engine InnoDB;

create table RememberMeToken (
	mvccVersion bigint default 0 not null,
	rememberMeTokenId bigint not null primary key,
	companyId bigint,
	userId bigint,
	createDate datetime(6) null,
	expirationDate datetime(6) null,
	value varchar(255) null
) engine InnoDB;

create table Repository (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	repositoryId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	classNameId bigint,
	name varchar(200) null,
	description longtext null,
	portletId varchar(200) null,
	typeSettings longtext null,
	dlFolderId bigint,
	lastPublishDate datetime(6) null,
	primary key (repositoryId, ctCollectionId)
) engine InnoDB;

create table RepositoryEntry (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	repositoryEntryId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	repositoryId bigint,
	mappedId varchar(255) null,
	manualCheckInRequired tinyint,
	lastPublishDate datetime(6) null,
	primary key (repositoryEntryId, ctCollectionId)
) engine InnoDB;

create table ResourceAction (
	mvccVersion bigint default 0 not null,
	resourceActionId bigint not null primary key,
	name varchar(255) null,
	actionId varchar(75) null,
	bitwiseValue bigint
) engine InnoDB;

create table ResourcePermission (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	resourcePermissionId bigint not null,
	companyId bigint,
	name varchar(255) null,
	scope integer,
	primKey varchar(255) null,
	primKeyId bigint,
	roleId bigint,
	ownerId bigint,
	actionIds bigint,
	viewActionId tinyint,
	primary key (resourcePermissionId, ctCollectionId)
) engine InnoDB;

create table Role_ (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	roleId bigint not null,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	classNameId bigint,
	classPK bigint,
	name varchar(75) null,
	title longtext null,
	description longtext null,
	type_ integer,
	subtype varchar(75) null,
	primary key (roleId, ctCollectionId)
) engine InnoDB;

create table ServiceComponent (
	mvccVersion bigint default 0 not null,
	serviceComponentId bigint not null primary key,
	buildNamespace varchar(75) null,
	buildNumber bigint,
	buildDate bigint,
	data_ longtext null
) engine InnoDB;

create table SocialActivity (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	activityId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	createDate bigint,
	activitySetId bigint,
	mirrorActivityId bigint,
	classNameId bigint,
	classPK bigint,
	parentClassNameId bigint,
	parentClassPK bigint,
	type_ integer,
	extraData longtext null,
	receiverUserId bigint,
	primary key (activityId, ctCollectionId)
) engine InnoDB;

create table SocialActivityAchievement (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	activityAchievementId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	createDate bigint,
	name varchar(75) null,
	firstInGroup tinyint,
	primary key (activityAchievementId, ctCollectionId)
) engine InnoDB;

create table SocialActivityCounter (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	activityCounterId bigint not null,
	groupId bigint,
	companyId bigint,
	classNameId bigint,
	classPK bigint,
	name varchar(75) null,
	ownerType integer,
	currentValue integer,
	totalValue integer,
	graceValue integer,
	startPeriod integer,
	endPeriod integer,
	active_ tinyint,
	primary key (activityCounterId, ctCollectionId)
) engine InnoDB;

create table SocialActivityLimit (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	activityLimitId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	classNameId bigint,
	classPK bigint,
	activityType integer,
	activityCounterName varchar(75) null,
	value varchar(75) null,
	primary key (activityLimitId, ctCollectionId)
) engine InnoDB;

create table SocialActivitySet (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	activitySetId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	createDate bigint,
	modifiedDate bigint,
	classNameId bigint,
	classPK bigint,
	type_ integer,
	extraData longtext null,
	activityCount integer,
	primary key (activitySetId, ctCollectionId)
) engine InnoDB;

create table SocialActivitySetting (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	activitySettingId bigint not null,
	groupId bigint,
	companyId bigint,
	classNameId bigint,
	activityType integer,
	name varchar(75) null,
	value varchar(1024) null,
	primary key (activitySettingId, ctCollectionId)
) engine InnoDB;

create table SocialRelation (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	relationId bigint not null,
	companyId bigint,
	createDate bigint,
	userId1 bigint,
	userId2 bigint,
	type_ integer,
	primary key (relationId, ctCollectionId)
) engine InnoDB;

create table SocialRequest (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	requestId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	createDate bigint,
	modifiedDate bigint,
	classNameId bigint,
	classPK bigint,
	type_ integer,
	extraData longtext null,
	receiverUserId bigint,
	status integer,
	primary key (requestId, ctCollectionId)
) engine InnoDB;

create table SystemEvent (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	systemEventId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	classNameId bigint,
	classPK bigint,
	classUuid varchar(75) null,
	referrerClassNameId bigint,
	parentSystemEventId bigint,
	systemEventSetKey bigint,
	type_ integer,
	extraData longtext null,
	primary key (systemEventId, ctCollectionId)
) engine InnoDB;

create table Team (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	teamId bigint not null,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	groupId bigint,
	name varchar(75) null,
	description longtext null,
	lastPublishDate datetime(6) null,
	primary key (teamId, ctCollectionId)
) engine InnoDB;

create table Ticket (
	mvccVersion bigint default 0 not null,
	ticketId bigint not null primary key,
	companyId bigint,
	createDate datetime(6) null,
	classNameId bigint,
	classPK bigint,
	key_ varchar(255) null,
	type_ integer,
	extraInfo longtext null,
	expirationDate datetime(6) null
) engine InnoDB;

create table UserNotificationDelivery (
	mvccVersion bigint default 0 not null,
	userNotificationDeliveryId bigint not null primary key,
	companyId bigint,
	userId bigint,
	portletId varchar(200) null,
	classNameId bigint,
	notificationType integer,
	deliveryType integer,
	deliver tinyint
) engine InnoDB;

create table User_ (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	userId bigint not null,
	companyId bigint,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	contactId bigint,
	password_ varchar(255) null,
	passwordEncrypted tinyint,
	passwordReset tinyint,
	passwordModifiedDate datetime(6) null,
	digest varchar(255) null,
	reminderQueryQuestion varchar(75) null,
	reminderQueryAnswer varchar(75) null,
	graceLoginCount integer,
	screenName varchar(75) null,
	emailAddress varchar(254) null,
	facebookId bigint,
	googleUserId varchar(75) null,
	ldapServerId bigint,
	openId varchar(1024) null,
	portraitId bigint,
	languageId varchar(75) null,
	timeZoneId varchar(75) null,
	greeting varchar(255) null,
	comments longtext null,
	firstName varchar(75) null,
	middleName varchar(75) null,
	lastName varchar(75) null,
	jobTitle varchar(100) null,
	loginDate datetime(6) null,
	loginIP varchar(75) null,
	lastLoginDate datetime(6) null,
	lastLoginIP varchar(75) null,
	lastFailedLoginDate datetime(6) null,
	failedLoginAttempts integer,
	lockout tinyint,
	lockoutDate datetime(6) null,
	agreedToTermsOfUse tinyint,
	emailAddressVerified tinyint,
	type_ integer,
	status integer,
	primary key (userId, ctCollectionId)
) engine InnoDB;

create table UserGroup (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	userGroupId bigint not null,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	parentUserGroupId bigint,
	name varchar(255) null,
	description longtext null,
	addedByLDAPImport tinyint,
	primary key (userGroupId, ctCollectionId)
) engine InnoDB;

create table UserGroupGroupRole (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	userGroupGroupRoleId bigint not null,
	companyId bigint,
	userGroupId bigint,
	groupId bigint,
	roleId bigint,
	primary key (userGroupGroupRoleId, ctCollectionId)
) engine InnoDB;

create table UserGroupRole (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	userGroupRoleId bigint not null,
	companyId bigint,
	userId bigint,
	groupId bigint,
	roleId bigint,
	primary key (userGroupRoleId, ctCollectionId)
) engine InnoDB;

create table UserGroups_Teams (
	companyId bigint not null,
	teamId bigint not null,
	userGroupId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType tinyint,
	primary key (teamId, userGroupId, ctCollectionId)
) engine InnoDB;

create table UserIdMapper (
	mvccVersion bigint default 0 not null,
	userIdMapperId bigint not null primary key,
	companyId bigint,
	userId bigint,
	type_ varchar(75) null,
	description varchar(75) null,
	externalUserId varchar(75) null
) engine InnoDB;

create table UserNotificationEvent (
	mvccVersion bigint default 0 not null,
	uuid_ varchar(75) null,
	userNotificationEventId bigint not null primary key,
	companyId bigint,
	userId bigint,
	type_ varchar(200) null,
	timestamp bigint,
	deliveryType integer,
	deliverBy bigint,
	delivered tinyint,
	payload longtext null,
	actionRequired tinyint,
	archived tinyint
) engine InnoDB;

create table Users_Groups (
	companyId bigint not null,
	groupId bigint not null,
	userId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType tinyint,
	primary key (groupId, userId, ctCollectionId)
) engine InnoDB;

create table Users_Orgs (
	companyId bigint not null,
	organizationId bigint not null,
	userId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType tinyint,
	primary key (organizationId, userId, ctCollectionId)
) engine InnoDB;

create table Users_Roles (
	companyId bigint not null,
	roleId bigint not null,
	userId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType tinyint,
	primary key (roleId, userId, ctCollectionId)
) engine InnoDB;

create table Users_Teams (
	companyId bigint not null,
	teamId bigint not null,
	userId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType tinyint,
	primary key (teamId, userId, ctCollectionId)
) engine InnoDB;

create table Users_UserGroups (
	companyId bigint not null,
	userId bigint not null,
	userGroupId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType tinyint,
	primary key (userId, userGroupId, ctCollectionId)
) engine InnoDB;

create table UserTracker (
	mvccVersion bigint default 0 not null,
	userTrackerId bigint not null primary key,
	companyId bigint,
	userId bigint,
	modifiedDate datetime(6) null,
	sessionId varchar(200) null,
	remoteAddr varchar(75) null,
	remoteHost varchar(75) null,
	userAgent varchar(200) null
) engine InnoDB;

create table UserTrackerPath (
	mvccVersion bigint default 0 not null,
	userTrackerPathId bigint not null primary key,
	companyId bigint,
	userTrackerId bigint,
	path_ longtext null,
	pathDate datetime(6) null
) engine InnoDB;

create table VirtualHost (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	virtualHostId bigint not null,
	companyId bigint,
	layoutSetId bigint,
	hostname varchar(200) null,
	defaultVirtualHost tinyint,
	languageId varchar(75) null,
	primary key (virtualHostId, ctCollectionId)
) engine InnoDB;

create table WebDAVProps (
	mvccVersion bigint default 0 not null,
	webDavPropsId bigint not null primary key,
	companyId bigint,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	classNameId bigint,
	classPK bigint,
	props longtext null
) engine InnoDB;

create table Website (
	mvccVersion bigint default 0 not null,
	uuid_ varchar(75) null,
	websiteId bigint not null primary key,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	classNameId bigint,
	classPK bigint,
	url longtext null,
	listTypeId bigint,
	primary_ tinyint,
	lastPublishDate datetime(6) null
) engine InnoDB;

create table WorkflowDefinitionLink (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	workflowDefinitionLinkId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	classNameId bigint,
	classPK bigint,
	typePK bigint,
	workflowDefinitionName varchar(75) null,
	workflowDefinitionVersion integer,
	primary key (workflowDefinitionLinkId, ctCollectionId)
) engine InnoDB;

create table WorkflowInstanceLink (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	workflowInstanceLinkId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName varchar(75) null,
	createDate datetime(6) null,
	modifiedDate datetime(6) null,
	classNameId bigint,
	classPK bigint,
	workflowInstanceId bigint,
	primary key (workflowInstanceLinkId, ctCollectionId)
) engine InnoDB;


insert into Counter (name, currentId) values ('com.liferay.counter.kernel.model.Counter', 20000);



commit;


create index IX_FEAFC68A on Address (companyId, classNameId, classPK, listTypeId);
create index IX_923BD178 on Address (companyId, classNameId, classPK, mailing);
create index IX_9226DBB4 on Address (companyId, classNameId, classPK, primary_);
create unique index IX_C0F7C08D on Address (companyId, externalReferenceCode, ctCollectionId);
create index IX_5A2093E7 on Address (countryId);
create index IX_C8E3E87D on Address (regionId);
create index IX_5BC8B0D4 on Address (userId);
create index IX_381E55DA on Address (uuid_);

create index IX_37B0A8A2 on AnnouncementsDelivery (companyId);
create unique index IX_7EA033 on AnnouncementsDelivery (userId, type_, ctCollectionId);

create index IX_14F06A6B on AnnouncementsEntry (classNameId, classPK, alert);
create index IX_94C04525 on AnnouncementsEntry (classNameId, classPK, companyId, alert);
create index IX_3F376E7C on AnnouncementsEntry (companyId);
create index IX_D49C2E66 on AnnouncementsEntry (userId);
create index IX_1AFBDE08 on AnnouncementsEntry (uuid_);

create index IX_EF1F022A on AnnouncementsFlag (companyId);
create index IX_ED8CE4E8 on AnnouncementsFlag (entryId, userId, value);

create unique index IX_F3842169 on AssetCategory (groupId, ctCollectionId, externalReferenceCode);
create index IX_F67BECAD on AssetCategory (groupId, parentCategoryId);
create unique index IX_AF94405C on AssetCategory (groupId, uuid_, ctCollectionId);
create index IX_2710C64A on AssetCategory (groupId, vocabularyId, name);
create index IX_68169942 on AssetCategory (groupId, vocabularyId, parentCategoryId);
create index IX_9DDD15EA on AssetCategory (parentCategoryId, name);
create index IX_4D37BB00 on AssetCategory (uuid_);
create index IX_3537E488 on AssetCategory (vocabularyId, name);
create unique index IX_8C99329D on AssetCategory (vocabularyId, parentCategoryId, name, ctCollectionId);

create index IX_112337B8 on AssetEntries_AssetTags (companyId);
create index IX_B2A61B55 on AssetEntries_AssetTags (tagId);

create unique index IX_7BF8337B on AssetEntry (classNameId, classPK, ctCollectionId);
create index IX_7306C60 on AssetEntry (companyId);
create index IX_75D42FF9 on AssetEntry (expirationDate);
create index IX_6418BB52 on AssetEntry (groupId, classNameId, publishDate, expirationDate);
create index IX_82C4BEF6 on AssetEntry (groupId, classNameId, visible);
create index IX_1EBA6821 on AssetEntry (groupId, classUuid);
create index IX_FEC4A201 on AssetEntry (layoutUuid);
create index IX_2E4E3885 on AssetEntry (publishDate);
create index IX_9029E15A on AssetEntry (visible);

create index IX_D63322F9 on AssetTag (groupId, name);
create index IX_C43137AF on AssetTag (name);
create unique index IX_A43FBC4 on AssetTag (uuid_, groupId, ctCollectionId);

create index IX_B22D908C on AssetVocabulary (companyId);
create unique index IX_E06DEF51 on AssetVocabulary (groupId, ctCollectionId, externalReferenceCode);
create unique index IX_32F2132B on AssetVocabulary (groupId, ctCollectionId, name);
create index IX_C0AAD74D on AssetVocabulary (groupId, name);
create unique index IX_3966DE44 on AssetVocabulary (groupId, uuid_, ctCollectionId);
create index IX_2F7F11EE on AssetVocabulary (groupId, visibilityType);
create index IX_55F58818 on AssetVocabulary (uuid_);

create unique index IX_E7B95510 on BrowserTracker (userId);

create unique index IX_B27A301F on ClassName_ (value);

create index IX_38EFE3FD on Company (logoId);
create index IX_12566EC2 on Company (mx);
create unique index IX_EC00543C on Company (webId);

create unique index IX_85C63FD7 on CompanyInfo (companyId);

create index IX_791914FA on Contact_ (classNameId, classPK);
create index IX_FD2E9BDD on Contact_ (companyId, userId);
create index IX_42F94F9F on Contact_ (userId);

create index IX_25D734CD on Country (active_);
create index IX_F9CD867E on Country (companyId, active_, billingAllowed);
create index IX_54E98CCD on Country (companyId, active_, shippingAllowed);
create unique index IX_7DA11A6F on Country (companyId, ctCollectionId, a2);
create unique index IX_7DA11E30 on Country (companyId, ctCollectionId, a3);
create unique index IX_B2A91789 on Country (companyId, ctCollectionId, name);
create unique index IX_74AB3DC on Country (companyId, ctCollectionId, number_);
create index IX_B59A9078 on Country (uuid_);

create unique index IX_E22A5911 on CountryLocalization (countryId, languageId, ctCollectionId);

create index IX_4CB1B2B4 on DLFileEntry (companyId);
create index IX_B8526DBE on DLFileEntry (custom1ImageId);
create index IX_AC9BDEDD on DLFileEntry (custom2ImageId);
create index IX_772ECDE7 on DLFileEntry (fileEntryTypeId);
create index IX_8F6C75D0 on DLFileEntry (folderId, name);
create index IX_57FFBBCA on DLFileEntry (folderId, repositoryId);
create unique index IX_761F8629 on DLFileEntry (groupId, ctCollectionId, externalReferenceCode);
create unique index IX_672F1AA0 on DLFileEntry (groupId, ctCollectionId, uuid_);
create unique index IX_1920CC0C on DLFileEntry (groupId, folderId, ctCollectionId, fileName);
create unique index IX_7BDA28F0 on DLFileEntry (groupId, folderId, ctCollectionId, name);
create unique index IX_4ADDCFF7 on DLFileEntry (groupId, folderId, ctCollectionId, title);
create index IX_29D0AF28 on DLFileEntry (groupId, folderId, fileEntryTypeId);
create index IX_1DC796CD on DLFileEntry (groupId, folderId, userId);
create index IX_43261870 on DLFileEntry (groupId, userId);
create index IX_4DB7A143 on DLFileEntry (largeImageId);
create index IX_D9492CF6 on DLFileEntry (mimeType);
create index IX_9EE96CAD on DLFileEntry (repositoryId);
create index IX_25F5CAB9 on DLFileEntry (smallImageId, largeImageId, custom1ImageId, custom2ImageId);
create index IX_64F0FE40 on DLFileEntry (uuid_);

create index IX_4F40FE5E on DLFileEntryMetadata (fileEntryId);
create unique index IX_5DC2B977 on DLFileEntryMetadata (fileVersionId, DDMStructureId, ctCollectionId);
create index IX_D49AB5D1 on DLFileEntryMetadata (uuid_);

create unique index IX_93ED0F06 on DLFileEntryType (groupId, ctCollectionId, dataDefinitionId);
create unique index IX_A5C4723D on DLFileEntryType (groupId, ctCollectionId, fileEntryTypeKey);
create unique index IX_C1518AF6 on DLFileEntryType (groupId, uuid_, ctCollectionId);
create index IX_90724726 on DLFileEntryType (uuid_);

create index IX_2E64D9F9 on DLFileEntryTypes_DLFolders (companyId);
create index IX_6E00A2EC on DLFileEntryTypes_DLFolders (folderId);

create index IX_8571953E on DLFileShortcut (companyId, status);
create index IX_17EE3098 on DLFileShortcut (groupId, folderId, active_, status);
create unique index IX_86FE17F8 on DLFileShortcut (groupId, uuid_, ctCollectionId);
create index IX_4B7247F6 on DLFileShortcut (toFileEntryId);
create index IX_4831EBE4 on DLFileShortcut (uuid_);

create index IX_CF394FE on DLFileVersion (companyId, storeUUID);
create unique index IX_10E504DF on DLFileVersion (fileEntryId, version, ctCollectionId);
create index IX_BC5541ED on DLFileVersion (groupId, folderId, version, title);
create index IX_FFB3395C on DLFileVersion (mimeType);
create index IX_5898E799 on DLFileVersion (status, companyId, expirationDate);
create index IX_92309600 on DLFileVersion (status, displayDate);
create index IX_D50EAA41 on DLFileVersion (status, fileEntryId);
create index IX_799D5D47 on DLFileVersion (status, groupId, folderId);
create unique index IX_350F5CAE on DLFileVersion (uuid_, groupId, ctCollectionId);

create index IX_A74DB14C on DLFolder (companyId);
create unique index IX_F0D74691 on DLFolder (groupId, ctCollectionId, externalReferenceCode);
create unique index IX_4C35E652 on DLFolder (groupId, parentFolderId, ctCollectionId, name);
create index IX_CE360BF6 on DLFolder (groupId, parentFolderId, hidden_, status);
create index IX_2D8D2D2B on DLFolder (groupId, parentFolderId, mountPoint, hidden_, status);
create unique index IX_53E6B584 on DLFolder (groupId, uuid_, ctCollectionId);
create index IX_D6D77780 on DLFolder (mountPoint, repositoryId);
create index IX_51556082 on DLFolder (parentFolderId, name);
create index IX_56F3D47C on DLFolder (parentFolderId, repositoryId);
create index IX_EE29C715 on DLFolder (repositoryId);
create index IX_B199E2A6 on DLFolder (status, companyId);
create index IX_CBC408D8 on DLFolder (uuid_);

create index IX_2A2CB130 on EmailAddress (companyId, classNameId, classPK, primary_);
create index IX_7B43CD8 on EmailAddress (userId);
create index IX_D24F3956 on EmailAddress (uuid_);

create unique index IX_4A7D3605 on ExpandoColumn (tableId, name, ctCollectionId);

create index IX_49EB3118 on ExpandoRow (classPK);
create unique index IX_488E0C53 on ExpandoRow (tableId, classPK, ctCollectionId);

create unique index IX_87D370E2 on ExpandoTable (companyId, classNameId, name, ctCollectionId);

create index IX_CAD04B0D on ExpandoValue (classPK, classNameId);
create unique index IX_E6D98E43 on ExpandoValue (columnId, rowId_, ctCollectionId);
create index IX_9112A7A0 on ExpandoValue (rowId_);
create index IX_1BD3F4C on ExpandoValue (tableId, classPK);
create unique index IX_D8C72C45 on ExpandoValue (tableId, columnId, classPK, ctCollectionId);
create index IX_B71E92D5 on ExpandoValue (tableId, rowId_);

create index IX_1827A2E5 on ExportImportConfiguration (companyId);
create index IX_38FA468D on ExportImportConfiguration (groupId, status);
create index IX_47CC6234 on ExportImportConfiguration (groupId, type_, status);

create index IX_75017452 on Group_ (active_, type_);
create index IX_8257E37B on Group_ (classNameId, classPK);
create index IX_DDC91A87 on Group_ (companyId, active_);
create unique index IX_DBA56EF9 on Group_ (companyId, classNameId, ctCollectionId, classPK);
create index IX_ABE2D54 on Group_ (companyId, classNameId, parentGroupId);
create index IX_DF76A247 on Group_ (companyId, classNameId, site);
create unique index IX_23B1C81D on Group_ (companyId, ctCollectionId, externalReferenceCode);
create unique index IX_3551EED4 on Group_ (companyId, ctCollectionId, friendlyURL);
create unique index IX_42E6E774 on Group_ (companyId, ctCollectionId, groupKey);
create index IX_5D75499E on Group_ (companyId, parentGroupId);
create index IX_B91488EC on Group_ (companyId, site, active_);
create index IX_7B216735 on Group_ (companyId, site, parentGroupId, inheritContent);
create index IX_16218A38 on Group_ (liveGroupId);
create index IX_F981514E on Group_ (uuid_);

create index IX_8BFD4548 on Groups_Orgs (companyId);
create index IX_6BBB7682 on Groups_Orgs (organizationId);

create index IX_557D8550 on Groups_Roles (companyId);
create index IX_3103EF3D on Groups_Roles (roleId);

create index IX_676FC818 on Groups_UserGroups (companyId);
create index IX_3B69160F on Groups_UserGroups (userGroupId);

create index IX_6A925A4D on Image (size_);

create index IX_B8E1E6E5 on Layout (classNameId, classPK);
create index IX_881EABCB on Layout (companyId, layoutPrototypeUuid);
create unique index IX_E81EADC5 on Layout (groupId, ctCollectionId, externalReferenceCode);
create index IX_993CBA31 on Layout (groupId, masterLayoutPlid);
create unique index IX_502B1A93 on Layout (groupId, privateLayout, ctCollectionId, friendlyURL);
create unique index IX_4FBF955A on Layout (groupId, privateLayout, ctCollectionId, layoutId);
create unique index IX_18646B93 on Layout (groupId, privateLayout, ctCollectionId, uuid_);
create index IX_7DAA999F on Layout (groupId, privateLayout, parentLayoutId, hidden_);
create index IX_7399B71E on Layout (groupId, privateLayout, parentLayoutId, priority);
create index IX_8F78BAFA on Layout (groupId, privateLayout, parentLayoutId, system_);
create index IX_8CE8C0D9 on Layout (groupId, privateLayout, sourcePrototypeLayoutUuid);
create index IX_A0364689 on Layout (groupId, privateLayout, status);
create index IX_1A1B61D2 on Layout (groupId, privateLayout, type_);
create index IX_6EDC627B on Layout (groupId, type_);
create index IX_23922F7D on Layout (iconImageId);
create index IX_B529BFD3 on Layout (layoutPrototypeUuid);
create index IX_1D4DCAA5 on Layout (parentPlid);
create index IX_3BC009C0 on Layout (privateLayout, iconImageId);
create index IX_39A18ECC on Layout (sourcePrototypeLayoutUuid);
create index IX_D0822724 on Layout (uuid_);

create index IX_A705FF94 on LayoutBranch (layoutSetBranchId, plid, master);
create unique index IX_FD57097D on LayoutBranch (layoutSetBranchId, plid, name);
create index IX_72FC531D on LayoutBranch (plid);

create index IX_EAB317C8 on LayoutFriendlyURL (companyId);
create index IX_C23A9814 on LayoutFriendlyURL (friendlyURL, companyId);
create index IX_D3B2D6DF on LayoutFriendlyURL (friendlyURL, plid);
create unique index IX_8B1B117C on LayoutFriendlyURL (groupId, friendlyURL, ctCollectionId, privateLayout, languageId);
create index IX_26AE82D3 on LayoutFriendlyURL (groupId, friendlyURL, privateLayout);
create unique index IX_2C37488 on LayoutFriendlyURL (groupId, uuid_, ctCollectionId);
create unique index IX_A4D8B1D0 on LayoutFriendlyURL (plid, ctCollectionId, languageId);
create index IX_9F80D54 on LayoutFriendlyURL (uuid_);

create index IX_557A639F on LayoutPrototype (companyId, active_);
create index IX_CEF72136 on LayoutPrototype (uuid_);

create index IX_9EC9F954 on LayoutRevision (layoutSetBranchId, head, status);
create index IX_538BFC54 on LayoutRevision (layoutSetBranchId, plid, head, layoutBranchId);
create index IX_84668240 on LayoutRevision (layoutSetBranchId, plid, layoutBranchId);
create index IX_F93E5CC3 on LayoutRevision (layoutSetBranchId, plid, parentLayoutRevisionId);
create index IX_70DA9ECB on LayoutRevision (layoutSetBranchId, plid, status);
create index IX_7FFAE700 on LayoutRevision (layoutSetBranchId, status);
create index IX_27F4B32A on LayoutRevision (plid, head);
create index IX_8EC3D2BC on LayoutRevision (plid, status);
create index IX_421223B1 on LayoutRevision (status);

create unique index IX_3F2A9AEF on LayoutSet (groupId, privateLayout, ctCollectionId);
create index IX_C629311 on LayoutSet (layoutSetPrototypeUuid, companyId);
create index IX_1B698D9 on LayoutSet (privateLayout, logoId);

create index IX_CCF0DA29 on LayoutSetBranch (groupId, privateLayout, master);
create unique index IX_5FF18552 on LayoutSetBranch (groupId, privateLayout, name);

create index IX_9178FC71 on LayoutSetPrototype (companyId, active_);
create index IX_C5D69B24 on LayoutSetPrototype (uuid_);

create unique index IX_BF6DBF8A on ListType (companyId, type_, name);
create index IX_56E29D16 on ListType (uuid_);

create index IX_C28C72EC on MembershipRequest (groupId, statusId);
create index IX_35AA8FA6 on MembershipRequest (groupId, userId, statusId);
create index IX_66D70879 on MembershipRequest (userId);

create index IX_6AF0D434 on OrgLabor (organizationId);

create unique index IX_87E47DA9 on Organization_ (companyId, ctCollectionId, externalReferenceCode);
create unique index IX_F1E40A53 on Organization_ (companyId, name, ctCollectionId);
create index IX_4BCBAB21 on Organization_ (companyId, name, parentOrganizationId);
create index IX_418E4522 on Organization_ (companyId, parentOrganizationId);
create index IX_396D6B42 on Organization_ (uuid_);

create index IX_2C1142E on PasswordPolicy (companyId, defaultPolicy);
create unique index IX_3FBFA9F4 on PasswordPolicy (companyId, name);
create index IX_51437A01 on PasswordPolicy (uuid_);

create unique index IX_C3A17327 on PasswordPolicyRel (classNameId, classPK);
create index IX_CD25266E on PasswordPolicyRel (passwordPolicyId);

create index IX_326F75BD on PasswordTracker (userId);

create index IX_812CE07A on Phone (companyId, classNameId, classPK, primary_);
create index IX_F202B9CE on Phone (userId);
create index IX_EA6245A0 on Phone (uuid_);

create unique index IX_7171B2E8 on PluginSetting (companyId, pluginId, pluginType);

create unique index IX_D5E35599 on PortalPreferenceValue (portalPreferencesId, namespace, key_(255), index_);
create index IX_737DBC36 on PortalPreferenceValue (portalPreferencesId, namespace, key_(255), smallValue);

create index IX_D1846D13 on PortalPreferences (ownerType, ownerId);

create unique index IX_12B5E51D on Portlet (companyId, portletId);

create index IX_C6246ECD on PortletItem (groupId, classNameId, portletId, name);

create index IX_EE8C5489 on PortletPreferenceValue (name, smallValue, companyId);
create unique index IX_B517784D on PortletPreferenceValue (portletPreferencesId, name, index_, ctCollectionId);
create index IX_8E75AB8C on PortletPreferenceValue (portletPreferencesId, name, smallValue);

create index IX_3EAB5A5A on PortletPreferences (ownerId);
create index IX_6DD4B410 on PortletPreferences (ownerType, ownerId, plid);
create index IX_F15C1C4F on PortletPreferences (plid);
create index IX_CEA05B46 on PortletPreferences (portletId, ownerType, ownerId, companyId);
create unique index IX_8CCEB8CB on PortletPreferences (portletId, ownerType, ownerId, plid, ctCollectionId);
create index IX_EF5FCC07 on PortletPreferences (portletId, ownerType, plid);
create index IX_8DCFD52C on PortletPreferences (portletId, plid);

create index IX_A1A8CB8B on RatingsEntry (classNameId, classPK, score);
create unique index IX_119FF2EF on RatingsEntry (classNameId, classPK, userId, ctCollectionId);
create index IX_C34DEAF2 on RatingsEntry (uuid_);

create unique index IX_C286E0E2 on RatingsStats (classNameId, classPK, ctCollectionId);

create index IX_B91F79BD on RecentLayoutBranch (groupId);
create index IX_351E86E8 on RecentLayoutBranch (layoutBranchId);
create unique index IX_C27D6369 on RecentLayoutBranch (userId, layoutSetBranchId, plid);

create index IX_8D8A2724 on RecentLayoutRevision (groupId);
create index IX_DA0788DA on RecentLayoutRevision (layoutRevisionId);
create unique index IX_4C600BD0 on RecentLayoutRevision (userId, layoutSetBranchId, plid);

create index IX_711995A5 on RecentLayoutSetBranch (groupId);
create index IX_23FF0700 on RecentLayoutSetBranch (layoutSetBranchId);
create unique index IX_4654D204 on RecentLayoutSetBranch (userId, layoutSetId);

create index IX_2D9A426F on Region (active_);
create index IX_11FB3E42 on Region (countryId, active_);
create unique index IX_183BFDBA on Region (countryId, regionCode, ctCollectionId);
create index IX_48A89E9A on Region (uuid_);

create unique index IX_982329B on RegionLocalization (regionId, languageId, ctCollectionId);

create unique index IX_8BD6BCA7 on Release_ (servletContextName);

create index IX_D4C6FBCB on RememberMeToken (expirationDate);
create index IX_291F58D4 on RememberMeToken (userId);

create unique index IX_470608AE on Repository (groupId, ctCollectionId, name, portletId);
create unique index IX_4009E884 on Repository (uuid_, groupId, ctCollectionId);

create unique index IX_B43A3F67 on RepositoryEntry (repositoryId, ctCollectionId, mappedId);
create unique index IX_239165C6 on RepositoryEntry (uuid_, ctCollectionId, groupId);

create unique index IX_EDB9986E on ResourceAction (name, actionId);

create index IX_26284944 on ResourcePermission (companyId, primKey);
create unique index IX_F2237D8E on ResourcePermission (companyId, scope, name, primKey, roleId, ctCollectionId);
create index IX_FA3E7EEB on ResourcePermission (companyId, scope, name, roleId, primKeyId, viewActionId);
create index IX_F6BAE86A on ResourcePermission (companyId, scope, primKey);
create index IX_D5F1E2A2 on ResourcePermission (name);
create index IX_A37A0588 on ResourcePermission (roleId);
create index IX_F4555981 on ResourcePermission (scope);

create unique index IX_CC85CC2C on Role_ (companyId, ctCollectionId, classNameId, classPK);
create unique index IX_D11C3796 on Role_ (companyId, ctCollectionId, name);
create index IX_F436EC8E on Role_ (name);
create index IX_5EB4E2FB on Role_ (subtype);
create index IX_CBE204 on Role_ (type_, subtype);
create index IX_26DB26C5 on Role_ (uuid_);

create unique index IX_4F0315B8 on ServiceComponent (buildNamespace, buildNumber);

create index IX_F542E9BC on SocialActivity (activitySetId);
create unique index IX_7E6A9AAD on SocialActivity (classNameId, classPK, groupId, userId, type_, receiverUserId, ctCollectionId, createDate);
create index IX_85370BF4 on SocialActivity (classNameId, classPK, mirrorActivityId);
create index IX_D0E9029E on SocialActivity (classNameId, classPK, type_);
create index IX_64B1BC66 on SocialActivity (companyId);
create index IX_2A2468 on SocialActivity (groupId);
create index IX_1271F25F on SocialActivity (mirrorActivityId);
create index IX_121CA3CB on SocialActivity (receiverUserId);
create index IX_3504B8BC on SocialActivity (userId);

create index IX_83E16F2F on SocialActivityAchievement (groupId, firstInGroup);
create index IX_8F6408F0 on SocialActivityAchievement (groupId, name);
create index IX_AABC18E9 on SocialActivityAchievement (groupId, userId, firstInGroup);
create unique index IX_5ED94F08 on SocialActivityAchievement (groupId, userId, name, ctCollectionId);

create index IX_A4B9A23B on SocialActivityCounter (classNameId, classPK);
create unique index IX_56195A6B on SocialActivityCounter (groupId, classNameId, classPK, ownerType, name, ctCollectionId, endPeriod);
create unique index IX_379AA3B2 on SocialActivityCounter (groupId, classNameId, classPK, ownerType, name, ctCollectionId, startPeriod);

create index IX_B15863FA on SocialActivityLimit (classNameId, classPK);
create unique index IX_4A636E75 on SocialActivityLimit (groupId, userId, classNameId, classPK, activityType, activityCounterName, ctCollectionId);
create index IX_6F9EDE9F on SocialActivityLimit (userId);

create index IX_9E13F2DE on SocialActivitySet (groupId);
create index IX_5D1FA9E on SocialActivitySet (type_, classNameId, classPK);
create index IX_241D10A4 on SocialActivitySet (userId, type_, classNameId, classPK);
create index IX_6D0C8733 on SocialActivitySet (userId, type_, groupId, classNameId);

create index IX_384788CD on SocialActivitySetting (groupId, activityType);
create index IX_D984AABA on SocialActivitySetting (groupId, classNameId, activityType, name);

create index IX_61171E99 on SocialRelation (companyId);
create index IX_5E1F07A2 on SocialRelation (type_, companyId);
create unique index IX_ECA579C5 on SocialRelation (type_, userId1, userId2, ctCollectionId);
create index IX_C91168D6 on SocialRelation (type_, userId2);
create index IX_B5C9C690 on SocialRelation (userId1, userId2);
create index IX_5A40D18D on SocialRelation (userId2);
create index IX_F0CA24A5 on SocialRelation (uuid_);

create index IX_E8468A49 on SocialRequest (classNameId, classPK, receiverUserId, status, type_);
create index IX_A90FE5A0 on SocialRequest (companyId);
create index IX_D9380CB7 on SocialRequest (receiverUserId, status);
create unique index IX_2FE40453 on SocialRequest (userId, classNameId, classPK, receiverUserId, type_, ctCollectionId);
create index IX_7CFF5CB8 on SocialRequest (userId, classNameId, classPK, status, type_);
create index IX_AB5906A8 on SocialRequest (userId, status);
create unique index IX_87DD8A60 on SocialRequest (uuid_, ctCollectionId, groupId);

create index IX_FFCBB747 on SystemEvent (groupId, classNameId, classPK, type_);
create index IX_A19C89FF on SystemEvent (groupId, systemEventSetKey);

create index IX_93AB8545 on Team (companyId);
create unique index IX_58777164 on Team (groupId, ctCollectionId, name);
create unique index IX_1AAF62D7 on Team (uuid_, groupId, ctCollectionId);

create index IX_DAD135B4 on Ticket (classNameId, classPK, companyId, type_);
create index IX_1E8DFB2E on Ticket (classNameId, classPK, type_);
create index IX_B2468446 on Ticket (key_);

create unique index IX_A33BD191 on UserGroup (companyId, ctCollectionId, externalReferenceCode);
create unique index IX_3F4FC96B on UserGroup (companyId, name, ctCollectionId);
create index IX_69771487 on UserGroup (companyId, parentUserGroupId);
create index IX_5F1DD85A on UserGroup (uuid_);

create index IX_CAB0CCC8 on UserGroupGroupRole (groupId, roleId);
create unique index IX_618D3E5F on UserGroupGroupRole (groupId, userGroupId, roleId, ctCollectionId);
create index IX_1CDF88C on UserGroupGroupRole (roleId);
create index IX_DCDED558 on UserGroupGroupRole (userGroupId);

create index IX_871412DF on UserGroupRole (groupId, roleId);
create unique index IX_5427FB77 on UserGroupRole (groupId, userId, roleId, ctCollectionId);
create index IX_887A2C95 on UserGroupRole (roleId);
create index IX_887BE56A on UserGroupRole (userId);

create index IX_2AC5356C on UserGroups_Teams (companyId);
create index IX_7F187E63 on UserGroups_Teams (userGroupId);

create unique index IX_41A32E0D on UserIdMapper (type_, externalUserId);
create unique index IX_D1C44A6E on UserIdMapper (userId, type_);

create unique index IX_8B6E3ACE on UserNotificationDelivery (userId, portletId, classNameId, notificationType, deliveryType);

create index IX_BF29100B on UserNotificationEvent (type_);
create index IX_6E095243 on UserNotificationEvent (userId, archived, actionRequired);
create index IX_E32CC19 on UserNotificationEvent (userId, delivered, actionRequired);
create index IX_AE54166F on UserNotificationEvent (userId, delivered, archived, actionRequired);
create index IX_7522B7DB on UserNotificationEvent (userId, delivered, deliveryType, actionRequired);
create index IX_3BE9B7B1 on UserNotificationEvent (userId, delivered, deliveryType, archived, actionRequired);
create index IX_2AB8294D on UserNotificationEvent (userId, delivered, deliveryType, archived, type_);
create index IX_105871E3 on UserNotificationEvent (userId, delivered, deliveryType, type_);
create index IX_EBF87241 on UserNotificationEvent (userId, delivered, type_, timestamp);
create index IX_D60FB085 on UserNotificationEvent (userId, deliveryType, archived, actionRequired);
create index IX_ECD8CFEA on UserNotificationEvent (uuid_);

create index IX_29BA1CF5 on UserTracker (companyId);
create index IX_46B0AE8E on UserTracker (sessionId);
create index IX_E4EFBA8D on UserTracker (userId);

create index IX_14D8BCC0 on UserTrackerPath (userTrackerId);

create index IX_BCFDA257 on User_ (companyId, createDate, modifiedDate);
create unique index IX_77D89D58 on User_ (companyId, ctCollectionId, emailAddress);
create unique index IX_6FF64E11 on User_ (companyId, ctCollectionId, externalReferenceCode);
create unique index IX_6B7C3D77 on User_ (companyId, ctCollectionId, screenName);
create index IX_1D731F03 on User_ (companyId, facebookId);
create index IX_B6E3AE1 on User_ (companyId, googleUserId);
create index IX_EE8ABD19 on User_ (companyId, modifiedDate);
create index IX_89509087 on User_ (companyId, openId(255));
create index IX_F6039434 on User_ (companyId, status);
create index IX_FD06BAAD on User_ (companyId, type_, status);
create unique index IX_E902F853 on User_ (ctCollectionId, contactId);
create index IX_762F63C6 on User_ (emailAddress);
create index IX_A18034A4 on User_ (portraitId);
create index IX_E0422BDA on User_ (uuid_);

create index IX_3499B657 on Users_Groups (companyId);
create index IX_F10B6C6B on Users_Groups (userId);

create index IX_5FBB883C on Users_Orgs (companyId);
create index IX_FB646CA6 on Users_Orgs (userId);

create index IX_F987A0DC on Users_Roles (companyId);
create index IX_C1A01806 on Users_Roles (userId);

create index IX_799F8283 on Users_Teams (companyId);
create index IX_A098EFBF on Users_Teams (userId);

create index IX_BB65040C on Users_UserGroups (companyId);
create index IX_66FF2503 on Users_UserGroups (userGroupId);

create index IX_EECA5FDA on VirtualHost (companyId, layoutSetId, defaultVirtualHost);
create unique index IX_76A64FBE on VirtualHost (hostname, ctCollectionId);
create index IX_774643D1 on VirtualHost (layoutSetId, hostname);

create unique index IX_97DFA146 on WebDAVProps (classNameId, classPK);

create index IX_1AA07A6D on Website (companyId, classNameId, classPK, primary_);
create index IX_F75690BB on Website (userId);
create index IX_76F15D13 on Website (uuid_);

create index IX_EB4D2E32 on WorkflowDefinitionLink (companyId, groupId, classNameId, classPK, typePK);
create index IX_4AE45F6F on WorkflowDefinitionLink (companyId, groupId, classPK);
create index IX_A4DB1F0F on WorkflowDefinitionLink (companyId, workflowDefinitionName, workflowDefinitionVersion);

create index IX_415A7007 on WorkflowInstanceLink (groupId, companyId, classNameId, classPK);



