drop user &1 cascade;
create user &1 identified by &2;
grant connect,resource to &1;
quitconnect &1/&2;
set define off;

create table Address (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	externalReferenceCode VARCHAR2(75 CHAR) null,
	addressId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	countryId number(30,0),
	listTypeId number(30,0),
	regionId number(30,0),
	city VARCHAR2(75 CHAR) null,
	description varchar2(4000 char) null,
	latitude binary_double,
	longitude binary_double,
	mailing number(1, 0),
	name VARCHAR2(255 CHAR) null,
	primary_ number(1, 0),
	street1 VARCHAR2(255 CHAR) null,
	street2 VARCHAR2(255 CHAR) null,
	street3 VARCHAR2(255 CHAR) null,
	validationDate timestamp null,
	validationStatus number(30,0),
	zip VARCHAR2(75 CHAR) null,
	primary key (addressId, ctCollectionId)
);

create table AnnouncementsDelivery (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	deliveryId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	type_ VARCHAR2(75 CHAR) null,
	email number(1, 0),
	sms number(1, 0),
	website number(1, 0),
	primary key (deliveryId, ctCollectionId)
);

create table AnnouncementsEntry (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	entryId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	title VARCHAR2(75 CHAR) null,
	content clob null,
	url varchar2(4000 char) null,
	type_ VARCHAR2(75 CHAR) null,
	displayDate timestamp null,
	expirationDate timestamp null,
	priority number(30,0),
	alert number(1, 0),
	primary key (entryId, ctCollectionId)
);

create table AnnouncementsFlag (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	flagId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	createDate timestamp null,
	entryId number(30,0),
	value number(30,0),
	primary key (flagId, ctCollectionId)
);

create table AssetCategory (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	externalReferenceCode VARCHAR2(75 CHAR) null,
	categoryId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	parentCategoryId number(30,0),
	treePath varchar2(4000 char) null,
	name VARCHAR2(255 CHAR) null,
	title clob null,
	description clob null,
	vocabularyId number(30,0),
	lastPublishDate timestamp null,
	primary key (categoryId, ctCollectionId)
);

create table AssetEntries_AssetTags (
	companyId number(30,0) not null,
	entryId number(30,0) not null,
	tagId number(30,0) not null,
	ctCollectionId number(30,0) default 0 not null,
	ctChangeType number(1, 0),
	primary key (entryId, tagId, ctCollectionId)
);

create table AssetEntry (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	entryId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	classUuid VARCHAR2(75 CHAR) null,
	classTypeId number(30,0),
	listable number(1, 0),
	visible number(1, 0),
	startDate timestamp null,
	endDate timestamp null,
	publishDate timestamp null,
	expirationDate timestamp null,
	mimeType VARCHAR2(75 CHAR) null,
	title clob null,
	description clob null,
	summary clob null,
	url varchar2(4000 char) null,
	layoutUuid VARCHAR2(75 CHAR) null,
	height number(30,0),
	width number(30,0),
	priority binary_double,
	primary key (entryId, ctCollectionId)
);

create table AssetTag (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	tagId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	name VARCHAR2(75 CHAR) null,
	assetCount number(30,0),
	lastPublishDate timestamp null,
	primary key (tagId, ctCollectionId)
);

create table AssetVocabulary (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	externalReferenceCode VARCHAR2(75 CHAR) null,
	vocabularyId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	name VARCHAR2(75 CHAR) null,
	title varchar2(4000 char) null,
	description varchar2(4000 char) null,
	settings_ varchar2(4000 char) null,
	visibilityType number(30,0),
	lastPublishDate timestamp null,
	primary key (vocabularyId, ctCollectionId)
);

create table BrowserTracker (
	mvccVersion number(30,0) default 0 not null,
	browserTrackerId number(30,0) not null primary key,
	companyId number(30,0),
	userId number(30,0),
	browserKey number(30,0)
);

create table ClassName_ (
	mvccVersion number(30,0) default 0 not null,
	classNameId number(30,0) not null primary key,
	value VARCHAR2(200 CHAR) null
);

create table Company (
	mvccVersion number(30,0) default 0 not null,
	companyId number(30,0) not null primary key,
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	webId VARCHAR2(75 CHAR) null,
	mx VARCHAR2(200 CHAR) null,
	homeURL varchar2(4000 char) null,
	logoId number(30,0),
	maxUsers number(30,0),
	active_ number(1, 0),
	name VARCHAR2(75 CHAR) null,
	legalName VARCHAR2(75 CHAR) null,
	legalId VARCHAR2(75 CHAR) null,
	legalType VARCHAR2(75 CHAR) null,
	sicCode VARCHAR2(75 CHAR) null,
	tickerSymbol VARCHAR2(75 CHAR) null,
	industry VARCHAR2(75 CHAR) null,
	type_ VARCHAR2(75 CHAR) null,
	size_ VARCHAR2(75 CHAR) null,
	indexNameCurrent VARCHAR2(75 CHAR) null,
	indexNameNext VARCHAR2(75 CHAR) null
);

create table CompanyInfo (
	mvccVersion number(30,0) default 0 not null,
	companyInfoId number(30,0) not null primary key,
	companyId number(30,0),
	key_ clob null
);

create table Contact_ (
	mvccVersion number(30,0) default 0 not null,
	contactId number(30,0) not null primary key,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	parentContactId number(30,0),
	emailAddress VARCHAR2(254 CHAR) null,
	firstName VARCHAR2(75 CHAR) null,
	middleName VARCHAR2(75 CHAR) null,
	lastName VARCHAR2(75 CHAR) null,
	prefixListTypeId number(30,0),
	suffixListTypeId number(30,0),
	male number(1, 0),
	birthday timestamp null,
	smsSn VARCHAR2(75 CHAR) null,
	facebookSn VARCHAR2(75 CHAR) null,
	jabberSn VARCHAR2(75 CHAR) null,
	skypeSn VARCHAR2(75 CHAR) null,
	twitterSn VARCHAR2(75 CHAR) null,
	employeeStatusId VARCHAR2(75 CHAR) null,
	employeeNumber VARCHAR2(75 CHAR) null,
	jobTitle VARCHAR2(100 CHAR) null,
	jobClass VARCHAR2(75 CHAR) null,
	hoursOfOperation VARCHAR2(75 CHAR) null
);

create table Counter (
	name VARCHAR2(150 CHAR) not null primary key,
	currentId number(30,0)
);

create table Country (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	defaultLanguageId VARCHAR2(75 CHAR) null,
	countryId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	a2 VARCHAR2(75 CHAR) null,
	a3 VARCHAR2(75 CHAR) null,
	active_ number(1, 0),
	billingAllowed number(1, 0),
	groupFilterEnabled number(1, 0),
	idd_ VARCHAR2(75 CHAR) null,
	name VARCHAR2(75 CHAR) null,
	number_ VARCHAR2(75 CHAR) null,
	position binary_double,
	shippingAllowed number(1, 0),
	subjectToVAT number(1, 0),
	zipRequired number(1, 0),
	lastPublishDate timestamp null,
	primary key (countryId, ctCollectionId)
);

create table CountryLocalization (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	countryLocalizationId number(30,0) not null,
	companyId number(30,0),
	countryId number(30,0),
	languageId VARCHAR2(75 CHAR) null,
	title VARCHAR2(75 CHAR) null,
	primary key (countryLocalizationId, ctCollectionId)
);

create table DLFileEntry (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	externalReferenceCode VARCHAR2(75 CHAR) null,
	fileEntryId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	repositoryId number(30,0),
	folderId number(30,0),
	treePath varchar2(4000 char) null,
	name VARCHAR2(255 CHAR) null,
	fileName VARCHAR2(255 CHAR) null,
	extension VARCHAR2(75 CHAR) null,
	mimeType VARCHAR2(75 CHAR) null,
	title VARCHAR2(255 CHAR) null,
	description varchar2(4000 char) null,
	extraSettings clob null,
	fileEntryTypeId number(30,0),
	version VARCHAR2(75 CHAR) null,
	size_ number(30,0),
	smallImageId number(30,0),
	largeImageId number(30,0),
	custom1ImageId number(30,0),
	custom2ImageId number(30,0),
	manualCheckInRequired number(1, 0),
	displayDate timestamp null,
	expirationDate timestamp null,
	reviewDate timestamp null,
	lastPublishDate timestamp null,
	primary key (fileEntryId, ctCollectionId)
);

create table DLFileEntryMetadata (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	fileEntryMetadataId number(30,0) not null,
	companyId number(30,0),
	DDMStorageId number(30,0),
	DDMStructureId number(30,0),
	fileEntryId number(30,0),
	fileVersionId number(30,0),
	primary key (fileEntryMetadataId, ctCollectionId)
);

create table DLFileEntryType (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	fileEntryTypeId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	dataDefinitionId number(30,0),
	fileEntryTypeKey VARCHAR2(75 CHAR) null,
	name varchar2(4000 char) null,
	description varchar2(4000 char) null,
	scope number(30,0),
	lastPublishDate timestamp null,
	primary key (fileEntryTypeId, ctCollectionId)
);

create table DLFileEntryTypes_DLFolders (
	companyId number(30,0) not null,
	fileEntryTypeId number(30,0) not null,
	folderId number(30,0) not null,
	ctCollectionId number(30,0) default 0 not null,
	ctChangeType number(1, 0),
	primary key (fileEntryTypeId, folderId, ctCollectionId)
);

create table DLFileShortcut (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	fileShortcutId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	repositoryId number(30,0),
	folderId number(30,0),
	toFileEntryId number(30,0),
	treePath varchar2(4000 char) null,
	active_ number(1, 0),
	lastPublishDate timestamp null,
	status number(30,0),
	statusByUserId number(30,0),
	statusByUserName VARCHAR2(75 CHAR) null,
	statusDate timestamp null,
	primary key (fileShortcutId, ctCollectionId)
);

create table DLFileVersion (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	fileVersionId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	repositoryId number(30,0),
	folderId number(30,0),
	fileEntryId number(30,0),
	treePath varchar2(4000 char) null,
	fileName VARCHAR2(255 CHAR) null,
	extension VARCHAR2(75 CHAR) null,
	mimeType VARCHAR2(75 CHAR) null,
	title VARCHAR2(255 CHAR) null,
	description varchar2(4000 char) null,
	changeLog VARCHAR2(75 CHAR) null,
	extraSettings clob null,
	fileEntryTypeId number(30,0),
	version VARCHAR2(75 CHAR) null,
	size_ number(30,0),
	checksum VARCHAR2(75 CHAR) null,
	storeUUID VARCHAR2(255 CHAR) null,
	displayDate timestamp null,
	expirationDate timestamp null,
	reviewDate timestamp null,
	lastPublishDate timestamp null,
	status number(30,0),
	statusByUserId number(30,0),
	statusByUserName VARCHAR2(75 CHAR) null,
	statusDate timestamp null,
	primary key (fileVersionId, ctCollectionId)
);

create table DLFolder (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	externalReferenceCode VARCHAR2(75 CHAR) null,
	folderId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	repositoryId number(30,0),
	mountPoint number(1, 0),
	parentFolderId number(30,0),
	treePath varchar2(4000 char) null,
	name VARCHAR2(255 CHAR) null,
	description varchar2(4000 char) null,
	lastPostDate timestamp null,
	defaultFileEntryTypeId number(30,0),
	hidden_ number(1, 0),
	restrictionType number(30,0),
	lastPublishDate timestamp null,
	status number(30,0),
	statusByUserId number(30,0),
	statusByUserName VARCHAR2(75 CHAR) null,
	statusDate timestamp null,
	primary key (folderId, ctCollectionId)
);

create table EmailAddress (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	emailAddressId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	address VARCHAR2(254 CHAR) null,
	listTypeId number(30,0),
	primary_ number(1, 0),
	primary key (emailAddressId, ctCollectionId)
);

create table ExpandoColumn (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	columnId number(30,0) not null,
	companyId number(30,0),
	modifiedDate timestamp null,
	tableId number(30,0),
	name VARCHAR2(75 CHAR) null,
	type_ number(30,0),
	defaultData clob null,
	typeSettings clob null,
	primary key (columnId, ctCollectionId)
);

create table ExpandoRow (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	rowId_ number(30,0) not null,
	companyId number(30,0),
	modifiedDate timestamp null,
	tableId number(30,0),
	classPK number(30,0),
	primary key (rowId_, ctCollectionId)
);

create table ExpandoTable (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	tableId number(30,0) not null,
	companyId number(30,0),
	classNameId number(30,0),
	name VARCHAR2(75 CHAR) null,
	primary key (tableId, ctCollectionId)
);

create table ExpandoValue (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	valueId number(30,0) not null,
	companyId number(30,0),
	tableId number(30,0),
	columnId number(30,0),
	rowId_ number(30,0),
	classNameId number(30,0),
	classPK number(30,0),
	data_ clob null,
	primary key (valueId, ctCollectionId)
);

create table ExportImportConfiguration (
	mvccVersion number(30,0) default 0 not null,
	exportImportConfigurationId number(30,0) not null primary key,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	name VARCHAR2(200 CHAR) null,
	description varchar2(4000 char) null,
	type_ number(30,0),
	settings_ clob null,
	status number(30,0),
	statusByUserId number(30,0),
	statusByUserName VARCHAR2(75 CHAR) null,
	statusDate timestamp null
);

create table Group_ (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	externalReferenceCode VARCHAR2(75 CHAR) null,
	groupId number(30,0) not null,
	companyId number(30,0),
	creatorUserId number(30,0),
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	parentGroupId number(30,0),
	liveGroupId number(30,0),
	treePath varchar2(4000 char) null,
	groupKey VARCHAR2(150 CHAR) null,
	name varchar2(4000 char) null,
	description varchar2(4000 char) null,
	type_ number(30,0),
	typeSettings clob null,
	manualMembership number(1, 0),
	membershipRestriction number(30,0),
	friendlyURL VARCHAR2(255 CHAR) null,
	site number(1, 0),
	remoteStagingGroupCount number(30,0),
	inheritContent number(1, 0),
	active_ number(1, 0),
	primary key (groupId, ctCollectionId)
);

create table Groups_Orgs (
	companyId number(30,0) not null,
	groupId number(30,0) not null,
	organizationId number(30,0) not null,
	ctCollectionId number(30,0) default 0 not null,
	ctChangeType number(1, 0),
	primary key (groupId, organizationId, ctCollectionId)
);

create table Groups_Roles (
	companyId number(30,0) not null,
	groupId number(30,0) not null,
	roleId number(30,0) not null,
	ctCollectionId number(30,0) default 0 not null,
	ctChangeType number(1, 0),
	primary key (groupId, roleId, ctCollectionId)
);

create table Groups_UserGroups (
	companyId number(30,0) not null,
	groupId number(30,0) not null,
	userGroupId number(30,0) not null,
	ctCollectionId number(30,0) default 0 not null,
	ctChangeType number(1, 0),
	primary key (groupId, userGroupId, ctCollectionId)
);

create table Image (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	imageId number(30,0) not null,
	companyId number(30,0),
	modifiedDate timestamp null,
	type_ VARCHAR2(75 CHAR) null,
	height number(30,0),
	width number(30,0),
	size_ number(30,0),
	primary key (imageId, ctCollectionId)
);

create table Layout (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	externalReferenceCode VARCHAR2(75 CHAR) null,
	plid number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	parentPlid number(30,0),
	privateLayout number(1, 0),
	layoutId number(30,0),
	parentLayoutId number(30,0),
	classNameId number(30,0),
	classPK number(30,0),
	name varchar2(4000 char) null,
	title clob null,
	description clob null,
	keywords varchar2(4000 char) null,
	robots varchar2(4000 char) null,
	type_ VARCHAR2(75 CHAR) null,
	typeSettings clob null,
	hidden_ number(1, 0),
	system_ number(1, 0),
	friendlyURL VARCHAR2(255 CHAR) null,
	iconImageId number(30,0),
	themeId VARCHAR2(75 CHAR) null,
	colorSchemeId VARCHAR2(75 CHAR) null,
	styleBookEntryId number(30,0),
	css clob null,
	priority number(30,0),
	faviconFileEntryId number(30,0),
	masterLayoutPlid number(30,0),
	layoutPrototypeUuid VARCHAR2(75 CHAR) null,
	layoutPrototypeLinkEnabled number(1, 0),
	sourcePrototypeLayoutUuid VARCHAR2(75 CHAR) null,
	publishDate timestamp null,
	lastPublishDate timestamp null,
	status number(30,0),
	statusByUserId number(30,0),
	statusByUserName VARCHAR2(75 CHAR) null,
	statusDate timestamp null,
	primary key (plid, ctCollectionId)
);

create table LayoutBranch (
	mvccVersion number(30,0) default 0 not null,
	layoutBranchId number(30,0) not null primary key,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	layoutSetBranchId number(30,0),
	plid number(30,0),
	name VARCHAR2(75 CHAR) null,
	description varchar2(4000 char) null,
	master number(1, 0)
);

create table LayoutFriendlyURL (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	layoutFriendlyURLId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	plid number(30,0),
	privateLayout number(1, 0),
	friendlyURL VARCHAR2(255 CHAR) null,
	languageId VARCHAR2(75 CHAR) null,
	lastPublishDate timestamp null,
	primary key (layoutFriendlyURLId, ctCollectionId)
);

create table LayoutPrototype (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	layoutPrototypeId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	name clob null,
	description clob null,
	settings_ varchar2(4000 char) null,
	active_ number(1, 0),
	primary key (layoutPrototypeId, ctCollectionId)
);

create table LayoutRevision (
	mvccVersion number(30,0) default 0 not null,
	layoutRevisionId number(30,0) not null primary key,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	layoutSetBranchId number(30,0),
	layoutBranchId number(30,0),
	parentLayoutRevisionId number(30,0),
	head number(1, 0),
	major number(1, 0),
	plid number(30,0),
	privateLayout number(1, 0),
	name varchar2(4000 char) null,
	title varchar2(4000 char) null,
	description varchar2(4000 char) null,
	keywords varchar2(4000 char) null,
	robots varchar2(4000 char) null,
	typeSettings clob null,
	iconImageId number(30,0),
	themeId VARCHAR2(75 CHAR) null,
	colorSchemeId VARCHAR2(75 CHAR) null,
	css clob null,
	status number(30,0),
	statusByUserId number(30,0),
	statusByUserName VARCHAR2(75 CHAR) null,
	statusDate timestamp null
);

create table LayoutSet (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	layoutSetId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	createDate timestamp null,
	modifiedDate timestamp null,
	privateLayout number(1, 0),
	logoId number(30,0),
	themeId VARCHAR2(75 CHAR) null,
	colorSchemeId VARCHAR2(75 CHAR) null,
	faviconFileEntryId number(30,0),
	css clob null,
	settings_ clob null,
	layoutSetPrototypeUuid VARCHAR2(75 CHAR) null,
	layoutSetPrototypeLinkEnabled number(1, 0),
	primary key (layoutSetId, ctCollectionId)
);

create table LayoutSetBranch (
	mvccVersion number(30,0) default 0 not null,
	layoutSetBranchId number(30,0) not null primary key,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	privateLayout number(1, 0),
	name VARCHAR2(75 CHAR) null,
	description varchar2(4000 char) null,
	master number(1, 0),
	logoId number(30,0),
	themeId VARCHAR2(75 CHAR) null,
	colorSchemeId VARCHAR2(75 CHAR) null,
	css clob null,
	settings_ clob null,
	layoutSetPrototypeUuid VARCHAR2(75 CHAR) null,
	layoutSetPrototypeLinkEnabled number(1, 0)
);

create table LayoutSetPrototype (
	mvccVersion number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	layoutSetPrototypeId number(30,0) not null primary key,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	name clob null,
	description clob null,
	settings_ varchar2(4000 char) null,
	active_ number(1, 0)
);

create table ListType (
	mvccVersion number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	listTypeId number(30,0) not null primary key,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	name VARCHAR2(75 CHAR) null,
	type_ VARCHAR2(75 CHAR) null
);

create table MembershipRequest (
	mvccVersion number(30,0) default 0 not null,
	membershipRequestId number(30,0) not null primary key,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	createDate timestamp null,
	comments varchar2(4000 char) null,
	replyComments varchar2(4000 char) null,
	replyDate timestamp null,
	replierUserId number(30,0),
	statusId number(30,0)
);

create table OrgLabor (
	mvccVersion number(30,0) default 0 not null,
	orgLaborId number(30,0) not null primary key,
	companyId number(30,0),
	organizationId number(30,0),
	listTypeId number(30,0),
	sunOpen number(30,0),
	sunClose number(30,0),
	monOpen number(30,0),
	monClose number(30,0),
	tueOpen number(30,0),
	tueClose number(30,0),
	wedOpen number(30,0),
	wedClose number(30,0),
	thuOpen number(30,0),
	thuClose number(30,0),
	friOpen number(30,0),
	friClose number(30,0),
	satOpen number(30,0),
	satClose number(30,0)
);

create table Organization_ (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	externalReferenceCode VARCHAR2(75 CHAR) null,
	organizationId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	parentOrganizationId number(30,0),
	treePath varchar2(4000 char) null,
	name VARCHAR2(100 CHAR) null,
	type_ VARCHAR2(75 CHAR) null,
	recursable number(1, 0),
	regionId number(30,0),
	countryId number(30,0),
	statusListTypeId number(30,0),
	comments varchar2(4000 char) null,
	logoId number(30,0),
	primary key (organizationId, ctCollectionId)
);

create table PasswordPolicy (
	mvccVersion number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	passwordPolicyId number(30,0) not null primary key,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	defaultPolicy number(1, 0),
	name VARCHAR2(75 CHAR) null,
	description varchar2(4000 char) null,
	changeable number(1, 0),
	changeRequired number(1, 0),
	minAge number(30,0),
	checkSyntax number(1, 0),
	allowDictionaryWords number(1, 0),
	minAlphanumeric number(30,0),
	minLength number(30,0),
	minLowerCase number(30,0),
	minNumbers number(30,0),
	minSymbols number(30,0),
	minUpperCase number(30,0),
	regex varchar2(4000 char) null,
	history number(1, 0),
	historyCount number(30,0),
	expireable number(1, 0),
	maxAge number(30,0),
	warningTime number(30,0),
	graceLimit number(30,0),
	lockout number(1, 0),
	maxFailure number(30,0),
	lockoutDuration number(30,0),
	requireUnlock number(1, 0),
	resetFailureCount number(30,0),
	resetTicketMaxAge number(30,0)
);

create table PasswordPolicyRel (
	mvccVersion number(30,0) default 0 not null,
	passwordPolicyRelId number(30,0) not null primary key,
	companyId number(30,0),
	passwordPolicyId number(30,0),
	classNameId number(30,0),
	classPK number(30,0)
);

create table PasswordTracker (
	mvccVersion number(30,0) default 0 not null,
	passwordTrackerId number(30,0) not null primary key,
	companyId number(30,0),
	userId number(30,0),
	createDate timestamp null,
	password_ VARCHAR2(255 CHAR) null
);

create table Phone (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	phoneId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	number_ VARCHAR2(75 CHAR) null,
	extension VARCHAR2(75 CHAR) null,
	listTypeId number(30,0),
	primary_ number(1, 0),
	primary key (phoneId, ctCollectionId)
);

create table PluginSetting (
	mvccVersion number(30,0) default 0 not null,
	pluginSettingId number(30,0) not null primary key,
	companyId number(30,0),
	pluginId VARCHAR2(75 CHAR) null,
	pluginType VARCHAR2(75 CHAR) null,
	roles varchar2(4000 char) null,
	active_ number(1, 0)
);

create table PortalPreferenceValue (
	mvccVersion number(30,0) default 0 not null,
	portalPreferenceValueId number(30,0) not null primary key,
	companyId number(30,0),
	portalPreferencesId number(30,0),
	index_ number(30,0),
	key_ VARCHAR2(1024 CHAR) null,
	largeValue clob null,
	namespace VARCHAR2(255 CHAR) null,
	smallValue VARCHAR2(255 CHAR) null
);

create table PortalPreferences (
	mvccVersion number(30,0) default 0 not null,
	portalPreferencesId number(30,0) not null primary key,
	companyId number(30,0),
	ownerId number(30,0),
	ownerType number(30,0)
);

create table Portlet (
	mvccVersion number(30,0) default 0 not null,
	id_ number(30,0) not null primary key,
	companyId number(30,0),
	portletId VARCHAR2(200 CHAR) null,
	roles varchar2(4000 char) null,
	active_ number(1, 0)
);

create table PortletItem (
	mvccVersion number(30,0) default 0 not null,
	portletItemId number(30,0) not null primary key,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	name VARCHAR2(75 CHAR) null,
	portletId VARCHAR2(200 CHAR) null,
	classNameId number(30,0)
);

create table PortletPreferenceValue (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	portletPreferenceValueId number(30,0) not null,
	companyId number(30,0),
	portletPreferencesId number(30,0),
	index_ number(30,0),
	largeValue clob null,
	name VARCHAR2(255 CHAR) null,
	readOnly number(1, 0),
	smallValue VARCHAR2(255 CHAR) null,
	primary key (portletPreferenceValueId, ctCollectionId)
);

create table PortletPreferences (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	portletPreferencesId number(30,0) not null,
	companyId number(30,0),
	ownerId number(30,0),
	ownerType number(30,0),
	plid number(30,0),
	portletId VARCHAR2(200 CHAR) null,
	primary key (portletPreferencesId, ctCollectionId)
);

create table RatingsEntry (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	entryId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	score binary_double,
	primary key (entryId, ctCollectionId)
);

create table RatingsStats (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	statsId number(30,0) not null,
	companyId number(30,0),
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	totalEntries number(30,0),
	totalScore binary_double,
	averageScore binary_double,
	primary key (statsId, ctCollectionId)
);

create table RecentLayoutBranch (
	mvccVersion number(30,0) default 0 not null,
	recentLayoutBranchId number(30,0) not null primary key,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	layoutBranchId number(30,0),
	layoutSetBranchId number(30,0),
	plid number(30,0)
);

create table RecentLayoutRevision (
	mvccVersion number(30,0) default 0 not null,
	recentLayoutRevisionId number(30,0) not null primary key,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	layoutRevisionId number(30,0),
	layoutSetBranchId number(30,0),
	plid number(30,0)
);

create table RecentLayoutSetBranch (
	mvccVersion number(30,0) default 0 not null,
	recentLayoutSetBranchId number(30,0) not null primary key,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	layoutSetBranchId number(30,0),
	layoutSetId number(30,0)
);

create table Region (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	defaultLanguageId VARCHAR2(75 CHAR) null,
	regionId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	countryId number(30,0),
	active_ number(1, 0),
	name VARCHAR2(75 CHAR) null,
	position binary_double,
	regionCode VARCHAR2(75 CHAR) null,
	lastPublishDate timestamp null,
	primary key (regionId, ctCollectionId)
);

create table RegionLocalization (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	regionLocalizationId number(30,0) not null,
	companyId number(30,0),
	regionId number(30,0),
	languageId VARCHAR2(75 CHAR) null,
	title VARCHAR2(75 CHAR) null,
	primary key (regionLocalizationId, ctCollectionId)
);

create table Release_ (
	mvccVersion number(30,0) default 0 not null,
	releaseId number(30,0) not null primary key,
	createDate timestamp null,
	modifiedDate timestamp null,
	servletContextName VARCHAR2(75 CHAR) null,
	schemaVersion VARCHAR2(75 CHAR) null,
	buildNumber number(30,0),
	buildDate timestamp null,
	verified number(1, 0),
	state_ number(30,0),
	testString VARCHAR2(1024 CHAR) null
);

create table RememberMeToken (
	mvccVersion number(30,0) default 0 not null,
	rememberMeTokenId number(30,0) not null primary key,
	companyId number(30,0),
	userId number(30,0),
	createDate timestamp null,
	expirationDate timestamp null,
	value VARCHAR2(255 CHAR) null
);

create table Repository (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	repositoryId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	name VARCHAR2(200 CHAR) null,
	description varchar2(4000 char) null,
	portletId VARCHAR2(200 CHAR) null,
	typeSettings clob null,
	dlFolderId number(30,0),
	lastPublishDate timestamp null,
	primary key (repositoryId, ctCollectionId)
);

create table RepositoryEntry (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	repositoryEntryId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	repositoryId number(30,0),
	mappedId VARCHAR2(255 CHAR) null,
	manualCheckInRequired number(1, 0),
	lastPublishDate timestamp null,
	primary key (repositoryEntryId, ctCollectionId)
);

create table ResourceAction (
	mvccVersion number(30,0) default 0 not null,
	resourceActionId number(30,0) not null primary key,
	name VARCHAR2(255 CHAR) null,
	actionId VARCHAR2(75 CHAR) null,
	bitwiseValue number(30,0)
);

create table ResourcePermission (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	resourcePermissionId number(30,0) not null,
	companyId number(30,0),
	name VARCHAR2(255 CHAR) null,
	scope number(30,0),
	primKey VARCHAR2(255 CHAR) null,
	primKeyId number(30,0),
	roleId number(30,0),
	ownerId number(30,0),
	actionIds number(30,0),
	viewActionId number(1, 0),
	primary key (resourcePermissionId, ctCollectionId)
);

create table Role_ (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	roleId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	name VARCHAR2(75 CHAR) null,
	title varchar2(4000 char) null,
	description clob null,
	type_ number(30,0),
	subtype VARCHAR2(75 CHAR) null,
	primary key (roleId, ctCollectionId)
);

create table ServiceComponent (
	mvccVersion number(30,0) default 0 not null,
	serviceComponentId number(30,0) not null primary key,
	buildNamespace VARCHAR2(75 CHAR) null,
	buildNumber number(30,0),
	buildDate number(30,0),
	data_ clob null
);

create table SocialActivity (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	activityId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	createDate number(30,0),
	activitySetId number(30,0),
	mirrorActivityId number(30,0),
	classNameId number(30,0),
	classPK number(30,0),
	parentClassNameId number(30,0),
	parentClassPK number(30,0),
	type_ number(30,0),
	extraData varchar2(4000 char) null,
	receiverUserId number(30,0),
	primary key (activityId, ctCollectionId)
);

create table SocialActivityAchievement (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	activityAchievementId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	createDate number(30,0),
	name VARCHAR2(75 CHAR) null,
	firstInGroup number(1, 0),
	primary key (activityAchievementId, ctCollectionId)
);

create table SocialActivityCounter (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	activityCounterId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	classNameId number(30,0),
	classPK number(30,0),
	name VARCHAR2(75 CHAR) null,
	ownerType number(30,0),
	currentValue number(30,0),
	totalValue number(30,0),
	graceValue number(30,0),
	startPeriod number(30,0),
	endPeriod number(30,0),
	active_ number(1, 0),
	primary key (activityCounterId, ctCollectionId)
);

create table SocialActivityLimit (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	activityLimitId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	classNameId number(30,0),
	classPK number(30,0),
	activityType number(30,0),
	activityCounterName VARCHAR2(75 CHAR) null,
	value VARCHAR2(75 CHAR) null,
	primary key (activityLimitId, ctCollectionId)
);

create table SocialActivitySet (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	activitySetId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	createDate number(30,0),
	modifiedDate number(30,0),
	classNameId number(30,0),
	classPK number(30,0),
	type_ number(30,0),
	extraData varchar2(4000 char) null,
	activityCount number(30,0),
	primary key (activitySetId, ctCollectionId)
);

create table SocialActivitySetting (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	activitySettingId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	classNameId number(30,0),
	activityType number(30,0),
	name VARCHAR2(75 CHAR) null,
	value VARCHAR2(1024 CHAR) null,
	primary key (activitySettingId, ctCollectionId)
);

create table SocialRelation (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	relationId number(30,0) not null,
	companyId number(30,0),
	createDate number(30,0),
	userId1 number(30,0),
	userId2 number(30,0),
	type_ number(30,0),
	primary key (relationId, ctCollectionId)
);

create table SocialRequest (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	requestId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	createDate number(30,0),
	modifiedDate number(30,0),
	classNameId number(30,0),
	classPK number(30,0),
	type_ number(30,0),
	extraData varchar2(4000 char) null,
	receiverUserId number(30,0),
	status number(30,0),
	primary key (requestId, ctCollectionId)
);

create table SystemEvent (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	systemEventId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	classUuid VARCHAR2(75 CHAR) null,
	referrerClassNameId number(30,0),
	parentSystemEventId number(30,0),
	systemEventSetKey number(30,0),
	type_ number(30,0),
	extraData clob null,
	primary key (systemEventId, ctCollectionId)
);

create table Team (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	teamId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	groupId number(30,0),
	name VARCHAR2(75 CHAR) null,
	description varchar2(4000 char) null,
	lastPublishDate timestamp null,
	primary key (teamId, ctCollectionId)
);

create table Ticket (
	mvccVersion number(30,0) default 0 not null,
	ticketId number(30,0) not null primary key,
	companyId number(30,0),
	createDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	key_ VARCHAR2(255 CHAR) null,
	type_ number(30,0),
	extraInfo clob null,
	expirationDate timestamp null
);

create table UserNotificationDelivery (
	mvccVersion number(30,0) default 0 not null,
	userNotificationDeliveryId number(30,0) not null primary key,
	companyId number(30,0),
	userId number(30,0),
	portletId VARCHAR2(200 CHAR) null,
	classNameId number(30,0),
	notificationType number(30,0),
	deliveryType number(30,0),
	deliver number(1, 0)
);

create table User_ (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	externalReferenceCode VARCHAR2(75 CHAR) null,
	userId number(30,0) not null,
	companyId number(30,0),
	createDate timestamp null,
	modifiedDate timestamp null,
	contactId number(30,0),
	password_ VARCHAR2(255 CHAR) null,
	passwordEncrypted number(1, 0),
	passwordReset number(1, 0),
	passwordModifiedDate timestamp null,
	digest VARCHAR2(255 CHAR) null,
	reminderQueryQuestion VARCHAR2(75 CHAR) null,
	reminderQueryAnswer VARCHAR2(75 CHAR) null,
	graceLoginCount number(30,0),
	screenName VARCHAR2(75 CHAR) null,
	emailAddress VARCHAR2(254 CHAR) null,
	facebookId number(30,0),
	googleUserId VARCHAR2(75 CHAR) null,
	ldapServerId number(30,0),
	openId VARCHAR2(1024 CHAR) null,
	portraitId number(30,0),
	languageId VARCHAR2(75 CHAR) null,
	timeZoneId VARCHAR2(75 CHAR) null,
	greeting VARCHAR2(255 CHAR) null,
	comments varchar2(4000 char) null,
	firstName VARCHAR2(75 CHAR) null,
	middleName VARCHAR2(75 CHAR) null,
	lastName VARCHAR2(75 CHAR) null,
	jobTitle VARCHAR2(100 CHAR) null,
	loginDate timestamp null,
	loginIP VARCHAR2(75 CHAR) null,
	lastLoginDate timestamp null,
	lastLoginIP VARCHAR2(75 CHAR) null,
	lastFailedLoginDate timestamp null,
	failedLoginAttempts number(30,0),
	lockout number(1, 0),
	lockoutDate timestamp null,
	agreedToTermsOfUse number(1, 0),
	emailAddressVerified number(1, 0),
	type_ number(30,0),
	status number(30,0),
	primary key (userId, ctCollectionId)
);

create table UserGroup (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	externalReferenceCode VARCHAR2(75 CHAR) null,
	userGroupId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	parentUserGroupId number(30,0),
	name VARCHAR2(255 CHAR) null,
	description varchar2(4000 char) null,
	addedByLDAPImport number(1, 0),
	primary key (userGroupId, ctCollectionId)
);

create table UserGroupGroupRole (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	userGroupGroupRoleId number(30,0) not null,
	companyId number(30,0),
	userGroupId number(30,0),
	groupId number(30,0),
	roleId number(30,0),
	primary key (userGroupGroupRoleId, ctCollectionId)
);

create table UserGroupRole (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	userGroupRoleId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	groupId number(30,0),
	roleId number(30,0),
	primary key (userGroupRoleId, ctCollectionId)
);

create table UserGroups_Teams (
	companyId number(30,0) not null,
	teamId number(30,0) not null,
	userGroupId number(30,0) not null,
	ctCollectionId number(30,0) default 0 not null,
	ctChangeType number(1, 0),
	primary key (teamId, userGroupId, ctCollectionId)
);

create table UserIdMapper (
	mvccVersion number(30,0) default 0 not null,
	userIdMapperId number(30,0) not null primary key,
	companyId number(30,0),
	userId number(30,0),
	type_ VARCHAR2(75 CHAR) null,
	description VARCHAR2(75 CHAR) null,
	externalUserId VARCHAR2(75 CHAR) null
);

create table UserNotificationEvent (
	mvccVersion number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	userNotificationEventId number(30,0) not null primary key,
	companyId number(30,0),
	userId number(30,0),
	type_ VARCHAR2(200 CHAR) null,
	timestamp number(30,0),
	deliveryType number(30,0),
	deliverBy number(30,0),
	delivered number(1, 0),
	payload clob null,
	actionRequired number(1, 0),
	archived number(1, 0)
);

create table Users_Groups (
	companyId number(30,0) not null,
	groupId number(30,0) not null,
	userId number(30,0) not null,
	ctCollectionId number(30,0) default 0 not null,
	ctChangeType number(1, 0),
	primary key (groupId, userId, ctCollectionId)
);

create table Users_Orgs (
	companyId number(30,0) not null,
	organizationId number(30,0) not null,
	userId number(30,0) not null,
	ctCollectionId number(30,0) default 0 not null,
	ctChangeType number(1, 0),
	primary key (organizationId, userId, ctCollectionId)
);

create table Users_Roles (
	companyId number(30,0) not null,
	roleId number(30,0) not null,
	userId number(30,0) not null,
	ctCollectionId number(30,0) default 0 not null,
	ctChangeType number(1, 0),
	primary key (roleId, userId, ctCollectionId)
);

create table Users_Teams (
	companyId number(30,0) not null,
	teamId number(30,0) not null,
	userId number(30,0) not null,
	ctCollectionId number(30,0) default 0 not null,
	ctChangeType number(1, 0),
	primary key (teamId, userId, ctCollectionId)
);

create table Users_UserGroups (
	companyId number(30,0) not null,
	userId number(30,0) not null,
	userGroupId number(30,0) not null,
	ctCollectionId number(30,0) default 0 not null,
	ctChangeType number(1, 0),
	primary key (userId, userGroupId, ctCollectionId)
);

create table UserTracker (
	mvccVersion number(30,0) default 0 not null,
	userTrackerId number(30,0) not null primary key,
	companyId number(30,0),
	userId number(30,0),
	modifiedDate timestamp null,
	sessionId VARCHAR2(200 CHAR) null,
	remoteAddr VARCHAR2(75 CHAR) null,
	remoteHost VARCHAR2(75 CHAR) null,
	userAgent VARCHAR2(200 CHAR) null
);

create table UserTrackerPath (
	mvccVersion number(30,0) default 0 not null,
	userTrackerPathId number(30,0) not null primary key,
	companyId number(30,0),
	userTrackerId number(30,0),
	path_ varchar2(4000 char) null,
	pathDate timestamp null
);

create table VirtualHost (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	virtualHostId number(30,0) not null,
	companyId number(30,0),
	layoutSetId number(30,0),
	hostname VARCHAR2(200 CHAR) null,
	defaultVirtualHost number(1, 0),
	languageId VARCHAR2(75 CHAR) null,
	primary key (virtualHostId, ctCollectionId)
);

create table WebDAVProps (
	mvccVersion number(30,0) default 0 not null,
	webDavPropsId number(30,0) not null primary key,
	companyId number(30,0),
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	props clob null
);

create table Website (
	mvccVersion number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	websiteId number(30,0) not null primary key,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	url varchar2(4000 char) null,
	listTypeId number(30,0),
	primary_ number(1, 0),
	lastPublishDate timestamp null
);

create table WorkflowDefinitionLink (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	workflowDefinitionLinkId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	typePK number(30,0),
	workflowDefinitionName VARCHAR2(75 CHAR) null,
	workflowDefinitionVersion number(30,0),
	primary key (workflowDefinitionLinkId, ctCollectionId)
);

create table WorkflowInstanceLink (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	workflowInstanceLinkId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	workflowInstanceId number(30,0),
	primary key (workflowInstanceLinkId, ctCollectionId)
);


insert into Counter (name, currentId) values ('com.liferay.counter.kernel.model.Counter', 20000);



commit;


create index IX_FEAFC68A on Address (companyId, classNameId, classPK, listTypeId);
create index IX_923BD178 on Address (companyId, classNameId, classPK, mailing);
create index IX_9226DBB4 on Address (companyId, classNameId, classPK, primary_);
create unique index IX_C0F7C08D on Address (companyId, externalReferenceCode, ctCollectionId);
create index IX_5A2093E7 on Address (countryId);
create index IX_C8E3E87D on Address (regionId);
create index IX_5BC8B0D4 on Address (userId);
create index IX_381E55DA on Address (uuid_);

create index IX_37B0A8A2 on AnnouncementsDelivery (companyId);
create unique index IX_7EA033 on AnnouncementsDelivery (userId, type_, ctCollectionId);

create index IX_14F06A6B on AnnouncementsEntry (classNameId, classPK, alert);
create index IX_94C04525 on AnnouncementsEntry (classNameId, classPK, companyId, alert);
create index IX_3F376E7C on AnnouncementsEntry (companyId);
create index IX_D49C2E66 on AnnouncementsEntry (userId);
create index IX_1AFBDE08 on AnnouncementsEntry (uuid_);

create index IX_EF1F022A on AnnouncementsFlag (companyId);
create index IX_ED8CE4E8 on AnnouncementsFlag (entryId, userId, value);

create unique index IX_F3842169 on AssetCategory (groupId, ctCollectionId, externalReferenceCode);
create index IX_F67BECAD on AssetCategory (groupId, parentCategoryId);
create unique index IX_AF94405C on AssetCategory (groupId, uuid_, ctCollectionId);
create index IX_2710C64A on AssetCategory (groupId, vocabularyId, name);
create index IX_68169942 on AssetCategory (groupId, vocabularyId, parentCategoryId);
create index IX_9DDD15EA on AssetCategory (parentCategoryId, name);
create index IX_4D37BB00 on AssetCategory (uuid_);
create index IX_3537E488 on AssetCategory (vocabularyId, name);
create unique index IX_8C99329D on AssetCategory (vocabularyId, parentCategoryId, name, ctCollectionId);

create index IX_112337B8 on AssetEntries_AssetTags (companyId);
create index IX_B2A61B55 on AssetEntries_AssetTags (tagId);

create unique index IX_7BF8337B on AssetEntry (classNameId, classPK, ctCollectionId);
create index IX_7306C60 on AssetEntry (companyId);
create index IX_75D42FF9 on AssetEntry (expirationDate);
create index IX_6418BB52 on AssetEntry (groupId, classNameId, publishDate, expirationDate);
create index IX_82C4BEF6 on AssetEntry (groupId, classNameId, visible);
create index IX_1EBA6821 on AssetEntry (groupId, classUuid);
create index IX_FEC4A201 on AssetEntry (layoutUuid);
create index IX_2E4E3885 on AssetEntry (publishDate);
create index IX_9029E15A on AssetEntry (visible);

create index IX_D63322F9 on AssetTag (groupId, name);
create index IX_C43137AF on AssetTag (name);
create unique index IX_A43FBC4 on AssetTag (uuid_, groupId, ctCollectionId);

create index IX_B22D908C on AssetVocabulary (companyId);
create unique index IX_E06DEF51 on AssetVocabulary (groupId, ctCollectionId, externalReferenceCode);
create unique index IX_32F2132B on AssetVocabulary (groupId, ctCollectionId, name);
create index IX_C0AAD74D on AssetVocabulary (groupId, name);
create unique index IX_3966DE44 on AssetVocabulary (groupId, uuid_, ctCollectionId);
create index IX_2F7F11EE on AssetVocabulary (groupId, visibilityType);
create index IX_55F58818 on AssetVocabulary (uuid_);

create unique index IX_E7B95510 on BrowserTracker (userId);

create unique index IX_B27A301F on ClassName_ (value);

create index IX_38EFE3FD on Company (logoId);
create index IX_12566EC2 on Company (mx);
create unique index IX_EC00543C on Company (webId);

create unique index IX_85C63FD7 on CompanyInfo (companyId);

create index IX_791914FA on Contact_ (classNameId, classPK);
create index IX_FD2E9BDD on Contact_ (companyId, userId);
create index IX_42F94F9F on Contact_ (userId);

create index IX_25D734CD on Country (active_);
create index IX_F9CD867E on Country (companyId, active_, billingAllowed);
create index IX_54E98CCD on Country (companyId, active_, shippingAllowed);
create unique index IX_7DA11A6F on Country (companyId, ctCollectionId, a2);
create unique index IX_7DA11E30 on Country (companyId, ctCollectionId, a3);
create unique index IX_B2A91789 on Country (companyId, ctCollectionId, name);
create unique index IX_74AB3DC on Country (companyId, ctCollectionId, number_);
create index IX_B59A9078 on Country (uuid_);

create unique index IX_E22A5911 on CountryLocalization (countryId, languageId, ctCollectionId);

create index IX_4CB1B2B4 on DLFileEntry (companyId);
create index IX_B8526DBE on DLFileEntry (custom1ImageId);
create index IX_AC9BDEDD on DLFileEntry (custom2ImageId);
create index IX_772ECDE7 on DLFileEntry (fileEntryTypeId);
create index IX_8F6C75D0 on DLFileEntry (folderId, name);
create index IX_57FFBBCA on DLFileEntry (folderId, repositoryId);
create unique index IX_761F8629 on DLFileEntry (groupId, ctCollectionId, externalReferenceCode);
create unique index IX_672F1AA0 on DLFileEntry (groupId, ctCollectionId, uuid_);
create unique index IX_1920CC0C on DLFileEntry (groupId, folderId, ctCollectionId, fileName);
create unique index IX_7BDA28F0 on DLFileEntry (groupId, folderId, ctCollectionId, name);
create unique index IX_4ADDCFF7 on DLFileEntry (groupId, folderId, ctCollectionId, title);
create index IX_29D0AF28 on DLFileEntry (groupId, folderId, fileEntryTypeId);
create index IX_1DC796CD on DLFileEntry (groupId, folderId, userId);
create index IX_43261870 on DLFileEntry (groupId, userId);
create index IX_4DB7A143 on DLFileEntry (largeImageId);
create index IX_D9492CF6 on DLFileEntry (mimeType);
create index IX_9EE96CAD on DLFileEntry (repositoryId);
create index IX_25F5CAB9 on DLFileEntry (smallImageId, largeImageId, custom1ImageId, custom2ImageId);
create index IX_64F0FE40 on DLFileEntry (uuid_);

create index IX_4F40FE5E on DLFileEntryMetadata (fileEntryId);
create unique index IX_5DC2B977 on DLFileEntryMetadata (fileVersionId, DDMStructureId, ctCollectionId);
create index IX_D49AB5D1 on DLFileEntryMetadata (uuid_);

create unique index IX_93ED0F06 on DLFileEntryType (groupId, ctCollectionId, dataDefinitionId);
create unique index IX_A5C4723D on DLFileEntryType (groupId, ctCollectionId, fileEntryTypeKey);
create unique index IX_C1518AF6 on DLFileEntryType (groupId, uuid_, ctCollectionId);
create index IX_90724726 on DLFileEntryType (uuid_);

create index IX_2E64D9F9 on DLFileEntryTypes_DLFolders (companyId);
create index IX_6E00A2EC on DLFileEntryTypes_DLFolders (folderId);

create index IX_8571953E on DLFileShortcut (companyId, status);
create index IX_17EE3098 on DLFileShortcut (groupId, folderId, active_, status);
create unique index IX_86FE17F8 on DLFileShortcut (groupId, uuid_, ctCollectionId);
create index IX_4B7247F6 on DLFileShortcut (toFileEntryId);
create index IX_4831EBE4 on DLFileShortcut (uuid_);

create index IX_CF394FE on DLFileVersion (companyId, storeUUID);
create unique index IX_10E504DF on DLFileVersion (fileEntryId, version, ctCollectionId);
create index IX_BC5541ED on DLFileVersion (groupId, folderId, version, title);
create index IX_FFB3395C on DLFileVersion (mimeType);
create index IX_5898E799 on DLFileVersion (status, companyId, expirationDate);
create index IX_92309600 on DLFileVersion (status, displayDate);
create index IX_D50EAA41 on DLFileVersion (status, fileEntryId);
create index IX_799D5D47 on DLFileVersion (status, groupId, folderId);
create unique index IX_350F5CAE on DLFileVersion (uuid_, groupId, ctCollectionId);

create index IX_A74DB14C on DLFolder (companyId);
create unique index IX_F0D74691 on DLFolder (groupId, ctCollectionId, externalReferenceCode);
create unique index IX_4C35E652 on DLFolder (groupId, parentFolderId, ctCollectionId, name);
create index IX_CE360BF6 on DLFolder (groupId, parentFolderId, hidden_, status);
create index IX_2D8D2D2B on DLFolder (groupId, parentFolderId, mountPoint, hidden_, status);
create unique index IX_53E6B584 on DLFolder (groupId, uuid_, ctCollectionId);
create index IX_D6D77780 on DLFolder (mountPoint, repositoryId);
create index IX_51556082 on DLFolder (parentFolderId, name);
create index IX_56F3D47C on DLFolder (parentFolderId, repositoryId);
create index IX_EE29C715 on DLFolder (repositoryId);
create index IX_B199E2A6 on DLFolder (status, companyId);
create index IX_CBC408D8 on DLFolder (uuid_);

create index IX_2A2CB130 on EmailAddress (companyId, classNameId, classPK, primary_);
create index IX_7B43CD8 on EmailAddress (userId);
create index IX_D24F3956 on EmailAddress (uuid_);

create unique index IX_4A7D3605 on ExpandoColumn (tableId, name, ctCollectionId);

create index IX_49EB3118 on ExpandoRow (classPK);
create unique index IX_488E0C53 on ExpandoRow (tableId, classPK, ctCollectionId);

create unique index IX_87D370E2 on ExpandoTable (companyId, classNameId, name, ctCollectionId);

create index IX_CAD04B0D on ExpandoValue (classPK, classNameId);
create unique index IX_E6D98E43 on ExpandoValue (columnId, rowId_, ctCollectionId);
create index IX_9112A7A0 on ExpandoValue (rowId_);
create index IX_1BD3F4C on ExpandoValue (tableId, classPK);
create unique index IX_D8C72C45 on ExpandoValue (tableId, columnId, classPK, ctCollectionId);
create index IX_B71E92D5 on ExpandoValue (tableId, rowId_);

create index IX_1827A2E5 on ExportImportConfiguration (companyId);
create index IX_38FA468D on ExportImportConfiguration (groupId, status);
create index IX_47CC6234 on ExportImportConfiguration (groupId, type_, status);

create index IX_75017452 on Group_ (active_, type_);
create index IX_8257E37B on Group_ (classNameId, classPK);
create index IX_DDC91A87 on Group_ (companyId, active_);
create unique index IX_DBA56EF9 on Group_ (companyId, classNameId, ctCollectionId, classPK);
create index IX_ABE2D54 on Group_ (companyId, classNameId, parentGroupId);
create index IX_DF76A247 on Group_ (companyId, classNameId, site);
create unique index IX_23B1C81D on Group_ (companyId, ctCollectionId, externalReferenceCode);
create unique index IX_3551EED4 on Group_ (companyId, ctCollectionId, friendlyURL);
create unique index IX_42E6E774 on Group_ (companyId, ctCollectionId, groupKey);
create index IX_5D75499E on Group_ (companyId, parentGroupId);
create index IX_B91488EC on Group_ (companyId, site, active_);
create index IX_7B216735 on Group_ (companyId, site, parentGroupId, inheritContent);
create index IX_16218A38 on Group_ (liveGroupId);
create index IX_F981514E on Group_ (uuid_);

create index IX_8BFD4548 on Groups_Orgs (companyId);
create index IX_6BBB7682 on Groups_Orgs (organizationId);

create index IX_557D8550 on Groups_Roles (companyId);
create index IX_3103EF3D on Groups_Roles (roleId);

create index IX_676FC818 on Groups_UserGroups (companyId);
create index IX_3B69160F on Groups_UserGroups (userGroupId);

create index IX_6A925A4D on Image (size_);

create index IX_B8E1E6E5 on Layout (classNameId, classPK);
create index IX_881EABCB on Layout (companyId, layoutPrototypeUuid);
create unique index IX_E81EADC5 on Layout (groupId, ctCollectionId, externalReferenceCode);
create index IX_993CBA31 on Layout (groupId, masterLayoutPlid);
create unique index IX_502B1A93 on Layout (groupId, privateLayout, ctCollectionId, friendlyURL);
create unique index IX_4FBF955A on Layout (groupId, privateLayout, ctCollectionId, layoutId);
create unique index IX_18646B93 on Layout (groupId, privateLayout, ctCollectionId, uuid_);
create index IX_7DAA999F on Layout (groupId, privateLayout, parentLayoutId, hidden_);
create index IX_7399B71E on Layout (groupId, privateLayout, parentLayoutId, priority);
create index IX_8F78BAFA on Layout (groupId, privateLayout, parentLayoutId, system_);
create index IX_8CE8C0D9 on Layout (groupId, privateLayout, sourcePrototypeLayoutUuid);
create index IX_A0364689 on Layout (groupId, privateLayout, status);
create index IX_1A1B61D2 on Layout (groupId, privateLayout, type_);
create index IX_6EDC627B on Layout (groupId, type_);
create index IX_23922F7D on Layout (iconImageId);
create index IX_B529BFD3 on Layout (layoutPrototypeUuid);
create index IX_1D4DCAA5 on Layout (parentPlid);
create index IX_3BC009C0 on Layout (privateLayout, iconImageId);
create index IX_39A18ECC on Layout (sourcePrototypeLayoutUuid);
create index IX_D0822724 on Layout (uuid_);

create index IX_A705FF94 on LayoutBranch (layoutSetBranchId, plid, master);
create unique index IX_FD57097D on LayoutBranch (layoutSetBranchId, plid, name);
create index IX_72FC531D on LayoutBranch (plid);

create index IX_EAB317C8 on LayoutFriendlyURL (companyId);
create index IX_C23A9814 on LayoutFriendlyURL (friendlyURL, companyId);
create index IX_D3B2D6DF on LayoutFriendlyURL (friendlyURL, plid);
create unique index IX_8B1B117C on LayoutFriendlyURL (groupId, friendlyURL, ctCollectionId, privateLayout, languageId);
create index IX_26AE82D3 on LayoutFriendlyURL (groupId, friendlyURL, privateLayout);
create unique index IX_2C37488 on LayoutFriendlyURL (groupId, uuid_, ctCollectionId);
create unique index IX_A4D8B1D0 on LayoutFriendlyURL (plid, ctCollectionId, languageId);
create index IX_9F80D54 on LayoutFriendlyURL (uuid_);

create index IX_557A639F on LayoutPrototype (companyId, active_);
create index IX_CEF72136 on LayoutPrototype (uuid_);

create index IX_9EC9F954 on LayoutRevision (layoutSetBranchId, head, status);
create index IX_538BFC54 on LayoutRevision (layoutSetBranchId, plid, head, layoutBranchId);
create index IX_84668240 on LayoutRevision (layoutSetBranchId, plid, layoutBranchId);
create index IX_F93E5CC3 on LayoutRevision (layoutSetBranchId, plid, parentLayoutRevisionId);
create index IX_70DA9ECB on LayoutRevision (layoutSetBranchId, plid, status);
create index IX_7FFAE700 on LayoutRevision (layoutSetBranchId, status);
create index IX_27F4B32A on LayoutRevision (plid, head);
create index IX_8EC3D2BC on LayoutRevision (plid, status);
create index IX_421223B1 on LayoutRevision (status);

create unique index IX_3F2A9AEF on LayoutSet (groupId, privateLayout, ctCollectionId);
create index IX_C629311 on LayoutSet (layoutSetPrototypeUuid, companyId);
create index IX_1B698D9 on LayoutSet (privateLayout, logoId);

create index IX_CCF0DA29 on LayoutSetBranch (groupId, privateLayout, master);
create unique index IX_5FF18552 on LayoutSetBranch (groupId, privateLayout, name);

create index IX_9178FC71 on LayoutSetPrototype (companyId, active_);
create index IX_C5D69B24 on LayoutSetPrototype (uuid_);

create unique index IX_BF6DBF8A on ListType (companyId, type_, name);
create index IX_56E29D16 on ListType (uuid_);

create index IX_C28C72EC on MembershipRequest (groupId, statusId);
create index IX_35AA8FA6 on MembershipRequest (groupId, userId, statusId);
create index IX_66D70879 on MembershipRequest (userId);

create index IX_6AF0D434 on OrgLabor (organizationId);

create unique index IX_87E47DA9 on Organization_ (companyId, ctCollectionId, externalReferenceCode);
create unique index IX_F1E40A53 on Organization_ (companyId, name, ctCollectionId);
create index IX_4BCBAB21 on Organization_ (companyId, name, parentOrganizationId);
create index IX_418E4522 on Organization_ (companyId, parentOrganizationId);
create index IX_396D6B42 on Organization_ (uuid_);

create index IX_2C1142E on PasswordPolicy (companyId, defaultPolicy);
create unique index IX_3FBFA9F4 on PasswordPolicy (companyId, name);
create index IX_51437A01 on PasswordPolicy (uuid_);

create unique index IX_C3A17327 on PasswordPolicyRel (classNameId, classPK);
create index IX_CD25266E on PasswordPolicyRel (passwordPolicyId);

create index IX_326F75BD on PasswordTracker (userId);

create index IX_812CE07A on Phone (companyId, classNameId, classPK, primary_);
create index IX_F202B9CE on Phone (userId);
create index IX_EA6245A0 on Phone (uuid_);

create unique index IX_7171B2E8 on PluginSetting (companyId, pluginId, pluginType);

create unique index IX_D5E35599 on PortalPreferenceValue (portalPreferencesId, namespace, key_, index_);
create index IX_737DBC36 on PortalPreferenceValue (portalPreferencesId, namespace, key_, smallValue);

create index IX_D1846D13 on PortalPreferences (ownerType, ownerId);

create unique index IX_12B5E51D on Portlet (companyId, portletId);

create index IX_C6246ECD on PortletItem (groupId, classNameId, portletId, name);

create index IX_EE8C5489 on PortletPreferenceValue (name, smallValue, companyId);
create unique index IX_B517784D on PortletPreferenceValue (portletPreferencesId, name, index_, ctCollectionId);
create index IX_8E75AB8C on PortletPreferenceValue (portletPreferencesId, name, smallValue);

create index IX_3EAB5A5A on PortletPreferences (ownerId);
create index IX_6DD4B410 on PortletPreferences (ownerType, ownerId, plid);
create index IX_F15C1C4F on PortletPreferences (plid);
create index IX_CEA05B46 on PortletPreferences (portletId, ownerType, ownerId, companyId);
create unique index IX_8CCEB8CB on PortletPreferences (portletId, ownerType, ownerId, plid, ctCollectionId);
create index IX_EF5FCC07 on PortletPreferences (portletId, ownerType, plid);
create index IX_8DCFD52C on PortletPreferences (portletId, plid);

create index IX_A1A8CB8B on RatingsEntry (classNameId, classPK, score);
create unique index IX_119FF2EF on RatingsEntry (classNameId, classPK, userId, ctCollectionId);
create index IX_C34DEAF2 on RatingsEntry (uuid_);

create unique index IX_C286E0E2 on RatingsStats (classNameId, classPK, ctCollectionId);

create index IX_B91F79BD on RecentLayoutBranch (groupId);
create index IX_351E86E8 on RecentLayoutBranch (layoutBranchId);
create unique index IX_C27D6369 on RecentLayoutBranch (userId, layoutSetBranchId, plid);

create index IX_8D8A2724 on RecentLayoutRevision (groupId);
create index IX_DA0788DA on RecentLayoutRevision (layoutRevisionId);
create unique index IX_4C600BD0 on RecentLayoutRevision (userId, layoutSetBranchId, plid);

create index IX_711995A5 on RecentLayoutSetBranch (groupId);
create index IX_23FF0700 on RecentLayoutSetBranch (layoutSetBranchId);
create unique index IX_4654D204 on RecentLayoutSetBranch (userId, layoutSetId);

create index IX_2D9A426F on Region (active_);
create index IX_11FB3E42 on Region (countryId, active_);
create unique index IX_183BFDBA on Region (countryId, regionCode, ctCollectionId);
create index IX_48A89E9A on Region (uuid_);

create unique index IX_982329B on RegionLocalization (regionId, languageId, ctCollectionId);

create unique index IX_8BD6BCA7 on Release_ (servletContextName);

create index IX_D4C6FBCB on RememberMeToken (expirationDate);
create index IX_291F58D4 on RememberMeToken (userId);

create unique index IX_470608AE on Repository (groupId, ctCollectionId, name, portletId);
create unique index IX_4009E884 on Repository (uuid_, groupId, ctCollectionId);

create unique index IX_B43A3F67 on RepositoryEntry (repositoryId, ctCollectionId, mappedId);
create unique index IX_239165C6 on RepositoryEntry (uuid_, ctCollectionId, groupId);

create unique index IX_EDB9986E on ResourceAction (name, actionId);

create index IX_26284944 on ResourcePermission (companyId, primKey);
create unique index IX_F2237D8E on ResourcePermission (companyId, scope, name, primKey, roleId, ctCollectionId);
create index IX_FA3E7EEB on ResourcePermission (companyId, scope, name, roleId, primKeyId, viewActionId);
create index IX_F6BAE86A on ResourcePermission (companyId, scope, primKey);
create index IX_D5F1E2A2 on ResourcePermission (name);
create index IX_A37A0588 on ResourcePermission (roleId);
create index IX_F4555981 on ResourcePermission (scope);

create unique index IX_CC85CC2C on Role_ (companyId, ctCollectionId, classNameId, classPK);
create unique index IX_D11C3796 on Role_ (companyId, ctCollectionId, name);
create index IX_F436EC8E on Role_ (name);
create index IX_5EB4E2FB on Role_ (subtype);
create index IX_CBE204 on Role_ (type_, subtype);
create index IX_26DB26C5 on Role_ (uuid_);

create unique index IX_4F0315B8 on ServiceComponent (buildNamespace, buildNumber);

create index IX_F542E9BC on SocialActivity (activitySetId);
create unique index IX_7E6A9AAD on SocialActivity (classNameId, classPK, groupId, userId, type_, receiverUserId, ctCollectionId, createDate);
create index IX_85370BF4 on SocialActivity (classNameId, classPK, mirrorActivityId);
create index IX_D0E9029E on SocialActivity (classNameId, classPK, type_);
create index IX_64B1BC66 on SocialActivity (companyId);
create index IX_2A2468 on SocialActivity (groupId);
create index IX_1271F25F on SocialActivity (mirrorActivityId);
create index IX_121CA3CB on SocialActivity (receiverUserId);
create index IX_3504B8BC on SocialActivity (userId);

create index IX_83E16F2F on SocialActivityAchievement (groupId, firstInGroup);
create index IX_8F6408F0 on SocialActivityAchievement (groupId, name);
create index IX_AABC18E9 on SocialActivityAchievement (groupId, userId, firstInGroup);
create unique index IX_5ED94F08 on SocialActivityAchievement (groupId, userId, name, ctCollectionId);

create index IX_A4B9A23B on SocialActivityCounter (classNameId, classPK);
create unique index IX_56195A6B on SocialActivityCounter (groupId, classNameId, classPK, ownerType, name, ctCollectionId, endPeriod);
create unique index IX_379AA3B2 on SocialActivityCounter (groupId, classNameId, classPK, ownerType, name, ctCollectionId, startPeriod);

create index IX_B15863FA on SocialActivityLimit (classNameId, classPK);
create unique index IX_4A636E75 on SocialActivityLimit (groupId, userId, classNameId, classPK, activityType, activityCounterName, ctCollectionId);
create index IX_6F9EDE9F on SocialActivityLimit (userId);

create index IX_9E13F2DE on SocialActivitySet (groupId);
create index IX_5D1FA9E on SocialActivitySet (type_, classNameId, classPK);
create index IX_241D10A4 on SocialActivitySet (userId, type_, classNameId, classPK);
create index IX_6D0C8733 on SocialActivitySet (userId, type_, groupId, classNameId);

create index IX_384788CD on SocialActivitySetting (groupId, activityType);
create index IX_D984AABA on SocialActivitySetting (groupId, classNameId, activityType, name);

create index IX_61171E99 on SocialRelation (companyId);
create index IX_5E1F07A2 on SocialRelation (type_, companyId);
create unique index IX_ECA579C5 on SocialRelation (type_, userId1, userId2, ctCollectionId);
create index IX_C91168D6 on SocialRelation (type_, userId2);
create index IX_B5C9C690 on SocialRelation (userId1, userId2);
create index IX_5A40D18D on SocialRelation (userId2);
create index IX_F0CA24A5 on SocialRelation (uuid_);

create index IX_E8468A49 on SocialRequest (classNameId, classPK, receiverUserId, status, type_);
create index IX_A90FE5A0 on SocialRequest (companyId);
create index IX_D9380CB7 on SocialRequest (receiverUserId, status);
create unique index IX_2FE40453 on SocialRequest (userId, classNameId, classPK, receiverUserId, type_, ctCollectionId);
create index IX_7CFF5CB8 on SocialRequest (userId, classNameId, classPK, status, type_);
create index IX_AB5906A8 on SocialRequest (userId, status);
create unique index IX_87DD8A60 on SocialRequest (uuid_, ctCollectionId, groupId);

create index IX_FFCBB747 on SystemEvent (groupId, classNameId, classPK, type_);
create index IX_A19C89FF on SystemEvent (groupId, systemEventSetKey);

create index IX_93AB8545 on Team (companyId);
create unique index IX_58777164 on Team (groupId, ctCollectionId, name);
create unique index IX_1AAF62D7 on Team (uuid_, groupId, ctCollectionId);

create index IX_DAD135B4 on Ticket (classNameId, classPK, companyId, type_);
create index IX_1E8DFB2E on Ticket (classNameId, classPK, type_);
create index IX_B2468446 on Ticket (key_);

create unique index IX_A33BD191 on UserGroup (companyId, ctCollectionId, externalReferenceCode);
create unique index IX_3F4FC96B on UserGroup (companyId, name, ctCollectionId);
create index IX_69771487 on UserGroup (companyId, parentUserGroupId);
create index IX_5F1DD85A on UserGroup (uuid_);

create index IX_CAB0CCC8 on UserGroupGroupRole (groupId, roleId);
create unique index IX_618D3E5F on UserGroupGroupRole (groupId, userGroupId, roleId, ctCollectionId);
create index IX_1CDF88C on UserGroupGroupRole (roleId);
create index IX_DCDED558 on UserGroupGroupRole (userGroupId);

create index IX_871412DF on UserGroupRole (groupId, roleId);
create unique index IX_5427FB77 on UserGroupRole (groupId, userId, roleId, ctCollectionId);
create index IX_887A2C95 on UserGroupRole (roleId);
create index IX_887BE56A on UserGroupRole (userId);

create index IX_2AC5356C on UserGroups_Teams (companyId);
create index IX_7F187E63 on UserGroups_Teams (userGroupId);

create unique index IX_41A32E0D on UserIdMapper (type_, externalUserId);
create unique index IX_D1C44A6E on UserIdMapper (userId, type_);

create unique index IX_8B6E3ACE on UserNotificationDelivery (userId, portletId, classNameId, notificationType, deliveryType);

create index IX_BF29100B on UserNotificationEvent (type_);
create index IX_6E095243 on UserNotificationEvent (userId, archived, actionRequired);
create index IX_E32CC19 on UserNotificationEvent (userId, delivered, actionRequired);
create index IX_AE54166F on UserNotificationEvent (userId, delivered, archived, actionRequired);
create index IX_7522B7DB on UserNotificationEvent (userId, delivered, deliveryType, actionRequired);
create index IX_3BE9B7B1 on UserNotificationEvent (userId, delivered, deliveryType, archived, actionRequired);
create index IX_2AB8294D on UserNotificationEvent (userId, delivered, deliveryType, archived, type_);
create index IX_105871E3 on UserNotificationEvent (userId, delivered, deliveryType, type_);
create index IX_EBF87241 on UserNotificationEvent (userId, delivered, type_, timestamp);
create index IX_D60FB085 on UserNotificationEvent (userId, deliveryType, archived, actionRequired);
create index IX_ECD8CFEA on UserNotificationEvent (uuid_);

create index IX_29BA1CF5 on UserTracker (companyId);
create index IX_46B0AE8E on UserTracker (sessionId);
create index IX_E4EFBA8D on UserTracker (userId);

create index IX_14D8BCC0 on UserTrackerPath (userTrackerId);

create index IX_BCFDA257 on User_ (companyId, createDate, modifiedDate);
create unique index IX_77D89D58 on User_ (companyId, ctCollectionId, emailAddress);
create unique index IX_6FF64E11 on User_ (companyId, ctCollectionId, externalReferenceCode);
create unique index IX_6B7C3D77 on User_ (companyId, ctCollectionId, screenName);
create index IX_1D731F03 on User_ (companyId, facebookId);
create index IX_B6E3AE1 on User_ (companyId, googleUserId);
create index IX_EE8ABD19 on User_ (companyId, modifiedDate);
create index IX_89509087 on User_ (companyId, openId);
create index IX_F6039434 on User_ (companyId, status);
create index IX_FD06BAAD on User_ (companyId, type_, status);
create unique index IX_E902F853 on User_ (ctCollectionId, contactId);
create index IX_762F63C6 on User_ (emailAddress);
create index IX_A18034A4 on User_ (portraitId);
create index IX_E0422BDA on User_ (uuid_);

create index IX_3499B657 on Users_Groups (companyId);
create index IX_F10B6C6B on Users_Groups (userId);

create index IX_5FBB883C on Users_Orgs (companyId);
create index IX_FB646CA6 on Users_Orgs (userId);

create index IX_F987A0DC on Users_Roles (companyId);
create index IX_C1A01806 on Users_Roles (userId);

create index IX_799F8283 on Users_Teams (companyId);
create index IX_A098EFBF on Users_Teams (userId);

create index IX_BB65040C on Users_UserGroups (companyId);
create index IX_66FF2503 on Users_UserGroups (userGroupId);

create index IX_EECA5FDA on VirtualHost (companyId, layoutSetId, defaultVirtualHost);
create unique index IX_76A64FBE on VirtualHost (hostname, ctCollectionId);
create index IX_774643D1 on VirtualHost (layoutSetId, hostname);

create unique index IX_97DFA146 on WebDAVProps (classNameId, classPK);

create index IX_1AA07A6D on Website (companyId, classNameId, classPK, primary_);
create index IX_F75690BB on Website (userId);
create index IX_76F15D13 on Website (uuid_);

create index IX_EB4D2E32 on WorkflowDefinitionLink (companyId, groupId, classNameId, classPK, typePK);
create index IX_4AE45F6F on WorkflowDefinitionLink (companyId, groupId, classPK);
create index IX_A4DB1F0F on WorkflowDefinitionLink (companyId, workflowDefinitionName, workflowDefinitionVersion);

create index IX_415A7007 on WorkflowInstanceLink (groupId, companyId, classNameId, classPK);



quit