use master
exec sp_dboption 'lportal', 'allow nulls by default' , true
go

exec sp_dboption 'lportal', 'select into/bulkcopy/pllsort' , true
go

use lportal

create table Address (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	addressId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	countryId decimal(20,0),
	listTypeId decimal(20,0),
	regionId decimal(20,0),
	city varchar(75) null,
	description varchar(4000) null,
	latitude float,
	longitude float,
	mailing int,
	name varchar(255) null,
	primary_ int,
	street1 varchar(255) null,
	street2 varchar(255) null,
	street3 varchar(255) null,
	validationDate bigdatetime null,
	validationStatus int,
	zip varchar(75) null,
	primary key (addressId, ctCollectionId)
)
go

create table AnnouncementsDelivery (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	deliveryId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	type_ varchar(75) null,
	email int,
	sms int,
	website int,
	primary key (deliveryId, ctCollectionId)
)
go

create table AnnouncementsEntry (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	entryId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	title varchar(75) null,
	content text null,
	url varchar(4000) null,
	type_ varchar(75) null,
	displayDate bigdatetime null,
	expirationDate bigdatetime null,
	priority int,
	alert int,
	primary key (entryId, ctCollectionId)
)
go

create table AnnouncementsFlag (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	flagId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	createDate bigdatetime null,
	entryId decimal(20,0),
	value int,
	primary key (flagId, ctCollectionId)
)
go

create table AssetCategory (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	categoryId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	parentCategoryId decimal(20,0),
	treePath varchar(4000) null,
	name varchar(255) null,
	title text null,
	description text null,
	vocabularyId decimal(20,0),
	lastPublishDate bigdatetime null,
	primary key (categoryId, ctCollectionId)
)
go

create table AssetEntries_AssetTags (
	companyId decimal(20,0) not null,
	entryId decimal(20,0) not null,
	tagId decimal(20,0) not null,
	ctCollectionId decimal(20,0) default 0 not null,
	ctChangeType int,
	primary key (entryId, tagId, ctCollectionId)
)
go

create table AssetEntry (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	entryId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	classUuid varchar(75) null,
	classTypeId decimal(20,0),
	listable int,
	visible int,
	startDate bigdatetime null,
	endDate bigdatetime null,
	publishDate bigdatetime null,
	expirationDate bigdatetime null,
	mimeType varchar(75) null,
	title text null,
	description text null,
	summary text null,
	url varchar(4000) null,
	layoutUuid varchar(75) null,
	height int,
	width int,
	priority float,
	primary key (entryId, ctCollectionId)
)
go

create table AssetTag (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	tagId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	name varchar(75) null,
	assetCount int,
	lastPublishDate bigdatetime null,
	primary key (tagId, ctCollectionId)
)
go

create table AssetVocabulary (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	vocabularyId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	name varchar(75) null,
	title varchar(4000) null,
	description varchar(4000) null,
	settings_ varchar(4000) null,
	visibilityType int,
	lastPublishDate bigdatetime null,
	primary key (vocabularyId, ctCollectionId)
)
go

create table BrowserTracker (
	mvccVersion decimal(20,0) default 0 not null,
	browserTrackerId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userId decimal(20,0),
	browserKey decimal(20,0)
)
go

create table ClassName_ (
	mvccVersion decimal(20,0) default 0 not null,
	classNameId decimal(20,0) not null primary key,
	value varchar(200) null
)
go

create table Company (
	mvccVersion decimal(20,0) default 0 not null,
	companyId decimal(20,0) not null primary key,
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	webId varchar(75) null,
	mx varchar(200) null,
	homeURL varchar(4000) null,
	logoId decimal(20,0),
	maxUsers int,
	active_ int,
	name varchar(75) null,
	legalName varchar(75) null,
	legalId varchar(75) null,
	legalType varchar(75) null,
	sicCode varchar(75) null,
	tickerSymbol varchar(75) null,
	industry varchar(75) null,
	type_ varchar(75) null,
	size_ varchar(75) null,
	indexNameCurrent varchar(75) null,
	indexNameNext varchar(75) null
)
go

create table CompanyInfo (
	mvccVersion decimal(20,0) default 0 not null,
	companyInfoId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	key_ text null
)
go

create table Contact_ (
	mvccVersion decimal(20,0) default 0 not null,
	contactId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	parentContactId decimal(20,0),
	emailAddress varchar(254) null,
	firstName varchar(75) null,
	middleName varchar(75) null,
	lastName varchar(75) null,
	prefixListTypeId decimal(20,0),
	suffixListTypeId decimal(20,0),
	male int,
	birthday bigdatetime null,
	smsSn varchar(75) null,
	facebookSn varchar(75) null,
	jabberSn varchar(75) null,
	skypeSn varchar(75) null,
	twitterSn varchar(75) null,
	employeeStatusId varchar(75) null,
	employeeNumber varchar(75) null,
	jobTitle varchar(100) null,
	jobClass varchar(75) null,
	hoursOfOperation varchar(75) null
)
go

create table Counter (
	name varchar(150) not null primary key,
	currentId decimal(20,0)
)
go

create table Country (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	defaultLanguageId varchar(75) null,
	countryId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	a2 varchar(75) null,
	a3 varchar(75) null,
	active_ int,
	billingAllowed int,
	groupFilterEnabled int,
	idd_ varchar(75) null,
	name varchar(75) null,
	number_ varchar(75) null,
	position float,
	shippingAllowed int,
	subjectToVAT int,
	zipRequired int,
	lastPublishDate bigdatetime null,
	primary key (countryId, ctCollectionId)
)
go

create table CountryLocalization (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	countryLocalizationId decimal(20,0) not null,
	companyId decimal(20,0),
	countryId decimal(20,0),
	languageId varchar(75) null,
	title varchar(75) null,
	primary key (countryLocalizationId, ctCollectionId)
)
go

create table DLFileEntry (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	fileEntryId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	repositoryId decimal(20,0),
	folderId decimal(20,0),
	treePath varchar(4000) null,
	name varchar(255) null,
	fileName varchar(255) null,
	extension varchar(75) null,
	mimeType varchar(75) null,
	title varchar(255) null,
	description varchar(4000) null,
	extraSettings text null,
	fileEntryTypeId decimal(20,0),
	version varchar(75) null,
	size_ decimal(20,0),
	smallImageId decimal(20,0),
	largeImageId decimal(20,0),
	custom1ImageId decimal(20,0),
	custom2ImageId decimal(20,0),
	manualCheckInRequired int,
	displayDate bigdatetime null,
	expirationDate bigdatetime null,
	reviewDate bigdatetime null,
	lastPublishDate bigdatetime null,
	primary key (fileEntryId, ctCollectionId)
)
go

create table DLFileEntryMetadata (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	fileEntryMetadataId decimal(20,0) not null,
	companyId decimal(20,0),
	DDMStorageId decimal(20,0),
	DDMStructureId decimal(20,0),
	fileEntryId decimal(20,0),
	fileVersionId decimal(20,0),
	primary key (fileEntryMetadataId, ctCollectionId)
)
go

create table DLFileEntryType (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	fileEntryTypeId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	dataDefinitionId decimal(20,0),
	fileEntryTypeKey varchar(75) null,
	name varchar(4000) null,
	description varchar(4000) null,
	scope int,
	lastPublishDate bigdatetime null,
	primary key (fileEntryTypeId, ctCollectionId)
)
go

create table DLFileEntryTypes_DLFolders (
	companyId decimal(20,0) not null,
	fileEntryTypeId decimal(20,0) not null,
	folderId decimal(20,0) not null,
	ctCollectionId decimal(20,0) default 0 not null,
	ctChangeType int,
	primary key (fileEntryTypeId, folderId, ctCollectionId)
)
go

create table DLFileShortcut (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	fileShortcutId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	repositoryId decimal(20,0),
	folderId decimal(20,0),
	toFileEntryId decimal(20,0),
	treePath varchar(4000) null,
	active_ int,
	lastPublishDate bigdatetime null,
	status int,
	statusByUserId decimal(20,0),
	statusByUserName varchar(75) null,
	statusDate bigdatetime null,
	primary key (fileShortcutId, ctCollectionId)
)
go

create table DLFileVersion (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	fileVersionId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	repositoryId decimal(20,0),
	folderId decimal(20,0),
	fileEntryId decimal(20,0),
	treePath varchar(4000) null,
	fileName varchar(255) null,
	extension varchar(75) null,
	mimeType varchar(75) null,
	title varchar(255) null,
	description varchar(4000) null,
	changeLog varchar(75) null,
	extraSettings text null,
	fileEntryTypeId decimal(20,0),
	version varchar(75) null,
	size_ decimal(20,0),
	checksum varchar(75) null,
	storeUUID varchar(255) null,
	displayDate bigdatetime null,
	expirationDate bigdatetime null,
	reviewDate bigdatetime null,
	lastPublishDate bigdatetime null,
	status int,
	statusByUserId decimal(20,0),
	statusByUserName varchar(75) null,
	statusDate bigdatetime null,
	primary key (fileVersionId, ctCollectionId)
)
go

create table DLFolder (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	folderId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	repositoryId decimal(20,0),
	mountPoint int,
	parentFolderId decimal(20,0),
	treePath varchar(4000) null,
	name varchar(255) null,
	description varchar(4000) null,
	lastPostDate bigdatetime null,
	defaultFileEntryTypeId decimal(20,0),
	hidden_ int,
	restrictionType int,
	lastPublishDate bigdatetime null,
	status int,
	statusByUserId decimal(20,0),
	statusByUserName varchar(75) null,
	statusDate bigdatetime null,
	primary key (folderId, ctCollectionId)
)
go

create table EmailAddress (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	emailAddressId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	address varchar(254) null,
	listTypeId decimal(20,0),
	primary_ int,
	primary key (emailAddressId, ctCollectionId)
)
go

create table ExpandoColumn (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	columnId decimal(20,0) not null,
	companyId decimal(20,0),
	modifiedDate bigdatetime null,
	tableId decimal(20,0),
	name varchar(75) null,
	type_ int,
	defaultData text null,
	typeSettings text null,
	primary key (columnId, ctCollectionId)
)
go

create table ExpandoRow (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	rowId_ decimal(20,0) not null,
	companyId decimal(20,0),
	modifiedDate bigdatetime null,
	tableId decimal(20,0),
	classPK decimal(20,0),
	primary key (rowId_, ctCollectionId)
)
go

create table ExpandoTable (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	tableId decimal(20,0) not null,
	companyId decimal(20,0),
	classNameId decimal(20,0),
	name varchar(75) null,
	primary key (tableId, ctCollectionId)
)
go

create table ExpandoValue (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	valueId decimal(20,0) not null,
	companyId decimal(20,0),
	tableId decimal(20,0),
	columnId decimal(20,0),
	rowId_ decimal(20,0),
	classNameId decimal(20,0),
	classPK decimal(20,0),
	data_ text null,
	primary key (valueId, ctCollectionId)
)
go

create table ExportImportConfiguration (
	mvccVersion decimal(20,0) default 0 not null,
	exportImportConfigurationId decimal(20,0) not null primary key,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	name varchar(200) null,
	description varchar(4000) null,
	type_ int,
	settings_ text null,
	status int,
	statusByUserId decimal(20,0),
	statusByUserName varchar(75) null,
	statusDate bigdatetime null
)
go

create table Group_ (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	groupId decimal(20,0) not null,
	companyId decimal(20,0),
	creatorUserId decimal(20,0),
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	parentGroupId decimal(20,0),
	liveGroupId decimal(20,0),
	treePath varchar(4000) null,
	groupKey varchar(150) null,
	name varchar(4000) null,
	description varchar(4000) null,
	type_ int,
	typeSettings text null,
	manualMembership int,
	membershipRestriction int,
	friendlyURL varchar(255) null,
	site int,
	remoteStagingGroupCount int,
	inheritContent int,
	active_ int,
	primary key (groupId, ctCollectionId)
)
go

create table Groups_Orgs (
	companyId decimal(20,0) not null,
	groupId decimal(20,0) not null,
	organizationId decimal(20,0) not null,
	ctCollectionId decimal(20,0) default 0 not null,
	ctChangeType int,
	primary key (groupId, organizationId, ctCollectionId)
)
go

create table Groups_Roles (
	companyId decimal(20,0) not null,
	groupId decimal(20,0) not null,
	roleId decimal(20,0) not null,
	ctCollectionId decimal(20,0) default 0 not null,
	ctChangeType int,
	primary key (groupId, roleId, ctCollectionId)
)
go

create table Groups_UserGroups (
	companyId decimal(20,0) not null,
	groupId decimal(20,0) not null,
	userGroupId decimal(20,0) not null,
	ctCollectionId decimal(20,0) default 0 not null,
	ctChangeType int,
	primary key (groupId, userGroupId, ctCollectionId)
)
go

create table Image (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	imageId decimal(20,0) not null,
	companyId decimal(20,0),
	modifiedDate bigdatetime null,
	type_ varchar(75) null,
	height int,
	width int,
	size_ int,
	primary key (imageId, ctCollectionId)
)
go

create table Layout (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	plid decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	parentPlid decimal(20,0),
	privateLayout int,
	layoutId decimal(20,0),
	parentLayoutId decimal(20,0),
	classNameId decimal(20,0),
	classPK decimal(20,0),
	name varchar(4000) null,
	title text null,
	description text null,
	keywords varchar(4000) null,
	robots varchar(4000) null,
	type_ varchar(75) null,
	typeSettings text null,
	hidden_ int,
	system_ int,
	friendlyURL varchar(255) null,
	iconImageId decimal(20,0),
	themeId varchar(75) null,
	colorSchemeId varchar(75) null,
	styleBookEntryId decimal(20,0),
	css text null,
	priority int,
	faviconFileEntryId decimal(20,0),
	masterLayoutPlid decimal(20,0),
	layoutPrototypeUuid varchar(75) null,
	layoutPrototypeLinkEnabled int,
	sourcePrototypeLayoutUuid varchar(75) null,
	publishDate bigdatetime null,
	lastPublishDate bigdatetime null,
	status int,
	statusByUserId decimal(20,0),
	statusByUserName varchar(75) null,
	statusDate bigdatetime null,
	primary key (plid, ctCollectionId)
)
go

create table LayoutBranch (
	mvccVersion decimal(20,0) default 0 not null,
	layoutBranchId decimal(20,0) not null primary key,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	layoutSetBranchId decimal(20,0),
	plid decimal(20,0),
	name varchar(75) null,
	description varchar(4000) null,
	master int
)
go

create table LayoutFriendlyURL (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	layoutFriendlyURLId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	plid decimal(20,0),
	privateLayout int,
	friendlyURL varchar(255) null,
	languageId varchar(75) null,
	lastPublishDate bigdatetime null,
	primary key (layoutFriendlyURLId, ctCollectionId)
)
go

create table LayoutPrototype (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	layoutPrototypeId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	name text null,
	description text null,
	settings_ varchar(4000) null,
	active_ int,
	primary key (layoutPrototypeId, ctCollectionId)
)
go

create table LayoutRevision (
	mvccVersion decimal(20,0) default 0 not null,
	layoutRevisionId decimal(20,0) not null primary key,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	layoutSetBranchId decimal(20,0),
	layoutBranchId decimal(20,0),
	parentLayoutRevisionId decimal(20,0),
	head int,
	major int,
	plid decimal(20,0),
	privateLayout int,
	name varchar(4000) null,
	title varchar(4000) null,
	description varchar(4000) null,
	keywords varchar(4000) null,
	robots varchar(4000) null,
	typeSettings text null,
	iconImageId decimal(20,0),
	themeId varchar(75) null,
	colorSchemeId varchar(75) null,
	css text null,
	status int,
	statusByUserId decimal(20,0),
	statusByUserName varchar(75) null,
	statusDate bigdatetime null
)
go

create table LayoutSet (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	layoutSetId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	privateLayout int,
	logoId decimal(20,0),
	themeId varchar(75) null,
	colorSchemeId varchar(75) null,
	faviconFileEntryId decimal(20,0),
	css text null,
	settings_ text null,
	layoutSetPrototypeUuid varchar(75) null,
	layoutSetPrototypeLinkEnabled int,
	primary key (layoutSetId, ctCollectionId)
)
go

create table LayoutSetBranch (
	mvccVersion decimal(20,0) default 0 not null,
	layoutSetBranchId decimal(20,0) not null primary key,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	privateLayout int,
	name varchar(75) null,
	description varchar(4000) null,
	master int,
	logoId decimal(20,0),
	themeId varchar(75) null,
	colorSchemeId varchar(75) null,
	css text null,
	settings_ text null,
	layoutSetPrototypeUuid varchar(75) null,
	layoutSetPrototypeLinkEnabled int
)
go

create table LayoutSetPrototype (
	mvccVersion decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	layoutSetPrototypeId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	name text null,
	description text null,
	settings_ varchar(4000) null,
	active_ int
)
go

create table ListType (
	mvccVersion decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	listTypeId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	name varchar(75) null,
	type_ varchar(75) null
)
go

create table MembershipRequest (
	mvccVersion decimal(20,0) default 0 not null,
	membershipRequestId decimal(20,0) not null primary key,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	createDate bigdatetime null,
	comments varchar(4000) null,
	replyComments varchar(4000) null,
	replyDate bigdatetime null,
	replierUserId decimal(20,0),
	statusId decimal(20,0)
)
go

create table OrgLabor (
	mvccVersion decimal(20,0) default 0 not null,
	orgLaborId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	organizationId decimal(20,0),
	listTypeId decimal(20,0),
	sunOpen int,
	sunClose int,
	monOpen int,
	monClose int,
	tueOpen int,
	tueClose int,
	wedOpen int,
	wedClose int,
	thuOpen int,
	thuClose int,
	friOpen int,
	friClose int,
	satOpen int,
	satClose int
)
go

create table Organization_ (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	organizationId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	parentOrganizationId decimal(20,0),
	treePath varchar(4000) null,
	name varchar(100) null,
	type_ varchar(75) null,
	recursable int,
	regionId decimal(20,0),
	countryId decimal(20,0),
	statusListTypeId decimal(20,0),
	comments varchar(4000) null,
	logoId decimal(20,0),
	primary key (organizationId, ctCollectionId)
)
go

create table PasswordPolicy (
	mvccVersion decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	passwordPolicyId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	defaultPolicy int,
	name varchar(75) null,
	description varchar(4000) null,
	changeable int,
	changeRequired int,
	minAge decimal(20,0),
	checkSyntax int,
	allowDictionaryWords int,
	minAlphanumeric int,
	minLength int,
	minLowerCase int,
	minNumbers int,
	minSymbols int,
	minUpperCase int,
	regex varchar(4000) null,
	history int,
	historyCount int,
	expireable int,
	maxAge decimal(20,0),
	warningTime decimal(20,0),
	graceLimit int,
	lockout int,
	maxFailure int,
	lockoutDuration decimal(20,0),
	requireUnlock int,
	resetFailureCount decimal(20,0),
	resetTicketMaxAge decimal(20,0)
)
go

create table PasswordPolicyRel (
	mvccVersion decimal(20,0) default 0 not null,
	passwordPolicyRelId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	passwordPolicyId decimal(20,0),
	classNameId decimal(20,0),
	classPK decimal(20,0)
)
go

create table PasswordTracker (
	mvccVersion decimal(20,0) default 0 not null,
	passwordTrackerId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userId decimal(20,0),
	createDate bigdatetime null,
	password_ varchar(255) null
)
go

create table Phone (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	phoneId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	number_ varchar(75) null,
	extension varchar(75) null,
	listTypeId decimal(20,0),
	primary_ int,
	primary key (phoneId, ctCollectionId)
)
go

create table PluginSetting (
	mvccVersion decimal(20,0) default 0 not null,
	pluginSettingId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	pluginId varchar(75) null,
	pluginType varchar(75) null,
	roles varchar(4000) null,
	active_ int
)
go

create table PortalPreferenceValue (
	mvccVersion decimal(20,0) default 0 not null,
	portalPreferenceValueId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	portalPreferencesId decimal(20,0),
	index_ int,
	key_ varchar(1024) null,
	largeValue text null,
	namespace varchar(255) null,
	smallValue varchar(255) null
)
go

create table PortalPreferences (
	mvccVersion decimal(20,0) default 0 not null,
	portalPreferencesId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	ownerId decimal(20,0),
	ownerType int
)
go

create table Portlet (
	mvccVersion decimal(20,0) default 0 not null,
	id_ decimal(20,0) not null primary key,
	companyId decimal(20,0),
	portletId varchar(200) null,
	roles varchar(4000) null,
	active_ int
)
go

create table PortletItem (
	mvccVersion decimal(20,0) default 0 not null,
	portletItemId decimal(20,0) not null primary key,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	name varchar(75) null,
	portletId varchar(200) null,
	classNameId decimal(20,0)
)
go

create table PortletPreferenceValue (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	portletPreferenceValueId decimal(20,0) not null,
	companyId decimal(20,0),
	portletPreferencesId decimal(20,0),
	index_ int,
	largeValue text null,
	name varchar(255) null,
	readOnly int,
	smallValue varchar(255) null,
	primary key (portletPreferenceValueId, ctCollectionId)
)
go

create table PortletPreferences (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	portletPreferencesId decimal(20,0) not null,
	companyId decimal(20,0),
	ownerId decimal(20,0),
	ownerType int,
	plid decimal(20,0),
	portletId varchar(200) null,
	primary key (portletPreferencesId, ctCollectionId)
)
go

create table RatingsEntry (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	entryId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	score float,
	primary key (entryId, ctCollectionId)
)
go

create table RatingsStats (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	statsId decimal(20,0) not null,
	companyId decimal(20,0),
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	totalEntries int,
	totalScore float,
	averageScore float,
	primary key (statsId, ctCollectionId)
)
go

create table RecentLayoutBranch (
	mvccVersion decimal(20,0) default 0 not null,
	recentLayoutBranchId decimal(20,0) not null primary key,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	layoutBranchId decimal(20,0),
	layoutSetBranchId decimal(20,0),
	plid decimal(20,0)
)
go

create table RecentLayoutRevision (
	mvccVersion decimal(20,0) default 0 not null,
	recentLayoutRevisionId decimal(20,0) not null primary key,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	layoutRevisionId decimal(20,0),
	layoutSetBranchId decimal(20,0),
	plid decimal(20,0)
)
go

create table RecentLayoutSetBranch (
	mvccVersion decimal(20,0) default 0 not null,
	recentLayoutSetBranchId decimal(20,0) not null primary key,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	layoutSetBranchId decimal(20,0),
	layoutSetId decimal(20,0)
)
go

create table Region (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	defaultLanguageId varchar(75) null,
	regionId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	countryId decimal(20,0),
	active_ int,
	name varchar(75) null,
	position float,
	regionCode varchar(75) null,
	lastPublishDate bigdatetime null,
	primary key (regionId, ctCollectionId)
)
go

create table RegionLocalization (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	regionLocalizationId decimal(20,0) not null,
	companyId decimal(20,0),
	regionId decimal(20,0),
	languageId varchar(75) null,
	title varchar(75) null,
	primary key (regionLocalizationId, ctCollectionId)
)
go

create table Release_ (
	mvccVersion decimal(20,0) default 0 not null,
	releaseId decimal(20,0) not null primary key,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	servletContextName varchar(75) null,
	schemaVersion varchar(75) null,
	buildNumber int,
	buildDate bigdatetime null,
	verified int,
	state_ int,
	testString varchar(1024) null
)
go

create table RememberMeToken (
	mvccVersion decimal(20,0) default 0 not null,
	rememberMeTokenId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userId decimal(20,0),
	createDate bigdatetime null,
	expirationDate bigdatetime null,
	value varchar(255) null
)
go

create table Repository (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	repositoryId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	name varchar(200) null,
	description varchar(4000) null,
	portletId varchar(200) null,
	typeSettings text null,
	dlFolderId decimal(20,0),
	lastPublishDate bigdatetime null,
	primary key (repositoryId, ctCollectionId)
)
go

create table RepositoryEntry (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	repositoryEntryId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	repositoryId decimal(20,0),
	mappedId varchar(255) null,
	manualCheckInRequired int,
	lastPublishDate bigdatetime null,
	primary key (repositoryEntryId, ctCollectionId)
)
go

create table ResourceAction (
	mvccVersion decimal(20,0) default 0 not null,
	resourceActionId decimal(20,0) not null primary key,
	name varchar(255) null,
	actionId varchar(75) null,
	bitwiseValue decimal(20,0)
)
go

create table ResourcePermission (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	resourcePermissionId decimal(20,0) not null,
	companyId decimal(20,0),
	name varchar(255) null,
	scope int,
	primKey varchar(255) null,
	primKeyId decimal(20,0),
	roleId decimal(20,0),
	ownerId decimal(20,0),
	actionIds decimal(20,0),
	viewActionId int,
	primary key (resourcePermissionId, ctCollectionId)
)
go

create table Role_ (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	roleId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	name varchar(75) null,
	title varchar(4000) null,
	description text null,
	type_ int,
	subtype varchar(75) null,
	primary key (roleId, ctCollectionId)
)
go

create table ServiceComponent (
	mvccVersion decimal(20,0) default 0 not null,
	serviceComponentId decimal(20,0) not null primary key,
	buildNamespace varchar(75) null,
	buildNumber decimal(20,0),
	buildDate decimal(20,0),
	data_ text null
)
go

create table SocialActivity (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	activityId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	createDate decimal(20,0),
	activitySetId decimal(20,0),
	mirrorActivityId decimal(20,0),
	classNameId decimal(20,0),
	classPK decimal(20,0),
	parentClassNameId decimal(20,0),
	parentClassPK decimal(20,0),
	type_ int,
	extraData varchar(4000) null,
	receiverUserId decimal(20,0),
	primary key (activityId, ctCollectionId)
)
go

create table SocialActivityAchievement (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	activityAchievementId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	createDate decimal(20,0),
	name varchar(75) null,
	firstInGroup int,
	primary key (activityAchievementId, ctCollectionId)
)
go

create table SocialActivityCounter (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	activityCounterId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	classNameId decimal(20,0),
	classPK decimal(20,0),
	name varchar(75) null,
	ownerType int,
	currentValue int,
	totalValue int,
	graceValue int,
	startPeriod int,
	endPeriod int,
	active_ int,
	primary key (activityCounterId, ctCollectionId)
)
go

create table SocialActivityLimit (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	activityLimitId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	classNameId decimal(20,0),
	classPK decimal(20,0),
	activityType int,
	activityCounterName varchar(75) null,
	value varchar(75) null,
	primary key (activityLimitId, ctCollectionId)
)
go

create table SocialActivitySet (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	activitySetId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	createDate decimal(20,0),
	modifiedDate decimal(20,0),
	classNameId decimal(20,0),
	classPK decimal(20,0),
	type_ int,
	extraData varchar(4000) null,
	activityCount int,
	primary key (activitySetId, ctCollectionId)
)
go

create table SocialActivitySetting (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	activitySettingId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	classNameId decimal(20,0),
	activityType int,
	name varchar(75) null,
	value varchar(1024) null,
	primary key (activitySettingId, ctCollectionId)
)
go

create table SocialRelation (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	relationId decimal(20,0) not null,
	companyId decimal(20,0),
	createDate decimal(20,0),
	userId1 decimal(20,0),
	userId2 decimal(20,0),
	type_ int,
	primary key (relationId, ctCollectionId)
)
go

create table SocialRequest (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	requestId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	createDate decimal(20,0),
	modifiedDate decimal(20,0),
	classNameId decimal(20,0),
	classPK decimal(20,0),
	type_ int,
	extraData varchar(4000) null,
	receiverUserId decimal(20,0),
	status int,
	primary key (requestId, ctCollectionId)
)
go

create table SystemEvent (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	systemEventId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	classUuid varchar(75) null,
	referrerClassNameId decimal(20,0),
	parentSystemEventId decimal(20,0),
	systemEventSetKey decimal(20,0),
	type_ int,
	extraData text null,
	primary key (systemEventId, ctCollectionId)
)
go

create table Team (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	teamId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	groupId decimal(20,0),
	name varchar(75) null,
	description varchar(4000) null,
	lastPublishDate bigdatetime null,
	primary key (teamId, ctCollectionId)
)
go

create table Ticket (
	mvccVersion decimal(20,0) default 0 not null,
	ticketId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	createDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	key_ varchar(255) null,
	type_ int,
	extraInfo text null,
	expirationDate bigdatetime null
)
go

create table UserNotificationDelivery (
	mvccVersion decimal(20,0) default 0 not null,
	userNotificationDeliveryId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userId decimal(20,0),
	portletId varchar(200) null,
	classNameId decimal(20,0),
	notificationType int,
	deliveryType int,
	deliver int
)
go

create table User_ (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	userId decimal(20,0) not null,
	companyId decimal(20,0),
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	contactId decimal(20,0),
	password_ varchar(255) null,
	passwordEncrypted int,
	passwordReset int,
	passwordModifiedDate bigdatetime null,
	digest varchar(255) null,
	reminderQueryQuestion varchar(75) null,
	reminderQueryAnswer varchar(75) null,
	graceLoginCount int,
	screenName varchar(75) null,
	emailAddress varchar(254) null,
	facebookId decimal(20,0),
	googleUserId varchar(75) null,
	ldapServerId decimal(20,0),
	openId varchar(1024) null,
	portraitId decimal(20,0),
	languageId varchar(75) null,
	timeZoneId varchar(75) null,
	greeting varchar(255) null,
	comments varchar(4000) null,
	firstName varchar(75) null,
	middleName varchar(75) null,
	lastName varchar(75) null,
	jobTitle varchar(100) null,
	loginDate bigdatetime null,
	loginIP varchar(75) null,
	lastLoginDate bigdatetime null,
	lastLoginIP varchar(75) null,
	lastFailedLoginDate bigdatetime null,
	failedLoginAttempts int,
	lockout int,
	lockoutDate bigdatetime null,
	agreedToTermsOfUse int,
	emailAddressVerified int,
	type_ int,
	status int,
	primary key (userId, ctCollectionId)
)
go

create table UserGroup (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	userGroupId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	parentUserGroupId decimal(20,0),
	name varchar(255) null,
	description varchar(4000) null,
	addedByLDAPImport int,
	primary key (userGroupId, ctCollectionId)
)
go

create table UserGroupGroupRole (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	userGroupGroupRoleId decimal(20,0) not null,
	companyId decimal(20,0),
	userGroupId decimal(20,0),
	groupId decimal(20,0),
	roleId decimal(20,0),
	primary key (userGroupGroupRoleId, ctCollectionId)
)
go

create table UserGroupRole (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	userGroupRoleId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	groupId decimal(20,0),
	roleId decimal(20,0),
	primary key (userGroupRoleId, ctCollectionId)
)
go

create table UserGroups_Teams (
	companyId decimal(20,0) not null,
	teamId decimal(20,0) not null,
	userGroupId decimal(20,0) not null,
	ctCollectionId decimal(20,0) default 0 not null,
	ctChangeType int,
	primary key (teamId, userGroupId, ctCollectionId)
)
go

create table UserIdMapper (
	mvccVersion decimal(20,0) default 0 not null,
	userIdMapperId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userId decimal(20,0),
	type_ varchar(75) null,
	description varchar(75) null,
	externalUserId varchar(75) null
)
go

create table UserNotificationEvent (
	mvccVersion decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	userNotificationEventId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userId decimal(20,0),
	type_ varchar(200) null,
	timestamp decimal(20,0),
	deliveryType int,
	deliverBy decimal(20,0),
	delivered int,
	payload text null,
	actionRequired int,
	archived int
)
go

create table Users_Groups (
	companyId decimal(20,0) not null,
	groupId decimal(20,0) not null,
	userId decimal(20,0) not null,
	ctCollectionId decimal(20,0) default 0 not null,
	ctChangeType int,
	primary key (groupId, userId, ctCollectionId)
)
go

create table Users_Orgs (
	companyId decimal(20,0) not null,
	organizationId decimal(20,0) not null,
	userId decimal(20,0) not null,
	ctCollectionId decimal(20,0) default 0 not null,
	ctChangeType int,
	primary key (organizationId, userId, ctCollectionId)
)
go

create table Users_Roles (
	companyId decimal(20,0) not null,
	roleId decimal(20,0) not null,
	userId decimal(20,0) not null,
	ctCollectionId decimal(20,0) default 0 not null,
	ctChangeType int,
	primary key (roleId, userId, ctCollectionId)
)
go

create table Users_Teams (
	companyId decimal(20,0) not null,
	teamId decimal(20,0) not null,
	userId decimal(20,0) not null,
	ctCollectionId decimal(20,0) default 0 not null,
	ctChangeType int,
	primary key (teamId, userId, ctCollectionId)
)
go

create table Users_UserGroups (
	companyId decimal(20,0) not null,
	userId decimal(20,0) not null,
	userGroupId decimal(20,0) not null,
	ctCollectionId decimal(20,0) default 0 not null,
	ctChangeType int,
	primary key (userId, userGroupId, ctCollectionId)
)
go

create table UserTracker (
	mvccVersion decimal(20,0) default 0 not null,
	userTrackerId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userId decimal(20,0),
	modifiedDate bigdatetime null,
	sessionId varchar(200) null,
	remoteAddr varchar(75) null,
	remoteHost varchar(75) null,
	userAgent varchar(200) null
)
go

create table UserTrackerPath (
	mvccVersion decimal(20,0) default 0 not null,
	userTrackerPathId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userTrackerId decimal(20,0),
	path_ varchar(4000) null,
	pathDate bigdatetime null
)
go

create table VirtualHost (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	virtualHostId decimal(20,0) not null,
	companyId decimal(20,0),
	layoutSetId decimal(20,0),
	hostname varchar(200) null,
	defaultVirtualHost int,
	languageId varchar(75) null,
	primary key (virtualHostId, ctCollectionId)
)
go

create table WebDAVProps (
	mvccVersion decimal(20,0) default 0 not null,
	webDavPropsId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	props text null
)
go

create table Website (
	mvccVersion decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	websiteId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	url varchar(4000) null,
	listTypeId decimal(20,0),
	primary_ int,
	lastPublishDate bigdatetime null
)
go

create table WorkflowDefinitionLink (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	workflowDefinitionLinkId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	typePK decimal(20,0),
	workflowDefinitionName varchar(75) null,
	workflowDefinitionVersion int,
	primary key (workflowDefinitionLinkId, ctCollectionId)
)
go

create table WorkflowInstanceLink (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	workflowInstanceLinkId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	workflowInstanceId decimal(20,0),
	primary key (workflowInstanceLinkId, ctCollectionId)
)
go


insert into Counter (name, currentId) values ('com.liferay.counter.kernel.model.Counter', 20000)
go



go


create index IX_FEAFC68A on Address (companyId, classNameId, classPK, listTypeId)
go
create unique index IX_C0F7C08D on Address (companyId, externalReferenceCode, ctCollectionId)
go
create index IX_5A2093E7 on Address (countryId)
go
create index IX_C8E3E87D on Address (regionId)
go
create index IX_5BC8B0D4 on Address (userId)
go
create index IX_381E55DA on Address (uuid_)
go

create index IX_37B0A8A2 on AnnouncementsDelivery (companyId)
go
create unique index IX_7EA033 on AnnouncementsDelivery (userId, type_, ctCollectionId)
go

create index IX_3F376E7C on AnnouncementsEntry (companyId)
go
create index IX_D49C2E66 on AnnouncementsEntry (userId)
go
create index IX_1AFBDE08 on AnnouncementsEntry (uuid_)
go

create index IX_EF1F022A on AnnouncementsFlag (companyId)
go
create index IX_ED8CE4E8 on AnnouncementsFlag (entryId, userId, value)
go

create unique index IX_F3842169 on AssetCategory (groupId, ctCollectionId, externalReferenceCode)
go
create index IX_F67BECAD on AssetCategory (groupId, parentCategoryId)
go
create unique index IX_AF94405C on AssetCategory (groupId, uuid_, ctCollectionId)
go
create index IX_2710C64A on AssetCategory (groupId, vocabularyId, name)
go
create index IX_68169942 on AssetCategory (groupId, vocabularyId, parentCategoryId)
go
create index IX_9DDD15EA on AssetCategory (parentCategoryId, name)
go
create index IX_4D37BB00 on AssetCategory (uuid_)
go
create index IX_3537E488 on AssetCategory (vocabularyId, name)
go
create unique index IX_8C99329D on AssetCategory (vocabularyId, parentCategoryId, name, ctCollectionId)
go

create index IX_112337B8 on AssetEntries_AssetTags (companyId)
go
create index IX_B2A61B55 on AssetEntries_AssetTags (tagId)
go

create unique index IX_7BF8337B on AssetEntry (classNameId, classPK, ctCollectionId)
go
create index IX_7306C60 on AssetEntry (companyId)
go
create index IX_75D42FF9 on AssetEntry (expirationDate)
go
create index IX_6418BB52 on AssetEntry (groupId, classNameId, publishDate, expirationDate)
go
create index IX_1EBA6821 on AssetEntry (groupId, classUuid)
go
create index IX_FEC4A201 on AssetEntry (layoutUuid)
go
create index IX_2E4E3885 on AssetEntry (publishDate)
go

create index IX_D63322F9 on AssetTag (groupId, name)
go
create index IX_C43137AF on AssetTag (name)
go
create unique index IX_A43FBC4 on AssetTag (uuid_, groupId, ctCollectionId)
go

create index IX_B22D908C on AssetVocabulary (companyId)
go
create unique index IX_E06DEF51 on AssetVocabulary (groupId, ctCollectionId, externalReferenceCode)
go
create unique index IX_32F2132B on AssetVocabulary (groupId, ctCollectionId, name)
go
create index IX_C0AAD74D on AssetVocabulary (groupId, name)
go
create unique index IX_3966DE44 on AssetVocabulary (groupId, uuid_, ctCollectionId)
go
create index IX_2F7F11EE on AssetVocabulary (groupId, visibilityType)
go
create index IX_55F58818 on AssetVocabulary (uuid_)
go

create unique index IX_E7B95510 on BrowserTracker (userId)
go

create unique index IX_B27A301F on ClassName_ (value)
go

create index IX_38EFE3FD on Company (logoId)
go
create index IX_12566EC2 on Company (mx)
go
create unique index IX_EC00543C on Company (webId)
go

create unique index IX_85C63FD7 on CompanyInfo (companyId)
go

create index IX_791914FA on Contact_ (classNameId, classPK)
go
create index IX_FD2E9BDD on Contact_ (companyId, userId)
go
create index IX_42F94F9F on Contact_ (userId)
go

create unique index IX_7DA11A6F on Country (companyId, ctCollectionId, a2)
go
create unique index IX_7DA11E30 on Country (companyId, ctCollectionId, a3)
go
create unique index IX_B2A91789 on Country (companyId, ctCollectionId, name)
go
create unique index IX_74AB3DC on Country (companyId, ctCollectionId, number_)
go
create index IX_B59A9078 on Country (uuid_)
go

create unique index IX_E22A5911 on CountryLocalization (countryId, languageId, ctCollectionId)
go

create index IX_4CB1B2B4 on DLFileEntry (companyId)
go
create index IX_B8526DBE on DLFileEntry (custom1ImageId)
go
create index IX_AC9BDEDD on DLFileEntry (custom2ImageId)
go
create index IX_772ECDE7 on DLFileEntry (fileEntryTypeId)
go
create index IX_8F6C75D0 on DLFileEntry (folderId, name)
go
create index IX_57FFBBCA on DLFileEntry (folderId, repositoryId)
go
create unique index IX_761F8629 on DLFileEntry (groupId, ctCollectionId, externalReferenceCode)
go
create unique index IX_672F1AA0 on DLFileEntry (groupId, ctCollectionId, uuid_)
go
create unique index IX_1920CC0C on DLFileEntry (groupId, folderId, ctCollectionId, fileName)
go
create unique index IX_7BDA28F0 on DLFileEntry (groupId, folderId, ctCollectionId, name)
go
create unique index IX_4ADDCFF7 on DLFileEntry (groupId, folderId, ctCollectionId, title)
go
create index IX_29D0AF28 on DLFileEntry (groupId, folderId, fileEntryTypeId)
go
create index IX_1DC796CD on DLFileEntry (groupId, folderId, userId)
go
create index IX_43261870 on DLFileEntry (groupId, userId)
go
create index IX_4DB7A143 on DLFileEntry (largeImageId)
go
create index IX_D9492CF6 on DLFileEntry (mimeType)
go
create index IX_9EE96CAD on DLFileEntry (repositoryId)
go
create index IX_25F5CAB9 on DLFileEntry (smallImageId, largeImageId, custom1ImageId, custom2ImageId)
go
create index IX_64F0FE40 on DLFileEntry (uuid_)
go

create index IX_4F40FE5E on DLFileEntryMetadata (fileEntryId)
go
create unique index IX_5DC2B977 on DLFileEntryMetadata (fileVersionId, DDMStructureId, ctCollectionId)
go
create index IX_D49AB5D1 on DLFileEntryMetadata (uuid_)
go

create unique index IX_93ED0F06 on DLFileEntryType (groupId, ctCollectionId, dataDefinitionId)
go
create unique index IX_A5C4723D on DLFileEntryType (groupId, ctCollectionId, fileEntryTypeKey)
go
create unique index IX_C1518AF6 on DLFileEntryType (groupId, uuid_, ctCollectionId)
go
create index IX_90724726 on DLFileEntryType (uuid_)
go

create index IX_2E64D9F9 on DLFileEntryTypes_DLFolders (companyId)
go
create index IX_6E00A2EC on DLFileEntryTypes_DLFolders (folderId)
go

create index IX_8571953E on DLFileShortcut (companyId, status)
go
create unique index IX_86FE17F8 on DLFileShortcut (groupId, uuid_, ctCollectionId)
go
create index IX_4B7247F6 on DLFileShortcut (toFileEntryId)
go
create index IX_4831EBE4 on DLFileShortcut (uuid_)
go

create index IX_CF394FE on DLFileVersion (companyId, storeUUID)
go
create unique index IX_10E504DF on DLFileVersion (fileEntryId, version, ctCollectionId)
go
create index IX_BC5541ED on DLFileVersion (groupId, folderId, version, title)
go
create index IX_FFB3395C on DLFileVersion (mimeType)
go
create index IX_5898E799 on DLFileVersion (status, companyId, expirationDate)
go
create index IX_92309600 on DLFileVersion (status, displayDate)
go
create index IX_D50EAA41 on DLFileVersion (status, fileEntryId)
go
create index IX_799D5D47 on DLFileVersion (status, groupId, folderId)
go
create unique index IX_350F5CAE on DLFileVersion (uuid_, groupId, ctCollectionId)
go

create index IX_A74DB14C on DLFolder (companyId)
go
create unique index IX_F0D74691 on DLFolder (groupId, ctCollectionId, externalReferenceCode)
go
create unique index IX_4C35E652 on DLFolder (groupId, parentFolderId, ctCollectionId, name)
go
create unique index IX_53E6B584 on DLFolder (groupId, uuid_, ctCollectionId)
go
create index IX_51556082 on DLFolder (parentFolderId, name)
go
create index IX_56F3D47C on DLFolder (parentFolderId, repositoryId)
go
create index IX_EE29C715 on DLFolder (repositoryId)
go
create index IX_B199E2A6 on DLFolder (status, companyId)
go
create index IX_CBC408D8 on DLFolder (uuid_)
go

create index IX_7B43CD8 on EmailAddress (userId)
go
create index IX_D24F3956 on EmailAddress (uuid_)
go

create unique index IX_4A7D3605 on ExpandoColumn (tableId, name, ctCollectionId)
go

create index IX_49EB3118 on ExpandoRow (classPK)
go
create unique index IX_488E0C53 on ExpandoRow (tableId, classPK, ctCollectionId)
go

create unique index IX_87D370E2 on ExpandoTable (companyId, classNameId, name, ctCollectionId)
go

create index IX_CAD04B0D on ExpandoValue (classPK, classNameId)
go
create unique index IX_E6D98E43 on ExpandoValue (columnId, rowId_, ctCollectionId)
go
create index IX_9112A7A0 on ExpandoValue (rowId_)
go
create index IX_1BD3F4C on ExpandoValue (tableId, classPK)
go
create unique index IX_D8C72C45 on ExpandoValue (tableId, columnId, classPK, ctCollectionId)
go
create index IX_B71E92D5 on ExpandoValue (tableId, rowId_)
go

create index IX_1827A2E5 on ExportImportConfiguration (companyId)
go
create index IX_38FA468D on ExportImportConfiguration (groupId, status)
go
create index IX_47CC6234 on ExportImportConfiguration (groupId, type_, status)
go

create index IX_8257E37B on Group_ (classNameId, classPK)
go
create unique index IX_DBA56EF9 on Group_ (companyId, classNameId, ctCollectionId, classPK)
go
create index IX_ABE2D54 on Group_ (companyId, classNameId, parentGroupId)
go
create unique index IX_23B1C81D on Group_ (companyId, ctCollectionId, externalReferenceCode)
go
create unique index IX_3551EED4 on Group_ (companyId, ctCollectionId, friendlyURL)
go
create unique index IX_42E6E774 on Group_ (companyId, ctCollectionId, groupKey)
go
create index IX_5D75499E on Group_ (companyId, parentGroupId)
go
create index IX_16218A38 on Group_ (liveGroupId)
go
create index IX_F981514E on Group_ (uuid_)
go

create index IX_8BFD4548 on Groups_Orgs (companyId)
go
create index IX_6BBB7682 on Groups_Orgs (organizationId)
go

create index IX_557D8550 on Groups_Roles (companyId)
go
create index IX_3103EF3D on Groups_Roles (roleId)
go

create index IX_676FC818 on Groups_UserGroups (companyId)
go
create index IX_3B69160F on Groups_UserGroups (userGroupId)
go

create index IX_6A925A4D on Image (size_)
go

create index IX_B8E1E6E5 on Layout (classNameId, classPK)
go
create index IX_881EABCB on Layout (companyId, layoutPrototypeUuid)
go
create unique index IX_E81EADC5 on Layout (groupId, ctCollectionId, externalReferenceCode)
go
create index IX_993CBA31 on Layout (groupId, masterLayoutPlid)
go
create index IX_6EDC627B on Layout (groupId, type_)
go
create index IX_23922F7D on Layout (iconImageId)
go
create index IX_B529BFD3 on Layout (layoutPrototypeUuid)
go
create index IX_1D4DCAA5 on Layout (parentPlid)
go
create index IX_39A18ECC on Layout (sourcePrototypeLayoutUuid)
go
create index IX_D0822724 on Layout (uuid_)
go

create unique index IX_FD57097D on LayoutBranch (layoutSetBranchId, plid, name)
go
create index IX_72FC531D on LayoutBranch (plid)
go

create index IX_EAB317C8 on LayoutFriendlyURL (companyId)
go
create index IX_C23A9814 on LayoutFriendlyURL (friendlyURL, companyId)
go
create index IX_D3B2D6DF on LayoutFriendlyURL (friendlyURL, plid)
go
create unique index IX_2C37488 on LayoutFriendlyURL (groupId, uuid_, ctCollectionId)
go
create unique index IX_A4D8B1D0 on LayoutFriendlyURL (plid, ctCollectionId, languageId)
go
create index IX_9F80D54 on LayoutFriendlyURL (uuid_)
go

create index IX_CEF72136 on LayoutPrototype (uuid_)
go

create index IX_84668240 on LayoutRevision (layoutSetBranchId, plid, layoutBranchId)
go
create index IX_F93E5CC3 on LayoutRevision (layoutSetBranchId, plid, parentLayoutRevisionId)
go
create index IX_70DA9ECB on LayoutRevision (layoutSetBranchId, plid, status)
go
create index IX_7FFAE700 on LayoutRevision (layoutSetBranchId, status)
go
create index IX_8EC3D2BC on LayoutRevision (plid, status)
go
create index IX_421223B1 on LayoutRevision (status)
go

create index IX_C629311 on LayoutSet (layoutSetPrototypeUuid, companyId)
go


create index IX_C5D69B24 on LayoutSetPrototype (uuid_)
go

create unique index IX_BF6DBF8A on ListType (companyId, type_, name)
go
create index IX_56E29D16 on ListType (uuid_)
go

create index IX_C28C72EC on MembershipRequest (groupId, statusId)
go
create index IX_35AA8FA6 on MembershipRequest (groupId, userId, statusId)
go
create index IX_66D70879 on MembershipRequest (userId)
go

create index IX_6AF0D434 on OrgLabor (organizationId)
go

create unique index IX_87E47DA9 on Organization_ (companyId, ctCollectionId, externalReferenceCode)
go
create unique index IX_F1E40A53 on Organization_ (companyId, name, ctCollectionId)
go
create index IX_4BCBAB21 on Organization_ (companyId, name, parentOrganizationId)
go
create index IX_418E4522 on Organization_ (companyId, parentOrganizationId)
go
create index IX_396D6B42 on Organization_ (uuid_)
go

create unique index IX_3FBFA9F4 on PasswordPolicy (companyId, name)
go
create index IX_51437A01 on PasswordPolicy (uuid_)
go

create unique index IX_C3A17327 on PasswordPolicyRel (classNameId, classPK)
go
create index IX_CD25266E on PasswordPolicyRel (passwordPolicyId)
go

create index IX_326F75BD on PasswordTracker (userId)
go

create index IX_F202B9CE on Phone (userId)
go
create index IX_EA6245A0 on Phone (uuid_)
go

create unique index IX_7171B2E8 on PluginSetting (companyId, pluginId, pluginType)
go

create unique index IX_D5E35599 on PortalPreferenceValue (portalPreferencesId, namespace, key_, index_)
go
create index IX_737DBC36 on PortalPreferenceValue (portalPreferencesId, namespace, key_, smallValue)
go

create index IX_D1846D13 on PortalPreferences (ownerType, ownerId)
go

create unique index IX_12B5E51D on Portlet (companyId, portletId)
go

create index IX_C6246ECD on PortletItem (groupId, classNameId, portletId, name)
go

create index IX_EE8C5489 on PortletPreferenceValue (name, smallValue, companyId)
go
create unique index IX_B517784D on PortletPreferenceValue (portletPreferencesId, name, index_, ctCollectionId)
go
create index IX_8E75AB8C on PortletPreferenceValue (portletPreferencesId, name, smallValue)
go

create index IX_3EAB5A5A on PortletPreferences (ownerId)
go
create index IX_6DD4B410 on PortletPreferences (ownerType, ownerId, plid)
go
create index IX_F15C1C4F on PortletPreferences (plid)
go
create index IX_CEA05B46 on PortletPreferences (portletId, ownerType, ownerId, companyId)
go
create unique index IX_8CCEB8CB on PortletPreferences (portletId, ownerType, ownerId, plid, ctCollectionId)
go
create index IX_EF5FCC07 on PortletPreferences (portletId, ownerType, plid)
go
create index IX_8DCFD52C on PortletPreferences (portletId, plid)
go

create index IX_A1A8CB8B on RatingsEntry (classNameId, classPK, score)
go
create unique index IX_119FF2EF on RatingsEntry (classNameId, classPK, userId, ctCollectionId)
go
create index IX_C34DEAF2 on RatingsEntry (uuid_)
go

create unique index IX_C286E0E2 on RatingsStats (classNameId, classPK, ctCollectionId)
go

create index IX_B91F79BD on RecentLayoutBranch (groupId)
go
create index IX_351E86E8 on RecentLayoutBranch (layoutBranchId)
go
create unique index IX_C27D6369 on RecentLayoutBranch (userId, layoutSetBranchId, plid)
go

create index IX_8D8A2724 on RecentLayoutRevision (groupId)
go
create index IX_DA0788DA on RecentLayoutRevision (layoutRevisionId)
go
create unique index IX_4C600BD0 on RecentLayoutRevision (userId, layoutSetBranchId, plid)
go

create index IX_711995A5 on RecentLayoutSetBranch (groupId)
go
create index IX_23FF0700 on RecentLayoutSetBranch (layoutSetBranchId)
go
create unique index IX_4654D204 on RecentLayoutSetBranch (userId, layoutSetId)
go

create unique index IX_183BFDBA on Region (countryId, regionCode, ctCollectionId)
go
create index IX_48A89E9A on Region (uuid_)
go

create unique index IX_982329B on RegionLocalization (regionId, languageId, ctCollectionId)
go

create unique index IX_8BD6BCA7 on Release_ (servletContextName)
go

create index IX_D4C6FBCB on RememberMeToken (expirationDate)
go
create index IX_291F58D4 on RememberMeToken (userId)
go

create unique index IX_470608AE on Repository (groupId, ctCollectionId, name, portletId)
go
create unique index IX_4009E884 on Repository (uuid_, groupId, ctCollectionId)
go

create unique index IX_B43A3F67 on RepositoryEntry (repositoryId, ctCollectionId, mappedId)
go
create unique index IX_239165C6 on RepositoryEntry (uuid_, ctCollectionId, groupId)
go

create unique index IX_EDB9986E on ResourceAction (name, actionId)
go

create index IX_26284944 on ResourcePermission (companyId, primKey)
go
create unique index IX_F2237D8E on ResourcePermission (companyId, scope, name, primKey, roleId, ctCollectionId)
go
create index IX_F6BAE86A on ResourcePermission (companyId, scope, primKey)
go
create index IX_D5F1E2A2 on ResourcePermission (name)
go
create index IX_A37A0588 on ResourcePermission (roleId)
go
create index IX_F4555981 on ResourcePermission (scope)
go

create unique index IX_CC85CC2C on Role_ (companyId, ctCollectionId, classNameId, classPK)
go
create unique index IX_D11C3796 on Role_ (companyId, ctCollectionId, name)
go
create index IX_F436EC8E on Role_ (name)
go
create index IX_5EB4E2FB on Role_ (subtype)
go
create index IX_CBE204 on Role_ (type_, subtype)
go
create index IX_26DB26C5 on Role_ (uuid_)
go

create unique index IX_4F0315B8 on ServiceComponent (buildNamespace, buildNumber)
go

create index IX_F542E9BC on SocialActivity (activitySetId)
go
create unique index IX_7E6A9AAD on SocialActivity (classNameId, classPK, groupId, userId, type_, receiverUserId, ctCollectionId, createDate)
go
create index IX_85370BF4 on SocialActivity (classNameId, classPK, mirrorActivityId)
go
create index IX_D0E9029E on SocialActivity (classNameId, classPK, type_)
go
create index IX_64B1BC66 on SocialActivity (companyId)
go
create index IX_2A2468 on SocialActivity (groupId)
go
create index IX_1271F25F on SocialActivity (mirrorActivityId)
go
create index IX_121CA3CB on SocialActivity (receiverUserId)
go
create index IX_3504B8BC on SocialActivity (userId)
go

create index IX_8F6408F0 on SocialActivityAchievement (groupId, name)
go
create unique index IX_5ED94F08 on SocialActivityAchievement (groupId, userId, name, ctCollectionId)
go

create index IX_A4B9A23B on SocialActivityCounter (classNameId, classPK)
go
create unique index IX_56195A6B on SocialActivityCounter (groupId, classNameId, classPK, ownerType, name, ctCollectionId, endPeriod)
go
create unique index IX_379AA3B2 on SocialActivityCounter (groupId, classNameId, classPK, ownerType, name, ctCollectionId, startPeriod)
go

create index IX_B15863FA on SocialActivityLimit (classNameId, classPK)
go
create unique index IX_4A636E75 on SocialActivityLimit (groupId, userId, classNameId, classPK, activityType, activityCounterName, ctCollectionId)
go
create index IX_6F9EDE9F on SocialActivityLimit (userId)
go

create index IX_9E13F2DE on SocialActivitySet (groupId)
go
create index IX_5D1FA9E on SocialActivitySet (type_, classNameId, classPK)
go
create index IX_241D10A4 on SocialActivitySet (userId, type_, classNameId, classPK)
go
create index IX_6D0C8733 on SocialActivitySet (userId, type_, groupId, classNameId)
go

create index IX_384788CD on SocialActivitySetting (groupId, activityType)
go
create index IX_D984AABA on SocialActivitySetting (groupId, classNameId, activityType, name)
go

create index IX_61171E99 on SocialRelation (companyId)
go
create index IX_5E1F07A2 on SocialRelation (type_, companyId)
go
create unique index IX_ECA579C5 on SocialRelation (type_, userId1, userId2, ctCollectionId)
go
create index IX_C91168D6 on SocialRelation (type_, userId2)
go
create index IX_B5C9C690 on SocialRelation (userId1, userId2)
go
create index IX_5A40D18D on SocialRelation (userId2)
go
create index IX_F0CA24A5 on SocialRelation (uuid_)
go

create index IX_E8468A49 on SocialRequest (classNameId, classPK, receiverUserId, status, type_)
go
create index IX_A90FE5A0 on SocialRequest (companyId)
go
create index IX_D9380CB7 on SocialRequest (receiverUserId, status)
go
create unique index IX_2FE40453 on SocialRequest (userId, classNameId, classPK, receiverUserId, type_, ctCollectionId)
go
create index IX_7CFF5CB8 on SocialRequest (userId, classNameId, classPK, status, type_)
go
create index IX_AB5906A8 on SocialRequest (userId, status)
go
create unique index IX_87DD8A60 on SocialRequest (uuid_, ctCollectionId, groupId)
go

create index IX_FFCBB747 on SystemEvent (groupId, classNameId, classPK, type_)
go
create index IX_A19C89FF on SystemEvent (groupId, systemEventSetKey)
go

create index IX_93AB8545 on Team (companyId)
go
create unique index IX_58777164 on Team (groupId, ctCollectionId, name)
go
create unique index IX_1AAF62D7 on Team (uuid_, groupId, ctCollectionId)
go

create index IX_DAD135B4 on Ticket (classNameId, classPK, companyId, type_)
go
create index IX_1E8DFB2E on Ticket (classNameId, classPK, type_)
go
create index IX_B2468446 on Ticket (key_)
go

create unique index IX_A33BD191 on UserGroup (companyId, ctCollectionId, externalReferenceCode)
go
create unique index IX_3F4FC96B on UserGroup (companyId, name, ctCollectionId)
go
create index IX_69771487 on UserGroup (companyId, parentUserGroupId)
go
create index IX_5F1DD85A on UserGroup (uuid_)
go

create index IX_CAB0CCC8 on UserGroupGroupRole (groupId, roleId)
go
create unique index IX_618D3E5F on UserGroupGroupRole (groupId, userGroupId, roleId, ctCollectionId)
go
create index IX_1CDF88C on UserGroupGroupRole (roleId)
go
create index IX_DCDED558 on UserGroupGroupRole (userGroupId)
go

create index IX_871412DF on UserGroupRole (groupId, roleId)
go
create unique index IX_5427FB77 on UserGroupRole (groupId, userId, roleId, ctCollectionId)
go
create index IX_887A2C95 on UserGroupRole (roleId)
go
create index IX_887BE56A on UserGroupRole (userId)
go

create index IX_2AC5356C on UserGroups_Teams (companyId)
go
create index IX_7F187E63 on UserGroups_Teams (userGroupId)
go

create unique index IX_41A32E0D on UserIdMapper (type_, externalUserId)
go
create unique index IX_D1C44A6E on UserIdMapper (userId, type_)
go

create unique index IX_8B6E3ACE on UserNotificationDelivery (userId, portletId, classNameId, notificationType, deliveryType)
go

create index IX_BF29100B on UserNotificationEvent (type_)
go
create index IX_ECD8CFEA on UserNotificationEvent (uuid_)
go

create index IX_29BA1CF5 on UserTracker (companyId)
go
create index IX_46B0AE8E on UserTracker (sessionId)
go
create index IX_E4EFBA8D on UserTracker (userId)
go

create index IX_14D8BCC0 on UserTrackerPath (userTrackerId)
go

create index IX_BCFDA257 on User_ (companyId, createDate, modifiedDate)
go
create unique index IX_77D89D58 on User_ (companyId, ctCollectionId, emailAddress)
go
create unique index IX_6FF64E11 on User_ (companyId, ctCollectionId, externalReferenceCode)
go
create unique index IX_6B7C3D77 on User_ (companyId, ctCollectionId, screenName)
go
create index IX_1D731F03 on User_ (companyId, facebookId)
go
create index IX_B6E3AE1 on User_ (companyId, googleUserId)
go
create index IX_EE8ABD19 on User_ (companyId, modifiedDate)
go
create index IX_89509087 on User_ (companyId, openId)
go
create index IX_F6039434 on User_ (companyId, status)
go
create index IX_FD06BAAD on User_ (companyId, type_, status)
go
create unique index IX_E902F853 on User_ (ctCollectionId, contactId)
go
create index IX_762F63C6 on User_ (emailAddress)
go
create index IX_A18034A4 on User_ (portraitId)
go
create index IX_E0422BDA on User_ (uuid_)
go

create index IX_3499B657 on Users_Groups (companyId)
go
create index IX_F10B6C6B on Users_Groups (userId)
go

create index IX_5FBB883C on Users_Orgs (companyId)
go
create index IX_FB646CA6 on Users_Orgs (userId)
go

create index IX_F987A0DC on Users_Roles (companyId)
go
create index IX_C1A01806 on Users_Roles (userId)
go

create index IX_799F8283 on Users_Teams (companyId)
go
create index IX_A098EFBF on Users_Teams (userId)
go

create index IX_BB65040C on Users_UserGroups (companyId)
go
create index IX_66FF2503 on Users_UserGroups (userGroupId)
go

create unique index IX_76A64FBE on VirtualHost (hostname, ctCollectionId)
go
create index IX_774643D1 on VirtualHost (layoutSetId, hostname)
go

create unique index IX_97DFA146 on WebDAVProps (classNameId, classPK)
go

create index IX_F75690BB on Website (userId)
go
create index IX_76F15D13 on Website (uuid_)
go

create index IX_EB4D2E32 on WorkflowDefinitionLink (companyId, groupId, classNameId, classPK, typePK)
go
create index IX_4AE45F6F on WorkflowDefinitionLink (companyId, groupId, classPK)
go
create index IX_A4DB1F0F on WorkflowDefinitionLink (companyId, workflowDefinitionName, workflowDefinitionVersion)
go

create index IX_415A7007 on WorkflowInstanceLink (groupId, companyId, classNameId, classPK)
go



