create table Address (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	addressId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	countryId decimal(20,0),
	listTypeId decimal(20,0),
	regionId decimal(20,0),
	city varchar(75) null,
	description varchar(4000) null,
	latitude float,
	longitude float,
	mailing int,
	name varchar(255) null,
	primary_ int,
	street1 varchar(255) null,
	street2 varchar(255) null,
	street3 varchar(255) null,
	validationDate bigdatetime null,
	validationStatus int,
	zip varchar(75) null,
	primary key (addressId, ctCollectionId)
)
go

create table AnnouncementsDelivery (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	deliveryId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	type_ varchar(75) null,
	email int,
	sms int,
	website int,
	primary key (deliveryId, ctCollectionId)
)
go

create table AnnouncementsEntry (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	entryId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	title varchar(75) null,
	content text null,
	url varchar(4000) null,
	type_ varchar(75) null,
	displayDate bigdatetime null,
	expirationDate bigdatetime null,
	priority int,
	alert int,
	primary key (entryId, ctCollectionId)
)
go

create table AnnouncementsFlag (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	flagId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	createDate bigdatetime null,
	entryId decimal(20,0),
	value int,
	primary key (flagId, ctCollectionId)
)
go

create table AssetCategory (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	categoryId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	parentCategoryId decimal(20,0),
	treePath varchar(4000) null,
	name varchar(255) null,
	title text null,
	description text null,
	vocabularyId decimal(20,0),
	lastPublishDate bigdatetime null,
	primary key (categoryId, ctCollectionId)
)
go

create table AssetEntries_AssetTags (
	companyId decimal(20,0) not null,
	entryId decimal(20,0) not null,
	tagId decimal(20,0) not null,
	ctCollectionId decimal(20,0) default 0 not null,
	ctChangeType int,
	primary key (entryId, tagId, ctCollectionId)
)
go

create table AssetEntry (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	entryId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	classUuid varchar(75) null,
	classTypeId decimal(20,0),
	listable int,
	visible int,
	startDate bigdatetime null,
	endDate bigdatetime null,
	publishDate bigdatetime null,
	expirationDate bigdatetime null,
	mimeType varchar(75) null,
	title text null,
	description text null,
	summary text null,
	url varchar(4000) null,
	layoutUuid varchar(75) null,
	height int,
	width int,
	priority float,
	primary key (entryId, ctCollectionId)
)
go

create table AssetTag (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	tagId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	name varchar(75) null,
	assetCount int,
	lastPublishDate bigdatetime null,
	primary key (tagId, ctCollectionId)
)
go

create table AssetVocabulary (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	vocabularyId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	name varchar(75) null,
	title varchar(4000) null,
	description varchar(4000) null,
	settings_ varchar(4000) null,
	visibilityType int,
	lastPublishDate bigdatetime null,
	primary key (vocabularyId, ctCollectionId)
)
go

create table BrowserTracker (
	mvccVersion decimal(20,0) default 0 not null,
	browserTrackerId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userId decimal(20,0),
	browserKey decimal(20,0)
)
go

create table ClassName_ (
	mvccVersion decimal(20,0) default 0 not null,
	classNameId decimal(20,0) not null primary key,
	value varchar(200) null
)
go

create table Company (
	mvccVersion decimal(20,0) default 0 not null,
	companyId decimal(20,0) not null primary key,
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	webId varchar(75) null,
	mx varchar(200) null,
	homeURL varchar(4000) null,
	logoId decimal(20,0),
	maxUsers int,
	active_ int,
	name varchar(75) null,
	legalName varchar(75) null,
	legalId varchar(75) null,
	legalType varchar(75) null,
	sicCode varchar(75) null,
	tickerSymbol varchar(75) null,
	industry varchar(75) null,
	type_ varchar(75) null,
	size_ varchar(75) null,
	indexNameCurrent varchar(75) null,
	indexNameNext varchar(75) null
)
go

create table CompanyInfo (
	mvccVersion decimal(20,0) default 0 not null,
	companyInfoId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	key_ text null
)
go

create table Contact_ (
	mvccVersion decimal(20,0) default 0 not null,
	contactId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	parentContactId decimal(20,0),
	emailAddress varchar(254) null,
	firstName varchar(75) null,
	middleName varchar(75) null,
	lastName varchar(75) null,
	prefixListTypeId decimal(20,0),
	suffixListTypeId decimal(20,0),
	male int,
	birthday bigdatetime null,
	smsSn varchar(75) null,
	facebookSn varchar(75) null,
	jabberSn varchar(75) null,
	skypeSn varchar(75) null,
	twitterSn varchar(75) null,
	employeeStatusId varchar(75) null,
	employeeNumber varchar(75) null,
	jobTitle varchar(100) null,
	jobClass varchar(75) null,
	hoursOfOperation varchar(75) null
)
go

create table Counter (
	name varchar(150) not null primary key,
	currentId decimal(20,0)
)
go

create table Country (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	defaultLanguageId varchar(75) null,
	countryId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	a2 varchar(75) null,
	a3 varchar(75) null,
	active_ int,
	billingAllowed int,
	groupFilterEnabled int,
	idd_ varchar(75) null,
	name varchar(75) null,
	number_ varchar(75) null,
	position float,
	shippingAllowed int,
	subjectToVAT int,
	zipRequired int,
	lastPublishDate bigdatetime null,
	primary key (countryId, ctCollectionId)
)
go

create table CountryLocalization (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	countryLocalizationId decimal(20,0) not null,
	companyId decimal(20,0),
	countryId decimal(20,0),
	languageId varchar(75) null,
	title varchar(75) null,
	primary key (countryLocalizationId, ctCollectionId)
)
go

create table DLFileEntry (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	fileEntryId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	repositoryId decimal(20,0),
	folderId decimal(20,0),
	treePath varchar(4000) null,
	name varchar(255) null,
	fileName varchar(255) null,
	extension varchar(75) null,
	mimeType varchar(75) null,
	title varchar(255) null,
	description varchar(4000) null,
	extraSettings text null,
	fileEntryTypeId decimal(20,0),
	version varchar(75) null,
	size_ decimal(20,0),
	smallImageId decimal(20,0),
	largeImageId decimal(20,0),
	custom1ImageId decimal(20,0),
	custom2ImageId decimal(20,0),
	manualCheckInRequired int,
	displayDate bigdatetime null,
	expirationDate bigdatetime null,
	reviewDate bigdatetime null,
	lastPublishDate bigdatetime null,
	primary key (fileEntryId, ctCollectionId)
)
go

create table DLFileEntryMetadata (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	fileEntryMetadataId decimal(20,0) not null,
	companyId decimal(20,0),
	DDMStorageId decimal(20,0),
	DDMStructureId decimal(20,0),
	fileEntryId decimal(20,0),
	fileVersionId decimal(20,0),
	primary key (fileEntryMetadataId, ctCollectionId)
)
go

create table DLFileEntryType (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	fileEntryTypeId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	dataDefinitionId decimal(20,0),
	fileEntryTypeKey varchar(75) null,
	name varchar(4000) null,
	description varchar(4000) null,
	scope int,
	lastPublishDate bigdatetime null,
	primary key (fileEntryTypeId, ctCollectionId)
)
go

create table DLFileEntryTypes_DLFolders (
	companyId decimal(20,0) not null,
	fileEntryTypeId decimal(20,0) not null,
	folderId decimal(20,0) not null,
	ctCollectionId decimal(20,0) default 0 not null,
	ctChangeType int,
	primary key (fileEntryTypeId, folderId, ctCollectionId)
)
go

create table DLFileShortcut (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	fileShortcutId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	repositoryId decimal(20,0),
	folderId decimal(20,0),
	toFileEntryId decimal(20,0),
	treePath varchar(4000) null,
	active_ int,
	lastPublishDate bigdatetime null,
	status int,
	statusByUserId decimal(20,0),
	statusByUserName varchar(75) null,
	statusDate bigdatetime null,
	primary key (fileShortcutId, ctCollectionId)
)
go

create table DLFileVersion (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	fileVersionId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	repositoryId decimal(20,0),
	folderId decimal(20,0),
	fileEntryId decimal(20,0),
	treePath varchar(4000) null,
	fileName varchar(255) null,
	extension varchar(75) null,
	mimeType varchar(75) null,
	title varchar(255) null,
	description varchar(4000) null,
	changeLog varchar(75) null,
	extraSettings text null,
	fileEntryTypeId decimal(20,0),
	version varchar(75) null,
	size_ decimal(20,0),
	checksum varchar(75) null,
	storeUUID varchar(255) null,
	displayDate bigdatetime null,
	expirationDate bigdatetime null,
	reviewDate bigdatetime null,
	lastPublishDate bigdatetime null,
	status int,
	statusByUserId decimal(20,0),
	statusByUserName varchar(75) null,
	statusDate bigdatetime null,
	primary key (fileVersionId, ctCollectionId)
)
go

create table DLFolder (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	folderId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	repositoryId decimal(20,0),
	mountPoint int,
	parentFolderId decimal(20,0),
	treePath varchar(4000) null,
	name varchar(255) null,
	description varchar(4000) null,
	lastPostDate bigdatetime null,
	defaultFileEntryTypeId decimal(20,0),
	hidden_ int,
	restrictionType int,
	lastPublishDate bigdatetime null,
	status int,
	statusByUserId decimal(20,0),
	statusByUserName varchar(75) null,
	statusDate bigdatetime null,
	primary key (folderId, ctCollectionId)
)
go

create table EmailAddress (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	emailAddressId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	address varchar(254) null,
	listTypeId decimal(20,0),
	primary_ int,
	primary key (emailAddressId, ctCollectionId)
)
go

create table ExpandoColumn (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	columnId decimal(20,0) not null,
	companyId decimal(20,0),
	modifiedDate bigdatetime null,
	tableId decimal(20,0),
	name varchar(75) null,
	type_ int,
	defaultData text null,
	typeSettings text null,
	primary key (columnId, ctCollectionId)
)
go

create table ExpandoRow (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	rowId_ decimal(20,0) not null,
	companyId decimal(20,0),
	modifiedDate bigdatetime null,
	tableId decimal(20,0),
	classPK decimal(20,0),
	primary key (rowId_, ctCollectionId)
)
go

create table ExpandoTable (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	tableId decimal(20,0) not null,
	companyId decimal(20,0),
	classNameId decimal(20,0),
	name varchar(75) null,
	primary key (tableId, ctCollectionId)
)
go

create table ExpandoValue (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	valueId decimal(20,0) not null,
	companyId decimal(20,0),
	tableId decimal(20,0),
	columnId decimal(20,0),
	rowId_ decimal(20,0),
	classNameId decimal(20,0),
	classPK decimal(20,0),
	data_ text null,
	primary key (valueId, ctCollectionId)
)
go

create table ExportImportConfiguration (
	mvccVersion decimal(20,0) default 0 not null,
	exportImportConfigurationId decimal(20,0) not null primary key,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	name varchar(200) null,
	description varchar(4000) null,
	type_ int,
	settings_ text null,
	status int,
	statusByUserId decimal(20,0),
	statusByUserName varchar(75) null,
	statusDate bigdatetime null
)
go

create table Group_ (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	groupId decimal(20,0) not null,
	companyId decimal(20,0),
	creatorUserId decimal(20,0),
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	parentGroupId decimal(20,0),
	liveGroupId decimal(20,0),
	treePath varchar(4000) null,
	groupKey varchar(150) null,
	name varchar(4000) null,
	description varchar(4000) null,
	type_ int,
	typeSettings text null,
	manualMembership int,
	membershipRestriction int,
	friendlyURL varchar(255) null,
	site int,
	remoteStagingGroupCount int,
	inheritContent int,
	active_ int,
	primary key (groupId, ctCollectionId)
)
go

create table Groups_Orgs (
	companyId decimal(20,0) not null,
	groupId decimal(20,0) not null,
	organizationId decimal(20,0) not null,
	ctCollectionId decimal(20,0) default 0 not null,
	ctChangeType int,
	primary key (groupId, organizationId, ctCollectionId)
)
go

create table Groups_Roles (
	companyId decimal(20,0) not null,
	groupId decimal(20,0) not null,
	roleId decimal(20,0) not null,
	ctCollectionId decimal(20,0) default 0 not null,
	ctChangeType int,
	primary key (groupId, roleId, ctCollectionId)
)
go

create table Groups_UserGroups (
	companyId decimal(20,0) not null,
	groupId decimal(20,0) not null,
	userGroupId decimal(20,0) not null,
	ctCollectionId decimal(20,0) default 0 not null,
	ctChangeType int,
	primary key (groupId, userGroupId, ctCollectionId)
)
go

create table Image (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	imageId decimal(20,0) not null,
	companyId decimal(20,0),
	modifiedDate bigdatetime null,
	type_ varchar(75) null,
	height int,
	width int,
	size_ int,
	primary key (imageId, ctCollectionId)
)
go

create table Layout (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	plid decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	parentPlid decimal(20,0),
	privateLayout int,
	layoutId decimal(20,0),
	parentLayoutId decimal(20,0),
	classNameId decimal(20,0),
	classPK decimal(20,0),
	name varchar(4000) null,
	title text null,
	description text null,
	keywords varchar(4000) null,
	robots varchar(4000) null,
	type_ varchar(75) null,
	typeSettings text null,
	hidden_ int,
	system_ int,
	friendlyURL varchar(255) null,
	iconImageId decimal(20,0),
	themeId varchar(75) null,
	colorSchemeId varchar(75) null,
	styleBookEntryId decimal(20,0),
	css text null,
	priority int,
	faviconFileEntryId decimal(20,0),
	masterLayoutPlid decimal(20,0),
	layoutPrototypeUuid varchar(75) null,
	layoutPrototypeLinkEnabled int,
	sourcePrototypeLayoutUuid varchar(75) null,
	publishDate bigdatetime null,
	lastPublishDate bigdatetime null,
	status int,
	statusByUserId decimal(20,0),
	statusByUserName varchar(75) null,
	statusDate bigdatetime null,
	primary key (plid, ctCollectionId)
)
go

create table LayoutBranch (
	mvccVersion decimal(20,0) default 0 not null,
	layoutBranchId decimal(20,0) not null primary key,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	layoutSetBranchId decimal(20,0),
	plid decimal(20,0),
	name varchar(75) null,
	description varchar(4000) null,
	master int
)
go

create table LayoutFriendlyURL (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	layoutFriendlyURLId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	plid decimal(20,0),
	privateLayout int,
	friendlyURL varchar(255) null,
	languageId varchar(75) null,
	lastPublishDate bigdatetime null,
	primary key (layoutFriendlyURLId, ctCollectionId)
)
go

create table LayoutPrototype (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	layoutPrototypeId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	name text null,
	description text null,
	settings_ varchar(4000) null,
	active_ int,
	primary key (layoutPrototypeId, ctCollectionId)
)
go

create table LayoutRevision (
	mvccVersion decimal(20,0) default 0 not null,
	layoutRevisionId decimal(20,0) not null primary key,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	layoutSetBranchId decimal(20,0),
	layoutBranchId decimal(20,0),
	parentLayoutRevisionId decimal(20,0),
	head int,
	major int,
	plid decimal(20,0),
	privateLayout int,
	name varchar(4000) null,
	title varchar(4000) null,
	description varchar(4000) null,
	keywords varchar(4000) null,
	robots varchar(4000) null,
	typeSettings text null,
	iconImageId decimal(20,0),
	themeId varchar(75) null,
	colorSchemeId varchar(75) null,
	css text null,
	status int,
	statusByUserId decimal(20,0),
	statusByUserName varchar(75) null,
	statusDate bigdatetime null
)
go

create table LayoutSet (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	layoutSetId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	privateLayout int,
	logoId decimal(20,0),
	themeId varchar(75) null,
	colorSchemeId varchar(75) null,
	faviconFileEntryId decimal(20,0),
	css text null,
	settings_ text null,
	layoutSetPrototypeUuid varchar(75) null,
	layoutSetPrototypeLinkEnabled int,
	primary key (layoutSetId, ctCollectionId)
)
go

create table LayoutSetBranch (
	mvccVersion decimal(20,0) default 0 not null,
	layoutSetBranchId decimal(20,0) not null primary key,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	privateLayout int,
	name varchar(75) null,
	description varchar(4000) null,
	master int,
	logoId decimal(20,0),
	themeId varchar(75) null,
	colorSchemeId varchar(75) null,
	css text null,
	settings_ text null,
	layoutSetPrototypeUuid varchar(75) null,
	layoutSetPrototypeLinkEnabled int
)
go

create table LayoutSetPrototype (
	mvccVersion decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	layoutSetPrototypeId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	name text null,
	description text null,
	settings_ varchar(4000) null,
	active_ int
)
go

create table ListType (
	mvccVersion decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	listTypeId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	name varchar(75) null,
	type_ varchar(75) null
)
go

create table MembershipRequest (
	mvccVersion decimal(20,0) default 0 not null,
	membershipRequestId decimal(20,0) not null primary key,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	createDate bigdatetime null,
	comments varchar(4000) null,
	replyComments varchar(4000) null,
	replyDate bigdatetime null,
	replierUserId decimal(20,0),
	statusId decimal(20,0)
)
go

create table OrgLabor (
	mvccVersion decimal(20,0) default 0 not null,
	orgLaborId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	organizationId decimal(20,0),
	listTypeId decimal(20,0),
	sunOpen int,
	sunClose int,
	monOpen int,
	monClose int,
	tueOpen int,
	tueClose int,
	wedOpen int,
	wedClose int,
	thuOpen int,
	thuClose int,
	friOpen int,
	friClose int,
	satOpen int,
	satClose int
)
go

create table Organization_ (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	organizationId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	parentOrganizationId decimal(20,0),
	treePath varchar(4000) null,
	name varchar(100) null,
	type_ varchar(75) null,
	recursable int,
	regionId decimal(20,0),
	countryId decimal(20,0),
	statusListTypeId decimal(20,0),
	comments varchar(4000) null,
	logoId decimal(20,0),
	primary key (organizationId, ctCollectionId)
)
go

create table PasswordPolicy (
	mvccVersion decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	passwordPolicyId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	defaultPolicy int,
	name varchar(75) null,
	description varchar(4000) null,
	changeable int,
	changeRequired int,
	minAge decimal(20,0),
	checkSyntax int,
	allowDictionaryWords int,
	minAlphanumeric int,
	minLength int,
	minLowerCase int,
	minNumbers int,
	minSymbols int,
	minUpperCase int,
	regex varchar(4000) null,
	history int,
	historyCount int,
	expireable int,
	maxAge decimal(20,0),
	warningTime decimal(20,0),
	graceLimit int,
	lockout int,
	maxFailure int,
	lockoutDuration decimal(20,0),
	requireUnlock int,
	resetFailureCount decimal(20,0),
	resetTicketMaxAge decimal(20,0)
)
go

create table PasswordPolicyRel (
	mvccVersion decimal(20,0) default 0 not null,
	passwordPolicyRelId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	passwordPolicyId decimal(20,0),
	classNameId decimal(20,0),
	classPK decimal(20,0)
)
go

create table PasswordTracker (
	mvccVersion decimal(20,0) default 0 not null,
	passwordTrackerId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userId decimal(20,0),
	createDate bigdatetime null,
	password_ varchar(255) null
)
go

create table Phone (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	phoneId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	number_ varchar(75) null,
	extension varchar(75) null,
	listTypeId decimal(20,0),
	primary_ int,
	primary key (phoneId, ctCollectionId)
)
go

create table PluginSetting (
	mvccVersion decimal(20,0) default 0 not null,
	pluginSettingId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	pluginId varchar(75) null,
	pluginType varchar(75) null,
	roles varchar(4000) null,
	active_ int
)
go

create table PortalPreferenceValue (
	mvccVersion decimal(20,0) default 0 not null,
	portalPreferenceValueId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	portalPreferencesId decimal(20,0),
	index_ int,
	key_ varchar(1024) null,
	largeValue text null,
	namespace varchar(255) null,
	smallValue varchar(255) null
)
go

create table PortalPreferences (
	mvccVersion decimal(20,0) default 0 not null,
	portalPreferencesId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	ownerId decimal(20,0),
	ownerType int
)
go

create table Portlet (
	mvccVersion decimal(20,0) default 0 not null,
	id_ decimal(20,0) not null primary key,
	companyId decimal(20,0),
	portletId varchar(200) null,
	roles varchar(4000) null,
	active_ int
)
go

create table PortletItem (
	mvccVersion decimal(20,0) default 0 not null,
	portletItemId decimal(20,0) not null primary key,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	name varchar(75) null,
	portletId varchar(200) null,
	classNameId decimal(20,0)
)
go

create table PortletPreferenceValue (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	portletPreferenceValueId decimal(20,0) not null,
	companyId decimal(20,0),
	portletPreferencesId decimal(20,0),
	index_ int,
	largeValue text null,
	name varchar(255) null,
	readOnly int,
	smallValue varchar(255) null,
	primary key (portletPreferenceValueId, ctCollectionId)
)
go

create table PortletPreferences (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	portletPreferencesId decimal(20,0) not null,
	companyId decimal(20,0),
	ownerId decimal(20,0),
	ownerType int,
	plid decimal(20,0),
	portletId varchar(200) null,
	primary key (portletPreferencesId, ctCollectionId)
)
go

create table RatingsEntry (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	entryId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	score float,
	primary key (entryId, ctCollectionId)
)
go

create table RatingsStats (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	statsId decimal(20,0) not null,
	companyId decimal(20,0),
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	totalEntries int,
	totalScore float,
	averageScore float,
	primary key (statsId, ctCollectionId)
)
go

create table RecentLayoutBranch (
	mvccVersion decimal(20,0) default 0 not null,
	recentLayoutBranchId decimal(20,0) not null primary key,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	layoutBranchId decimal(20,0),
	layoutSetBranchId decimal(20,0),
	plid decimal(20,0)
)
go

create table RecentLayoutRevision (
	mvccVersion decimal(20,0) default 0 not null,
	recentLayoutRevisionId decimal(20,0) not null primary key,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	layoutRevisionId decimal(20,0),
	layoutSetBranchId decimal(20,0),
	plid decimal(20,0)
)
go

create table RecentLayoutSetBranch (
	mvccVersion decimal(20,0) default 0 not null,
	recentLayoutSetBranchId decimal(20,0) not null primary key,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	layoutSetBranchId decimal(20,0),
	layoutSetId decimal(20,0)
)
go

create table Region (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	defaultLanguageId varchar(75) null,
	regionId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	countryId decimal(20,0),
	active_ int,
	name varchar(75) null,
	position float,
	regionCode varchar(75) null,
	lastPublishDate bigdatetime null,
	primary key (regionId, ctCollectionId)
)
go

create table RegionLocalization (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	regionLocalizationId decimal(20,0) not null,
	companyId decimal(20,0),
	regionId decimal(20,0),
	languageId varchar(75) null,
	title varchar(75) null,
	primary key (regionLocalizationId, ctCollectionId)
)
go

create table Release_ (
	mvccVersion decimal(20,0) default 0 not null,
	releaseId decimal(20,0) not null primary key,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	servletContextName varchar(75) null,
	schemaVersion varchar(75) null,
	buildNumber int,
	buildDate bigdatetime null,
	verified int,
	state_ int,
	testString varchar(1024) null
)
go

create table RememberMeToken (
	mvccVersion decimal(20,0) default 0 not null,
	rememberMeTokenId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userId decimal(20,0),
	createDate bigdatetime null,
	expirationDate bigdatetime null,
	value varchar(255) null
)
go

create table Repository (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	repositoryId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	name varchar(200) null,
	description varchar(4000) null,
	portletId varchar(200) null,
	typeSettings text null,
	dlFolderId decimal(20,0),
	lastPublishDate bigdatetime null,
	primary key (repositoryId, ctCollectionId)
)
go

create table RepositoryEntry (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	repositoryEntryId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	repositoryId decimal(20,0),
	mappedId varchar(255) null,
	manualCheckInRequired int,
	lastPublishDate bigdatetime null,
	primary key (repositoryEntryId, ctCollectionId)
)
go

create table ResourceAction (
	mvccVersion decimal(20,0) default 0 not null,
	resourceActionId decimal(20,0) not null primary key,
	name varchar(255) null,
	actionId varchar(75) null,
	bitwiseValue decimal(20,0)
)
go

create table ResourcePermission (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	resourcePermissionId decimal(20,0) not null,
	companyId decimal(20,0),
	name varchar(255) null,
	scope int,
	primKey varchar(255) null,
	primKeyId decimal(20,0),
	roleId decimal(20,0),
	ownerId decimal(20,0),
	actionIds decimal(20,0),
	viewActionId int,
	primary key (resourcePermissionId, ctCollectionId)
)
go

create table Role_ (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	roleId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	name varchar(75) null,
	title varchar(4000) null,
	description text null,
	type_ int,
	subtype varchar(75) null,
	primary key (roleId, ctCollectionId)
)
go

create table ServiceComponent (
	mvccVersion decimal(20,0) default 0 not null,
	serviceComponentId decimal(20,0) not null primary key,
	buildNamespace varchar(75) null,
	buildNumber decimal(20,0),
	buildDate decimal(20,0),
	data_ text null
)
go

create table SocialActivity (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	activityId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	createDate decimal(20,0),
	activitySetId decimal(20,0),
	mirrorActivityId decimal(20,0),
	classNameId decimal(20,0),
	classPK decimal(20,0),
	parentClassNameId decimal(20,0),
	parentClassPK decimal(20,0),
	type_ int,
	extraData varchar(4000) null,
	receiverUserId decimal(20,0),
	primary key (activityId, ctCollectionId)
)
go

create table SocialActivityAchievement (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	activityAchievementId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	createDate decimal(20,0),
	name varchar(75) null,
	firstInGroup int,
	primary key (activityAchievementId, ctCollectionId)
)
go

create table SocialActivityCounter (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	activityCounterId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	classNameId decimal(20,0),
	classPK decimal(20,0),
	name varchar(75) null,
	ownerType int,
	currentValue int,
	totalValue int,
	graceValue int,
	startPeriod int,
	endPeriod int,
	active_ int,
	primary key (activityCounterId, ctCollectionId)
)
go

create table SocialActivityLimit (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	activityLimitId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	classNameId decimal(20,0),
	classPK decimal(20,0),
	activityType int,
	activityCounterName varchar(75) null,
	value varchar(75) null,
	primary key (activityLimitId, ctCollectionId)
)
go

create table SocialActivitySet (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	activitySetId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	createDate decimal(20,0),
	modifiedDate decimal(20,0),
	classNameId decimal(20,0),
	classPK decimal(20,0),
	type_ int,
	extraData varchar(4000) null,
	activityCount int,
	primary key (activitySetId, ctCollectionId)
)
go

create table SocialActivitySetting (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	activitySettingId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	classNameId decimal(20,0),
	activityType int,
	name varchar(75) null,
	value varchar(1024) null,
	primary key (activitySettingId, ctCollectionId)
)
go

create table SocialRelation (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	relationId decimal(20,0) not null,
	companyId decimal(20,0),
	createDate decimal(20,0),
	userId1 decimal(20,0),
	userId2 decimal(20,0),
	type_ int,
	primary key (relationId, ctCollectionId)
)
go

create table SocialRequest (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	requestId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	createDate decimal(20,0),
	modifiedDate decimal(20,0),
	classNameId decimal(20,0),
	classPK decimal(20,0),
	type_ int,
	extraData varchar(4000) null,
	receiverUserId decimal(20,0),
	status int,
	primary key (requestId, ctCollectionId)
)
go

create table SystemEvent (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	systemEventId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	classUuid varchar(75) null,
	referrerClassNameId decimal(20,0),
	parentSystemEventId decimal(20,0),
	systemEventSetKey decimal(20,0),
	type_ int,
	extraData text null,
	primary key (systemEventId, ctCollectionId)
)
go

create table Team (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	teamId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	groupId decimal(20,0),
	name varchar(75) null,
	description varchar(4000) null,
	lastPublishDate bigdatetime null,
	primary key (teamId, ctCollectionId)
)
go

create table Ticket (
	mvccVersion decimal(20,0) default 0 not null,
	ticketId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	createDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	key_ varchar(255) null,
	type_ int,
	extraInfo text null,
	expirationDate bigdatetime null
)
go

create table UserNotificationDelivery (
	mvccVersion decimal(20,0) default 0 not null,
	userNotificationDeliveryId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userId decimal(20,0),
	portletId varchar(200) null,
	classNameId decimal(20,0),
	notificationType int,
	deliveryType int,
	deliver int
)
go

create table User_ (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	userId decimal(20,0) not null,
	companyId decimal(20,0),
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	contactId decimal(20,0),
	password_ varchar(255) null,
	passwordEncrypted int,
	passwordReset int,
	passwordModifiedDate bigdatetime null,
	digest varchar(255) null,
	reminderQueryQuestion varchar(75) null,
	reminderQueryAnswer varchar(75) null,
	graceLoginCount int,
	screenName varchar(75) null,
	emailAddress varchar(254) null,
	facebookId decimal(20,0),
	googleUserId varchar(75) null,
	ldapServerId decimal(20,0),
	openId varchar(1024) null,
	portraitId decimal(20,0),
	languageId varchar(75) null,
	timeZoneId varchar(75) null,
	greeting varchar(255) null,
	comments varchar(4000) null,
	firstName varchar(75) null,
	middleName varchar(75) null,
	lastName varchar(75) null,
	jobTitle varchar(100) null,
	loginDate bigdatetime null,
	loginIP varchar(75) null,
	lastLoginDate bigdatetime null,
	lastLoginIP varchar(75) null,
	lastFailedLoginDate bigdatetime null,
	failedLoginAttempts int,
	lockout int,
	lockoutDate bigdatetime null,
	agreedToTermsOfUse int,
	emailAddressVerified int,
	type_ int,
	status int,
	primary key (userId, ctCollectionId)
)
go

create table UserGroup (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	externalReferenceCode varchar(75) null,
	userGroupId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	parentUserGroupId decimal(20,0),
	name varchar(255) null,
	description varchar(4000) null,
	addedByLDAPImport int,
	primary key (userGroupId, ctCollectionId)
)
go

create table UserGroupGroupRole (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	userGroupGroupRoleId decimal(20,0) not null,
	companyId decimal(20,0),
	userGroupId decimal(20,0),
	groupId decimal(20,0),
	roleId decimal(20,0),
	primary key (userGroupGroupRoleId, ctCollectionId)
)
go

create table UserGroupRole (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	userGroupRoleId decimal(20,0) not null,
	companyId decimal(20,0),
	userId decimal(20,0),
	groupId decimal(20,0),
	roleId decimal(20,0),
	primary key (userGroupRoleId, ctCollectionId)
)
go

create table UserGroups_Teams (
	companyId decimal(20,0) not null,
	teamId decimal(20,0) not null,
	userGroupId decimal(20,0) not null,
	ctCollectionId decimal(20,0) default 0 not null,
	ctChangeType int,
	primary key (teamId, userGroupId, ctCollectionId)
)
go

create table UserIdMapper (
	mvccVersion decimal(20,0) default 0 not null,
	userIdMapperId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userId decimal(20,0),
	type_ varchar(75) null,
	description varchar(75) null,
	externalUserId varchar(75) null
)
go

create table UserNotificationEvent (
	mvccVersion decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	userNotificationEventId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userId decimal(20,0),
	type_ varchar(200) null,
	timestamp decimal(20,0),
	deliveryType int,
	deliverBy decimal(20,0),
	delivered int,
	payload text null,
	actionRequired int,
	archived int
)
go

create table Users_Groups (
	companyId decimal(20,0) not null,
	groupId decimal(20,0) not null,
	userId decimal(20,0) not null,
	ctCollectionId decimal(20,0) default 0 not null,
	ctChangeType int,
	primary key (groupId, userId, ctCollectionId)
)
go

create table Users_Orgs (
	companyId decimal(20,0) not null,
	organizationId decimal(20,0) not null,
	userId decimal(20,0) not null,
	ctCollectionId decimal(20,0) default 0 not null,
	ctChangeType int,
	primary key (organizationId, userId, ctCollectionId)
)
go

create table Users_Roles (
	companyId decimal(20,0) not null,
	roleId decimal(20,0) not null,
	userId decimal(20,0) not null,
	ctCollectionId decimal(20,0) default 0 not null,
	ctChangeType int,
	primary key (roleId, userId, ctCollectionId)
)
go

create table Users_Teams (
	companyId decimal(20,0) not null,
	teamId decimal(20,0) not null,
	userId decimal(20,0) not null,
	ctCollectionId decimal(20,0) default 0 not null,
	ctChangeType int,
	primary key (teamId, userId, ctCollectionId)
)
go

create table Users_UserGroups (
	companyId decimal(20,0) not null,
	userId decimal(20,0) not null,
	userGroupId decimal(20,0) not null,
	ctCollectionId decimal(20,0) default 0 not null,
	ctChangeType int,
	primary key (userId, userGroupId, ctCollectionId)
)
go

create table UserTracker (
	mvccVersion decimal(20,0) default 0 not null,
	userTrackerId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userId decimal(20,0),
	modifiedDate bigdatetime null,
	sessionId varchar(200) null,
	remoteAddr varchar(75) null,
	remoteHost varchar(75) null,
	userAgent varchar(200) null
)
go

create table UserTrackerPath (
	mvccVersion decimal(20,0) default 0 not null,
	userTrackerPathId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userTrackerId decimal(20,0),
	path_ varchar(4000) null,
	pathDate bigdatetime null
)
go

create table VirtualHost (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	virtualHostId decimal(20,0) not null,
	companyId decimal(20,0),
	layoutSetId decimal(20,0),
	hostname varchar(200) null,
	defaultVirtualHost int,
	languageId varchar(75) null,
	primary key (virtualHostId, ctCollectionId)
)
go

create table WebDAVProps (
	mvccVersion decimal(20,0) default 0 not null,
	webDavPropsId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	props text null
)
go

create table Website (
	mvccVersion decimal(20,0) default 0 not null,
	uuid_ varchar(75) null,
	websiteId decimal(20,0) not null primary key,
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	url varchar(4000) null,
	listTypeId decimal(20,0),
	primary_ int,
	lastPublishDate bigdatetime null
)
go

create table WorkflowDefinitionLink (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	workflowDefinitionLinkId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	typePK decimal(20,0),
	workflowDefinitionName varchar(75) null,
	workflowDefinitionVersion int,
	primary key (workflowDefinitionLinkId, ctCollectionId)
)
go

create table WorkflowInstanceLink (
	mvccVersion decimal(20,0) default 0 not null,
	ctCollectionId decimal(20,0) default 0 not null,
	workflowInstanceLinkId decimal(20,0) not null,
	groupId decimal(20,0),
	companyId decimal(20,0),
	userId decimal(20,0),
	userName varchar(75) null,
	createDate bigdatetime null,
	modifiedDate bigdatetime null,
	classNameId decimal(20,0),
	classPK decimal(20,0),
	workflowInstanceId decimal(20,0),
	primary key (workflowInstanceLinkId, ctCollectionId)
)
go
