create table Address (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	externalReferenceCode VARCHAR2(75 CHAR) null,
	addressId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	countryId number(30,0),
	listTypeId number(30,0),
	regionId number(30,0),
	city VARCHAR2(75 CHAR) null,
	description varchar2(4000 char) null,
	latitude binary_double,
	longitude binary_double,
	mailing number(1, 0),
	name VARCHAR2(255 CHAR) null,
	primary_ number(1, 0),
	street1 VARCHAR2(255 CHAR) null,
	street2 VARCHAR2(255 CHAR) null,
	street3 VARCHAR2(255 CHAR) null,
	validationDate timestamp null,
	validationStatus number(30,0),
	zip VARCHAR2(75 CHAR) null,
	primary key (addressId, ctCollectionId)
);

create table AnnouncementsDelivery (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	deliveryId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	type_ VARCHAR2(75 CHAR) null,
	email number(1, 0),
	sms number(1, 0),
	website number(1, 0),
	primary key (deliveryId, ctCollectionId)
);

create table AnnouncementsEntry (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	entryId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	title VARCHAR2(75 CHAR) null,
	content clob null,
	url varchar2(4000 char) null,
	type_ VARCHAR2(75 CHAR) null,
	displayDate timestamp null,
	expirationDate timestamp null,
	priority number(30,0),
	alert number(1, 0),
	primary key (entryId, ctCollectionId)
);

create table AnnouncementsFlag (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	flagId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	createDate timestamp null,
	entryId number(30,0),
	value number(30,0),
	primary key (flagId, ctCollectionId)
);

create table AssetCategory (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	externalReferenceCode VARCHAR2(75 CHAR) null,
	categoryId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	parentCategoryId number(30,0),
	treePath varchar2(4000 char) null,
	name VARCHAR2(255 CHAR) null,
	title clob null,
	description clob null,
	vocabularyId number(30,0),
	lastPublishDate timestamp null,
	primary key (categoryId, ctCollectionId)
);

create table AssetEntries_AssetTags (
	companyId number(30,0) not null,
	entryId number(30,0) not null,
	tagId number(30,0) not null,
	ctCollectionId number(30,0) default 0 not null,
	ctChangeType number(1, 0),
	primary key (entryId, tagId, ctCollectionId)
);

create table AssetEntry (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	entryId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	classUuid VARCHAR2(75 CHAR) null,
	classTypeId number(30,0),
	listable number(1, 0),
	visible number(1, 0),
	startDate timestamp null,
	endDate timestamp null,
	publishDate timestamp null,
	expirationDate timestamp null,
	mimeType VARCHAR2(75 CHAR) null,
	title clob null,
	description clob null,
	summary clob null,
	url varchar2(4000 char) null,
	layoutUuid VARCHAR2(75 CHAR) null,
	height number(30,0),
	width number(30,0),
	priority binary_double,
	primary key (entryId, ctCollectionId)
);

create table AssetTag (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	tagId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	name VARCHAR2(75 CHAR) null,
	assetCount number(30,0),
	lastPublishDate timestamp null,
	primary key (tagId, ctCollectionId)
);

create table AssetVocabulary (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	externalReferenceCode VARCHAR2(75 CHAR) null,
	vocabularyId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	name VARCHAR2(75 CHAR) null,
	title varchar2(4000 char) null,
	description varchar2(4000 char) null,
	settings_ varchar2(4000 char) null,
	visibilityType number(30,0),
	lastPublishDate timestamp null,
	primary key (vocabularyId, ctCollectionId)
);

create table BrowserTracker (
	mvccVersion number(30,0) default 0 not null,
	browserTrackerId number(30,0) not null primary key,
	companyId number(30,0),
	userId number(30,0),
	browserKey number(30,0)
);

create table ClassName_ (
	mvccVersion number(30,0) default 0 not null,
	classNameId number(30,0) not null primary key,
	value VARCHAR2(200 CHAR) null
);

create table Company (
	mvccVersion number(30,0) default 0 not null,
	companyId number(30,0) not null primary key,
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	webId VARCHAR2(75 CHAR) null,
	mx VARCHAR2(200 CHAR) null,
	homeURL varchar2(4000 char) null,
	logoId number(30,0),
	maxUsers number(30,0),
	active_ number(1, 0),
	name VARCHAR2(75 CHAR) null,
	legalName VARCHAR2(75 CHAR) null,
	legalId VARCHAR2(75 CHAR) null,
	legalType VARCHAR2(75 CHAR) null,
	sicCode VARCHAR2(75 CHAR) null,
	tickerSymbol VARCHAR2(75 CHAR) null,
	industry VARCHAR2(75 CHAR) null,
	type_ VARCHAR2(75 CHAR) null,
	size_ VARCHAR2(75 CHAR) null,
	indexNameCurrent VARCHAR2(75 CHAR) null,
	indexNameNext VARCHAR2(75 CHAR) null
);

create table CompanyInfo (
	mvccVersion number(30,0) default 0 not null,
	companyInfoId number(30,0) not null primary key,
	companyId number(30,0),
	key_ clob null
);

create table Contact_ (
	mvccVersion number(30,0) default 0 not null,
	contactId number(30,0) not null primary key,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	parentContactId number(30,0),
	emailAddress VARCHAR2(254 CHAR) null,
	firstName VARCHAR2(75 CHAR) null,
	middleName VARCHAR2(75 CHAR) null,
	lastName VARCHAR2(75 CHAR) null,
	prefixListTypeId number(30,0),
	suffixListTypeId number(30,0),
	male number(1, 0),
	birthday timestamp null,
	smsSn VARCHAR2(75 CHAR) null,
	facebookSn VARCHAR2(75 CHAR) null,
	jabberSn VARCHAR2(75 CHAR) null,
	skypeSn VARCHAR2(75 CHAR) null,
	twitterSn VARCHAR2(75 CHAR) null,
	employeeStatusId VARCHAR2(75 CHAR) null,
	employeeNumber VARCHAR2(75 CHAR) null,
	jobTitle VARCHAR2(100 CHAR) null,
	jobClass VARCHAR2(75 CHAR) null,
	hoursOfOperation VARCHAR2(75 CHAR) null
);

create table Counter (
	name VARCHAR2(150 CHAR) not null primary key,
	currentId number(30,0)
);

create table Country (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	defaultLanguageId VARCHAR2(75 CHAR) null,
	countryId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	a2 VARCHAR2(75 CHAR) null,
	a3 VARCHAR2(75 CHAR) null,
	active_ number(1, 0),
	billingAllowed number(1, 0),
	groupFilterEnabled number(1, 0),
	idd_ VARCHAR2(75 CHAR) null,
	name VARCHAR2(75 CHAR) null,
	number_ VARCHAR2(75 CHAR) null,
	position binary_double,
	shippingAllowed number(1, 0),
	subjectToVAT number(1, 0),
	zipRequired number(1, 0),
	lastPublishDate timestamp null,
	primary key (countryId, ctCollectionId)
);

create table CountryLocalization (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	countryLocalizationId number(30,0) not null,
	companyId number(30,0),
	countryId number(30,0),
	languageId VARCHAR2(75 CHAR) null,
	title VARCHAR2(75 CHAR) null,
	primary key (countryLocalizationId, ctCollectionId)
);

create table DLFileEntry (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	externalReferenceCode VARCHAR2(75 CHAR) null,
	fileEntryId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	repositoryId number(30,0),
	folderId number(30,0),
	treePath varchar2(4000 char) null,
	name VARCHAR2(255 CHAR) null,
	fileName VARCHAR2(255 CHAR) null,
	extension VARCHAR2(75 CHAR) null,
	mimeType VARCHAR2(75 CHAR) null,
	title VARCHAR2(255 CHAR) null,
	description varchar2(4000 char) null,
	extraSettings clob null,
	fileEntryTypeId number(30,0),
	version VARCHAR2(75 CHAR) null,
	size_ number(30,0),
	smallImageId number(30,0),
	largeImageId number(30,0),
	custom1ImageId number(30,0),
	custom2ImageId number(30,0),
	manualCheckInRequired number(1, 0),
	displayDate timestamp null,
	expirationDate timestamp null,
	reviewDate timestamp null,
	lastPublishDate timestamp null,
	primary key (fileEntryId, ctCollectionId)
);

create table DLFileEntryMetadata (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	fileEntryMetadataId number(30,0) not null,
	companyId number(30,0),
	DDMStorageId number(30,0),
	DDMStructureId number(30,0),
	fileEntryId number(30,0),
	fileVersionId number(30,0),
	primary key (fileEntryMetadataId, ctCollectionId)
);

create table DLFileEntryType (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	fileEntryTypeId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	dataDefinitionId number(30,0),
	fileEntryTypeKey VARCHAR2(75 CHAR) null,
	name varchar2(4000 char) null,
	description varchar2(4000 char) null,
	scope number(30,0),
	lastPublishDate timestamp null,
	primary key (fileEntryTypeId, ctCollectionId)
);

create table DLFileEntryTypes_DLFolders (
	companyId number(30,0) not null,
	fileEntryTypeId number(30,0) not null,
	folderId number(30,0) not null,
	ctCollectionId number(30,0) default 0 not null,
	ctChangeType number(1, 0),
	primary key (fileEntryTypeId, folderId, ctCollectionId)
);

create table DLFileShortcut (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	fileShortcutId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	repositoryId number(30,0),
	folderId number(30,0),
	toFileEntryId number(30,0),
	treePath varchar2(4000 char) null,
	active_ number(1, 0),
	lastPublishDate timestamp null,
	status number(30,0),
	statusByUserId number(30,0),
	statusByUserName VARCHAR2(75 CHAR) null,
	statusDate timestamp null,
	primary key (fileShortcutId, ctCollectionId)
);

create table DLFileVersion (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	fileVersionId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	repositoryId number(30,0),
	folderId number(30,0),
	fileEntryId number(30,0),
	treePath varchar2(4000 char) null,
	fileName VARCHAR2(255 CHAR) null,
	extension VARCHAR2(75 CHAR) null,
	mimeType VARCHAR2(75 CHAR) null,
	title VARCHAR2(255 CHAR) null,
	description varchar2(4000 char) null,
	changeLog VARCHAR2(75 CHAR) null,
	extraSettings clob null,
	fileEntryTypeId number(30,0),
	version VARCHAR2(75 CHAR) null,
	size_ number(30,0),
	checksum VARCHAR2(75 CHAR) null,
	storeUUID VARCHAR2(255 CHAR) null,
	displayDate timestamp null,
	expirationDate timestamp null,
	reviewDate timestamp null,
	lastPublishDate timestamp null,
	status number(30,0),
	statusByUserId number(30,0),
	statusByUserName VARCHAR2(75 CHAR) null,
	statusDate timestamp null,
	primary key (fileVersionId, ctCollectionId)
);

create table DLFolder (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	externalReferenceCode VARCHAR2(75 CHAR) null,
	folderId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	repositoryId number(30,0),
	mountPoint number(1, 0),
	parentFolderId number(30,0),
	treePath varchar2(4000 char) null,
	name VARCHAR2(255 CHAR) null,
	description varchar2(4000 char) null,
	lastPostDate timestamp null,
	defaultFileEntryTypeId number(30,0),
	hidden_ number(1, 0),
	restrictionType number(30,0),
	lastPublishDate timestamp null,
	status number(30,0),
	statusByUserId number(30,0),
	statusByUserName VARCHAR2(75 CHAR) null,
	statusDate timestamp null,
	primary key (folderId, ctCollectionId)
);

create table EmailAddress (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	emailAddressId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	address VARCHAR2(254 CHAR) null,
	listTypeId number(30,0),
	primary_ number(1, 0),
	primary key (emailAddressId, ctCollectionId)
);

create table ExpandoColumn (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	columnId number(30,0) not null,
	companyId number(30,0),
	modifiedDate timestamp null,
	tableId number(30,0),
	name VARCHAR2(75 CHAR) null,
	type_ number(30,0),
	defaultData clob null,
	typeSettings clob null,
	primary key (columnId, ctCollectionId)
);

create table ExpandoRow (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	rowId_ number(30,0) not null,
	companyId number(30,0),
	modifiedDate timestamp null,
	tableId number(30,0),
	classPK number(30,0),
	primary key (rowId_, ctCollectionId)
);

create table ExpandoTable (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	tableId number(30,0) not null,
	companyId number(30,0),
	classNameId number(30,0),
	name VARCHAR2(75 CHAR) null,
	primary key (tableId, ctCollectionId)
);

create table ExpandoValue (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	valueId number(30,0) not null,
	companyId number(30,0),
	tableId number(30,0),
	columnId number(30,0),
	rowId_ number(30,0),
	classNameId number(30,0),
	classPK number(30,0),
	data_ clob null,
	primary key (valueId, ctCollectionId)
);

create table ExportImportConfiguration (
	mvccVersion number(30,0) default 0 not null,
	exportImportConfigurationId number(30,0) not null primary key,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	name VARCHAR2(200 CHAR) null,
	description varchar2(4000 char) null,
	type_ number(30,0),
	settings_ clob null,
	status number(30,0),
	statusByUserId number(30,0),
	statusByUserName VARCHAR2(75 CHAR) null,
	statusDate timestamp null
);

create table Group_ (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	externalReferenceCode VARCHAR2(75 CHAR) null,
	groupId number(30,0) not null,
	companyId number(30,0),
	creatorUserId number(30,0),
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	parentGroupId number(30,0),
	liveGroupId number(30,0),
	treePath varchar2(4000 char) null,
	groupKey VARCHAR2(150 CHAR) null,
	name varchar2(4000 char) null,
	description varchar2(4000 char) null,
	type_ number(30,0),
	typeSettings clob null,
	manualMembership number(1, 0),
	membershipRestriction number(30,0),
	friendlyURL VARCHAR2(255 CHAR) null,
	site number(1, 0),
	remoteStagingGroupCount number(30,0),
	inheritContent number(1, 0),
	active_ number(1, 0),
	primary key (groupId, ctCollectionId)
);

create table Groups_Orgs (
	companyId number(30,0) not null,
	groupId number(30,0) not null,
	organizationId number(30,0) not null,
	ctCollectionId number(30,0) default 0 not null,
	ctChangeType number(1, 0),
	primary key (groupId, organizationId, ctCollectionId)
);

create table Groups_Roles (
	companyId number(30,0) not null,
	groupId number(30,0) not null,
	roleId number(30,0) not null,
	ctCollectionId number(30,0) default 0 not null,
	ctChangeType number(1, 0),
	primary key (groupId, roleId, ctCollectionId)
);

create table Groups_UserGroups (
	companyId number(30,0) not null,
	groupId number(30,0) not null,
	userGroupId number(30,0) not null,
	ctCollectionId number(30,0) default 0 not null,
	ctChangeType number(1, 0),
	primary key (groupId, userGroupId, ctCollectionId)
);

create table Image (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	imageId number(30,0) not null,
	companyId number(30,0),
	modifiedDate timestamp null,
	type_ VARCHAR2(75 CHAR) null,
	height number(30,0),
	width number(30,0),
	size_ number(30,0),
	primary key (imageId, ctCollectionId)
);

create table Layout (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	externalReferenceCode VARCHAR2(75 CHAR) null,
	plid number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	parentPlid number(30,0),
	privateLayout number(1, 0),
	layoutId number(30,0),
	parentLayoutId number(30,0),
	classNameId number(30,0),
	classPK number(30,0),
	name varchar2(4000 char) null,
	title clob null,
	description clob null,
	keywords varchar2(4000 char) null,
	robots varchar2(4000 char) null,
	type_ VARCHAR2(75 CHAR) null,
	typeSettings clob null,
	hidden_ number(1, 0),
	system_ number(1, 0),
	friendlyURL VARCHAR2(255 CHAR) null,
	iconImageId number(30,0),
	themeId VARCHAR2(75 CHAR) null,
	colorSchemeId VARCHAR2(75 CHAR) null,
	styleBookEntryId number(30,0),
	css clob null,
	priority number(30,0),
	faviconFileEntryId number(30,0),
	masterLayoutPlid number(30,0),
	layoutPrototypeUuid VARCHAR2(75 CHAR) null,
	layoutPrototypeLinkEnabled number(1, 0),
	sourcePrototypeLayoutUuid VARCHAR2(75 CHAR) null,
	publishDate timestamp null,
	lastPublishDate timestamp null,
	status number(30,0),
	statusByUserId number(30,0),
	statusByUserName VARCHAR2(75 CHAR) null,
	statusDate timestamp null,
	primary key (plid, ctCollectionId)
);

create table LayoutBranch (
	mvccVersion number(30,0) default 0 not null,
	layoutBranchId number(30,0) not null primary key,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	layoutSetBranchId number(30,0),
	plid number(30,0),
	name VARCHAR2(75 CHAR) null,
	description varchar2(4000 char) null,
	master number(1, 0)
);

create table LayoutFriendlyURL (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	layoutFriendlyURLId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	plid number(30,0),
	privateLayout number(1, 0),
	friendlyURL VARCHAR2(255 CHAR) null,
	languageId VARCHAR2(75 CHAR) null,
	lastPublishDate timestamp null,
	primary key (layoutFriendlyURLId, ctCollectionId)
);

create table LayoutPrototype (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	layoutPrototypeId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	name clob null,
	description clob null,
	settings_ varchar2(4000 char) null,
	active_ number(1, 0),
	primary key (layoutPrototypeId, ctCollectionId)
);

create table LayoutRevision (
	mvccVersion number(30,0) default 0 not null,
	layoutRevisionId number(30,0) not null primary key,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	layoutSetBranchId number(30,0),
	layoutBranchId number(30,0),
	parentLayoutRevisionId number(30,0),
	head number(1, 0),
	major number(1, 0),
	plid number(30,0),
	privateLayout number(1, 0),
	name varchar2(4000 char) null,
	title varchar2(4000 char) null,
	description varchar2(4000 char) null,
	keywords varchar2(4000 char) null,
	robots varchar2(4000 char) null,
	typeSettings clob null,
	iconImageId number(30,0),
	themeId VARCHAR2(75 CHAR) null,
	colorSchemeId VARCHAR2(75 CHAR) null,
	css clob null,
	status number(30,0),
	statusByUserId number(30,0),
	statusByUserName VARCHAR2(75 CHAR) null,
	statusDate timestamp null
);

create table LayoutSet (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	layoutSetId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	createDate timestamp null,
	modifiedDate timestamp null,
	privateLayout number(1, 0),
	logoId number(30,0),
	themeId VARCHAR2(75 CHAR) null,
	colorSchemeId VARCHAR2(75 CHAR) null,
	faviconFileEntryId number(30,0),
	css clob null,
	settings_ clob null,
	layoutSetPrototypeUuid VARCHAR2(75 CHAR) null,
	layoutSetPrototypeLinkEnabled number(1, 0),
	primary key (layoutSetId, ctCollectionId)
);

create table LayoutSetBranch (
	mvccVersion number(30,0) default 0 not null,
	layoutSetBranchId number(30,0) not null primary key,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	privateLayout number(1, 0),
	name VARCHAR2(75 CHAR) null,
	description varchar2(4000 char) null,
	master number(1, 0),
	logoId number(30,0),
	themeId VARCHAR2(75 CHAR) null,
	colorSchemeId VARCHAR2(75 CHAR) null,
	css clob null,
	settings_ clob null,
	layoutSetPrototypeUuid VARCHAR2(75 CHAR) null,
	layoutSetPrototypeLinkEnabled number(1, 0)
);

create table LayoutSetPrototype (
	mvccVersion number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	layoutSetPrototypeId number(30,0) not null primary key,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	name clob null,
	description clob null,
	settings_ varchar2(4000 char) null,
	active_ number(1, 0)
);

create table ListType (
	mvccVersion number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	listTypeId number(30,0) not null primary key,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	name VARCHAR2(75 CHAR) null,
	type_ VARCHAR2(75 CHAR) null
);

create table MembershipRequest (
	mvccVersion number(30,0) default 0 not null,
	membershipRequestId number(30,0) not null primary key,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	createDate timestamp null,
	comments varchar2(4000 char) null,
	replyComments varchar2(4000 char) null,
	replyDate timestamp null,
	replierUserId number(30,0),
	statusId number(30,0)
);

create table OrgLabor (
	mvccVersion number(30,0) default 0 not null,
	orgLaborId number(30,0) not null primary key,
	companyId number(30,0),
	organizationId number(30,0),
	listTypeId number(30,0),
	sunOpen number(30,0),
	sunClose number(30,0),
	monOpen number(30,0),
	monClose number(30,0),
	tueOpen number(30,0),
	tueClose number(30,0),
	wedOpen number(30,0),
	wedClose number(30,0),
	thuOpen number(30,0),
	thuClose number(30,0),
	friOpen number(30,0),
	friClose number(30,0),
	satOpen number(30,0),
	satClose number(30,0)
);

create table Organization_ (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	externalReferenceCode VARCHAR2(75 CHAR) null,
	organizationId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	parentOrganizationId number(30,0),
	treePath varchar2(4000 char) null,
	name VARCHAR2(100 CHAR) null,
	type_ VARCHAR2(75 CHAR) null,
	recursable number(1, 0),
	regionId number(30,0),
	countryId number(30,0),
	statusListTypeId number(30,0),
	comments varchar2(4000 char) null,
	logoId number(30,0),
	primary key (organizationId, ctCollectionId)
);

create table PasswordPolicy (
	mvccVersion number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	passwordPolicyId number(30,0) not null primary key,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	defaultPolicy number(1, 0),
	name VARCHAR2(75 CHAR) null,
	description varchar2(4000 char) null,
	changeable number(1, 0),
	changeRequired number(1, 0),
	minAge number(30,0),
	checkSyntax number(1, 0),
	allowDictionaryWords number(1, 0),
	minAlphanumeric number(30,0),
	minLength number(30,0),
	minLowerCase number(30,0),
	minNumbers number(30,0),
	minSymbols number(30,0),
	minUpperCase number(30,0),
	regex varchar2(4000 char) null,
	history number(1, 0),
	historyCount number(30,0),
	expireable number(1, 0),
	maxAge number(30,0),
	warningTime number(30,0),
	graceLimit number(30,0),
	lockout number(1, 0),
	maxFailure number(30,0),
	lockoutDuration number(30,0),
	requireUnlock number(1, 0),
	resetFailureCount number(30,0),
	resetTicketMaxAge number(30,0)
);

create table PasswordPolicyRel (
	mvccVersion number(30,0) default 0 not null,
	passwordPolicyRelId number(30,0) not null primary key,
	companyId number(30,0),
	passwordPolicyId number(30,0),
	classNameId number(30,0),
	classPK number(30,0)
);

create table PasswordTracker (
	mvccVersion number(30,0) default 0 not null,
	passwordTrackerId number(30,0) not null primary key,
	companyId number(30,0),
	userId number(30,0),
	createDate timestamp null,
	password_ VARCHAR2(255 CHAR) null
);

create table Phone (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	phoneId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	number_ VARCHAR2(75 CHAR) null,
	extension VARCHAR2(75 CHAR) null,
	listTypeId number(30,0),
	primary_ number(1, 0),
	primary key (phoneId, ctCollectionId)
);

create table PluginSetting (
	mvccVersion number(30,0) default 0 not null,
	pluginSettingId number(30,0) not null primary key,
	companyId number(30,0),
	pluginId VARCHAR2(75 CHAR) null,
	pluginType VARCHAR2(75 CHAR) null,
	roles varchar2(4000 char) null,
	active_ number(1, 0)
);

create table PortalPreferenceValue (
	mvccVersion number(30,0) default 0 not null,
	portalPreferenceValueId number(30,0) not null primary key,
	companyId number(30,0),
	portalPreferencesId number(30,0),
	index_ number(30,0),
	key_ VARCHAR2(1024 CHAR) null,
	largeValue clob null,
	namespace VARCHAR2(255 CHAR) null,
	smallValue VARCHAR2(255 CHAR) null
);

create table PortalPreferences (
	mvccVersion number(30,0) default 0 not null,
	portalPreferencesId number(30,0) not null primary key,
	companyId number(30,0),
	ownerId number(30,0),
	ownerType number(30,0)
);

create table Portlet (
	mvccVersion number(30,0) default 0 not null,
	id_ number(30,0) not null primary key,
	companyId number(30,0),
	portletId VARCHAR2(200 CHAR) null,
	roles varchar2(4000 char) null,
	active_ number(1, 0)
);

create table PortletItem (
	mvccVersion number(30,0) default 0 not null,
	portletItemId number(30,0) not null primary key,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	name VARCHAR2(75 CHAR) null,
	portletId VARCHAR2(200 CHAR) null,
	classNameId number(30,0)
);

create table PortletPreferenceValue (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	portletPreferenceValueId number(30,0) not null,
	companyId number(30,0),
	portletPreferencesId number(30,0),
	index_ number(30,0),
	largeValue clob null,
	name VARCHAR2(255 CHAR) null,
	readOnly number(1, 0),
	smallValue VARCHAR2(255 CHAR) null,
	primary key (portletPreferenceValueId, ctCollectionId)
);

create table PortletPreferences (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	portletPreferencesId number(30,0) not null,
	companyId number(30,0),
	ownerId number(30,0),
	ownerType number(30,0),
	plid number(30,0),
	portletId VARCHAR2(200 CHAR) null,
	primary key (portletPreferencesId, ctCollectionId)
);

create table RatingsEntry (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	entryId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	score binary_double,
	primary key (entryId, ctCollectionId)
);

create table RatingsStats (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	statsId number(30,0) not null,
	companyId number(30,0),
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	totalEntries number(30,0),
	totalScore binary_double,
	averageScore binary_double,
	primary key (statsId, ctCollectionId)
);

create table RecentLayoutBranch (
	mvccVersion number(30,0) default 0 not null,
	recentLayoutBranchId number(30,0) not null primary key,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	layoutBranchId number(30,0),
	layoutSetBranchId number(30,0),
	plid number(30,0)
);

create table RecentLayoutRevision (
	mvccVersion number(30,0) default 0 not null,
	recentLayoutRevisionId number(30,0) not null primary key,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	layoutRevisionId number(30,0),
	layoutSetBranchId number(30,0),
	plid number(30,0)
);

create table RecentLayoutSetBranch (
	mvccVersion number(30,0) default 0 not null,
	recentLayoutSetBranchId number(30,0) not null primary key,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	layoutSetBranchId number(30,0),
	layoutSetId number(30,0)
);

create table Region (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	defaultLanguageId VARCHAR2(75 CHAR) null,
	regionId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	countryId number(30,0),
	active_ number(1, 0),
	name VARCHAR2(75 CHAR) null,
	position binary_double,
	regionCode VARCHAR2(75 CHAR) null,
	lastPublishDate timestamp null,
	primary key (regionId, ctCollectionId)
);

create table RegionLocalization (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	regionLocalizationId number(30,0) not null,
	companyId number(30,0),
	regionId number(30,0),
	languageId VARCHAR2(75 CHAR) null,
	title VARCHAR2(75 CHAR) null,
	primary key (regionLocalizationId, ctCollectionId)
);

create table Release_ (
	mvccVersion number(30,0) default 0 not null,
	releaseId number(30,0) not null primary key,
	createDate timestamp null,
	modifiedDate timestamp null,
	servletContextName VARCHAR2(75 CHAR) null,
	schemaVersion VARCHAR2(75 CHAR) null,
	buildNumber number(30,0),
	buildDate timestamp null,
	verified number(1, 0),
	state_ number(30,0),
	testString VARCHAR2(1024 CHAR) null
);

create table RememberMeToken (
	mvccVersion number(30,0) default 0 not null,
	rememberMeTokenId number(30,0) not null primary key,
	companyId number(30,0),
	userId number(30,0),
	createDate timestamp null,
	expirationDate timestamp null,
	value VARCHAR2(255 CHAR) null
);

create table Repository (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	repositoryId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	name VARCHAR2(200 CHAR) null,
	description varchar2(4000 char) null,
	portletId VARCHAR2(200 CHAR) null,
	typeSettings clob null,
	dlFolderId number(30,0),
	lastPublishDate timestamp null,
	primary key (repositoryId, ctCollectionId)
);

create table RepositoryEntry (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	repositoryEntryId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	repositoryId number(30,0),
	mappedId VARCHAR2(255 CHAR) null,
	manualCheckInRequired number(1, 0),
	lastPublishDate timestamp null,
	primary key (repositoryEntryId, ctCollectionId)
);

create table ResourceAction (
	mvccVersion number(30,0) default 0 not null,
	resourceActionId number(30,0) not null primary key,
	name VARCHAR2(255 CHAR) null,
	actionId VARCHAR2(75 CHAR) null,
	bitwiseValue number(30,0)
);

create table ResourcePermission (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	resourcePermissionId number(30,0) not null,
	companyId number(30,0),
	name VARCHAR2(255 CHAR) null,
	scope number(30,0),
	primKey VARCHAR2(255 CHAR) null,
	primKeyId number(30,0),
	roleId number(30,0),
	ownerId number(30,0),
	actionIds number(30,0),
	viewActionId number(1, 0),
	primary key (resourcePermissionId, ctCollectionId)
);

create table Role_ (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	roleId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	name VARCHAR2(75 CHAR) null,
	title varchar2(4000 char) null,
	description clob null,
	type_ number(30,0),
	subtype VARCHAR2(75 CHAR) null,
	primary key (roleId, ctCollectionId)
);

create table ServiceComponent (
	mvccVersion number(30,0) default 0 not null,
	serviceComponentId number(30,0) not null primary key,
	buildNamespace VARCHAR2(75 CHAR) null,
	buildNumber number(30,0),
	buildDate number(30,0),
	data_ clob null
);

create table SocialActivity (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	activityId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	createDate number(30,0),
	activitySetId number(30,0),
	mirrorActivityId number(30,0),
	classNameId number(30,0),
	classPK number(30,0),
	parentClassNameId number(30,0),
	parentClassPK number(30,0),
	type_ number(30,0),
	extraData varchar2(4000 char) null,
	receiverUserId number(30,0),
	primary key (activityId, ctCollectionId)
);

create table SocialActivityAchievement (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	activityAchievementId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	createDate number(30,0),
	name VARCHAR2(75 CHAR) null,
	firstInGroup number(1, 0),
	primary key (activityAchievementId, ctCollectionId)
);

create table SocialActivityCounter (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	activityCounterId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	classNameId number(30,0),
	classPK number(30,0),
	name VARCHAR2(75 CHAR) null,
	ownerType number(30,0),
	currentValue number(30,0),
	totalValue number(30,0),
	graceValue number(30,0),
	startPeriod number(30,0),
	endPeriod number(30,0),
	active_ number(1, 0),
	primary key (activityCounterId, ctCollectionId)
);

create table SocialActivityLimit (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	activityLimitId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	classNameId number(30,0),
	classPK number(30,0),
	activityType number(30,0),
	activityCounterName VARCHAR2(75 CHAR) null,
	value VARCHAR2(75 CHAR) null,
	primary key (activityLimitId, ctCollectionId)
);

create table SocialActivitySet (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	activitySetId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	createDate number(30,0),
	modifiedDate number(30,0),
	classNameId number(30,0),
	classPK number(30,0),
	type_ number(30,0),
	extraData varchar2(4000 char) null,
	activityCount number(30,0),
	primary key (activitySetId, ctCollectionId)
);

create table SocialActivitySetting (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	activitySettingId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	classNameId number(30,0),
	activityType number(30,0),
	name VARCHAR2(75 CHAR) null,
	value VARCHAR2(1024 CHAR) null,
	primary key (activitySettingId, ctCollectionId)
);

create table SocialRelation (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	relationId number(30,0) not null,
	companyId number(30,0),
	createDate number(30,0),
	userId1 number(30,0),
	userId2 number(30,0),
	type_ number(30,0),
	primary key (relationId, ctCollectionId)
);

create table SocialRequest (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	requestId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	createDate number(30,0),
	modifiedDate number(30,0),
	classNameId number(30,0),
	classPK number(30,0),
	type_ number(30,0),
	extraData varchar2(4000 char) null,
	receiverUserId number(30,0),
	status number(30,0),
	primary key (requestId, ctCollectionId)
);

create table SystemEvent (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	systemEventId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	classUuid VARCHAR2(75 CHAR) null,
	referrerClassNameId number(30,0),
	parentSystemEventId number(30,0),
	systemEventSetKey number(30,0),
	type_ number(30,0),
	extraData clob null,
	primary key (systemEventId, ctCollectionId)
);

create table Team (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	teamId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	groupId number(30,0),
	name VARCHAR2(75 CHAR) null,
	description varchar2(4000 char) null,
	lastPublishDate timestamp null,
	primary key (teamId, ctCollectionId)
);

create table Ticket (
	mvccVersion number(30,0) default 0 not null,
	ticketId number(30,0) not null primary key,
	companyId number(30,0),
	createDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	key_ VARCHAR2(255 CHAR) null,
	type_ number(30,0),
	extraInfo clob null,
	expirationDate timestamp null
);

create table UserNotificationDelivery (
	mvccVersion number(30,0) default 0 not null,
	userNotificationDeliveryId number(30,0) not null primary key,
	companyId number(30,0),
	userId number(30,0),
	portletId VARCHAR2(200 CHAR) null,
	classNameId number(30,0),
	notificationType number(30,0),
	deliveryType number(30,0),
	deliver number(1, 0)
);

create table User_ (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	externalReferenceCode VARCHAR2(75 CHAR) null,
	userId number(30,0) not null,
	companyId number(30,0),
	createDate timestamp null,
	modifiedDate timestamp null,
	contactId number(30,0),
	password_ VARCHAR2(255 CHAR) null,
	passwordEncrypted number(1, 0),
	passwordReset number(1, 0),
	passwordModifiedDate timestamp null,
	digest VARCHAR2(255 CHAR) null,
	reminderQueryQuestion VARCHAR2(75 CHAR) null,
	reminderQueryAnswer VARCHAR2(75 CHAR) null,
	graceLoginCount number(30,0),
	screenName VARCHAR2(75 CHAR) null,
	emailAddress VARCHAR2(254 CHAR) null,
	facebookId number(30,0),
	googleUserId VARCHAR2(75 CHAR) null,
	ldapServerId number(30,0),
	openId VARCHAR2(1024 CHAR) null,
	portraitId number(30,0),
	languageId VARCHAR2(75 CHAR) null,
	timeZoneId VARCHAR2(75 CHAR) null,
	greeting VARCHAR2(255 CHAR) null,
	comments varchar2(4000 char) null,
	firstName VARCHAR2(75 CHAR) null,
	middleName VARCHAR2(75 CHAR) null,
	lastName VARCHAR2(75 CHAR) null,
	jobTitle VARCHAR2(100 CHAR) null,
	loginDate timestamp null,
	loginIP VARCHAR2(75 CHAR) null,
	lastLoginDate timestamp null,
	lastLoginIP VARCHAR2(75 CHAR) null,
	lastFailedLoginDate timestamp null,
	failedLoginAttempts number(30,0),
	lockout number(1, 0),
	lockoutDate timestamp null,
	agreedToTermsOfUse number(1, 0),
	emailAddressVerified number(1, 0),
	type_ number(30,0),
	status number(30,0),
	primary key (userId, ctCollectionId)
);

create table UserGroup (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	externalReferenceCode VARCHAR2(75 CHAR) null,
	userGroupId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	parentUserGroupId number(30,0),
	name VARCHAR2(255 CHAR) null,
	description varchar2(4000 char) null,
	addedByLDAPImport number(1, 0),
	primary key (userGroupId, ctCollectionId)
);

create table UserGroupGroupRole (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	userGroupGroupRoleId number(30,0) not null,
	companyId number(30,0),
	userGroupId number(30,0),
	groupId number(30,0),
	roleId number(30,0),
	primary key (userGroupGroupRoleId, ctCollectionId)
);

create table UserGroupRole (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	userGroupRoleId number(30,0) not null,
	companyId number(30,0),
	userId number(30,0),
	groupId number(30,0),
	roleId number(30,0),
	primary key (userGroupRoleId, ctCollectionId)
);

create table UserGroups_Teams (
	companyId number(30,0) not null,
	teamId number(30,0) not null,
	userGroupId number(30,0) not null,
	ctCollectionId number(30,0) default 0 not null,
	ctChangeType number(1, 0),
	primary key (teamId, userGroupId, ctCollectionId)
);

create table UserIdMapper (
	mvccVersion number(30,0) default 0 not null,
	userIdMapperId number(30,0) not null primary key,
	companyId number(30,0),
	userId number(30,0),
	type_ VARCHAR2(75 CHAR) null,
	description VARCHAR2(75 CHAR) null,
	externalUserId VARCHAR2(75 CHAR) null
);

create table UserNotificationEvent (
	mvccVersion number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	userNotificationEventId number(30,0) not null primary key,
	companyId number(30,0),
	userId number(30,0),
	type_ VARCHAR2(200 CHAR) null,
	timestamp number(30,0),
	deliveryType number(30,0),
	deliverBy number(30,0),
	delivered number(1, 0),
	payload clob null,
	actionRequired number(1, 0),
	archived number(1, 0)
);

create table Users_Groups (
	companyId number(30,0) not null,
	groupId number(30,0) not null,
	userId number(30,0) not null,
	ctCollectionId number(30,0) default 0 not null,
	ctChangeType number(1, 0),
	primary key (groupId, userId, ctCollectionId)
);

create table Users_Orgs (
	companyId number(30,0) not null,
	organizationId number(30,0) not null,
	userId number(30,0) not null,
	ctCollectionId number(30,0) default 0 not null,
	ctChangeType number(1, 0),
	primary key (organizationId, userId, ctCollectionId)
);

create table Users_Roles (
	companyId number(30,0) not null,
	roleId number(30,0) not null,
	userId number(30,0) not null,
	ctCollectionId number(30,0) default 0 not null,
	ctChangeType number(1, 0),
	primary key (roleId, userId, ctCollectionId)
);

create table Users_Teams (
	companyId number(30,0) not null,
	teamId number(30,0) not null,
	userId number(30,0) not null,
	ctCollectionId number(30,0) default 0 not null,
	ctChangeType number(1, 0),
	primary key (teamId, userId, ctCollectionId)
);

create table Users_UserGroups (
	companyId number(30,0) not null,
	userId number(30,0) not null,
	userGroupId number(30,0) not null,
	ctCollectionId number(30,0) default 0 not null,
	ctChangeType number(1, 0),
	primary key (userId, userGroupId, ctCollectionId)
);

create table UserTracker (
	mvccVersion number(30,0) default 0 not null,
	userTrackerId number(30,0) not null primary key,
	companyId number(30,0),
	userId number(30,0),
	modifiedDate timestamp null,
	sessionId VARCHAR2(200 CHAR) null,
	remoteAddr VARCHAR2(75 CHAR) null,
	remoteHost VARCHAR2(75 CHAR) null,
	userAgent VARCHAR2(200 CHAR) null
);

create table UserTrackerPath (
	mvccVersion number(30,0) default 0 not null,
	userTrackerPathId number(30,0) not null primary key,
	companyId number(30,0),
	userTrackerId number(30,0),
	path_ varchar2(4000 char) null,
	pathDate timestamp null
);

create table VirtualHost (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	virtualHostId number(30,0) not null,
	companyId number(30,0),
	layoutSetId number(30,0),
	hostname VARCHAR2(200 CHAR) null,
	defaultVirtualHost number(1, 0),
	languageId VARCHAR2(75 CHAR) null,
	primary key (virtualHostId, ctCollectionId)
);

create table WebDAVProps (
	mvccVersion number(30,0) default 0 not null,
	webDavPropsId number(30,0) not null primary key,
	companyId number(30,0),
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	props clob null
);

create table Website (
	mvccVersion number(30,0) default 0 not null,
	uuid_ VARCHAR2(75 CHAR) null,
	websiteId number(30,0) not null primary key,
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	url varchar2(4000 char) null,
	listTypeId number(30,0),
	primary_ number(1, 0),
	lastPublishDate timestamp null
);

create table WorkflowDefinitionLink (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	workflowDefinitionLinkId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	typePK number(30,0),
	workflowDefinitionName VARCHAR2(75 CHAR) null,
	workflowDefinitionVersion number(30,0),
	primary key (workflowDefinitionLinkId, ctCollectionId)
);

create table WorkflowInstanceLink (
	mvccVersion number(30,0) default 0 not null,
	ctCollectionId number(30,0) default 0 not null,
	workflowInstanceLinkId number(30,0) not null,
	groupId number(30,0),
	companyId number(30,0),
	userId number(30,0),
	userName VARCHAR2(75 CHAR) null,
	createDate timestamp null,
	modifiedDate timestamp null,
	classNameId number(30,0),
	classPK number(30,0),
	workflowInstanceId number(30,0),
	primary key (workflowInstanceLinkId, ctCollectionId)
);


insert into Counter (name, currentId) values ('com.liferay.counter.kernel.model.Counter', 20000);



commit;
