create table Address (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	externalReferenceCode nvarchar(75) null,
	addressId bigint not null,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	classNameId bigint,
	classPK bigint,
	countryId bigint,
	listTypeId bigint,
	regionId bigint,
	city nvarchar(75) null,
	description nvarchar(4000) null,
	latitude float,
	longitude float,
	mailing bit,
	name nvarchar(255) null,
	primary_ bit,
	street1 nvarchar(255) null,
	street2 nvarchar(255) null,
	street3 nvarchar(255) null,
	validationDate datetime2(6) null,
	validationStatus int,
	zip nvarchar(75) null,
	primary key (addressId, ctCollectionId)
);

create table AnnouncementsDelivery (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	deliveryId bigint not null,
	companyId bigint,
	userId bigint,
	type_ nvarchar(75) null,
	email bit,
	sms bit,
	website bit,
	primary key (deliveryId, ctCollectionId)
);

create table AnnouncementsEntry (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	entryId bigint not null,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	classNameId bigint,
	classPK bigint,
	title nvarchar(75) null,
	content nvarchar(max) null,
	url nvarchar(4000) null,
	type_ nvarchar(75) null,
	displayDate datetime2(6) null,
	expirationDate datetime2(6) null,
	priority int,
	alert bit,
	primary key (entryId, ctCollectionId)
);

create table AnnouncementsFlag (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	flagId bigint not null,
	companyId bigint,
	userId bigint,
	createDate datetime2(6) null,
	entryId bigint,
	value int,
	primary key (flagId, ctCollectionId)
);

create table AssetCategory (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	externalReferenceCode nvarchar(75) null,
	categoryId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	parentCategoryId bigint,
	treePath nvarchar(4000) null,
	name nvarchar(255) null,
	title nvarchar(max) null,
	description nvarchar(max) null,
	vocabularyId bigint,
	lastPublishDate datetime2(6) null,
	primary key (categoryId, ctCollectionId)
);

create table AssetEntries_AssetTags (
	companyId bigint not null,
	entryId bigint not null,
	tagId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType bit,
	primary key (entryId, tagId, ctCollectionId)
);

create table AssetEntry (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	entryId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	classNameId bigint,
	classPK bigint,
	classUuid nvarchar(75) null,
	classTypeId bigint,
	listable bit,
	visible bit,
	startDate datetime2(6) null,
	endDate datetime2(6) null,
	publishDate datetime2(6) null,
	expirationDate datetime2(6) null,
	mimeType nvarchar(75) null,
	title nvarchar(max) null,
	description nvarchar(max) null,
	summary nvarchar(max) null,
	url nvarchar(4000) null,
	layoutUuid nvarchar(75) null,
	height int,
	width int,
	priority float,
	primary key (entryId, ctCollectionId)
);

create table AssetTag (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	tagId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	name nvarchar(75) null,
	assetCount int,
	lastPublishDate datetime2(6) null,
	primary key (tagId, ctCollectionId)
);

create table AssetVocabulary (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	externalReferenceCode nvarchar(75) null,
	vocabularyId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	name nvarchar(75) null,
	title nvarchar(4000) null,
	description nvarchar(4000) null,
	settings_ nvarchar(4000) null,
	visibilityType int,
	lastPublishDate datetime2(6) null,
	primary key (vocabularyId, ctCollectionId)
);

create table BrowserTracker (
	mvccVersion bigint default 0 not null,
	browserTrackerId bigint not null primary key,
	companyId bigint,
	userId bigint,
	browserKey bigint
);

create table ClassName_ (
	mvccVersion bigint default 0 not null,
	classNameId bigint not null primary key,
	value nvarchar(200) null
);

create table Company (
	mvccVersion bigint default 0 not null,
	companyId bigint not null primary key,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	webId nvarchar(75) null,
	mx nvarchar(200) null,
	homeURL nvarchar(4000) null,
	logoId bigint,
	maxUsers int,
	active_ bit,
	name nvarchar(75) null,
	legalName nvarchar(75) null,
	legalId nvarchar(75) null,
	legalType nvarchar(75) null,
	sicCode nvarchar(75) null,
	tickerSymbol nvarchar(75) null,
	industry nvarchar(75) null,
	type_ nvarchar(75) null,
	size_ nvarchar(75) null,
	indexNameCurrent nvarchar(75) null,
	indexNameNext nvarchar(75) null
);

create table CompanyInfo (
	mvccVersion bigint default 0 not null,
	companyInfoId bigint not null primary key,
	companyId bigint,
	key_ nvarchar(max) null
);

create table Contact_ (
	mvccVersion bigint default 0 not null,
	contactId bigint not null primary key,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	classNameId bigint,
	classPK bigint,
	parentContactId bigint,
	emailAddress nvarchar(254) null,
	firstName nvarchar(75) null,
	middleName nvarchar(75) null,
	lastName nvarchar(75) null,
	prefixListTypeId bigint,
	suffixListTypeId bigint,
	male bit,
	birthday datetime2(6) null,
	smsSn nvarchar(75) null,
	facebookSn nvarchar(75) null,
	jabberSn nvarchar(75) null,
	skypeSn nvarchar(75) null,
	twitterSn nvarchar(75) null,
	employeeStatusId nvarchar(75) null,
	employeeNumber nvarchar(75) null,
	jobTitle nvarchar(100) null,
	jobClass nvarchar(75) null,
	hoursOfOperation nvarchar(75) null
);

create table Counter (
	name nvarchar(150) not null primary key,
	currentId bigint
);

create table Country (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	defaultLanguageId nvarchar(75) null,
	countryId bigint not null,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	a2 nvarchar(75) null,
	a3 nvarchar(75) null,
	active_ bit,
	billingAllowed bit,
	groupFilterEnabled bit,
	idd_ nvarchar(75) null,
	name nvarchar(75) null,
	number_ nvarchar(75) null,
	position float,
	shippingAllowed bit,
	subjectToVAT bit,
	zipRequired bit,
	lastPublishDate datetime2(6) null,
	primary key (countryId, ctCollectionId)
);

create table CountryLocalization (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	countryLocalizationId bigint not null,
	companyId bigint,
	countryId bigint,
	languageId nvarchar(75) null,
	title nvarchar(75) null,
	primary key (countryLocalizationId, ctCollectionId)
);

create table DLFileEntry (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	externalReferenceCode nvarchar(75) null,
	fileEntryId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	classNameId bigint,
	classPK bigint,
	repositoryId bigint,
	folderId bigint,
	treePath nvarchar(4000) null,
	name nvarchar(255) null,
	fileName nvarchar(255) null,
	extension nvarchar(75) null,
	mimeType nvarchar(75) null,
	title nvarchar(255) null,
	description nvarchar(4000) null,
	extraSettings nvarchar(max) null,
	fileEntryTypeId bigint,
	version nvarchar(75) null,
	size_ bigint,
	smallImageId bigint,
	largeImageId bigint,
	custom1ImageId bigint,
	custom2ImageId bigint,
	manualCheckInRequired bit,
	displayDate datetime2(6) null,
	expirationDate datetime2(6) null,
	reviewDate datetime2(6) null,
	lastPublishDate datetime2(6) null,
	primary key (fileEntryId, ctCollectionId)
);

create table DLFileEntryMetadata (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	fileEntryMetadataId bigint not null,
	companyId bigint,
	DDMStorageId bigint,
	DDMStructureId bigint,
	fileEntryId bigint,
	fileVersionId bigint,
	primary key (fileEntryMetadataId, ctCollectionId)
);

create table DLFileEntryType (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	fileEntryTypeId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	dataDefinitionId bigint,
	fileEntryTypeKey nvarchar(75) null,
	name nvarchar(4000) null,
	description nvarchar(4000) null,
	scope int,
	lastPublishDate datetime2(6) null,
	primary key (fileEntryTypeId, ctCollectionId)
);

create table DLFileEntryTypes_DLFolders (
	companyId bigint not null,
	fileEntryTypeId bigint not null,
	folderId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType bit,
	primary key (fileEntryTypeId, folderId, ctCollectionId)
);

create table DLFileShortcut (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	fileShortcutId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	repositoryId bigint,
	folderId bigint,
	toFileEntryId bigint,
	treePath nvarchar(4000) null,
	active_ bit,
	lastPublishDate datetime2(6) null,
	status int,
	statusByUserId bigint,
	statusByUserName nvarchar(75) null,
	statusDate datetime2(6) null,
	primary key (fileShortcutId, ctCollectionId)
);

create table DLFileVersion (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	fileVersionId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	repositoryId bigint,
	folderId bigint,
	fileEntryId bigint,
	treePath nvarchar(4000) null,
	fileName nvarchar(255) null,
	extension nvarchar(75) null,
	mimeType nvarchar(75) null,
	title nvarchar(255) null,
	description nvarchar(4000) null,
	changeLog nvarchar(75) null,
	extraSettings nvarchar(max) null,
	fileEntryTypeId bigint,
	version nvarchar(75) null,
	size_ bigint,
	checksum nvarchar(75) null,
	storeUUID nvarchar(255) null,
	displayDate datetime2(6) null,
	expirationDate datetime2(6) null,
	reviewDate datetime2(6) null,
	lastPublishDate datetime2(6) null,
	status int,
	statusByUserId bigint,
	statusByUserName nvarchar(75) null,
	statusDate datetime2(6) null,
	primary key (fileVersionId, ctCollectionId)
);

create table DLFolder (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	externalReferenceCode nvarchar(75) null,
	folderId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	repositoryId bigint,
	mountPoint bit,
	parentFolderId bigint,
	treePath nvarchar(4000) null,
	name nvarchar(255) null,
	description nvarchar(4000) null,
	lastPostDate datetime2(6) null,
	defaultFileEntryTypeId bigint,
	hidden_ bit,
	restrictionType int,
	lastPublishDate datetime2(6) null,
	status int,
	statusByUserId bigint,
	statusByUserName nvarchar(75) null,
	statusDate datetime2(6) null,
	primary key (folderId, ctCollectionId)
);

create table EmailAddress (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	emailAddressId bigint not null,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	classNameId bigint,
	classPK bigint,
	address nvarchar(254) null,
	listTypeId bigint,
	primary_ bit,
	primary key (emailAddressId, ctCollectionId)
);

create table ExpandoColumn (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	columnId bigint not null,
	companyId bigint,
	modifiedDate datetime2(6) null,
	tableId bigint,
	name nvarchar(75) null,
	type_ int,
	defaultData nvarchar(max) null,
	typeSettings nvarchar(max) null,
	primary key (columnId, ctCollectionId)
);

create table ExpandoRow (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	rowId_ bigint not null,
	companyId bigint,
	modifiedDate datetime2(6) null,
	tableId bigint,
	classPK bigint,
	primary key (rowId_, ctCollectionId)
);

create table ExpandoTable (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	tableId bigint not null,
	companyId bigint,
	classNameId bigint,
	name nvarchar(75) null,
	primary key (tableId, ctCollectionId)
);

create table ExpandoValue (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	valueId bigint not null,
	companyId bigint,
	tableId bigint,
	columnId bigint,
	rowId_ bigint,
	classNameId bigint,
	classPK bigint,
	data_ nvarchar(max) null,
	primary key (valueId, ctCollectionId)
);

create table ExportImportConfiguration (
	mvccVersion bigint default 0 not null,
	exportImportConfigurationId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	name nvarchar(200) null,
	description nvarchar(4000) null,
	type_ int,
	settings_ nvarchar(max) null,
	status int,
	statusByUserId bigint,
	statusByUserName nvarchar(75) null,
	statusDate datetime2(6) null
);

create table Group_ (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	externalReferenceCode nvarchar(75) null,
	groupId bigint not null,
	companyId bigint,
	creatorUserId bigint,
	modifiedDate datetime2(6) null,
	classNameId bigint,
	classPK bigint,
	parentGroupId bigint,
	liveGroupId bigint,
	treePath nvarchar(4000) null,
	groupKey nvarchar(150) null,
	name nvarchar(4000) null,
	description nvarchar(4000) null,
	type_ int,
	typeSettings nvarchar(max) null,
	manualMembership bit,
	membershipRestriction int,
	friendlyURL nvarchar(255) null,
	site bit,
	remoteStagingGroupCount int,
	inheritContent bit,
	active_ bit,
	primary key (groupId, ctCollectionId)
);

create table Groups_Orgs (
	companyId bigint not null,
	groupId bigint not null,
	organizationId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType bit,
	primary key (groupId, organizationId, ctCollectionId)
);

create table Groups_Roles (
	companyId bigint not null,
	groupId bigint not null,
	roleId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType bit,
	primary key (groupId, roleId, ctCollectionId)
);

create table Groups_UserGroups (
	companyId bigint not null,
	groupId bigint not null,
	userGroupId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType bit,
	primary key (groupId, userGroupId, ctCollectionId)
);

create table Image (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	imageId bigint not null,
	companyId bigint,
	modifiedDate datetime2(6) null,
	type_ nvarchar(75) null,
	height int,
	width int,
	size_ int,
	primary key (imageId, ctCollectionId)
);

create table Layout (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	externalReferenceCode nvarchar(75) null,
	plid bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	parentPlid bigint,
	privateLayout bit,
	layoutId bigint,
	parentLayoutId bigint,
	classNameId bigint,
	classPK bigint,
	name nvarchar(4000) null,
	title nvarchar(max) null,
	description nvarchar(max) null,
	keywords nvarchar(4000) null,
	robots nvarchar(4000) null,
	type_ nvarchar(75) null,
	typeSettings nvarchar(max) null,
	hidden_ bit,
	system_ bit,
	friendlyURL nvarchar(255) null,
	iconImageId bigint,
	themeId nvarchar(75) null,
	colorSchemeId nvarchar(75) null,
	styleBookEntryId bigint,
	css nvarchar(max) null,
	priority int,
	faviconFileEntryId bigint,
	masterLayoutPlid bigint,
	layoutPrototypeUuid nvarchar(75) null,
	layoutPrototypeLinkEnabled bit,
	sourcePrototypeLayoutUuid nvarchar(75) null,
	publishDate datetime2(6) null,
	lastPublishDate datetime2(6) null,
	status int,
	statusByUserId bigint,
	statusByUserName nvarchar(75) null,
	statusDate datetime2(6) null,
	primary key (plid, ctCollectionId)
);

create table LayoutBranch (
	mvccVersion bigint default 0 not null,
	layoutBranchId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	layoutSetBranchId bigint,
	plid bigint,
	name nvarchar(75) null,
	description nvarchar(4000) null,
	master bit
);

create table LayoutFriendlyURL (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	layoutFriendlyURLId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	plid bigint,
	privateLayout bit,
	friendlyURL nvarchar(255) null,
	languageId nvarchar(75) null,
	lastPublishDate datetime2(6) null,
	primary key (layoutFriendlyURLId, ctCollectionId)
);

create table LayoutPrototype (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	layoutPrototypeId bigint not null,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	name nvarchar(max) null,
	description nvarchar(max) null,
	settings_ nvarchar(4000) null,
	active_ bit,
	primary key (layoutPrototypeId, ctCollectionId)
);

create table LayoutRevision (
	mvccVersion bigint default 0 not null,
	layoutRevisionId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	layoutSetBranchId bigint,
	layoutBranchId bigint,
	parentLayoutRevisionId bigint,
	head bit,
	major bit,
	plid bigint,
	privateLayout bit,
	name nvarchar(4000) null,
	title nvarchar(4000) null,
	description nvarchar(4000) null,
	keywords nvarchar(4000) null,
	robots nvarchar(4000) null,
	typeSettings nvarchar(max) null,
	iconImageId bigint,
	themeId nvarchar(75) null,
	colorSchemeId nvarchar(75) null,
	css nvarchar(max) null,
	status int,
	statusByUserId bigint,
	statusByUserName nvarchar(75) null,
	statusDate datetime2(6) null
);

create table LayoutSet (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	layoutSetId bigint not null,
	groupId bigint,
	companyId bigint,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	privateLayout bit,
	logoId bigint,
	themeId nvarchar(75) null,
	colorSchemeId nvarchar(75) null,
	faviconFileEntryId bigint,
	css nvarchar(max) null,
	settings_ nvarchar(max) null,
	layoutSetPrototypeUuid nvarchar(75) null,
	layoutSetPrototypeLinkEnabled bit,
	primary key (layoutSetId, ctCollectionId)
);

create table LayoutSetBranch (
	mvccVersion bigint default 0 not null,
	layoutSetBranchId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	privateLayout bit,
	name nvarchar(75) null,
	description nvarchar(4000) null,
	master bit,
	logoId bigint,
	themeId nvarchar(75) null,
	colorSchemeId nvarchar(75) null,
	css nvarchar(max) null,
	settings_ nvarchar(max) null,
	layoutSetPrototypeUuid nvarchar(75) null,
	layoutSetPrototypeLinkEnabled bit
);

create table LayoutSetPrototype (
	mvccVersion bigint default 0 not null,
	uuid_ nvarchar(75) null,
	layoutSetPrototypeId bigint not null primary key,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	name nvarchar(max) null,
	description nvarchar(max) null,
	settings_ nvarchar(4000) null,
	active_ bit
);

create table ListType (
	mvccVersion bigint default 0 not null,
	uuid_ nvarchar(75) null,
	listTypeId bigint not null primary key,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	name nvarchar(75) null,
	type_ nvarchar(75) null
);

create table MembershipRequest (
	mvccVersion bigint default 0 not null,
	membershipRequestId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	createDate datetime2(6) null,
	comments nvarchar(4000) null,
	replyComments nvarchar(4000) null,
	replyDate datetime2(6) null,
	replierUserId bigint,
	statusId bigint
);

create table OrgLabor (
	mvccVersion bigint default 0 not null,
	orgLaborId bigint not null primary key,
	companyId bigint,
	organizationId bigint,
	listTypeId bigint,
	sunOpen int,
	sunClose int,
	monOpen int,
	monClose int,
	tueOpen int,
	tueClose int,
	wedOpen int,
	wedClose int,
	thuOpen int,
	thuClose int,
	friOpen int,
	friClose int,
	satOpen int,
	satClose int
);

create table Organization_ (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	externalReferenceCode nvarchar(75) null,
	organizationId bigint not null,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	parentOrganizationId bigint,
	treePath nvarchar(4000) null,
	name nvarchar(100) null,
	type_ nvarchar(75) null,
	recursable bit,
	regionId bigint,
	countryId bigint,
	statusListTypeId bigint,
	comments nvarchar(4000) null,
	logoId bigint,
	primary key (organizationId, ctCollectionId)
);

create table PasswordPolicy (
	mvccVersion bigint default 0 not null,
	uuid_ nvarchar(75) null,
	passwordPolicyId bigint not null primary key,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	defaultPolicy bit,
	name nvarchar(75) null,
	description nvarchar(4000) null,
	changeable bit,
	changeRequired bit,
	minAge bigint,
	checkSyntax bit,
	allowDictionaryWords bit,
	minAlphanumeric int,
	minLength int,
	minLowerCase int,
	minNumbers int,
	minSymbols int,
	minUpperCase int,
	regex nvarchar(4000) null,
	history bit,
	historyCount int,
	expireable bit,
	maxAge bigint,
	warningTime bigint,
	graceLimit int,
	lockout bit,
	maxFailure int,
	lockoutDuration bigint,
	requireUnlock bit,
	resetFailureCount bigint,
	resetTicketMaxAge bigint
);

create table PasswordPolicyRel (
	mvccVersion bigint default 0 not null,
	passwordPolicyRelId bigint not null primary key,
	companyId bigint,
	passwordPolicyId bigint,
	classNameId bigint,
	classPK bigint
);

create table PasswordTracker (
	mvccVersion bigint default 0 not null,
	passwordTrackerId bigint not null primary key,
	companyId bigint,
	userId bigint,
	createDate datetime2(6) null,
	password_ nvarchar(255) null
);

create table Phone (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	phoneId bigint not null,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	classNameId bigint,
	classPK bigint,
	number_ nvarchar(75) null,
	extension nvarchar(75) null,
	listTypeId bigint,
	primary_ bit,
	primary key (phoneId, ctCollectionId)
);

create table PluginSetting (
	mvccVersion bigint default 0 not null,
	pluginSettingId bigint not null primary key,
	companyId bigint,
	pluginId nvarchar(75) null,
	pluginType nvarchar(75) null,
	roles nvarchar(4000) null,
	active_ bit
);

create table PortalPreferenceValue (
	mvccVersion bigint default 0 not null,
	portalPreferenceValueId bigint not null primary key,
	companyId bigint,
	portalPreferencesId bigint,
	index_ int,
	key_ nvarchar(1024) null,
	largeValue nvarchar(max) null,
	namespace nvarchar(255) null,
	smallValue nvarchar(255) null
);

create table PortalPreferences (
	mvccVersion bigint default 0 not null,
	portalPreferencesId bigint not null primary key,
	companyId bigint,
	ownerId bigint,
	ownerType int
);

create table Portlet (
	mvccVersion bigint default 0 not null,
	id_ bigint not null primary key,
	companyId bigint,
	portletId nvarchar(200) null,
	roles nvarchar(4000) null,
	active_ bit
);

create table PortletItem (
	mvccVersion bigint default 0 not null,
	portletItemId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	name nvarchar(75) null,
	portletId nvarchar(200) null,
	classNameId bigint
);

create table PortletPreferenceValue (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	portletPreferenceValueId bigint not null,
	companyId bigint,
	portletPreferencesId bigint,
	index_ int,
	largeValue nvarchar(max) null,
	name nvarchar(255) null,
	readOnly bit,
	smallValue nvarchar(255) null,
	primary key (portletPreferenceValueId, ctCollectionId)
);

create table PortletPreferences (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	portletPreferencesId bigint not null,
	companyId bigint,
	ownerId bigint,
	ownerType int,
	plid bigint,
	portletId nvarchar(200) null,
	primary key (portletPreferencesId, ctCollectionId)
);

create table RatingsEntry (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	entryId bigint not null,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	classNameId bigint,
	classPK bigint,
	score float,
	primary key (entryId, ctCollectionId)
);

create table RatingsStats (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	statsId bigint not null,
	companyId bigint,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	classNameId bigint,
	classPK bigint,
	totalEntries int,
	totalScore float,
	averageScore float,
	primary key (statsId, ctCollectionId)
);

create table RecentLayoutBranch (
	mvccVersion bigint default 0 not null,
	recentLayoutBranchId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	layoutBranchId bigint,
	layoutSetBranchId bigint,
	plid bigint
);

create table RecentLayoutRevision (
	mvccVersion bigint default 0 not null,
	recentLayoutRevisionId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	layoutRevisionId bigint,
	layoutSetBranchId bigint,
	plid bigint
);

create table RecentLayoutSetBranch (
	mvccVersion bigint default 0 not null,
	recentLayoutSetBranchId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	layoutSetBranchId bigint,
	layoutSetId bigint
);

create table Region (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	defaultLanguageId nvarchar(75) null,
	regionId bigint not null,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	countryId bigint,
	active_ bit,
	name nvarchar(75) null,
	position float,
	regionCode nvarchar(75) null,
	lastPublishDate datetime2(6) null,
	primary key (regionId, ctCollectionId)
);

create table RegionLocalization (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	regionLocalizationId bigint not null,
	companyId bigint,
	regionId bigint,
	languageId nvarchar(75) null,
	title nvarchar(75) null,
	primary key (regionLocalizationId, ctCollectionId)
);

create table Release_ (
	mvccVersion bigint default 0 not null,
	releaseId bigint not null primary key,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	servletContextName nvarchar(75) null,
	schemaVersion nvarchar(75) null,
	buildNumber int,
	buildDate datetime2(6) null,
	verified bit,
	state_ int,
	testString nvarchar(1024) null
);

create table RememberMeToken (
	mvccVersion bigint default 0 not null,
	rememberMeTokenId bigint not null primary key,
	companyId bigint,
	userId bigint,
	createDate datetime2(6) null,
	expirationDate datetime2(6) null,
	value nvarchar(255) null
);

create table Repository (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	repositoryId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	classNameId bigint,
	name nvarchar(200) null,
	description nvarchar(4000) null,
	portletId nvarchar(200) null,
	typeSettings nvarchar(max) null,
	dlFolderId bigint,
	lastPublishDate datetime2(6) null,
	primary key (repositoryId, ctCollectionId)
);

create table RepositoryEntry (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	repositoryEntryId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	repositoryId bigint,
	mappedId nvarchar(255) null,
	manualCheckInRequired bit,
	lastPublishDate datetime2(6) null,
	primary key (repositoryEntryId, ctCollectionId)
);

create table ResourceAction (
	mvccVersion bigint default 0 not null,
	resourceActionId bigint not null primary key,
	name nvarchar(255) null,
	actionId nvarchar(75) null,
	bitwiseValue bigint
);

create table ResourcePermission (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	resourcePermissionId bigint not null,
	companyId bigint,
	name nvarchar(255) null,
	scope int,
	primKey nvarchar(255) null,
	primKeyId bigint,
	roleId bigint,
	ownerId bigint,
	actionIds bigint,
	viewActionId bit,
	primary key (resourcePermissionId, ctCollectionId)
);

create table Role_ (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	roleId bigint not null,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	classNameId bigint,
	classPK bigint,
	name nvarchar(75) null,
	title nvarchar(4000) null,
	description nvarchar(max) null,
	type_ int,
	subtype nvarchar(75) null,
	primary key (roleId, ctCollectionId)
);

create table ServiceComponent (
	mvccVersion bigint default 0 not null,
	serviceComponentId bigint not null primary key,
	buildNamespace nvarchar(75) null,
	buildNumber bigint,
	buildDate bigint,
	data_ nvarchar(max) null
);

create table SocialActivity (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	activityId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	createDate bigint,
	activitySetId bigint,
	mirrorActivityId bigint,
	classNameId bigint,
	classPK bigint,
	parentClassNameId bigint,
	parentClassPK bigint,
	type_ int,
	extraData nvarchar(4000) null,
	receiverUserId bigint,
	primary key (activityId, ctCollectionId)
);

create table SocialActivityAchievement (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	activityAchievementId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	createDate bigint,
	name nvarchar(75) null,
	firstInGroup bit,
	primary key (activityAchievementId, ctCollectionId)
);

create table SocialActivityCounter (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	activityCounterId bigint not null,
	groupId bigint,
	companyId bigint,
	classNameId bigint,
	classPK bigint,
	name nvarchar(75) null,
	ownerType int,
	currentValue int,
	totalValue int,
	graceValue int,
	startPeriod int,
	endPeriod int,
	active_ bit,
	primary key (activityCounterId, ctCollectionId)
);

create table SocialActivityLimit (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	activityLimitId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	classNameId bigint,
	classPK bigint,
	activityType int,
	activityCounterName nvarchar(75) null,
	value nvarchar(75) null,
	primary key (activityLimitId, ctCollectionId)
);

create table SocialActivitySet (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	activitySetId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	createDate bigint,
	modifiedDate bigint,
	classNameId bigint,
	classPK bigint,
	type_ int,
	extraData nvarchar(4000) null,
	activityCount int,
	primary key (activitySetId, ctCollectionId)
);

create table SocialActivitySetting (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	activitySettingId bigint not null,
	groupId bigint,
	companyId bigint,
	classNameId bigint,
	activityType int,
	name nvarchar(75) null,
	value nvarchar(1024) null,
	primary key (activitySettingId, ctCollectionId)
);

create table SocialRelation (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	relationId bigint not null,
	companyId bigint,
	createDate bigint,
	userId1 bigint,
	userId2 bigint,
	type_ int,
	primary key (relationId, ctCollectionId)
);

create table SocialRequest (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	requestId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	createDate bigint,
	modifiedDate bigint,
	classNameId bigint,
	classPK bigint,
	type_ int,
	extraData nvarchar(4000) null,
	receiverUserId bigint,
	status int,
	primary key (requestId, ctCollectionId)
);

create table SystemEvent (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	systemEventId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	classNameId bigint,
	classPK bigint,
	classUuid nvarchar(75) null,
	referrerClassNameId bigint,
	parentSystemEventId bigint,
	systemEventSetKey bigint,
	type_ int,
	extraData nvarchar(max) null,
	primary key (systemEventId, ctCollectionId)
);

create table Team (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	teamId bigint not null,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	groupId bigint,
	name nvarchar(75) null,
	description nvarchar(4000) null,
	lastPublishDate datetime2(6) null,
	primary key (teamId, ctCollectionId)
);

create table Ticket (
	mvccVersion bigint default 0 not null,
	ticketId bigint not null primary key,
	companyId bigint,
	createDate datetime2(6) null,
	classNameId bigint,
	classPK bigint,
	key_ nvarchar(255) null,
	type_ int,
	extraInfo nvarchar(max) null,
	expirationDate datetime2(6) null
);

create table UserNotificationDelivery (
	mvccVersion bigint default 0 not null,
	userNotificationDeliveryId bigint not null primary key,
	companyId bigint,
	userId bigint,
	portletId nvarchar(200) null,
	classNameId bigint,
	notificationType int,
	deliveryType int,
	deliver bit
);

create table User_ (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	externalReferenceCode nvarchar(75) null,
	userId bigint not null,
	companyId bigint,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	contactId bigint,
	password_ nvarchar(255) null,
	passwordEncrypted bit,
	passwordReset bit,
	passwordModifiedDate datetime2(6) null,
	digest nvarchar(255) null,
	reminderQueryQuestion nvarchar(75) null,
	reminderQueryAnswer nvarchar(75) null,
	graceLoginCount int,
	screenName nvarchar(75) null,
	emailAddress nvarchar(254) null,
	facebookId bigint,
	googleUserId nvarchar(75) null,
	ldapServerId bigint,
	openId nvarchar(1024) null,
	portraitId bigint,
	languageId nvarchar(75) null,
	timeZoneId nvarchar(75) null,
	greeting nvarchar(255) null,
	comments nvarchar(4000) null,
	firstName nvarchar(75) null,
	middleName nvarchar(75) null,
	lastName nvarchar(75) null,
	jobTitle nvarchar(100) null,
	loginDate datetime2(6) null,
	loginIP nvarchar(75) null,
	lastLoginDate datetime2(6) null,
	lastLoginIP nvarchar(75) null,
	lastFailedLoginDate datetime2(6) null,
	failedLoginAttempts int,
	lockout bit,
	lockoutDate datetime2(6) null,
	agreedToTermsOfUse bit,
	emailAddressVerified bit,
	type_ int,
	status int,
	primary key (userId, ctCollectionId)
);

create table UserGroup (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	uuid_ nvarchar(75) null,
	externalReferenceCode nvarchar(75) null,
	userGroupId bigint not null,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	parentUserGroupId bigint,
	name nvarchar(255) null,
	description nvarchar(4000) null,
	addedByLDAPImport bit,
	primary key (userGroupId, ctCollectionId)
);

create table UserGroupGroupRole (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	userGroupGroupRoleId bigint not null,
	companyId bigint,
	userGroupId bigint,
	groupId bigint,
	roleId bigint,
	primary key (userGroupGroupRoleId, ctCollectionId)
);

create table UserGroupRole (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	userGroupRoleId bigint not null,
	companyId bigint,
	userId bigint,
	groupId bigint,
	roleId bigint,
	primary key (userGroupRoleId, ctCollectionId)
);

create table UserGroups_Teams (
	companyId bigint not null,
	teamId bigint not null,
	userGroupId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType bit,
	primary key (teamId, userGroupId, ctCollectionId)
);

create table UserIdMapper (
	mvccVersion bigint default 0 not null,
	userIdMapperId bigint not null primary key,
	companyId bigint,
	userId bigint,
	type_ nvarchar(75) null,
	description nvarchar(75) null,
	externalUserId nvarchar(75) null
);

create table UserNotificationEvent (
	mvccVersion bigint default 0 not null,
	uuid_ nvarchar(75) null,
	userNotificationEventId bigint not null primary key,
	companyId bigint,
	userId bigint,
	type_ nvarchar(200) null,
	timestamp bigint,
	deliveryType int,
	deliverBy bigint,
	delivered bit,
	payload nvarchar(max) null,
	actionRequired bit,
	archived bit
);

create table Users_Groups (
	companyId bigint not null,
	groupId bigint not null,
	userId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType bit,
	primary key (groupId, userId, ctCollectionId)
);

create table Users_Orgs (
	companyId bigint not null,
	organizationId bigint not null,
	userId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType bit,
	primary key (organizationId, userId, ctCollectionId)
);

create table Users_Roles (
	companyId bigint not null,
	roleId bigint not null,
	userId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType bit,
	primary key (roleId, userId, ctCollectionId)
);

create table Users_Teams (
	companyId bigint not null,
	teamId bigint not null,
	userId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType bit,
	primary key (teamId, userId, ctCollectionId)
);

create table Users_UserGroups (
	companyId bigint not null,
	userId bigint not null,
	userGroupId bigint not null,
	ctCollectionId bigint default 0 not null,
	ctChangeType bit,
	primary key (userId, userGroupId, ctCollectionId)
);

create table UserTracker (
	mvccVersion bigint default 0 not null,
	userTrackerId bigint not null primary key,
	companyId bigint,
	userId bigint,
	modifiedDate datetime2(6) null,
	sessionId nvarchar(200) null,
	remoteAddr nvarchar(75) null,
	remoteHost nvarchar(75) null,
	userAgent nvarchar(200) null
);

create table UserTrackerPath (
	mvccVersion bigint default 0 not null,
	userTrackerPathId bigint not null primary key,
	companyId bigint,
	userTrackerId bigint,
	path_ nvarchar(4000) null,
	pathDate datetime2(6) null
);

create table VirtualHost (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	virtualHostId bigint not null,
	companyId bigint,
	layoutSetId bigint,
	hostname nvarchar(200) null,
	defaultVirtualHost bit,
	languageId nvarchar(75) null,
	primary key (virtualHostId, ctCollectionId)
);

create table WebDAVProps (
	mvccVersion bigint default 0 not null,
	webDavPropsId bigint not null primary key,
	companyId bigint,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	classNameId bigint,
	classPK bigint,
	props nvarchar(max) null
);

create table Website (
	mvccVersion bigint default 0 not null,
	uuid_ nvarchar(75) null,
	websiteId bigint not null primary key,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	classNameId bigint,
	classPK bigint,
	url nvarchar(4000) null,
	listTypeId bigint,
	primary_ bit,
	lastPublishDate datetime2(6) null
);

create table WorkflowDefinitionLink (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	workflowDefinitionLinkId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	classNameId bigint,
	classPK bigint,
	typePK bigint,
	workflowDefinitionName nvarchar(75) null,
	workflowDefinitionVersion int,
	primary key (workflowDefinitionLinkId, ctCollectionId)
);

create table WorkflowInstanceLink (
	mvccVersion bigint default 0 not null,
	ctCollectionId bigint default 0 not null,
	workflowInstanceLinkId bigint not null,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime2(6) null,
	modifiedDate datetime2(6) null,
	classNameId bigint,
	classPK bigint,
	workflowInstanceId bigint,
	primary key (workflowInstanceLinkId, ctCollectionId)
);


insert into Counter (name, currentId) values ('com.liferay.counter.kernel.model.Counter', 20000);



go
