/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.db;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DBInspector {
    private static final Log _log = LogFactoryUtil.getLog(DBInspector.class);
    private static final Pattern _columnDefaultClausePattern = Pattern.compile(".*DEFAULT ((?:'[^']+')|(?:\\S+)) NOT NULL", 2);
    private static final Pattern _columnSizePattern = Pattern.compile("^\\w+(?:\\((\\d+)\\))?.*", 2);
    private static final Pattern _columnTypePattern = Pattern.compile("(^\\w+)", 2);
    private static final Set<String> _controlTableNames = new HashSet<String>(Arrays.asList("company", "release_", "servicecomponent", "virtualhost"));
    private static final Set<String> _partitionedControlTableNames = new HashSet<String>(Arrays.asList("classname_", "counter", "resourceaction"));
    private final Connection _connection;

    public DBInspector(Connection connection) {
        this._connection = connection;
    }

    public String getCatalog() throws SQLException {
        return this._connection.getCatalog();
    }

    public ResultSet getColumnsResultSet(String tableName) throws SQLException {
        return this._getColumnsResultSet(tableName, null);
    }

    public String getSchema() {
        try {
            return this._connection.getSchema();
        }
        catch (Throwable throwable) {
            if (_log.isDebugEnabled()) {
                _log.debug(throwable, throwable);
            }
            return null;
        }
    }

    public List<String> getTableNames(String tableNamePattern) throws SQLException {
        ArrayList<String> tableNames = new ArrayList<String>();
        DatabaseMetaData databaseMetaData = this._connection.getMetaData();
        try (ResultSet resultSet = databaseMetaData.getTables(this._connection.getCatalog(), this._connection.getSchema(), tableNamePattern, new String[]{"TABLE"});){
            while (resultSet.next()) {
                tableNames.add(resultSet.getString("TABLE_NAME"));
            }
        }
        return tableNames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasColumn(String tableName, String columnName) throws Exception {
        try (ResultSet resultSet = this._getColumnsResultSet(tableName, columnName);){
            if (!resultSet.next()) {
                boolean bl2 = false;
                return bl2;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            _log.error(exception);
            return false;
        }
    }

    public boolean hasColumnType(String tableName, String columnName, String columnType) throws Exception {
        try (ResultSet resultSet = this._getColumnsResultSet(tableName, columnName);){
            if (!resultSet.next()) {
                boolean bl = false;
                return bl;
            }
            int expectedColumnSize = this._getColumnSize(columnType);
            int actualColumnSize = resultSet.getInt("COLUMN_SIZE");
            if (expectedColumnSize != -1 && (expectedColumnSize != Integer.MAX_VALUE && expectedColumnSize != actualColumnSize || expectedColumnSize == Integer.MAX_VALUE && actualColumnSize < 9999999)) {
                boolean bl = false;
                return bl;
            }
            Integer expectedColumnDataType = this._getByColumnType(columnType, DB::getSQLType);
            int actualColumnDataType = resultSet.getInt("DATA_TYPE");
            if (expectedColumnDataType == null || expectedColumnDataType != actualColumnDataType) {
                boolean bl = false;
                return bl;
            }
            Integer expectedColumnDecimalDigits = this._getByColumnType(columnType, DB::getSQLTypeDecimalDigits);
            if (expectedColumnDecimalDigits != -1) {
                int actualColumnDecimalDigits = resultSet.getInt("DECIMAL_DIGITS");
                if (expectedColumnDecimalDigits != actualColumnDecimalDigits) {
                    boolean bl = false;
                    return bl;
                }
            }
            boolean expectedColumnNullable = this._isColumnNullable(columnType);
            int actualColumnNullable = resultSet.getInt("NULLABLE");
            if (expectedColumnNullable && actualColumnNullable != 1 || !expectedColumnNullable && actualColumnNullable != 0) {
                boolean bl = false;
                return bl;
            }
            if (!expectedColumnNullable) {
                String expectedColumnDefaultValue = this._getColumnDefaultValue(columnType);
                String actualColumnDefaultValue = this._getColumnDefaultValue(resultSet.getString("COLUMN_DEF"), DB::getDefaultValue);
                if (Validator.isNull((String)expectedColumnDefaultValue) && Validator.isNull((String)actualColumnDefaultValue)) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = StringUtil.equals(expectedColumnDefaultValue, actualColumnDefaultValue);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasIndex(String tableName, String indexName) throws Exception {
        DB db = DBManagerUtil.getDB();
        DatabaseMetaData databaseMetaData = this._connection.getMetaData();
        try (ResultSet resultSet = db.getIndexResultSet(this._connection, this.normalizeName(tableName, databaseMetaData), false);){
            do {
                if (!resultSet.next()) return false;
            } while (!Objects.equals(this.normalizeName(indexName, databaseMetaData), resultSet.getString("index_name")));
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            _log.error(exception);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasRows(String tableName) {
        try (PreparedStatement preparedStatement = this._connection.prepareStatement("select count(*) from " + tableName);
             ResultSet resultSet = preparedStatement.executeQuery();){
            int count;
            do {
                if (!resultSet.next()) return false;
            } while ((count = resultSet.getInt(1)) <= 0);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            _log.error(exception);
        }
        return false;
    }

    public boolean hasTable(String tableName) throws Exception {
        return this._hasElement(tableName, "TABLE");
    }

    @Deprecated
    public boolean hasTable(String tableName, boolean caseSensitive) throws Exception {
        return this._hasElement(tableName, "TABLE");
    }

    public boolean hasView(String viewName) throws Exception {
        return this._hasElement(viewName, "VIEW");
    }

    public boolean isControlTable(String tableName) {
        return _controlTableNames.contains(StringUtil.toLowerCase(tableName)) || StringUtil.toLowerCase(tableName).startsWith("quartz");
    }

    public boolean isNullable(String tableName, String columnName) throws SQLException {
        try (ResultSet resultSet = this._getColumnsResultSet(tableName, columnName);){
            if (!resultSet.next()) {
                throw new SQLException(StringBundler.concat("Column ", tableName, ".", columnName, " does not exist"));
            }
            if (resultSet.getInt("NULLABLE") == 1) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean isObjectTable(List<Long> companyIds, String tableName) {
        for (long companyId : companyIds) {
            if (!tableName.endsWith("_x_" + companyId) && !tableName.startsWith("L_" + companyId + "_") && !tableName.startsWith("O_" + companyId + "_") && !tableName.startsWith("R_")) continue;
            return true;
        }
        return false;
    }

    public boolean isPartitionedControlTable(String tableName) {
        return _partitionedControlTableNames.contains(StringUtil.toLowerCase(tableName));
    }

    public String normalizeName(String name) throws SQLException {
        return this.normalizeName(name, this._connection.getMetaData());
    }

    public String normalizeName(String name, DatabaseMetaData databaseMetaData) throws SQLException {
        if (databaseMetaData.storesLowerCaseIdentifiers()) {
            return StringUtil.toLowerCase(name);
        }
        if (databaseMetaData.storesUpperCaseIdentifiers()) {
            return StringUtil.toUpperCase(name);
        }
        return name;
    }

    private Integer _getByColumnType(String columnType, BiFunction<DB, String, Integer> biFunction) {
        Matcher matcher = _columnTypePattern.matcher(columnType);
        if (!matcher.lookingAt()) {
            return null;
        }
        return biFunction.apply(DBManagerUtil.getDB(), matcher.group(1));
    }

    private String _getColumnDefaultValue(String columnType) {
        Matcher matcher = _columnDefaultClausePattern.matcher(columnType);
        if (matcher.find()) {
            return StringUtil.unquote(matcher.group(1));
        }
        return null;
    }

    private String _getColumnDefaultValue(String columnDef, BiFunction<DB, String, String> biFunction) {
        if (Validator.isNull((String)columnDef)) {
            return columnDef;
        }
        return biFunction.apply(DBManagerUtil.getDB(), columnDef);
    }

    private int _getColumnSize(String columnType) throws Exception {
        Matcher matcher = _columnSizePattern.matcher(columnType);
        if (!matcher.matches()) {
            return -1;
        }
        String columnSize = matcher.group(1);
        if (Validator.isNotNull((String)columnSize)) {
            try {
                return Integer.parseInt(columnSize);
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception(StringBundler.concat("Column type ", columnType, " has an invalid column size ", columnSize), numberFormatException);
            }
        }
        Integer dataTypeSize = this._getByColumnType(columnType, DB::getSQLTypeSize);
        if (dataTypeSize != null) {
            return dataTypeSize;
        }
        return -1;
    }

    private ResultSet _getColumnsResultSet(String tableName, String columnName) throws SQLException {
        DatabaseMetaData databaseMetaData = this._connection.getMetaData();
        if (columnName != null) {
            columnName = this.normalizeName(columnName, databaseMetaData);
        }
        return databaseMetaData.getColumns(this.getCatalog(), this.getSchema(), this.normalizeName(tableName, databaseMetaData), columnName);
    }

    private boolean _hasElement(String elementName, String elementType) throws Exception {
        DatabaseMetaData databaseMetaData = this._connection.getMetaData();
        elementName = this.normalizeName(elementName, databaseMetaData);
        try (ResultSet resultSet = databaseMetaData.getTables(this.getCatalog(), this.getSchema(), elementName, new String[]{elementType});){
            if (resultSet.next()) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private boolean _isColumnNullable(String typeName) {
        typeName = typeName.trim();
        return !(typeName = StringUtil.toLowerCase(typeName)).endsWith("not null");
    }
}

