/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.db.partition.migration.validator;

import com.liferay.petra.string.StringBundler;
import java.util.ArrayList;
import java.util.List;

public class Recorder {
    private final List<String> _errors = new ArrayList<String>();
    private final List<String> _warnings = new ArrayList<String>();

    public boolean hasErrors() {
        return !this._errors.isEmpty();
    }

    public boolean hasWarnings() {
        return !this._warnings.isEmpty();
    }

    public void printErrors() {
        for (String error : this._errors) {
            System.out.println("[ERROR] " + error);
        }
    }

    public void printMessages() {
        this.printErrors();
        this.printWarnings();
    }

    public void printWarnings() {
        for (String warning : this._warnings) {
            System.out.println("[WARN] " + warning);
        }
    }

    public void registerError(String message) {
        this._errors.add(message);
    }

    public void registerErrors(String message, List<String> moduleNames) {
        for (String moduleName : moduleNames) {
            this._errors.add(StringBundler.concat("Module ", moduleName, " ", message));
        }
    }

    public void registerWarning(String message) {
        this._warnings.add(message);
    }

    public void registerWarnings(String message, List<String> moduleNames) {
        for (String moduleName : moduleNames) {
            this._warnings.add(StringBundler.concat("Module ", moduleName, " ", message));
        }
    }
}

