/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.db.partition.migration.validator.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.version.Version;
import com.liferay.portal.tools.db.partition.migration.validator.Company;
import com.liferay.portal.tools.db.partition.migration.validator.LiferayDatabase;
import com.liferay.portal.tools.db.partition.migration.validator.Release;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class DatabaseUtil {
    public static LiferayDatabase exportLiferayDatabase(Connection connection) throws Exception {
        LiferayDatabase liferayDatabase = new LiferayDatabase();
        liferayDatabase.setCompanies(DatabaseUtil._getCompanies(connection));
        liferayDatabase.setExportedCompanyId(DatabaseUtil._getExportedCompanyId(connection));
        liferayDatabase.setExportedCompanyDefault(DatabaseUtil._isDefaultCompany(connection));
        liferayDatabase.setReleases(DatabaseUtil._getReleases(connection));
        liferayDatabase.setTableNames(DatabaseUtil._getPartitionedTableNames(connection));
        return liferayDatabase;
    }

    public static boolean isPostgreSQL(String jdbcURL) {
        return jdbcURL.indexOf("postgresql") != -1;
    }

    public static String replaceSchemaName(String jdbcURL, String schemaName) {
        if (schemaName == null) {
            return jdbcURL;
        }
        if (DatabaseUtil.isPostgreSQL(jdbcURL)) {
            return DatabaseUtil._replacePostgreSQLSchemaName(jdbcURL, schemaName);
        }
        return DatabaseUtil._replaceMySQLSchemaName(jdbcURL, schemaName);
    }

    private static List<Company> _getCompanies(Connection connection) throws Exception {
        ArrayList<Company> companies = new ArrayList<Company>();
        try (PreparedStatement preparedStatement = connection.prepareStatement("select Company.companyId, webId, name, hostname from Company left join VirtualHost on Company.companyId = VirtualHost.companyId");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                companies.add(new Company(resultSet.getLong(1), resultSet.getString(3), resultSet.getString(4), resultSet.getString(2)));
            }
        }
        return companies;
    }

    private static List<Long> _getCompanyIds(Connection connection) throws Exception {
        ArrayList<Long> companyIds = new ArrayList<Long>();
        try (PreparedStatement preparedStatement = connection.prepareStatement("select companyId from Company");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                companyIds.add(resultSet.getLong("companyId"));
            }
        }
        return companyIds;
    }

    private static long _getExportedCompanyId(Connection connection) throws Exception {
        long companyId = 0L;
        try (PreparedStatement preparedStatement = connection.prepareStatement("select companyId from CompanyInfo");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                if (companyId > 0L) {
                    throw new UnsupportedOperationException("Database schema has to have a single company or database partitioning must be enabled");
                }
                companyId = resultSet.getLong(1);
            }
        }
        return companyId;
    }

    private static List<String> _getPartitionedTableNames(Connection connection) throws Exception {
        ArrayList<String> partitionedTableNames = new ArrayList<String>();
        List<Long> companyIds = DatabaseUtil._getCompanyIds(connection);
        DBInspector dbInspector = new DBInspector(connection);
        for (String tableName : dbInspector.getTableNames(null)) {
            if (dbInspector.isControlTable(tableName) || dbInspector.isObjectTable(companyIds, tableName)) continue;
            partitionedTableNames.add(tableName);
        }
        return partitionedTableNames;
    }

    private static List<Release> _getReleases(Connection connection) throws Exception {
        ArrayList<Release> releases = new ArrayList<Release>();
        try (PreparedStatement preparedStatement = connection.prepareStatement("select servletContextName, schemaVersion, state_, verified from Release_");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                releases.add(new Release(Version.parseVersion(resultSet.getString(2)), resultSet.getString(1), resultSet.getInt(3), resultSet.getBoolean(4)));
            }
        }
        return releases;
    }

    private static boolean _isDefaultCompany(Connection connection) throws Exception {
        DBInspector dbInspector = new DBInspector(connection);
        return dbInspector.hasTable("Company");
    }

    private static String _replaceMySQLSchemaName(String jdbcURL, String schemaName) {
        int index = jdbcURL.indexOf("?");
        if (index == -1) {
            return jdbcURL.substring(0, jdbcURL.lastIndexOf("/") + 1) + schemaName;
        }
        String baseJDBCURL = jdbcURL.substring(0, index);
        return StringBundler.concat(jdbcURL.substring(0, baseJDBCURL.lastIndexOf("/") + 1), schemaName, jdbcURL.substring(index));
    }

    private static String _replacePostgreSQLSchemaName(String jdbcURL, String schemaName) {
        int index = jdbcURL.indexOf("?");
        if (index == -1) {
            return jdbcURL + "?currentSchema=" + schemaName;
        }
        return jdbcURL + "&currentSchema=" + schemaName;
    }
}

