/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.db.partition.migration.validator.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.version.Version;
import com.liferay.portal.tools.db.partition.migration.validator.Company;
import com.liferay.portal.tools.db.partition.migration.validator.LiferayDatabase;
import com.liferay.portal.tools.db.partition.migration.validator.Recorder;
import com.liferay.portal.tools.db.partition.migration.validator.Release;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ValidatorUtil {
    public static Recorder validateDatabases(LiferayDatabase sourceLiferayDatabase, LiferayDatabase targetLiferayDatabase) {
        Recorder recorder = new Recorder();
        ValidatorUtil._validateCompany(recorder, sourceLiferayDatabase, targetLiferayDatabase);
        ValidatorUtil._validatePartitionedTables(recorder, sourceLiferayDatabase, targetLiferayDatabase);
        ValidatorUtil._validateRelease(recorder, sourceLiferayDatabase, targetLiferayDatabase);
        return recorder;
    }

    private static List<String> _getFailedServletContextNames(LiferayDatabase liferayDatabase) {
        ArrayList<String> failedServletContextNames = new ArrayList<String>();
        for (Release release : liferayDatabase.getReleases()) {
            if (release.getState() == 0) continue;
            failedServletContextNames.add(release.getServletContextName());
        }
        return failedServletContextNames;
    }

    private static Map<String, Release> _getReleases(LiferayDatabase liferayDatabase) {
        HashMap<String, Release> releases = new HashMap<String, Release>();
        for (Release release : liferayDatabase.getReleases()) {
            releases.put(release.getServletContextName(), release);
        }
        return releases;
    }

    private static void _validateCompany(Company company, Recorder recorder, Company sourceCompany) {
        if (Objects.equals(company.getCompanyId(), sourceCompany.getCompanyId())) {
            recorder.registerError(StringBundler.concat("Company ID ", sourceCompany.getCompanyId(), " already exists in the target database"));
        }
        if (Objects.equals(company.getCompanyName(), sourceCompany.getCompanyName())) {
            recorder.registerWarning(StringBundler.concat("Company name ", sourceCompany.getCompanyName(), " already exists in the target database. You must set a ", "different value in ", "DBPartitionInsertVirtualInstanceConfiguration.config."));
        }
        if (Objects.equals(company.getVirtualHostname(), sourceCompany.getVirtualHostname())) {
            recorder.registerWarning(StringBundler.concat("Virtual host ", sourceCompany.getVirtualHostname(), " already exists in the target database. You must set a ", "different value in ", "DBPartitionInsertVirtualInstanceConfiguration.config."));
        }
        if (Objects.equals(company.getWebId(), sourceCompany.getWebId())) {
            recorder.registerWarning(StringBundler.concat("Web ID ", sourceCompany.getWebId(), " already exists in the target database. You must set a ", "different value in ", "DBPartitionInsertVirtualInstanceConfiguration.config."));
        }
    }

    private static void _validateCompany(Recorder recorder, LiferayDatabase sourceLiferayDatabase, LiferayDatabase targetLiferayDatabase) {
        Company sourceCompany = null;
        for (Company company : sourceLiferayDatabase.getCompanies()) {
            if (!Objects.equals(company.getCompanyId(), sourceLiferayDatabase.getExportedCompanyId())) continue;
            sourceCompany = company;
            break;
        }
        for (Company company : targetLiferayDatabase.getCompanies()) {
            ValidatorUtil._validateCompany(company, recorder, sourceCompany);
        }
    }

    private static void _validatePartitionedTables(Recorder recorder, LiferayDatabase sourceLiferayDatabase, LiferayDatabase targetLiferayDatabase) {
        ArrayList<String> sourcePartitionedTableNames = new ArrayList<String>(sourceLiferayDatabase.getTableNames());
        ArrayList<String> targetPartitionedTableNames = new ArrayList<String>(targetLiferayDatabase.getTableNames());
        for (String sourcePartitionedTableName : sourcePartitionedTableNames) {
            if (targetPartitionedTableNames.contains(sourcePartitionedTableName)) {
                targetPartitionedTableNames.remove(sourcePartitionedTableName);
                continue;
            }
            recorder.registerWarning("Table " + sourcePartitionedTableName + " is not present in the target database");
        }
        for (String targetPartitionedTableName : targetPartitionedTableNames) {
            recorder.registerWarning("Table " + targetPartitionedTableName + " is not present in the source database");
        }
    }

    private static void _validateRelease(Recorder recorder, LiferayDatabase sourceLiferayDatabase, LiferayDatabase targetLiferayDatabase) {
        ValidatorUtil._validateReleaseState(recorder, sourceLiferayDatabase, targetLiferayDatabase);
        ArrayList<String> higherVersionModules = new ArrayList<String>();
        ArrayList<String> lowerVersionModules = new ArrayList<String>();
        ArrayList<String> missingSourceModules = new ArrayList<String>();
        ArrayList<String> missingTargetModules = new ArrayList<String>();
        ArrayList<String> missingTargetServiceModules = new ArrayList<String>();
        Map<String, Release> targetReleases = ValidatorUtil._getReleases(targetLiferayDatabase);
        ArrayList<String> unverifiedSourceModules = new ArrayList<String>();
        ArrayList<String> unverifiedTargetModules = new ArrayList<String>();
        for (Release sourceRelease : sourceLiferayDatabase.getReleases()) {
            Version targetVersion;
            String sourceServletContextName = sourceRelease.getServletContextName();
            Release targetRelease = targetReleases.remove(sourceServletContextName);
            if (targetRelease == null) {
                missingSourceModules.add(sourceServletContextName);
                continue;
            }
            Version sourceVersion = sourceRelease.getSchemaVersion();
            if (sourceVersion.compareTo(targetVersion = targetRelease.getSchemaVersion()) < 0) {
                lowerVersionModules.add(sourceServletContextName);
            } else if (sourceVersion.compareTo(targetVersion) > 0) {
                higherVersionModules.add(sourceServletContextName);
            }
            if (sourceRelease.getVerified() && !targetRelease.getVerified()) {
                unverifiedTargetModules.add(sourceServletContextName);
                continue;
            }
            if (sourceRelease.getVerified() || !targetRelease.getVerified()) continue;
            unverifiedSourceModules.add(sourceServletContextName);
        }
        for (Release targetRelease : targetReleases.values()) {
            String targetServletContextName = targetRelease.getServletContextName();
            if (targetServletContextName.endsWith(".service")) {
                missingTargetServiceModules.add(targetServletContextName);
                continue;
            }
            missingTargetModules.add(targetServletContextName);
        }
        recorder.registerErrors("needs to be upgraded in the target database before the migration", higherVersionModules);
        recorder.registerErrors("needs to be upgraded in the source database before the migration", lowerVersionModules);
        recorder.registerWarnings("is not present in the target database", missingSourceModules);
        recorder.registerWarnings("is not present in the source database", missingTargetModules);
        recorder.registerErrors("needs to be installed in the source database before the migration", missingTargetServiceModules);
        recorder.registerErrors("needs to be verified in the source database before the migration", unverifiedSourceModules);
        recorder.registerErrors("needs to be verified in the target database before the migration", unverifiedTargetModules);
    }

    private static void _validateReleaseState(Recorder recorder, LiferayDatabase sourceLiferayDatabase, LiferayDatabase targetLiferayDatabase) {
        String message = "has a failed release state in the %s database";
        List<String> failedServletContextNames = ValidatorUtil._getFailedServletContextNames(sourceLiferayDatabase);
        if (!failedServletContextNames.isEmpty()) {
            recorder.registerErrors(String.format(message, "source"), failedServletContextNames);
        }
        if (!(failedServletContextNames = ValidatorUtil._getFailedServletContextNames(targetLiferayDatabase)).isEmpty()) {
            recorder.registerErrors(String.format(message, "target"), failedServletContextNames);
        }
    }
}

