/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.db.upgrade.client;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AppServer {
    private File _dir;
    private String _extraLibDirNames;
    private String _globalLibDirName;
    private String _portalDirName;
    private final String _serverDetectorServerId;

    public static AppServer getAppServer(File liferayHomeDir, String appServerName) {
        if (appServerName.equals("jboss")) {
            return new AppServer(AppServer._getAppServerDirName(liferayHomeDir, "jboss-eap"), AppServer._getJBossExtraLibDirNames(), "/modules/com/liferay/portal/main", "/standalone/deployments/ROOT.war", appServerName);
        }
        if (appServerName.equals("tomcat")) {
            return new AppServer(AppServer._getAppServerDirName(liferayHomeDir, "tomcat"), "/bin", "/lib", "/webapps/ROOT", appServerName);
        }
        if (appServerName.equals("weblogic")) {
            return new AppServer(AppServer._getAppServerDirName(liferayHomeDir, "weblogic"), "/wlserver/modules", "/domains/liferay/lib", "/domains/liferay/autodeploy/ROOT", appServerName);
        }
        if (appServerName.equals("websphere")) {
            return new AppServer(AppServer._getAppServerDirName(liferayHomeDir, "websphere"), "", "/lib", "/profiles/liferay/installedApps/liferay-cell/liferay-portal.ear/liferay-portal.war", appServerName);
        }
        if (appServerName.equals("wildfly")) {
            return new AppServer(AppServer._getAppServerDirName(liferayHomeDir, "wildfly"), AppServer._getJBossExtraLibDirNames(), "/modules/com/liferay/portal/main", "/standalone/deployments/ROOT.war", appServerName);
        }
        return null;
    }

    public AppServer(String dirName, String extraLibDirNames, String globalLibDirName, String portalDirName, String serverDetectorServerId) {
        this._setDirName(dirName);
        this._extraLibDirNames = extraLibDirNames;
        this._globalLibDirName = globalLibDirName;
        this._portalDirName = portalDirName;
        this._serverDetectorServerId = serverDetectorServerId;
    }

    public File getDir() {
        return this._dir;
    }

    public String getExtraLibDirNames() {
        return this._extraLibDirNames;
    }

    public List<File> getExtraLibDirs() {
        ArrayList<File> extraLibDirs = new ArrayList<File>();
        if (this._extraLibDirNames != null && !this._extraLibDirNames.isEmpty()) {
            for (String extraLibDirName : this._extraLibDirNames.split(",")) {
                extraLibDirs.add(new File(this._dir, extraLibDirName));
            }
        }
        return extraLibDirs;
    }

    public File getGlobalLibDir() {
        return new File(this._dir, this._globalLibDirName);
    }

    public String getGlobalLibDirName() {
        return this._globalLibDirName;
    }

    public File getPortalClassesDir() {
        return new File(this.getPortalDir(), "/WEB-INF/classes");
    }

    public File getPortalDir() {
        return new File(this._dir, this._portalDirName);
    }

    public String getPortalDirName() {
        return this._portalDirName;
    }

    public File getPortalLibDir() {
        return new File(this.getPortalDir(), "/WEB-INF/lib");
    }

    public File getPortalShieldedContainerLibDir() {
        return new File(this.getPortalDir(), "/WEB-INF/shielded-container-lib");
    }

    public String getServerDetectorServerId() {
        return this._serverDetectorServerId;
    }

    public void setDirName(String dirName) {
        this._setDirName(dirName);
    }

    public void setExtraLibDirNames(String extraLibDirNames) {
        this._extraLibDirNames = extraLibDirNames;
    }

    public void setGlobalLibDirName(String globalLibDirName) {
        this._globalLibDirName = globalLibDirName;
    }

    public void setPortalDirName(String portalDirName) {
        this._portalDirName = portalDirName;
    }

    private static String _getAppServerDirName(File liferayHomeDir, String dirName) {
        if (!liferayHomeDir.isDirectory()) {
            return dirName;
        }
        File[] files = liferayHomeDir.listFiles();
        if (files == null) {
            return dirName;
        }
        for (File file : files) {
            String fileName = file.getName();
            if (!file.isDirectory() || !Objects.equals(file.getName(), dirName) && !fileName.startsWith(dirName + "-")) continue;
            try {
                return file.getCanonicalPath();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
        return dirName;
    }

    private static String _getJBossExtraLibDirNames() {
        StringBuilder sb = new StringBuilder();
        String extraLibDirPrefix = "/modules/system/layers/base/";
        sb.append(extraLibDirPrefix);
        sb.append("javax/mail,");
        sb.append(extraLibDirPrefix);
        sb.append("javax/persistence,");
        sb.append(extraLibDirPrefix);
        sb.append("javax/servlet,");
        sb.append(extraLibDirPrefix);
        sb.append("javax/transaction");
        return sb.toString();
    }

    private void _setDirName(String dirName) {
        try {
            this._dir = new File(dirName);
            if (!this._dir.isAbsolute()) {
                this._dir = this._dir.getCanonicalFile();
            }
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }
}

