/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.db.upgrade.client;

import com.liferay.gogo.shell.client.GogoShellClient;
import com.liferay.portal.tools.db.upgrade.client.AppServer;
import com.liferay.portal.tools.db.upgrade.client.DBUpgraderLauncher;
import com.liferay.portal.tools.db.upgrade.client.Database;
import com.liferay.portal.tools.db.upgrade.client.util.Properties;
import com.liferay.portal.tools.db.upgrade.client.util.TeePrintStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.console.ConsoleReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class DBUpgradeClient {
    private static final String[] _APP_SERVER_NAMES = new String[]{"jboss", "tomcat", "weblogic", "websphere", "wildfly"};
    private static final String[] _DATABASE_TYPES = new String[]{"db2", "mariadb", "mysql", "oracle", "postgresql", "sqlserver"};
    private static final String _GOGO_SHELL_PREFIX = "g! ";
    private static final String _JAVA_HOME = System.getenv("JAVA_HOME");
    private static final Pattern _gogoShellAddressPattern = Pattern.compile("^([^\\:]+):([0-9]{1,5})$");
    private static File _jarDir;
    private static final List<String> _reflectionOpens;
    private AppServer _appServer;
    private final Properties _appServerProperties;
    private final File _appServerPropertiesFile;
    private final ConsoleReader _consoleReader = new ConsoleReader();
    private final FileOutputStream _fileOutputStream;
    private List<String> _jvmOpts = new ArrayList<String>();
    private final File _logFile;
    private final Properties _portalUpgradeDatabaseProperties;
    private final File _portalUpgradeDatabasePropertiesFile;
    private final Properties _portalUpgradeExtProperties;
    private final File _portalUpgradeExtPropertiesFile;
    private final boolean _shell;

    public static void main(String[] args) {
        Options options = DBUpgradeClient._getOptions();
        try {
            File logDir;
            DefaultParser commandLineParser = new DefaultParser();
            CommandLine commandLine = commandLineParser.parse(options, args);
            if (commandLine.hasOption("help")) {
                HelpFormatter helpFormatter = new HelpFormatter();
                helpFormatter.printHelp("Liferay Portal Tools Database Upgrade Client", options);
                return;
            }
            ArrayList<String> jvmOpts = new ArrayList<String>();
            if (commandLine.hasOption("jvm-opts")) {
                String optionValue = commandLine.getOptionValue("jvm-opts");
                Collections.addAll(jvmOpts, optionValue.split(" "));
            } else {
                jvmOpts.add("-Dfile.encoding=UTF8");
                jvmOpts.add("-Duser.country=US");
                jvmOpts.add("-Duser.language=en");
                jvmOpts.add("-Duser.timezone=GMT");
                jvmOpts.add("-Xmx2048m");
            }
            if (commandLine.hasOption("debug")) {
                jvmOpts.add("-agentlib:jdwp=transport=dt_socket,address=8001,server=y,suspend=y");
            }
            if ((logDir = new File(_jarDir, "logs")) != null && !logDir.exists()) {
                logDir.mkdirs();
            }
            File logFile = null;
            logFile = commandLine.hasOption("log-file") ? new File(logDir, commandLine.getOptionValue("log-file")) : new File(logDir, "upgrade.log");
            if (logFile.exists()) {
                String logFileName = logFile.getName();
                logFile.renameTo(new File(logDir, logFileName + "." + logFile.lastModified()));
                logFile = new File(logDir, logFileName);
            }
            boolean shell = false;
            if (commandLine.hasOption("shell")) {
                shell = true;
            }
            DBUpgradeClient dbUpgradeClient = new DBUpgradeClient(jvmOpts, logFile, shell);
            dbUpgradeClient.upgrade();
        }
        catch (ParseException parseException) {
            System.err.println("Unable to parse command line properties:");
            parseException.printStackTrace();
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("Liferay Portal Tools Database Upgrade Client", options);
        }
        catch (Exception exception) {
            System.err.println("Error running upgrade:");
            exception.printStackTrace();
        }
    }

    public DBUpgradeClient(List<String> jvmOpts, File logFile, boolean shell) throws IOException {
        this._jvmOpts = jvmOpts;
        this._logFile = logFile;
        this._shell = shell;
        this._appServerPropertiesFile = new File(_jarDir, "app-server.properties");
        this._appServerProperties = this._readProperties(this._appServerPropertiesFile);
        this._fileOutputStream = new FileOutputStream(this._logFile);
        this._portalUpgradeDatabasePropertiesFile = new File(_jarDir, "portal-upgrade-database.properties");
        this._portalUpgradeDatabaseProperties = this._readProperties(this._portalUpgradeDatabasePropertiesFile);
        this._portalUpgradeExtPropertiesFile = new File(_jarDir, "portal-upgrade-ext.properties");
        this._portalUpgradeExtProperties = this._readProperties(this._portalUpgradeExtPropertiesFile);
    }

    public void upgrade() throws IOException {
        Process process;
        block62: {
            this.verifyProperties();
            System.setOut(new TeePrintStream((OutputStream)this._fileOutputStream, System.out));
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            ArrayList<String> commands = new ArrayList<String>();
            String javaHome = _JAVA_HOME;
            if (javaHome == null) {
                javaHome = System.getProperty("java.home");
            }
            commands.add(javaHome + "/bin/java");
            this._jvmOpts.add("-Dexternal-properties=portal-upgrade.properties");
            this._jvmOpts.add("-Dliferay.shielded.container.lib.portal.dir=" + this._appServer.getPortalShieldedContainerLibDir());
            this._jvmOpts.add("-Dserver.detector.server.id=" + this._appServer.getServerDetectorServerId());
            commands.add("-cp");
            commands.add(this._getBootstrapClassPath());
            System.out.println("JVM arguments: " + this._jvmOpts.toString());
            commands.addAll(this._jvmOpts);
            commands.add(DBUpgraderLauncher.class.getName());
            processBuilder.command(commands);
            processBuilder.directory(_jarDir);
            processBuilder.redirectErrorStream(true);
            Map<String, String> environment = processBuilder.environment();
            if (this._isGTJDK8()) {
                environment.put("JDK_JAVA_OPTIONS", this._buildJDKJavaOptions());
            }
            process = processBuilder.start();
            boolean upgradeFailed = false;
            try (ObjectOutputStream bootstrapObjectOutputStream = new ObjectOutputStream(process.getOutputStream());
                 InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                bootstrapObjectOutputStream.writeObject(this._getClassPath());
                bootstrapObjectOutputStream.flush();
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    if (line.contains("UpgradeRecorder") && (line.contains("fail") || line.contains("unresolved"))) {
                        upgradeFailed = true;
                    }
                    if (line.equals("Exiting DBUpgrader#main(String[]).")) break;
                    System.out.println(line);
                }
                System.out.flush();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
            if (upgradeFailed || this._shell) {
                String message = "Connecting to Gogo shell";
                if (upgradeFailed) {
                    message = message + " because the upgrade failed or is incomplete";
                }
                System.out.println(message);
                try (GogoShellClient gogoShellClient = this._initGogoShellClient();){
                    if (!this._isPortalUpgradeFinished(gogoShellClient)) break block62;
                    this._printHelp();
                    this._consoleReader.setPrompt(_GOGO_SHELL_PREFIX);
                    String line = this._consoleReader.readLine();
                    if (line == null) {
                        System.out.println("Unable to open Gogo shell");
                    }
                    while (line != null) {
                        if (!this._processGogoShellCommand(gogoShellClient, line)) {
                            break;
                        }
                        line = this._consoleReader.readLine();
                    }
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
        }
        this._close(process.getErrorStream());
        this._close(process.getInputStream());
        this._close(process.getOutputStream());
        process.destroy();
    }

    public void verifyProperties() {
        File file = new File(System.getProperty("user.home") + "/portal-ext.properties");
        if (file.exists()) {
            System.err.println("Remove " + file + " prior to running an upgrade to prevent possible conflicts.");
            System.exit(0);
        }
        try {
            this._verifyPortalUpgradeExtProperties();
            this._verifyAppServerProperties();
            this._verifyPortalUpgradeDatabaseProperties();
            this._saveProperties();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    private static Options _getOptions() {
        Options options = new Options();
        options.addOption(new Option("d", "debug", false, "Debug the upgrade JVM."));
        options.addOption(new Option("h", "help", false, "Print help message."));
        options.addOption(new Option("j", "jvm-opts", true, "Set the JVM_OPTS used for the upgrade."));
        options.addOption(new Option("l", "log-file", true, "Set the name of log file."));
        options.addOption(new Option("s", "shell", false, "Automatically connect to GoGo shell."));
        return options;
    }

    private void _appendClassPath(StringBuilder sb, File dir) throws IOException {
        if (dir.exists() && dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                String fileName = file.getName();
                if (file.isFile() && fileName.endsWith("jar")) {
                    sb.append(file.getCanonicalPath());
                    sb.append(File.pathSeparator);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this._appendClassPath(sb, file);
            }
        }
    }

    private void _appendClassPath(StringBuilder sb, List<File> dirs) throws IOException {
        for (File dir : dirs) {
            this._appendClassPath(sb, dir);
        }
    }

    private String _buildJDKJavaOptions() {
        StringBuilder sb = new StringBuilder();
        for (String reflectionOpen : _reflectionOpens) {
            sb.append(reflectionOpen);
            sb.append(' ');
        }
        if (!_reflectionOpens.isEmpty()) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private void _close(Closeable closeable) throws IOException {
        closeable.close();
    }

    private String _getBootstrapClassPath() throws IOException {
        StringBuilder sb = new StringBuilder();
        this._appendClassPath(sb, _jarDir);
        return sb.toString();
    }

    private String _getClassPath() throws IOException {
        StringBuilder sb = new StringBuilder();
        String liferayClassPath = System.getenv("LIFERAY_CLASSPATH");
        if (liferayClassPath != null && !liferayClassPath.isEmpty()) {
            sb.append(liferayClassPath);
            sb.append(File.pathSeparator);
        }
        this._appendClassPath(sb, new File(_jarDir, "lib"));
        this._appendClassPath(sb, _jarDir);
        sb.append(this._appServer.getPortalClassesDir());
        sb.append(File.pathSeparator);
        this._appendClassPath(sb, this._appServer.getPortalLibDir());
        this._appendClassPath(sb, this._appServer.getPortalShieldedContainerLibDir());
        this._appendClassPath(sb, this._appServer.getGlobalLibDir());
        this._appendClassPath(sb, this._appServer.getExtraLibDirs());
        return sb.toString();
    }

    private GogoShellClient _initGogoShellClient() throws IOException {
        String value = this._portalUpgradeExtProperties.getProperty("module.framework.properties.osgi.console");
        if (value == null) {
            return new GogoShellClient();
        }
        Matcher matcher = _gogoShellAddressPattern.matcher(value);
        if (!matcher.find()) {
            return new GogoShellClient();
        }
        String host = matcher.group(1);
        int port = Integer.parseInt(matcher.group(2));
        return new GogoShellClient(host, port);
    }

    private boolean _isGTJDK8() {
        String javaVersion = System.getProperty("java.version");
        int majorVersion = Integer.parseInt(javaVersion.substring(0, javaVersion.indexOf(46)));
        return majorVersion > 8;
    }

    private boolean _isPortalUpgradeFinished(GogoShellClient gogoShellClient) throws IOException {
        String upgradeList = gogoShellClient.send("upgrade:list");
        if (upgradeList.contains("CommandNotFoundException")) {
            System.out.print("Portal upgrade failed. Fix the issue and retry.");
            return false;
        }
        return true;
    }

    private void _printHelp() {
        System.out.println("\nType \"help\" to get available upgrade and verify commands.");
        System.out.println("Type \"help {command}\" to get additional information about the command. For example, \"help upgrade:list\".");
        System.out.println("Enter \"exit\" or \"quit\" to exit.");
    }

    private boolean _processGogoShellCommand(GogoShellClient gogoShellClient, String command) throws IOException {
        if (command.equals("")) {
            return true;
        }
        String line = _GOGO_SHELL_PREFIX + command + System.lineSeparator();
        this._fileOutputStream.write(line.getBytes());
        if (command.equals("exit") || command.equals("quit")) {
            return false;
        }
        String output = gogoShellClient.send(command);
        int index = output.indexOf(System.lineSeparator());
        if (index == -1) {
            return true;
        }
        output = output.substring(index + 1);
        System.out.println(output);
        return true;
    }

    private Properties _readProperties(File file) {
        Properties properties = new Properties();
        if (file.exists()) {
            try {
                properties.load(file);
            }
            catch (IOException ioException) {
                System.err.println("Unable to load " + file);
            }
        }
        return properties;
    }

    private void _saveProperties() throws IOException {
        this._appServerProperties.store(this._appServerPropertiesFile);
        this._portalUpgradeDatabaseProperties.store(this._portalUpgradeDatabasePropertiesFile);
        this._portalUpgradeExtProperties.store(this._portalUpgradeExtPropertiesFile);
    }

    private void _verifyAppServerProperties() throws IOException {
        String value = this._appServerProperties.getProperty("server.detector.server.id");
        if (value == null || value.isEmpty()) {
            String response = null;
            while (this._appServer == null) {
                System.out.print("[ ");
                for (String appServerName : _APP_SERVER_NAMES) {
                    System.out.print(appServerName + " ");
                }
                System.out.println("]");
                System.out.println("Please enter your application server (tomcat): ");
                response = this._consoleReader.readLine();
                if (response.isEmpty()) {
                    response = "tomcat";
                }
                this._appServer = AppServer.getAppServer(new File(this._portalUpgradeExtProperties.getProperty("liferay.home")), response);
                if (this._appServer != null) continue;
                System.err.println(response + " is an unsupported application server.");
            }
            System.out.println("Please enter your application server directory (" + this._appServer.getDir() + "): ");
            response = this._consoleReader.readLine();
            if (!response.isEmpty()) {
                this._appServer.setDirName(response);
            }
            System.out.println("Please enter your extra library directories in application server directory (" + this._appServer.getExtraLibDirNames() + "): ");
            response = this._consoleReader.readLine();
            if (!response.isEmpty()) {
                this._appServer.setExtraLibDirNames(response);
            }
            System.out.println("Please enter your global library directory in application server directory (" + this._appServer.getGlobalLibDirName() + "): ");
            response = this._consoleReader.readLine();
            if (!response.isEmpty()) {
                this._appServer.setGlobalLibDirName(response);
            }
            System.out.println("Please enter your portal directory in application server directory (" + this._appServer.getPortalDirName() + "): ");
            response = this._consoleReader.readLine();
            if (!response.isEmpty()) {
                this._appServer.setPortalDirName(response);
            }
            File dir = this._appServer.getDir();
            this._appServerProperties.setProperty("dir", dir.getCanonicalPath());
            this._appServerProperties.setProperty("extra.lib.dirs", this._appServer.getExtraLibDirNames());
            this._appServerProperties.setProperty("global.lib.dir", this._appServer.getGlobalLibDirName());
            this._appServerProperties.setProperty("portal.dir", this._appServer.getPortalDirName());
            this._appServerProperties.setProperty("server.detector.server.id", this._appServer.getServerDetectorServerId());
        } else {
            String dirName = this._appServerProperties.getProperty("dir");
            File dir = new File(dirName);
            if (!dir.isAbsolute()) {
                dir = new File(_jarDir, dirName);
            }
            dirName = dir.getCanonicalPath();
            this._appServerProperties.setProperty("dir", dirName);
            this._appServer = new AppServer(dirName, this._appServerProperties.getProperty("extra.lib.dirs"), this._appServerProperties.getProperty("global.lib.dir"), this._appServerProperties.getProperty("portal.dir"), value);
        }
    }

    private void _verifyPortalUpgradeDatabaseProperties() throws IOException {
        String value = this._portalUpgradeDatabaseProperties.getProperty("jdbc.default.driverClassName");
        if (value != null && !value.isEmpty()) {
            return;
        }
        String response = null;
        Database dataSource = null;
        while (dataSource == null) {
            System.out.print("[ ");
            for (String databaseType : _DATABASE_TYPES) {
                System.out.print(databaseType + " ");
            }
            System.out.println("]");
            System.out.println("Please enter your database (mysql): ");
            response = this._consoleReader.readLine();
            if (response.isEmpty()) {
                response = "mysql";
            }
            if ((dataSource = Database.getDatabase(response)) != null) continue;
            System.err.println(response + " is an unsupported database.");
        }
        System.out.println("Please enter your database JDBC driver class name (" + dataSource.getClassName() + "): ");
        response = this._consoleReader.readLine();
        if (!response.isEmpty()) {
            dataSource.setClassName(response);
        }
        System.out.println("Please enter your database JDBC driver protocol (" + dataSource.getProtocol() + "): ");
        response = this._consoleReader.readLine();
        if (!response.isEmpty()) {
            dataSource.setProtocol(response);
        }
        System.out.println("Please enter your database host (" + dataSource.getHost() + "): ");
        response = this._consoleReader.readLine();
        if (!response.isEmpty()) {
            dataSource.setHost(response);
        }
        String port = null;
        port = dataSource.getPort() > 0 ? String.valueOf(dataSource.getPort()) : "none";
        System.out.println("Please enter your database port (" + port + "): ");
        response = this._consoleReader.readLine();
        if (!response.isEmpty()) {
            if (response.equals("none")) {
                dataSource.setPort(0);
            } else {
                dataSource.setPort(Integer.parseInt(response));
            }
        }
        System.out.println("Please enter your database name (" + dataSource.getSchemaName() + "): ");
        response = this._consoleReader.readLine();
        if (!response.isEmpty()) {
            dataSource.setSchemaName(response);
        }
        System.out.println("Please enter your database username: ");
        String userName = this._consoleReader.readLine();
        System.out.println("Please enter your database password: ");
        String password = this._consoleReader.readLine(Character.valueOf('*'));
        this._portalUpgradeDatabaseProperties.setProperty("jdbc.default.driverClassName", dataSource.getClassName());
        this._portalUpgradeDatabaseProperties.setProperty("jdbc.default.password", password);
        this._portalUpgradeDatabaseProperties.setProperty("jdbc.default.url", dataSource.getURL());
        this._portalUpgradeDatabaseProperties.setProperty("jdbc.default.username", userName);
    }

    private void _verifyPortalUpgradeExtProperties() throws IOException {
        String value = this._portalUpgradeExtProperties.getProperty("liferay.home");
        File baseDir = new File(".");
        if (value == null || value.isEmpty()) {
            File defaultLiferayHomeDir = new File(_jarDir, "../../");
            System.out.println("Please enter your Liferay home (" + defaultLiferayHomeDir.getCanonicalPath() + "): ");
            value = this._consoleReader.readLine();
            if (value.isEmpty()) {
                value = defaultLiferayHomeDir.getCanonicalPath();
            }
        } else {
            baseDir = _jarDir;
        }
        File liferayHome = new File(value);
        if (!liferayHome.isAbsolute()) {
            liferayHome = new File(baseDir, value);
        }
        this._portalUpgradeExtProperties.setProperty("liferay.home", liferayHome.getCanonicalPath());
    }

    static {
        _reflectionOpens = Arrays.asList("--add-opens=java.base/java.lang=ALL-UNNAMED", "--add-opens=java.base/java.lang.invoke=ALL-UNNAMED", "--add-opens=java.base/java.lang.reflect=ALL-UNNAMED", "--add-opens=java.base/java.net=ALL-UNNAMED", "--add-opens=java.base/sun.net.www.protocol.http=ALL-UNNAMED", "--add-opens=java.base/sun.net.www.protocol.https=ALL-UNNAMED", "--add-opens=java.base/sun.util.calendar=ALL-UNNAMED", "--add-opens=jdk.zipfs/jdk.nio.zipfs=ALL-UNNAMED");
        ProtectionDomain protectionDomain = DBUpgradeClient.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL url = codeSource.getLocation();
        try {
            Path path = Paths.get(url.toURI());
            File jarFile = path.toFile();
            _jarDir = jarFile.getParentFile();
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new ExceptionInInitializerError(uriSyntaxException);
        }
    }
}

