/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.db.upgrade.client;

public class Database {
    private String _className;
    private String _host;
    private String _params;
    private int _port;
    private String _protocol;
    private String _schemaName;

    public static Database getDatabase(String databaseType) {
        if (databaseType.equals("db2")) {
            return new Database("com.ibm.db2.jcc.DB2Driver", "jdbc:db2://", "localhost", 50000, ":deferPrepares=false;fullyMaterializeInputStreams=true;fullyMaterializeLobData=true;progresssiveLocators=2;progressiveStreaming=2;", "lportal");
        }
        if (databaseType.equals("mariadb")) {
            return new Database("org.mariadb.jdbc.Driver", "jdbc:mariadb://", "localhost", 0, "?useUnicode=true&characterEncoding=UTF-8&useFastDateParsing=false", "lportal");
        }
        if (databaseType.equals("mysql")) {
            return new Database("com.mysql.cj.jdbc.Driver", "jdbc:mysql://", "localhost", 0, "?characterEncoding=UTF-8&dontTrackOpenResources=true&holdResultsOpenOverStatementClose=true&serverTimezone=GMT&useFastDateParsing=false&useUnicode=true", "lportal");
        }
        if (databaseType.equals("oracle")) {
            return new Database("oracle.jdbc.OracleDriver", "jdbc:oracle:thin:@", "localhost", 1521, "", "xe");
        }
        if (databaseType.equals("postgresql")) {
            return new Database("org.postgresql.Driver", "jdbc:postgresql://", "localhost", 5432, "", "lportal");
        }
        if (databaseType.equals("sqlserver")) {
            return new Database("com.microsoft.sqlserver.jdbc.SQLServerDriver", "jdbc:sqlserver://", "localhost", 0, "", "lportal");
        }
        return null;
    }

    public String getClassName() {
        return this._className;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public String getURL() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._protocol);
        sb.append(this._host);
        if (this._port > 0) {
            sb.append(':');
            sb.append(this._port);
        }
        if (this._protocol.contains("sqlserver")) {
            sb.append(";databaseType=");
        } else if (this._protocol.contains("oracle")) {
            sb.append(":");
        } else {
            sb.append("/");
        }
        sb.append(this._schemaName);
        sb.append(this._params);
        return sb.toString();
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public void setParams(String params) {
        this._params = params;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public void setSchemaName(String schemaName) {
        this._schemaName = schemaName;
    }

    private Database(String className, String protocol, String host, int port, String params, String schemaName) {
        this._className = className;
        this._protocol = protocol;
        this._host = host;
        this._port = port;
        this._params = params;
        this._schemaName = schemaName;
    }
}

