/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.db.upgrade.client.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Properties {
    private final Map<String, String> _properties = new LinkedHashMap<String, String>();

    public String getProperty(String key) {
        return this._properties.get(key);
    }

    public void load(File file) throws IOException {
        this.load(new FileInputStream(file));
    }

    public Set<String> propertyNames() {
        return this._properties.keySet();
    }

    public void setProperty(String key, String value) {
        this._properties.put(key, value);
    }

    public void store(File file) throws IOException {
        try (PrintWriter printWriter = new PrintWriter(file, StandardCharsets.UTF_8.name());){
            for (String name : this.propertyNames()) {
                String value = this.getProperty(name);
                if (name.endsWith(".dir") || name.endsWith(".dirs") || name.endsWith("liferay.home")) {
                    value = value.replace('\\', '/');
                }
                printWriter.println(name + "=" + value);
            }
        }
    }

    protected void load(InputStream inputStream) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String name = null;
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                String value;
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                int index = line.indexOf("=");
                if (index > 0) {
                    name = line.substring(0, index);
                    value = line.substring(index + 1);
                } else {
                    value = this._properties.get(name) + "\n" + line;
                }
                this._properties.put(name, value);
            }
        }
    }
}

