/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language.antlr;

import antlr.CommonHiddenStreamToken;
import antlr.Token;
import antlr.collections.AST;
import de.hunsicker.jalopy.language.Annotation;
import de.hunsicker.jalopy.language.Position;
import de.hunsicker.jalopy.language.antlr.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class JavaNode
extends Node {
    protected JavaNode parent;
    protected JavaNode prevSibling;
    private List _annotations = Collections.EMPTY_LIST;
    private Position _position;
    public int newLine;
    public int newColumn;

    private JavaNode(int startLine, int startColumn, int endLine, int endColumn) {
        super(startLine, startColumn, endLine, endColumn);
    }

    public JavaNode() {
    }

    private JavaNode(Token tok) {
        super(tok);
    }

    private JavaNode(int type, String text) {
        super(type, text);
    }

    public CommonHiddenStreamToken getCommentAfter() {
        if (this.hiddenAfter != null) {
            CommonHiddenStreamToken t = this.hiddenAfter;
            while (t != null) {
                switch (t.getType()) {
                    case 175: {
                        break;
                    }
                    default: {
                        return t;
                    }
                }
                t = t.getHiddenAfter();
            }
        }
        return null;
    }

    public CommonHiddenStreamToken getCommentBefore() {
        CommonHiddenStreamToken result = null;
        CommonHiddenStreamToken t = this.getHiddenBefore();
        while (t != null) {
            switch (t.getType()) {
                case 175: {
                    break;
                }
                default: {
                    result = t;
                }
            }
            t = t.getHiddenBefore();
        }
        return result;
    }

    public void setParent(JavaNode node) {
        this.parent = node;
    }

    public JavaNode getParent() {
        return this.parent;
    }

    public void setPosition(Position position) {
        this._position = position;
    }

    public Position getPosition() {
        return this._position;
    }

    public void setPreviousSibling(JavaNode node) {
        this.prevSibling = node;
    }

    public JavaNode getPreviousSibling() {
        return this.prevSibling;
    }

    public int getSizeCommentsAfter() {
        if (this.hiddenAfter != null) {
            int result = 0;
            CommonHiddenStreamToken t = this.hiddenAfter;
            while (t != null) {
                switch (t.getType()) {
                    case 175: {
                        break;
                    }
                    default: {
                        ++result;
                    }
                }
                t = t.getHiddenAfter();
            }
            return result;
        }
        return 0;
    }

    public int getSizeCommentsBefore() {
        if (this.hiddenBefore != null) {
            int result = 0;
            CommonHiddenStreamToken t = this.hiddenBefore;
            while (t != null) {
                switch (t.getType()) {
                    case 175: {
                        break;
                    }
                    default: {
                        ++result;
                    }
                }
                t = t.getHiddenBefore();
            }
            return result;
        }
        return 0;
    }

    public void addChild(AST node) {
        if (node == null) {
            return;
        }
        JavaNode t = (JavaNode)this.down;
        JavaNode n = (JavaNode)node;
        if (t != null) {
            while (t.getNextSibling() != null) {
                t = (JavaNode)t.getNextSibling();
            }
            t.setNextSibling(node);
            n.prevSibling = t;
        } else {
            this.down = n;
            n.prevSibling = this;
        }
        n.parent = this;
    }

    public void attachAnnotation(Annotation annotation) {
        if (this._annotations == Collections.EMPTY_LIST) {
            this._annotations = new ArrayList(10);
        }
        this._annotations.add(annotation);
    }

    public List detachAnnotations() {
        try {
            List list = this._annotations;
            return list;
        }
        finally {
            if (this._annotations != Collections.EMPTY_LIST) {
                this._annotations = Collections.EMPTY_LIST;
            }
        }
    }

    public boolean hasCommentsAfter() {
        return this.getSizeCommentsAfter() > 0;
    }

    public boolean hasCommentsBefore() {
        return this.getSizeCommentsBefore() > 0;
    }

    public boolean hasJavadocComment(boolean includeML) {
        CommonHiddenStreamToken comment = this.getHiddenBefore();
        while (comment != null) {
            switch (comment.getType()) {
                case 6: {
                    return true;
                }
                case 178: {
                    if (!includeML) break;
                    return true;
                }
            }
            comment = comment.getHiddenBefore();
        }
        return false;
    }

    public void initialize(AST node) {
        super.initialize(node);
        JavaNode n = (JavaNode)node;
        this.parent = n.parent;
        this.prevSibling = n.prevSibling;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(50);
        buf.append('\"');
        buf.append(this.text);
        buf.append('\"');
        buf.append(", <");
        buf.append(this.type);
        buf.append(">");
        buf.append(", par ");
        buf.append(this.parent != null ? this.parent.text : "NONE");
        buf.append(", prev ");
        buf.append(this.prevSibling != null ? this.prevSibling.text : "NONE");
        buf.append(", next ");
        buf.append(this.getNextSibling() != null ? this.getNextSibling().getText() : "NONE");
        buf.append(", [");
        buf.append(this.startLine);
        buf.append(':');
        buf.append(this.startColumn);
        buf.append("-");
        buf.append(this.endLine);
        buf.append(':');
        buf.append(this.endColumn);
        buf.append("], ");
        buf.append(this.getSizeCommentsBefore());
        buf.append(",");
        buf.append(this.getSizeCommentsAfter());
        return buf.toString();
    }

    public void updatePosition(int line, int column) {
        if (this._position != null) {
            this._position.line = line;
            this._position.column = column;
        }
        int i = 0;
        int size = this._annotations.size();
        while (i < size) {
            Annotation annotation = (Annotation)this._annotations.get(i);
            annotation.setLine(line);
            ++i;
        }
    }

    public void clear() {
        this.parent = null;
        this.prevSibling = null;
        super.clear();
    }
}

