/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.BlockStatementPrinter;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.ParenthesesScope;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class ForPrinter
extends BlockStatementPrinter {
    private static final Printer INSTANCE = new ForPrinter();

    protected ForPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        super.print(node, out);
        int offset = 1;
        offset = AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_BEFORE_STATEMENT_PAREN, true) ? out.print("for ", 131) : out.print("for", 131);
        this.trackPosition((JavaNode)node, out.line, offset, out);
        AST lparen = node.getFirstChild();
        PrinterFactory.create(lparen, out).print(lparen, out);
        Marker marker = out.state.markers.add();
        AST forNode = lparen.getNextSibling();
        AST rparen = forNode.getNextSibling();
        switch (forNode.getType()) {
            case 40: {
                rparen = this.for_init(forNode, out, marker);
                break;
            }
            case 53: {
                rparen = this.for_each(forNode, out, marker);
                break;
            }
            default: {
                throw new IllegalArgumentException("no viable printer for -- " + forNode);
            }
        }
        PrinterFactory.create(rparen, out).print(rparen, out);
        out.state.markers.remove(marker);
        if (out.mode == 1) {
            --out.state.paramLevel;
            out.state.parenScope.removeFirst();
        }
        out.last = 131;
        AST body = rparen.getNextSibling();
        switch (body.getType()) {
            case 12: {
                PrinterFactory.create(body, out).print(body, out);
                break;
            }
            default: {
                if (AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_INSERT_FOR, false)) {
                    out.printLeftBrace(AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_NEWLINE_LEFT, false), true);
                    PrinterFactory.create(body, out).print(body, out);
                    out.printRightBrace();
                    break;
                }
                out.printNewline();
                out.indent();
                PrinterFactory.create(body, out).print(body, out);
                out.unindent();
            }
        }
        out.last = 8;
    }

    private AST for_each(AST forNode, NodeWriter out, Marker marker) throws IOException {
        if (out.mode == 1) {
            ++out.state.paramLevel;
            out.state.parenScope.addFirst(new ParenthesesScope(out.state.paramLevel));
        }
        AST forEachClause = forNode.getFirstChild();
        AST expresion = forEachClause.getNextSibling();
        PrinterFactory.create(forEachClause, out).print(forEachClause, out);
        out.print(" : ", forEachClause.getType());
        this.printChildren(expresion, out);
        return forNode.getNextSibling();
    }

    private AST for_init(AST forInit, NodeWriter out, Marker marker) throws IOException {
        AST firstSemi = forInit.getNextSibling();
        AST forCond = firstSemi.getNextSibling();
        AST secondSemi = forCond.getNextSibling();
        AST forIter = secondSemi.getNextSibling();
        int lineLength = AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80);
        boolean indentDeep = AbstractPrinter.settings.getBoolean(ConventionKeys.INDENT_DEEP, false);
        boolean firstWrap = false;
        if (out.mode == 1) {
            ++out.state.paramLevel;
            out.state.parenScope.addFirst(new ParenthesesScope(out.state.paramLevel));
            if (AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_LEFT_PAREN, false)) {
                AST child;
                TestNodeWriter tester = out.testers.get();
                AST c = child = forInit.getFirstChild();
                while (c != null) {
                    PrinterFactory.create(c, out).print(c, tester);
                    c = c.getNextSibling();
                }
                child = forCond.getFirstChild();
                if (child != null) {
                    PrinterFactory.create(child, out).print(child, tester);
                }
                if ((child = forIter.getFirstChild()) != null) {
                    PrinterFactory.create(child, out).print(child, tester);
                }
                if (out.column + tester.length > lineLength) {
                    firstWrap = true;
                }
                out.testers.release(tester);
            }
        }
        this.printForInit(forInit, firstWrap, out);
        boolean wrapAll = AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_PARAMS_EXCEED, false);
        boolean spaceAfterSemi = AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_AFTER_SEMICOLON, true);
        out.continuation = AbstractPrinter.settings.getBoolean(ConventionKeys.INDENT_CONTINUATION_BLOCK, true);
        boolean secondWrap = false;
        if (out.mode == 1) {
            if (firstWrap && wrapAll) {
                secondWrap = true;
            } else {
                TestNodeWriter tester = out.testers.get();
                AST child = forCond.getFirstChild();
                if (child != null) {
                    PrinterFactory.create(child, out).print(child, tester);
                    tester.length = tester.length + (spaceAfterSemi ? 3 : 2);
                }
                if (out.column + tester.length > lineLength) {
                    secondWrap = true;
                }
                out.testers.release(tester);
            }
        }
        out.print(";", 40);
        this.printCommentsAfter(firstSemi, false, false, out);
        this.printForCond(forCond, secondWrap, out);
        boolean thirdWrap = false;
        if (out.mode == 1) {
            if (firstWrap && wrapAll) {
                thirdWrap = true;
            } else {
                TestNodeWriter tester = out.testers.get();
                AST child = forIter.getFirstChild();
                if (child != null) {
                    PrinterFactory.create(child, out).print(child, tester);
                    tester.length = tester.length + (spaceAfterSemi ? 5 : 3);
                }
                if (out.column + tester.length > lineLength) {
                    thirdWrap = true;
                }
                out.testers.release(tester);
            }
        }
        out.print(";", 40);
        this.printCommentsAfter(secondSemi, false, false, out);
        this.printForIter(forIter, thirdWrap, out);
        out.continuation = false;
        if ((firstWrap || secondWrap || thirdWrap) && AbstractPrinter.settings.getBoolean(ConventionKeys.LINE_WRAP_BEFORE_RIGHT_PAREN, false)) {
            if (!out.newline) {
                out.printNewline();
                if (indentDeep) {
                    out.print(out.getString(marker.column - 1 - out.getIndentLength()), 175);
                }
            }
            out.print(EMPTY_STRING, 175);
        }
        return forIter.getNextSibling();
    }

    private void printForCond(AST node, boolean wrap, NodeWriter out) throws IOException {
        if (node.getFirstChild() == null) {
            return;
        }
        if (wrap) {
            out.printNewline();
            this.printIndentation(out);
        } else if (AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_AFTER_SEMICOLON, true)) {
            out.print(" ", 40);
        }
        AST child = node.getFirstChild();
        while (child != null) {
            PrinterFactory.create(child, out).print(child, out);
            child = child.getNextSibling();
        }
    }

    private void printForInit(AST node, boolean wrap, NodeWriter out) throws IOException {
        AST child;
        if (wrap) {
            out.printNewline();
            this.printIndentation(out);
        }
        if ((child = node.getFirstChild()) != null) {
            this.printVariableDefs(node, out);
        }
    }

    private void printForIter(AST node, boolean wrap, NodeWriter out) throws IOException {
        AST elist = node.getFirstChild();
        if (elist == null) {
            return;
        }
        if (wrap) {
            out.printNewline();
            this.printIndentation(out);
        } else if (AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_AFTER_SEMICOLON, true)) {
            out.print(" ", 40);
        }
        boolean spaceAfterComma = AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_AFTER_COMMA, true);
        String comma = spaceAfterComma ? ", " : ",";
        AST element = elist.getFirstChild();
        while (element != null) {
            switch (element.getType()) {
                case 85: {
                    out.print(comma, 85);
                    break;
                }
                default: {
                    PrinterFactory.create(element, out).print(element, out);
                }
            }
            element = element.getNextSibling();
        }
    }

    private void printVariableDef(AST node, NodeWriter out, boolean printType) throws IOException {
        switch (node.getType()) {
            case 39: {
                boolean spaceAfterComma = AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_AFTER_COMMA, true);
                String comma = spaceAfterComma ? ", " : ",";
                AST param = node.getFirstChild();
                while (param != null) {
                    PrinterFactory.create(param, out).print(param, out);
                    if (param.getNextSibling() != null) {
                        out.print(comma, 85);
                    }
                    param = param.getNextSibling();
                }
                return;
            }
        }
        AST modifier = node.getFirstChild();
        AST type = modifier.getNextSibling();
        if (printType) {
            PrinterFactory.create(modifier, out).print(modifier, out);
            PrinterFactory.create(type, out).print(type, out);
        }
        AST identifier = type.getNextSibling();
        if (out.last != 85) {
            out.print(" ", out.last);
        }
        PrinterFactory.create(identifier, out).print(identifier, out);
        AST assign = identifier.getNextSibling();
        if (assign != null) {
            switch (assign.getType()) {
                case 74: {
                    break;
                }
                default: {
                    PrinterFactory.create(assign, out).print(assign, out);
                }
            }
        }
    }

    private void printVariableDefs(AST node, NodeWriter out) throws IOException {
        AST child = node.getFirstChild();
        boolean spaceAfterComma = AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_AFTER_COMMA, true);
        String comma = spaceAfterComma ? ", " : ",";
        switch (child.getType()) {
            case 15: {
                this.printVariableDef(child, out, true);
                child = child.getNextSibling();
                while (child != null) {
                    out.print(comma, 85);
                    this.printVariableDef(child, out, false);
                    child = child.getNextSibling();
                }
                break;
            }
            case 39: {
                AST var = child.getFirstChild();
                while (var != null) {
                    switch (child.getType()) {
                        case 85: {
                            out.print(comma, 85);
                            break;
                        }
                        default: {
                            PrinterFactory.create(var, out).print(var, out);
                        }
                    }
                    var = var.getNextSibling();
                }
                break;
            }
        }
    }
}

