/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.BasicDeclarationPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class VariableDeclarationPrinter
extends BasicDeclarationPrinter {
    static final int OFFSET_NONE = -1;
    private static final Printer INSTANCE = new VariableDeclarationPrinter();

    protected VariableDeclarationPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        AST semi;
        boolean innerClass;
        JavaNode n = (JavaNode)node;
        boolean isMLaComment = AbstractPrinter.settings.getBoolean(ConventionKeys.DONT_COMMENT_JAVADOC_WHEN_ML, false);
        if (!(out.state.anonymousInnerClass || n.hasJavadocComment(isMLaComment) || out.state.innerClass && !AbstractPrinter.settings.getBoolean(ConventionKeys.COMMENT_JAVADOC_INNER_CLASS, false) || JavaNodeHelper.isLocalVariable(node))) {
            this.addComment(n, out);
        }
        this.printCommentsBefore(node, out);
        int last = out.last;
        AST modifiers = node.getFirstChild();
        PrinterFactory.create(modifiers, out).print(modifiers, out);
        AST type = modifiers.getNextSibling();
        PrinterFactory.create(type, out).print(type, out);
        if (out.mode == 1) {
            if (AbstractPrinter.settings.getBoolean(ConventionKeys.ALIGN_VAR_IDENTS, false) && !n.hasJavadocComment(isMLaComment)) {
                this.alignVariable(node, last, out);
            } else {
                AST next = node.getNextSibling();
                if (next == null || JavaNodeHelper.getFirstChild(node, 110) != null || next.getType() != 15) {
                    // empty if block
                }
            }
        }
        out.print(" ", 175);
        AST identifier = type.getNextSibling();
        PrinterFactory.create(identifier, out).print(identifier, out);
        AST assign = identifier.getNextSibling();
        if (assign != null) {
            if (type != null && "String".equals(type.getFirstChild().getText())) {
                switch (assign.getType()) {
                    default: 
                }
                PrinterFactory.create(assign, out).print(assign, out);
            } else {
                PrinterFactory.create(assign, out).print(assign, out);
            }
        }
        boolean bl = innerClass = out.last == 19;
        if (assign != null && (semi = assign.getNextSibling()) != null) {
            PrinterFactory.create(semi, out).print(semi, out);
        }
        out.last = innerClass ? 8 : 15;
    }

    boolean isNewChunk(AST node, int last) {
        JavaNode n = (JavaNode)node;
        if (AbstractPrinter.settings.getBoolean(ConventionKeys.CHUNKS_BY_COMMENTS, true) && n.hasCommentsBefore()) {
            return true;
        }
        switch (last) {
            case 15: {
                int totalLines;
                int maxLinesBetween = AbstractPrinter.settings.getInt(ConventionKeys.BLANK_LINES_KEEP_UP_TO, 1);
                if (maxLinesBetween <= 0) break;
                return AbstractPrinter.settings.getBoolean(ConventionKeys.CHUNKS_BY_BLANK_LINES, true) && (totalLines = this.countChildrenLines((JavaNode)n.getPreviousSibling().getFirstChild(), 0)) - 1 > maxLinesBetween;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isLongStringLiteral(AST node, NodeWriter out) throws IOException {
        boolean result = false;
        boolean possible = false;
        int lineLength = AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80);
        AST child = node.getFirstChild();
        while (child != null) {
            switch (child.getType()) {
                case 157: {
                    possible = true;
                    break;
                }
                case 171: {
                    if (!possible) return result;
                    if (out.column + child.getText().length() <= lineLength) return result;
                    return true;
                }
            }
            child = child.getFirstChild();
        }
        return result;
    }

    private boolean alignVariable(AST node, int last, NodeWriter out) throws IOException {
        boolean result = false;
        if (out.mode == 1) {
            AST next = node.getNextSibling();
            if ((last != 15 || out.state.variableOffset == -1) && next != null) {
                out.state.variableOffset = -1;
                result = true;
                switch (next.getType()) {
                    case 15: {
                        TestNodeWriter tester = out.testers.get();
                        int length = -1;
                        AST def = node;
                        block9: while (def != null) {
                            switch (def.getType()) {
                                case 15: {
                                    tester.reset();
                                    AST defModifier = def.getFirstChild();
                                    AST defType = defModifier.getNextSibling();
                                    PrinterFactory.create(defModifier, out).print(defModifier, tester);
                                    PrinterFactory.create(defType, out).print(defType, tester);
                                    if (tester.length > length) {
                                        length = tester.length;
                                    }
                                    if (!this.isNewChunk(def.getNextSibling(), 15)) break;
                                    break block9;
                                }
                                default: {
                                    break block9;
                                }
                            }
                            def = def.getNextSibling();
                        }
                        out.testers.release(tester);
                        out.state.variableOffset = length + out.getIndentLength() + 1;
                        break;
                    }
                }
            }
            if (out.state.variableOffset != -1) {
                if (out.state.variableOffset > out.column) {
                    out.print(out.getString(out.state.variableOffset - out.column), 175);
                }
                switch (next.getType()) {
                    case 15: {
                        if (!this.isNewChunk(next, last)) break;
                        out.state.variableOffset = -1;
                        result = true;
                        break;
                    }
                    default: {
                        out.state.variableOffset = -1;
                        result = true;
                    }
                }
            }
        }
        return result;
    }
}

