/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.swing.util;

import de.hunsicker.util.concurrent.Callable;
import de.hunsicker.util.concurrent.FutureResult;
import de.hunsicker.util.concurrent.ThreadFactory;
import de.hunsicker.util.concurrent.ThreadFactoryUser;
import de.hunsicker.util.concurrent.TimedCallable;
import de.hunsicker.util.concurrent.TimeoutException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public abstract class SwingWorker
extends ThreadFactoryUser
implements Runnable {
    private static final ThreadFactory FACTORY = new ThreadFactory(){

        public Thread newThread(Runnable command) {
            Thread t = new Thread(command);
            t.setPriority(2);
            return t;
        }
    };
    private final FutureResult result = new FutureResult();
    private Thread thread;
    private final long timeout;

    public SwingWorker() {
        this(FACTORY, 0L);
    }

    public SwingWorker(long msecs) {
        this(FACTORY, msecs);
    }

    protected SwingWorker(ThreadFactory factory, long msecs) {
        this.setThreadFactory(factory);
        if (msecs < 0L) {
            throw new IllegalArgumentException("timeout=" + msecs);
        }
        this.timeout = msecs;
    }

    public InvocationTargetException getException() {
        return this.result.getException();
    }

    public boolean isReady() {
        return this.result.isReady();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public Object get() throws InterruptedException, InvocationTargetException {
        return this.result.get();
    }

    public synchronized void interrupt() {
        if (this.thread != null) {
            try {
                this.thread.interrupt();
            }
            catch (Throwable throwable) {}
        }
        this.result.setException(new InterruptedException());
    }

    public void run() {
        Callable function = new Callable(){

            public Object call() throws Exception {
                return SwingWorker.this.construct();
            }
        };
        Runnable doFinished = new Runnable(){

            public void run() {
                SwingWorker.this.finished();
            }
        };
        long msecs = this.getTimeout();
        if (msecs != 0L) {
            TimedCallable tc = new TimedCallable(function, msecs);
            tc.setThreadFactory(this.getThreadFactory());
            function = tc;
        }
        this.result.setter(function).run();
        SwingUtilities.invokeLater(doFinished);
    }

    public synchronized void start() {
        if (this.thread == null) {
            this.thread = this.getThreadFactory().newThread(this);
        }
        this.thread.start();
    }

    public Object timedGet(long msecs) throws TimeoutException, InterruptedException, InvocationTargetException {
        return this.result.timedGet(msecs);
    }

    protected abstract Object construct() throws Exception;

    protected void finished() {
    }
}

