/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.SimpleBindings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleScriptContext
implements ScriptContext {
    protected Bindings engineScope = new SimpleBindings();
    protected Bindings globalScope = new SimpleBindings();
    protected Reader reader = new InputStreamReader(System.in);
    protected Writer writer = new OutputStreamWriter(System.out);
    protected Writer errorWriter = new OutputStreamWriter(System.err);

    @Override
    public void setBindings(Bindings bindings, int scope) {
        switch (scope) {
            case 100: {
                this.engineScope = bindings;
                break;
            }
            case 200: {
                this.globalScope = bindings;
                break;
            }
            default: {
                throw new IllegalArgumentException("scope '" + scope + " must either be ENGINE_SCOPE or GLOBAL_SCOPE.");
            }
        }
    }

    @Override
    public Bindings getBindings(int scope) {
        switch (scope) {
            case 100: {
                return this.engineScope;
            }
            case 200: {
                return this.globalScope;
            }
        }
        throw new IllegalArgumentException("scope '" + scope + " must either be ENGINE_SCOPE or GLOBAL_SCOPE.");
    }

    @Override
    public Object getAttribute(String name) {
        Object v = null;
        if (this.engineScope != null) {
            v = this.engineScope.get(name);
        }
        if (v != null) {
            return v;
        }
        if (this.globalScope != null) {
            v = this.globalScope.get(name);
        }
        return v;
    }

    @Override
    public int getAttributesScope(String name) {
        Object v = this.engineScope.get(name);
        if (v != null) {
            return 100;
        }
        v = this.globalScope.get(name);
        if (v != null) {
            return 200;
        }
        return -1;
    }

    @Override
    public Object getAttribute(String name, int scope) {
        return this.getBindings(scope).get(name);
    }

    @Override
    public Object removeAttribute(String name, int scope) {
        return this.getBindings(scope).remove(name);
    }

    @Override
    public void setAttribute(String name, Object value, int scope) {
        this.getBindings(scope).put(name, value);
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public Writer getErrorWriter() {
        return this.errorWriter;
    }

    @Override
    public void setErrorWriter(Writer writer) {
        this.errorWriter = writer;
    }

    @Override
    public List<Integer> getScopes() {
        ArrayList<Integer> scopes = new ArrayList<Integer>();
        scopes.add(100);
        scopes.add(200);
        return scopes;
    }
}

