/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.id.uuid;

import java.io.DataInput;
import java.io.IOException;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.apache.commons.id.DecoderException;
import org.apache.commons.id.DigestUtils;
import org.apache.commons.id.Hex;
import org.apache.commons.id.uuid.Bytes;
import org.apache.commons.id.uuid.Constants;
import org.apache.commons.id.uuid.UUIDFormatException;
import org.apache.commons.id.uuid.VersionFourGenerator;
import org.apache.commons.id.uuid.VersionOneGenerator;

public class UUID
implements Constants,
Serializable,
Comparable {
    private byte[] rawBytes = new byte[16];
    private Long node = null;
    private long timestamp = -1L;
    private Short clockSq = null;
    private int version = -1;
    private int variant = -1;
    private String stringValue = null;

    public UUID() {
    }

    public UUID(UUID copyFrom) {
        this.rawBytes = copyFrom.getRawBytes();
    }

    public UUID(byte[] byteArray) throws IllegalArgumentException {
        if (byteArray.length != 16) {
            throw new IllegalArgumentException("UUID must be contructed using a 16 byte array.");
        }
        System.arraycopy(byteArray, 0, this.rawBytes, 0, 16);
    }

    public UUID(DataInput input) throws IOException {
        input.readFully(this.rawBytes, 0, 16);
    }

    public UUID(long mostSignificant, long leastSignificant) {
        this.rawBytes = Bytes.append(Bytes.toBytes(mostSignificant), Bytes.toBytes(leastSignificant));
    }

    public UUID(String uuidString) throws UUIDFormatException {
        this(UUID.fromString(uuidString));
    }

    public static UUID fromString(String uuidString) throws UUIDFormatException {
        String leanString = uuidString.toLowerCase();
        UUID tmpUUID = null;
        int pos = uuidString.lastIndexOf(":");
        if (pos > 1) {
            leanString = uuidString.substring(++pos, uuidString.length());
        }
        if (leanString.length() != 36) {
            throw new UUIDFormatException(uuidString);
        }
        StringTokenizer tok = new StringTokenizer(leanString, "-");
        if (tok.countTokens() != 5) {
            throw new UUIDFormatException(uuidString);
        }
        StringBuffer buf = new StringBuffer(32);
        String token = null;
        int count = 0;
        while (tok.hasMoreTokens()) {
            token = tok.nextToken();
            if (token.length() != Constants.TOKEN_LENGTHS[count++]) {
                throw new UUIDFormatException(uuidString);
            }
            buf.append(token);
        }
        try {
            char[] chars = buf.toString().toCharArray();
            tmpUUID = new UUID(Hex.decodeHex(chars));
        }
        catch (DecoderException de) {
            throw new UUIDFormatException(uuidString + ": " + de.getMessage());
        }
        return tmpUUID;
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuffer buf = new StringBuffer(new String(Hex.encodeHex(this.rawBytes)));
            while (buf.length() != 32) {
                buf.insert(0, "0");
            }
            buf.ensureCapacity(36);
            buf.insert(8, '-');
            buf.insert(13, '-');
            buf.insert(18, '-');
            buf.insert(23, '-');
            this.stringValue = buf.toString();
        }
        return this.stringValue;
    }

    public String toUrn() {
        return "urn:uuid:" + this.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UUID)) {
            return false;
        }
        return Bytes.areEqual(((UUID)obj).getRawBytes(), this.rawBytes);
    }

    public int hashCode() {
        int iConstant = 37;
        int iTotal = 17;
        for (int i = 0; i < this.rawBytes.length; ++i) {
            iTotal = iTotal * iConstant + this.rawBytes[i];
        }
        return iTotal;
    }

    public int compareTo(Object compareTo) throws ClassCastException {
        if (!(compareTo instanceof UUID)) {
            throw new ClassCastException();
        }
        return Bytes.compareTo(this.rawBytes, ((UUID)compareTo).getRawBytes());
    }

    public int clockSequence() throws UnsupportedOperationException {
        if (this.variant() != 2 || this.version() != 1) {
            throw new UnsupportedOperationException("Not a ietf variant 2 or version 1 (time-based UUID)");
        }
        if (this.clockSq == null) {
            byte[] b = new byte[]{(byte)(this.rawBytes[8] & 0x3F), this.rawBytes[9]};
            this.clockSq = new Short(Bytes.toShort(b));
        }
        return this.clockSq.intValue();
    }

    public int version() {
        if (this.version == -1) {
            this.version = this.rawBytes[6] >>> 4 & 0xF;
        }
        return this.version;
    }

    public int variant() {
        if (this.variant == -1) {
            this.variant = (this.rawBytes[8] & 0x80) == 0 ? 0 : ((this.rawBytes[8] & 0x40) == 0 ? 2 : ((this.rawBytes[8] & 0x20) == 0 ? 6 : 7));
        }
        return this.variant;
    }

    public long node() throws UnsupportedOperationException {
        if (this.variant() != 2 || this.version() != 1) {
            throw new UnsupportedOperationException("Not a ietf variant 2 or version 1 (time-based UUID)");
        }
        if (this.node == null) {
            byte[] b = new byte[8];
            System.arraycopy(this.rawBytes, 10, b, 2, 6);
            this.node = new Long(Bytes.toLong(b) & 0xFFFFFFFFFFFFL);
        }
        return this.node;
    }

    public long timestamp() throws UnsupportedOperationException {
        if (this.variant() != 2 || this.version() != 1) {
            throw new UnsupportedOperationException("Not a ietf variant 2 or version 1 (time-based UUID)");
        }
        if (this.timestamp == -1L) {
            byte[] longVal = new byte[8];
            System.arraycopy(this.rawBytes, 6, longVal, 0, 2);
            System.arraycopy(this.rawBytes, 4, longVal, 2, 2);
            System.arraycopy(this.rawBytes, 0, longVal, 4, 4);
            longVal[0] = (byte)(longVal[0] & 0xF);
            this.timestamp = Bytes.toLong(longVal);
        }
        return this.timestamp;
    }

    long getLeastSignificantBits() {
        byte[] lsb = new byte[8];
        System.arraycopy(this.rawBytes, 8, lsb, 0, 8);
        return Bytes.toLong(lsb);
    }

    long getMostSignificantBits() {
        byte[] msb = new byte[8];
        System.arraycopy(this.rawBytes, 0, msb, 0, 8);
        return Bytes.toLong(msb);
    }

    public byte[] getRawBytes() {
        byte[] ret = new byte[16];
        System.arraycopy(this.rawBytes, 0, ret, 0, 16);
        return ret;
    }

    public static UUID randomUUID() {
        return VersionFourGenerator.getInstance().nextUUID();
    }

    public static UUID timeUUID() {
        return VersionOneGenerator.getInstance().nextUUID();
    }

    public static UUID nameUUIDFromString(String name, UUID namespace, String encoding) {
        byte[] nameAsBytes = name.getBytes();
        byte[] concat = new byte[16 + nameAsBytes.length];
        System.arraycopy(namespace.getRawBytes(), 0, concat, 0, 16);
        System.arraycopy(nameAsBytes, 0, concat, 16, nameAsBytes.length);
        byte[] raw = null;
        if (encoding.equals("MD5")) {
            raw = DigestUtils.md5(concat);
        } else if (encoding.equals("SHA1")) {
            byte[] shaDigest = DigestUtils.sha(concat);
            raw = new byte[16];
            System.arraycopy(shaDigest, 0, raw, 0, 16);
        } else {
            throw new RuntimeException("Unsupported encoding " + encoding);
        }
        raw[6] = (byte)(raw[6] & 0xF);
        raw[6] = (byte)(raw[6] | 0x30);
        raw[8] = (byte)(raw[8] & 0x3F);
        raw[8] = (byte)(raw[8] | 0x80);
        return new UUID(raw);
    }

    public static UUID nameUUIDFromString(String name, UUID namespace) {
        return UUID.nameUUIDFromString(name, namespace, "MD5");
    }
}

