/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.id.uuid.task;

import org.apache.commons.id.uuid.UUID;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class UUIDTask
extends Task {
    private String uuidVersion = "VERSION_FOUR";
    private String name = "www.apache.org";
    private String namespace = "urn:uuid:B4F00409-CEF8-4822-802C-DEB20704C365";

    public void setName(String name) {
        this.name = name;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setVersion(UUIDVersion newVersion) {
        this.uuidVersion = newVersion.getValue();
    }

    public void execute() throws BuildException {
        UUID uuid = null;
        if (this.uuidVersion.equals("VERSION_THREE")) {
            uuid = UUID.nameUUIDFromString(this.name, new UUID(this.namespace), "MD5");
        } else if (this.uuidVersion.equals("VERSION_FIVE")) {
            uuid = UUID.nameUUIDFromString(this.name, new UUID(this.namespace), "SHA1");
        } else if (this.uuidVersion.equals("VERSION_FOUR")) {
            uuid = UUID.randomUUID();
        } else if (this.uuidVersion.equals("VERSION_ONE")) {
            uuid = UUID.timeUUID();
        }
        this.setProperty("uuid", uuid.toString());
    }

    private void setProperty(String name, String value) {
        this.getProject().setProperty(name, value);
    }

    public static class UUIDVersion
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"VERSION_ONE", "VERSION_THREE", "VERSION_FOUR", "VERSION_FIVE"};
        }
    }
}

