/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.filter;

import java.util.Date;
import java.util.Iterator;
import net.fortuna.ical4j.filter.ComponentRule;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.RDate;
import net.fortuna.ical4j.model.property.RRule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PeriodRule
extends ComponentRule {
    private Log log = LogFactory.getLog((Class)PeriodRule.class);
    private Period period;

    public PeriodRule(Period period) {
        this.period = period;
    }

    public final boolean match(Component component) {
        Date startPlusDuration;
        DtStart start = (DtStart)component.getProperty("DTSTART");
        if (start != null && this.period.includes((Date)start.getDate(), 1)) {
            this.debug(start.getDate(), "start date");
            return true;
        }
        DtEnd end = (DtEnd)component.getProperty("DTEND");
        if (end != null && this.period.includes((Date)end.getDate(), 2)) {
            this.debug(end.getDate(), "end date");
            return true;
        }
        Duration duration = (Duration)component.getProperty("DURATION");
        if (start != null && duration != null && this.period.includes(startPlusDuration = duration.getDuration().getTime(start.getDate()))) {
            this.debug(startPlusDuration, "duration");
            return true;
        }
        Iterator i = component.getProperties("RDATE").iterator();
        while (i.hasNext()) {
            RDate rdate = (RDate)i.next();
            if (!Value.PERIOD.equals(rdate.getParameter("VALUE"))) continue;
            Iterator j = rdate.getPeriods().iterator();
            while (j.hasNext()) {
                Period rdatePeriod = (Period)j.next();
                if (!this.period.intersects(rdatePeriod)) continue;
                this.debug(rdatePeriod.getStart(), "recurrence date");
                this.debug(rdatePeriod.getEnd(), "recurrence date");
                return true;
            }
        }
        i = component.getProperties("RRULE").iterator();
        while (i.hasNext()) {
            RRule rrule = (RRule)i.next();
            DateList startDates = rrule.getRecur().getDates(start.getDate(), this.period, (Value)start.getParameter("VALUE"));
            Iterator j = startDates.iterator();
            while (j.hasNext()) {
                Date recurDate = (Date)j.next();
                if (!this.period.includes(recurDate)) continue;
                this.debug(recurDate, "recurrence rule");
                return true;
            }
        }
        return false;
    }

    private void debug(Date date, String type) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Matching date: " + date + " (" + type + ")"));
        }
    }
}

