/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.regexp;

import com.caucho.regexp.IllegalRegexpException;
import com.caucho.regexp.Node;
import com.caucho.regexp.PeekStream;
import com.caucho.regexp.RegexpSet;
import com.caucho.util.CharBuffer;

class Regcomp {
    static final int MULTILINE = 1;
    static final int SINGLE_LINE = 2;
    static final int IGNORE_CASE = 4;
    static final int IGNORE_WS = 8;
    static final int GLOBAL = 16;
    int nGroup;
    int maxGroup;
    int nLoop;
    int flags;

    Regcomp(int flags) {
        this.flags = flags;
    }

    Node parse(PeekStream pattern) throws IllegalRegexpException {
        this.nGroup = 0;
        Node value = this.parseRec(pattern);
        if (this.nGroup > this.maxGroup) {
            this.maxGroup = this.nGroup;
        }
        return value;
    }

    /*
     * Unable to fully structure code
     */
    private Node parseRec(PeekStream pattern) throws IllegalRegexpException {
        head = null;
        last = null;
        block28: while ((ch = pattern.read()) >= 0) {
            switch (ch) {
                case 42: {
                    if (last == null) {
                        throw new IllegalRegexpException("`*' must follow content expression");
                    }
                    if (last.code == 8) {
                        throw new IllegalRegexpException("nested *?+");
                    }
                    if (pattern.peek() == 63) {
                        pattern.read();
                        node = new Node(10, this.nLoop++, 0, 0x7FFFFFFF);
                    } else {
                        node = new Node(8, this.nLoop++, 0, 0x7FFFFFFF);
                    }
                    node.branch = last;
                    last = node;
                    continue block28;
                }
                case 43: {
                    if (last == null) {
                        throw new IllegalRegexpException("`+' must follow content expression");
                    }
                    if (last.code == 8) {
                        throw new IllegalRegexpException("nested *?+");
                    }
                    if (pattern.peek() == 63) {
                        pattern.read();
                        node = new Node(10, this.nLoop++, 1, 0x7FFFFFFF);
                    } else {
                        node = new Node(8, this.nLoop++, 1, 0x7FFFFFFF);
                    }
                    node.branch = last;
                    last = node;
                    continue block28;
                }
                case 63: {
                    if (last == null) {
                        throw new IllegalRegexpException("`?' must follow content expression");
                    }
                    if (last.code == 8) {
                        throw new IllegalRegexpException("nested *?+");
                    }
                    if (pattern.peek() == 63) {
                        pattern.read();
                        node = new Node(10, this.nLoop++, 0, 1);
                    } else {
                        node = new Node(8, this.nLoop++, 0, 1);
                    }
                    node.branch = last;
                    last = node;
                    continue block28;
                }
                case 123: {
                    if (last == null) {
                        throw new IllegalRegexpException("`{' must follow content expression");
                    }
                    if (last.code == 8) {
                        throw new IllegalRegexpException("nested *?+");
                    }
                    node = new Node(8);
                    ++this.nLoop;
                    node.index = node.index;
                    node.branch = last;
                    this.parseBrace(pattern, node);
                    ch = pattern.read();
                    if (ch != 125) {
                        throw new IllegalRegexpException("expected `}' at " + this.badChar(ch));
                    }
                    if (pattern.peek() == 63) {
                        pattern.read();
                        node.code = 10;
                    }
                    last = node;
                    continue block28;
                }
                case 124: {
                    head = new Node(13, Node.concat(head, last));
                    last = null;
                    continue block28;
                }
                case 40: {
                    head = Node.concat(head, last);
                    if (pattern.peek() != 63) ** GOTO lbl119
                    pattern.read();
                    ch = pattern.read();
                    switch (ch) {
                        case 35: {
                            while ((ch = pattern.read()) >= 0 && ch != 41) {
                            }
                            pattern.ungetc(ch);
                            last = null;
                            ** GOTO lbl124
                        }
                        case 58: {
                            last = this.parseRec(pattern);
                            last = Node.replaceTail(last, new Node(1));
                            ** GOTO lbl124
                        }
                        case 61: {
                            last = new Node(15, this.parseRec(pattern));
                            ** GOTO lbl124
                        }
                        case 33: {
                            last = new Node(16, this.parseRec(pattern));
                            ** GOTO lbl124
                        }
                        case 103: 
                        case 105: 
                        case 109: 
                        case 115: 
                        case 120: {
                            do {
                                switch (ch) {
                                    case 109: {
                                        this.flags |= 1;
                                        break;
                                    }
                                    case 105: {
                                        this.flags |= 4;
                                        break;
                                    }
                                    case 115: {
                                        this.flags |= 2;
                                        break;
                                    }
                                    case 120: {
                                        this.flags |= 8;
                                        break;
                                    }
                                    case 103: {
                                        this.flags |= 16;
                                        break;
                                    }
                                    default: {
                                        throw new IllegalRegexpException("expected one of `misxg' at " + this.badChar(ch));
                                    }
                                }
                            } while ((ch = pattern.read()) >= 0 && ch != 41);
                            pattern.ungetc(ch);
                            last = null;
                            ** GOTO lbl124
                        }
                        default: {
                            throw new IllegalRegexpException("expected `(?' code at " + this.badChar(ch));
                        }
                    }
lbl119:
                    // 1 sources

                    groupIndex = ++this.nGroup;
                    last = new Node(5, groupIndex);
                    last.rest = this.parseRec(pattern);
                    node = new Node(6, groupIndex);
                    last = Node.replaceTail(last, node);
lbl124:
                    // 6 sources

                    if ((ch = pattern.read()) == 41) continue block28;
                    throw new IllegalRegexpException("expected `)' at " + this.badChar(ch));
                }
                case 41: {
                    pattern.ungetc(ch);
                    return Node.concat(head, last);
                }
                case 91: {
                    head = Node.concat(head, last);
                    last = this.parseSet(pattern);
                    ch = pattern.read();
                    if (ch == 93) continue block28;
                    throw new IllegalRegexpException("expected `]' at " + this.badChar(ch));
                }
                case 46: {
                    head = Node.concat(head, last);
                    if ((this.flags & 2) == 0) {
                        last = new Node(4, RegexpSet.DOT);
                        continue block28;
                    }
                    last = new Node(4, new RegexpSet());
                    continue block28;
                }
                case 92: {
                    next = this.parseSlash(pattern, last);
                    if (next != last) {
                        head = Node.concat(head, last);
                    }
                    last = next;
                    continue block28;
                }
                case 94: {
                    head = Node.concat(head, last);
                    if ((this.flags & 1) != 0) {
                        last = new Node(19);
                        continue block28;
                    }
                    last = new Node(21);
                    continue block28;
                }
                case 36: {
                    head = Node.concat(head, last);
                    if ((this.flags & 1) != 0) {
                        last = new Node(20);
                        continue block28;
                    }
                    last = new Node(22);
                    continue block28;
                }
            }
            next = this.parseString(ch, pattern, last);
            if (next == last) continue;
            head = Node.concat(head, last);
            last = next;
        }
        return Node.concat(head, last);
    }

    private void parseBrace(PeekStream pattern, Node loop) {
        int ch;
        loop.min = 0;
        while ((ch = pattern.read()) >= 48 && ch <= 57) {
            loop.min = 10 * loop.min + ch - 48;
        }
        if (ch != 44) {
            loop.max = loop.min;
            pattern.ungetc(ch);
            return;
        }
        loop.max = Integer.MAX_VALUE;
        while ((ch = pattern.read()) >= 48 && ch <= 57) {
            loop.max = loop.max == Integer.MAX_VALUE ? 0 : loop.max;
            loop.max = 10 * loop.max + ch - 48;
        }
        pattern.ungetc(ch);
    }

    private String hex(int value) {
        CharBuffer cb = new CharBuffer();
        for (int b = 3; b >= 0; --b) {
            int v = value >> 4 * b & 0xF;
            if (v < 10) {
                cb.append((char)(v + 48));
                continue;
            }
            cb.append((char)(v - 10 + 97));
        }
        return cb.toString();
    }

    private String badChar(int ch) {
        if (ch >= 32 && ch <= 127) {
            return "`" + (char)ch + "'";
        }
        if ((ch & 0xFFFF) == 65535) {
            return "end of expression";
        }
        return "`" + (char)ch + "' (\\u" + this.hex(ch) + ")";
    }

    private Node parseSet(PeekStream pattern) throws IllegalRegexpException {
        int ch;
        RegexpSet set;
        Node node;
        if (pattern.peek() == 94) {
            pattern.read();
            node = new Node(4);
        } else {
            node = new Node(3);
        }
        node.set = set = new RegexpSet();
        int last = -1;
        int lastdash = -1;
        while ((ch = pattern.read()) != 93 && ch >= 0) {
            boolean isDash;
            boolean isChar = true;
            boolean bl = isDash = ch == 45;
            if (ch == 92) {
                isChar = false;
                ch = pattern.read();
                switch (ch) {
                    case 115: {
                        set.mergeOr(RegexpSet.SPACE);
                        break;
                    }
                    case 83: {
                        set.mergeOrInv(RegexpSet.SPACE);
                        break;
                    }
                    case 100: {
                        set.mergeOr(RegexpSet.DIGIT);
                        break;
                    }
                    case 68: {
                        set.mergeOrInv(RegexpSet.DIGIT);
                        break;
                    }
                    case 119: {
                        set.mergeOr(RegexpSet.WORD);
                        break;
                    }
                    case 87: {
                        set.mergeOrInv(RegexpSet.WORD);
                        break;
                    }
                    case 98: {
                        ch = 8;
                        isChar = true;
                        break;
                    }
                    default: {
                        isChar = true;
                    }
                }
            }
            if (isDash && last != -1 && lastdash == -1) {
                lastdash = last;
                continue;
            }
            if (isChar && lastdash != -1) {
                if (lastdash > ch) {
                    throw new IllegalRegexpException("expected increasing range at " + this.badChar(ch));
                }
                set.setRange(lastdash, ch);
                last = -1;
                lastdash = -1;
                continue;
            }
            if (lastdash != -1) {
                set.setRange(lastdash, lastdash);
                set.setRange(45, 45);
                last = -1;
                lastdash = -1;
                continue;
            }
            if (last != -1) {
                set.setRange(last, last);
                if (!isChar) continue;
                last = ch;
                continue;
            }
            if (!isChar) continue;
            last = ch;
        }
        if (lastdash != -1) {
            set.setRange(lastdash, lastdash);
            set.setRange(45, 45);
        } else if (last != -1) {
            set.setRange(last, last);
        }
        if (ch == 93) {
            pattern.ungetc(ch);
        }
        return node;
    }

    private Node parseString(int ch, PeekStream pattern, Node last) throws IllegalRegexpException {
        if ((this.flags & 8) != 0 && RegexpSet.SPACE.match(ch)) {
            return last;
        }
        int next = pattern.read();
        if (last == null || last.code != 2 || next == 42 || next == 63 || next == 123 || next == 43) {
            last = new Node(new CharBuffer());
        }
        last.string.append((char)ch);
        if (next != -1) {
            pattern.ungetc(next);
        }
        return last;
    }

    private Node parseSlash(PeekStream pattern, Node last) throws IllegalRegexpException {
        int ch = pattern.read();
        switch (ch) {
            case 115: {
                return new Node(3, new RegexpSet(RegexpSet.SPACE));
            }
            case 83: {
                return new Node(4, new RegexpSet(RegexpSet.SPACE));
            }
            case 100: {
                return new Node(3, new RegexpSet(RegexpSet.DIGIT));
            }
            case 68: {
                return new Node(4, new RegexpSet(RegexpSet.DIGIT));
            }
            case 119: {
                return new Node(3, new RegexpSet(RegexpSet.WORD));
            }
            case 87: {
                return new Node(4, new RegexpSet(RegexpSet.WORD));
            }
            case 98: {
                return new Node(17);
            }
            case 66: {
                return new Node(18);
            }
            case 65: {
                return new Node(21);
            }
            case 90: {
                return new Node(22);
            }
            case 71: {
                return new Node(23);
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                boolean badOct;
                int value = ch - 48;
                int oct = ch - 48;
                boolean bl = badOct = ch >= 56;
                while ((ch = pattern.read()) >= 48 && ch <= 57) {
                    value = 10 * value + ch - 48;
                    oct = 8 * oct + ch - 48;
                    if (ch < 56) continue;
                    badOct = true;
                }
                if (ch != -1) {
                    pattern.ungetc(ch);
                }
                if (value <= this.nGroup) {
                    return new Node(7, value);
                }
                if (badOct) {
                    throw new IllegalRegexpException("expected octal digit at " + this.badChar(ch));
                }
                return this.parseString(oct, pattern, last);
            }
        }
        return this.parseString(ch, pattern, last);
    }
}

