/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.regexp;

import com.caucho.regexp.IllegalRegexpException;
import com.caucho.regexp.Node;
import com.caucho.regexp.PeekString;
import com.caucho.regexp.RegOptim;
import com.caucho.regexp.Regcomp;
import com.caucho.regexp.RegexpSet;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharCursor;
import com.caucho.util.IntArray;
import com.caucho.util.StringCharCursor;
import java.util.ArrayList;
import java.util.logging.Logger;

public class Regexp {
    private static final Logger log = Logger.getLogger(Regexp.class.getName());
    public static final int FAIL = -1;
    String pattern;
    Node prog;
    boolean ignoreCase;
    boolean isGlobal;
    int first;
    int start;
    StringCharCursor stringCursor;
    int nLoop;
    int[] loopCount;
    int[] loopTail;
    int nGroup;
    int[] groupStart;
    IntArray group;
    int match;
    int lexeme;
    CharBuffer cb;
    CharBuffer prefix;
    int minLength;
    CharCursor lastCursor;
    int lastIndex;

    public Regexp(String pattern, String sflags) throws IllegalRegexpException {
        this.pattern = pattern;
        int flags = 0;
        block7: for (int i = 0; sflags != null && i < sflags.length(); ++i) {
            switch (sflags.charAt(i)) {
                case 'm': {
                    flags |= 1;
                    continue block7;
                }
                case 's': {
                    flags |= 2;
                    continue block7;
                }
                case 'i': {
                    flags |= 4;
                    continue block7;
                }
                case 'x': {
                    flags |= 8;
                    continue block7;
                }
                case 'g': {
                    flags |= 0x10;
                }
            }
        }
        Regcomp comp = new Regcomp(flags);
        this.prog = comp.parse(new PeekString(pattern));
        this.compile(this.prog, comp);
    }

    public Regexp(String pattern) throws IllegalRegexpException {
        this(pattern, null);
    }

    public Regexp(Node prog, Regcomp comp) {
        this.compile(prog, comp);
    }

    public String getPattern() {
        return this.pattern;
    }

    private void compile(Node prog, Regcomp comp) {
        this.ignoreCase = (comp.flags & 4) != 0;
        boolean bl = this.isGlobal = (comp.flags & 0x10) != 0;
        if (this.ignoreCase) {
            RegOptim.ignoreCase(prog);
        }
        if (!this.ignoreCase) {
            RegOptim.eliminateBacktrack(prog, null);
        }
        this.minLength = RegOptim.minLength(prog);
        this.prefix = RegOptim.prefix(prog);
        this.prog = RegOptim.linkLoops(prog);
        this.nGroup = comp.maxGroup;
        this.nLoop = comp.nLoop;
        this.groupStart = new int[this.nGroup + 1];
        this.loopCount = new int[this.nLoop];
        this.loopTail = new int[this.nLoop];
        this.cb = new CharBuffer();
        this.stringCursor = new StringCharCursor("");
        this.group = new IntArray();
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public boolean ignoreCase() {
        return this.ignoreCase;
    }

    public int exec(CharCursor cursor, int start, int first) {
        int pos;
        this.start = start;
        this.first = first;
        cursor.setIndex(first);
        int begin = cursor.getIndex();
        int value = -1;
        if (begin >= first) {
            do {
                this.group.setLength(0);
                value = this.match(this.prog, cursor);
                if (value != -1) break;
                cursor.setIndex(begin + 1);
                begin = cursor.getIndex();
            } while (cursor.current() != '\uffff');
        }
        if ((pos = cursor.getIndex()) < begin) {
            begin = pos;
        }
        if (this.group.size() < 2) {
            this.group.setLength(2);
        }
        this.group.set(0, begin);
        this.group.set(1, pos);
        return value;
    }

    public int exec(String string, int first) {
        this.stringCursor.init(string);
        return this.exec(this.stringCursor, 0, first);
    }

    public int exec(CharBuffer buffer, int first) {
        this.stringCursor.init(buffer.toString());
        return this.exec(this.stringCursor, 0, first);
    }

    public int exec(CharCursor cursor) {
        int first = 0;
        if (cursor == this.lastCursor) {
            first = this.lastIndex;
        }
        this.lastCursor = cursor;
        int value = this.exec(cursor, 0, first);
        this.lastIndex = value == -1 ? 0 : (this.getBegin(0) == this.getEnd(0) ? this.getEnd(0) + 1 : this.getEnd(0));
        return value;
    }

    private int match(Node prog, CharCursor cursor) {
        while (prog != null) {
            switch (prog.code) {
                case 1: {
                    prog = prog.rest;
                    break;
                }
                case 0: 
                case 28: {
                    this.lexeme = prog.index;
                    return prog.index;
                }
                case 2: {
                    int length = prog.string.length();
                    if (cursor.regionMatches(prog.string.getBuffer(), 0, length)) {
                        prog = prog.rest;
                        break;
                    }
                    return -1;
                }
                case 24: {
                    int length = prog.string.length();
                    if (cursor.regionMatchesIgnoreCase(prog.string.getBuffer(), 0, length)) {
                        prog = prog.rest;
                        break;
                    }
                    return -1;
                }
                case 3: {
                    char ch = cursor.read();
                    if (ch != '\uffff' && prog.set.match(ch)) {
                        prog = prog.rest;
                        break;
                    }
                    return -1;
                }
                case 25: {
                    char ch = cursor.read();
                    if (ch == '\uffff') {
                        return -1;
                    }
                    char lch = Character.toLowerCase(ch);
                    char uch = Character.toUpperCase(lch);
                    if (prog.set.match(lch) || prog.set.match(uch)) {
                        prog = prog.rest;
                        break;
                    }
                    return -1;
                }
                case 4: {
                    char ch = cursor.read();
                    if (ch != '\uffff' && !prog.set.match(ch)) {
                        prog = prog.rest;
                        break;
                    }
                    return -1;
                }
                case 26: {
                    char ch = cursor.read();
                    if (ch == '\uffff') {
                        return -1;
                    }
                    char lch = Character.toLowerCase(ch);
                    char uch = Character.toUpperCase(lch);
                    if (!prog.set.match(lch) && !prog.set.match(uch)) {
                        prog = prog.rest;
                        break;
                    }
                    return -1;
                }
                case 5: {
                    this.groupStart[prog.index] = cursor.getIndex();
                    prog = prog.rest;
                    break;
                }
                case 6: {
                    int index = 2 * prog.index;
                    if (this.group.size() <= index + 1) {
                        this.group.setLength(index + 2);
                    }
                    this.group.set(2 * prog.index, this.groupStart[prog.index]);
                    this.group.set(2 * prog.index + 1, cursor.getIndex());
                    prog = prog.rest;
                    break;
                }
                case 7: {
                    int begin = this.group.get(2 * prog.index);
                    int length = this.group.get(2 * prog.index + 1) - this.group.get(2 * prog.index);
                    this.cb.setLength(0);
                    cursor.subseq(this.cb, begin, begin + length);
                    if (cursor.regionMatches(this.cb.getBuffer(), 0, length)) {
                        prog = prog.rest;
                        break;
                    }
                    return -1;
                }
                case 27: {
                    int begin = this.group.get(2 * prog.index);
                    int length = this.group.get(2 * prog.index + 1) - this.group.get(2 * prog.index);
                    this.cb.setLength(0);
                    cursor.subseq(this.cb, begin, begin + length);
                    if (cursor.regionMatchesIgnoreCase(this.cb.getBuffer(), 0, length)) {
                        cursor.skip(length);
                        prog = prog.rest;
                        break;
                    }
                    return -1;
                }
                case 9: {
                    this.loopCount[prog.rest.index] = 0;
                    this.loopTail[prog.rest.index] = -1;
                    prog = prog.rest;
                    break;
                }
                case 8: {
                    int tail = cursor.getIndex();
                    int n = prog.index;
                    int n2 = this.loopCount[n];
                    this.loopCount[n] = n2 + 1;
                    if (n2 < prog.min) {
                        prog = prog.branch;
                        break;
                    }
                    if (this.loopCount[prog.index] > prog.max) {
                        prog = prog.rest;
                        break;
                    }
                    if (this.loopTail[prog.index] == tail) {
                        return -1;
                    }
                    this.loopTail[prog.index] = tail;
                    int match = this.group.size();
                    char ch = cursor.current();
                    if (ch == '\uffff') {
                        prog = prog.rest;
                        break;
                    }
                    if (prog.set != null && prog.set.match(ch)) {
                        prog = prog.branch;
                        break;
                    }
                    int value = this.match(prog.branch, cursor);
                    if (value != -1) {
                        return value;
                    }
                    cursor.setIndex(tail);
                    this.group.setLength(match);
                    prog = prog.rest;
                    break;
                }
                case 10: {
                    int tail = cursor.getIndex();
                    int n = prog.index;
                    int n3 = this.loopCount[n];
                    this.loopCount[n] = n3 + 1;
                    if (n3 < prog.min) {
                        prog = prog.branch;
                        break;
                    }
                    if (this.loopCount[prog.index] > prog.max) {
                        prog = prog.rest;
                        break;
                    }
                    int value = this.match(prog.rest, cursor);
                    if (value != -1) {
                        return value;
                    }
                    if (this.loopTail[prog.index] == tail) {
                        return -1;
                    }
                    this.loopTail[prog.index] = tail;
                    cursor.setIndex(tail);
                    prog = prog.branch;
                    break;
                }
                case 11: {
                    int n = prog.index;
                    int n4 = this.loopCount[n];
                    this.loopCount[n] = n4 + 1;
                    if (n4 < prog.min) {
                        prog = prog.branch;
                        break;
                    }
                    if (this.loopCount[prog.index] > prog.max) {
                        prog = prog.rest;
                        break;
                    }
                    char ch = cursor.current();
                    if (ch == '\uffff') {
                        prog = prog.rest;
                        break;
                    }
                    if (prog.set.match(ch)) {
                        prog = prog.branch;
                        break;
                    }
                    prog = prog.rest;
                    break;
                }
                case 13: {
                    this.match = this.group.size();
                    int tail = cursor.getIndex();
                    int value = this.match(prog.branch, cursor);
                    if (value != -1) {
                        return value;
                    }
                    cursor.setIndex(tail);
                    this.group.setLength(this.match);
                    prog = prog.rest;
                    break;
                }
                case 14: {
                    char ch = cursor.current();
                    if (ch == '\uffff') {
                        prog = prog.rest;
                        break;
                    }
                    if (prog.set.match(ch)) {
                        prog = prog.branch;
                        break;
                    }
                    prog = prog.rest;
                    break;
                }
                case 15: {
                    int tail = cursor.getIndex();
                    if (this.match(prog.branch, cursor) == -1) {
                        return -1;
                    }
                    cursor.setIndex(tail);
                    prog = prog.rest;
                    break;
                }
                case 16: {
                    int tail = cursor.getIndex();
                    if (this.match(prog.branch, cursor) != -1) {
                        return -1;
                    }
                    cursor.setIndex(tail);
                    prog = prog.rest;
                    break;
                }
                case 19: {
                    if (cursor.getIndex() == this.start) {
                        prog = prog.rest;
                        break;
                    }
                    if (cursor.previous() == '\n') {
                        cursor.next();
                        prog = prog.rest;
                        break;
                    }
                    cursor.next();
                    return -1;
                }
                case 20: {
                    if (cursor.current() == '\uffff' || cursor.current() == '\n') {
                        prog = prog.rest;
                        break;
                    }
                    return -1;
                }
                case 23: {
                    if (cursor.getIndex() == this.first) {
                        prog = prog.rest;
                        break;
                    }
                    return -1;
                }
                case 21: {
                    if (cursor.getIndex() == this.start) {
                        prog = prog.rest;
                        break;
                    }
                    return -1;
                }
                case 22: {
                    if (cursor.current() == '\uffff') {
                        prog = prog.rest;
                        break;
                    }
                    return -1;
                }
                case 17: {
                    int tail = cursor.getIndex();
                    if ((tail != this.start && RegexpSet.WORD.match(cursor.prev())) != (cursor.current() != '\uffff' && RegexpSet.WORD.match(cursor.current()))) {
                        prog = prog.rest;
                        break;
                    }
                    return -1;
                }
                case 18: {
                    int tail = cursor.getIndex();
                    if ((tail != this.start && RegexpSet.WORD.match(cursor.prev())) == (cursor.current() != '\uffff' && RegexpSet.WORD.match(cursor.current()))) {
                        prog = prog.rest;
                        break;
                    }
                    return -1;
                }
                default: {
                    throw new RuntimeException("Internal error");
                }
            }
        }
        return 0;
    }

    public int getBegin(int i) {
        if (this.group.size() < 2 * i) {
            return 0;
        }
        return this.group.get(2 * i);
    }

    public int getEnd(int i) {
        if (this.group.size() < 2 * i + 1) {
            return 0;
        }
        return this.group.get(2 * i + 1);
    }

    public int length() {
        return this.group.size() / 2;
    }

    public boolean match(String string) {
        return this.exec(string, 0) != -1;
    }

    public ArrayList split(String string) {
        ArrayList<String> vector = new ArrayList<String>();
        int i = 0;
        int length = string.length();
        while (i < length) {
            if (this.exec(string, i) == -1) {
                vector.add(string.substring(i));
                break;
            }
            vector.add(string.substring(i, this.getBegin(0)));
            if (this.getBegin(0) != this.getEnd(0)) {
                i = this.getEnd(0);
                continue;
            }
            i = this.getEnd(0) + 1;
        }
        return vector;
    }

    public CharBuffer replace(String test, String replace, CharBuffer cb) {
        cb.clear();
        for (int i = 0; i < replace.length(); ++i) {
            char ch = replace.charAt(i);
            if (ch != '$' || i == replace.length() - 1) {
                cb.append(ch);
                continue;
            }
            ch = replace.charAt(i + 1);
            if (ch >= '0' && ch <= '9') {
                int group = ch - 48;
                if (group < this.length()) {
                    cb.append(test.substring(this.getBegin(group), this.getEnd(group)));
                }
                ++i;
                continue;
            }
            if (ch == '$') {
                cb.append('$');
                ++i;
                continue;
            }
            cb.append('$');
        }
        return cb;
    }

    public String replace(String test, String replace) {
        return this.replace(test, replace, this.cb).toString();
    }

    public CharBuffer fill(String test, String replace, CharBuffer cb) {
        cb.clear();
        for (int i = 0; i < replace.length(); ++i) {
            char ch = replace.charAt(i);
            if (ch != '$' || i == replace.length() - 1) {
                cb.append(ch);
                continue;
            }
            ch = replace.charAt(i + 1);
            if (ch >= '0' && ch <= '9') {
                int group = ch - 48;
                if (group < this.length()) {
                    cb.append(test.substring(this.getBegin(group), this.getEnd(group)));
                }
                ++i;
                continue;
            }
            if (ch == '$') {
                cb.append('$');
                ++i;
                continue;
            }
            cb.append('$');
        }
        return cb;
    }

    public String fill(String test, String replace) {
        return this.replace(test, replace, this.cb).toString();
    }

    public String toString() {
        return "[Regexp " + this.pattern + "]";
    }
}

