/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.regexp;

import com.caucho.util.IntSet;

class RegexpSet {
    static final int BITSET_CHARS = 128;
    static final int BITSET_WIDTH = 16;
    static RegexpSet SPACE = null;
    static RegexpSet WORD = null;
    static RegexpSet DIGIT = null;
    static RegexpSet DOT = null;
    int[] bitset = new int[16];
    IntSet range;

    void mergeOr(RegexpSet b) {
        for (int i = 0; i < 16; ++i) {
            int n = i;
            this.bitset[n] = this.bitset[n] | b.bitset[i];
        }
        this.range.union(b.range);
    }

    void mergeOrInv(RegexpSet b) {
        for (int i = 0; i < 16; ++i) {
            int n = i;
            this.bitset[n] = this.bitset[n] | ~b.bitset[i];
        }
        this.range.unionNegate(b.range, 0, 65535);
    }

    void setRange(int low, int high) {
        if (low > high || low < 0 || high > 65535) {
            throw new RuntimeException("Range out of range");
        }
        if (low < 128) {
            for (int i = low; i < Math.min(high + 1, 128); ++i) {
                int n = i >> 3;
                this.bitset[n] = this.bitset[n] | 1 << (i & 7);
            }
            if (high < 128) {
                return;
            }
            low = 128;
        }
        this.range.union(low, high);
    }

    boolean mergeOverlap(RegexpSet next) {
        boolean isDisjoint = true;
        for (int i = 0; i < 16; ++i) {
            int n = i;
            this.bitset[n] = this.bitset[n] & next.bitset[i];
            if (this.bitset[n] == 0) continue;
            isDisjoint = false;
        }
        if (this.range.intersection(next.range)) {
            isDisjoint = false;
        }
        return isDisjoint;
    }

    void difference(RegexpSet next) {
        for (int i = 0; i < 16; ++i) {
            int n = i;
            this.bitset[n] = this.bitset[n] & ~next.bitset[i];
        }
        this.range.difference(next.range);
    }

    boolean match(int ch) {
        if (ch < 0) {
            return false;
        }
        if (ch < 128) {
            return (this.bitset[ch >> 3] & 1 << (ch & 7)) != 0;
        }
        return this.range.contains(ch);
    }

    RegexpSet() {
        this.range = new IntSet();
    }

    RegexpSet(RegexpSet old) {
        for (int i = 0; i < 16; ++i) {
            this.bitset[i] = old.bitset[i];
        }
        this.range = (IntSet)old.range.clone();
    }

    static {
        SPACE = new RegexpSet();
        SPACE.setRange(32, 32);
        SPACE.setRange(9, 13);
        DOT = new RegexpSet();
        DOT.setRange(10, 10);
        DIGIT = new RegexpSet();
        DIGIT.setRange(48, 57);
        WORD = new RegexpSet();
        WORD.setRange(97, 122);
        WORD.setRange(65, 90);
        WORD.setRange(48, 57);
        WORD.setRange(95, 95);
    }
}

