/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.ClockCacheItem;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClockCache<K, E extends ClockCacheItem> {
    private K[] _keys;
    private E[] _values;
    private int _capacity;
    private int _size;
    private int _mask;
    private int _clock;

    public ClockCache(int initialCapacity) {
        int capacity;
        for (capacity = 16; capacity < initialCapacity; capacity *= 2) {
        }
        this._keys = new Object[capacity];
        this._values = (ClockCacheItem[])new Object[capacity];
        this._mask = capacity - 1;
        this._capacity = initialCapacity;
    }

    public int size() {
        return this._size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        int i;
        ArrayList<E> listeners = null;
        ClockCache clockCache = this;
        synchronized (clockCache) {
            for (int i2 = 0; i2 < this._values.length; ++i2) {
                E item = this._values[i2];
                if (item != null) {
                    if (listeners == null) {
                        listeners = new ArrayList<E>();
                    }
                    listeners.add(item);
                }
                this._values[i2] = null;
            }
            this._size = 0;
        }
        int n = i = listeners == null ? -1 : listeners.size() - 1;
        while (i >= 0) {
            ClockCacheItem listener = (ClockCacheItem)listeners.get(i);
            listener.removeEvent();
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E get(K key) {
        int hash = key.hashCode() & this._mask;
        ClockCache clockCache = this;
        synchronized (clockCache) {
            for (int count = this._size + 1; count > 0; --count) {
                E item = this._values[hash];
                if (item == null) {
                    return null;
                }
                if (this._keys[hash].equals(key)) {
                    item.setUsed();
                    return item;
                }
                hash = hash + 1 & this._mask;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E put(K key, E value) {
        this.freeSpace();
        E item = this.putImpl(key, value);
        if (3 * this._values.length <= 4 * this._size) {
            ClockCache clockCache = this;
            synchronized (clockCache) {
                K[] oldKeys = this._keys;
                E[] oldValues = this._values;
                this._keys = new Object[2 * oldKeys.length];
                this._values = (ClockCacheItem[])new Object[2 * oldValues.length];
                this._mask = this._values.length - 1;
                this._size = 0;
                for (int i = oldValues.length - 1; i >= 0; --i) {
                    K oldKey = oldKeys[i];
                    E oldValue = oldValues[i];
                    if (oldValue == null) continue;
                    this.putImpl(oldKey, oldValue);
                }
            }
        }
        if (item != null) {
            item.removeEvent();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E putImpl(K key, E value) {
        ClockCacheItem item = null;
        int hash = key.hashCode() & this._mask;
        ClockCache clockCache = this;
        synchronized (clockCache) {
            for (int count = this._size + 1; count > 0; --count) {
                item = (ClockCacheItem)this._values[hash];
                if (item == null) {
                    this._keys[hash] = key;
                    this._values[hash] = value;
                    ++this._size;
                    return null;
                }
                if (this._keys[hash].equals(key)) {
                    item.setUsed();
                    this._values[hash] = value;
                    return (E)item;
                }
                hash = hash + 1 & this._mask;
            }
        }
        throw new IllegalStateException();
    }

    private void freeSpace() {
        int i = this._size - this._capacity;
        if (i > 16) {
            i = 16;
        }
        while (i-- > 0 && this.removeItem()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeItem() {
        int length = this._values.length;
        int clock = this._clock;
        ClockCacheItem item = null;
        for (int i = 0; i < length; ++i) {
            ClockCache clockCache = this;
            synchronized (clockCache) {
                item = this._values[clock];
                if (item != null && !item.isUsed()) {
                    this._keys[clock] = null;
                    this._values[clock] = null;
                    --this._size;
                    this.refillEntries(clock);
                    break;
                }
            }
            if (item != null) {
                item.clearUsed();
            }
            clock = (clock + 1) % length;
            item = null;
        }
        this._clock = clock;
        if (item != null) {
            item.removeEvent();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClockCacheItem remove(K key) {
        int count;
        int hash = key.hashCode() & this._mask;
        ClockCacheItem item = null;
        ClockCache clockCache = this;
        synchronized (clockCache) {
            for (count = this._size + 1; count > 0; --count) {
                item = (ClockCacheItem)this._values[hash];
                if (item == null) {
                    return null;
                }
                if (this._keys[hash].equals(key)) {
                    this._keys[hash] = null;
                    this._values[hash] = null;
                    --this._size;
                    this.refillEntries(hash);
                    break;
                }
                hash = hash + 1 & this._mask;
            }
        }
        if (count < 0) {
            throw new RuntimeException("internal cache error");
        }
        item.removeEvent();
        return item;
    }

    private void refillEntries(int hash) {
        for (int count = this._size; count >= 0; --count) {
            if (this._values[hash = hash + 1 & this._mask] == null) {
                return;
            }
            this.refillEntry(hash);
        }
    }

    private void refillEntry(int baseHash) {
        K key = this._keys[baseHash];
        E value = this._values[baseHash];
        this._keys[baseHash] = null;
        this._values[baseHash] = null;
        int hash = key.hashCode() & this._mask;
        for (int count = this._size; count >= 0; --count) {
            if (this._values[hash] == null) {
                this._keys[hash] = key;
                this._values[hash] = value;
                return;
            }
            hash = hash + 1 & this._mask;
        }
    }

    public Iterator<E> values() {
        ValueIterator iter = new ValueIterator();
        iter.init(this);
        return iter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ValueIterator<K1, V1 extends ClockCacheItem>
    implements Iterator<V1> {
        ClockCache<K1, V1> _cache;
        int _i;

        ValueIterator() {
        }

        void init(ClockCache<K1, V1> cache) {
            this._cache = cache;
            this._i = 0;
        }

        @Override
        public boolean hasNext() {
            ClockCacheItem[] values = ((ClockCache)this._cache)._values;
            int len = values.length;
            while (this._i < len) {
                if (values[this._i] != null) {
                    return true;
                }
                ++this._i;
            }
            return false;
        }

        @Override
        public V1 next() {
            ClockCacheItem[] values = ((ClockCache)this._cache)._values;
            Object[] keys = ((ClockCache)this._cache)._keys;
            int len = values.length;
            if (this._i < values.length && values[this._i] != null) {
                ClockCacheItem value = values[this._i++];
                return (V1)value;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

