/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import java.util.Iterator;

public class IntMap {
    public static final int NULL = -65536;
    private static int DELETED = 1;
    private Object[] _keys;
    private int _nullValue;
    private int[] _values;
    private int _size;
    private int _mask;

    public IntMap() {
        this._keys = new Object[16];
        this._values = new int[16];
        this._mask = this._keys.length - 1;
        this._size = 0;
        this._nullValue = -65536;
    }

    private IntMap(boolean dummy) {
    }

    public void clear() {
        this._nullValue = -65536;
        for (int i = 0; i < this._values.length; ++i) {
            this._keys[i] = null;
            this._values[i] = 0;
        }
        this._size = 0;
    }

    public int size() {
        return this._size;
    }

    public int get(Object key) {
        if (key == null) {
            return this._nullValue;
        }
        int hash = key.hashCode() & this._mask;
        Object[] keys = this._keys;
        for (int i = keys.length; i >= 0; --i) {
            Object mapKey = keys[hash];
            if (mapKey == key) {
                return this._values[hash];
            }
            if (mapKey == null) {
                return -65536;
            }
            if (mapKey.equals(key)) {
                return this._values[hash];
            }
            hash = hash + 1 & this._mask;
        }
        return -65536;
    }

    private void resize(int newSize) {
        Object[] newKeys = new Object[newSize];
        int[] newValues = new int[newSize];
        this._mask = newKeys.length - 1;
        block0: for (int i = 0; i < this._keys.length; ++i) {
            if (this._keys[i] == null) continue;
            int hash = this._keys[i].hashCode() & this._mask;
            for (int j = this._mask; j >= 0; --j) {
                if (newKeys[hash] == null) {
                    newKeys[hash] = this._keys[i];
                    newValues[hash] = this._values[i];
                    continue block0;
                }
                hash = hash + 1 & this._mask;
            }
        }
        this._keys = newKeys;
        this._values = newValues;
    }

    public int put(Object key, int value) {
        if (key == null) {
            int old = this._nullValue;
            this._nullValue = value;
            return old;
        }
        int hash = key.hashCode() & this._mask;
        for (int count = this._size; count >= 0; --count) {
            Object testKey = this._keys[hash];
            if (testKey == null) {
                this._keys[hash] = key;
                this._values[hash] = value;
                ++this._size;
                if (this._keys.length <= 4 * this._size) {
                    this.resize(4 * this._keys.length);
                }
                return -65536;
            }
            if (key == testKey || testKey.equals(key)) {
                int old = this._values[hash];
                this._values[hash] = value;
                return old;
            }
            hash = hash + 1 & this._mask;
        }
        return -65536;
    }

    public int remove(Object key) {
        if (key == null) {
            int old = this._nullValue;
            this._nullValue = -65536;
            return old;
        }
        int hash = key.hashCode() & this._mask;
        for (int j = this._size; j >= 0; --j) {
            Object mapKey = this._keys[hash];
            if (mapKey == null) {
                return -65536;
            }
            if (mapKey.equals(key)) {
                --this._size;
                this._keys[hash] = null;
                int value = this._values[hash];
                this.refillEntries(hash);
                return value;
            }
            hash = hash + 1 & this._mask;
        }
        return -65536;
    }

    private void refillEntries(int hash) {
        for (int count = this._size; count >= 0; --count) {
            if (this._keys[hash = hash + 1 & this._mask] == null) {
                return;
            }
            this.refillEntry(hash);
        }
    }

    private void refillEntry(int baseHash) {
        Object key = this._keys[baseHash];
        int value = this._values[baseHash];
        int hash = key.hashCode();
        for (int count = this._size; count >= 0; --count) {
            if (this._keys[hash] == null) {
                this._keys[hash] = key;
                this._values[hash] = value;
                return;
            }
            hash = hash + 1 & this._mask;
        }
    }

    public Iterator iterator() {
        return new IntMapIterator();
    }

    public Object clone() {
        IntMap clone = new IntMap(true);
        clone._keys = new Object[this._keys.length];
        System.arraycopy(this._keys, 0, clone._keys, 0, this._keys.length);
        clone._values = new int[this._values.length];
        System.arraycopy(this._values, 0, clone._values, 0, this._values.length);
        clone._mask = this._mask;
        clone._size = this._size;
        clone._nullValue = this._nullValue;
        return clone;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("IntMap[");
        boolean isFirst = true;
        for (int i = 0; i <= this._mask; ++i) {
            if (this._keys[i] == null) continue;
            if (!isFirst) {
                sbuf.append(", ");
            }
            isFirst = false;
            sbuf.append(this._keys[i]);
            sbuf.append(":");
            sbuf.append(this._values[i]);
        }
        sbuf.append("]");
        return sbuf.toString();
    }

    class IntMapIterator
    implements Iterator {
        int index;

        IntMapIterator() {
        }

        public boolean hasNext() {
            while (this.index < IntMap.this._keys.length) {
                if (IntMap.this._keys[this.index] != null) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        public Object next() {
            while (this.index < IntMap.this._keys.length) {
                if (IntMap.this._keys[this.index] != null) {
                    return IntMap.this._keys[this.index++];
                }
                ++this.index;
            }
            return null;
        }

        public void remove() {
            throw new RuntimeException();
        }
    }
}

