/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.config.ConfigException;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreadPool {
    private static final L10N L = new L10N(ThreadPool.class);
    private static final Logger log = Logger.getLogger(ThreadPool.class.getName());
    private static final long MAX_EXPIRE = 0x3FFFFFFFFFFFFFFFL;
    private static ThreadPool _globalThreadPool;
    private int _g_id;
    private int _threadMax = 8192;
    private int _threadIdleMax = 15;
    private int _threadIdleMin = 10;
    private int _executorTaskMax = -1;
    private int _threadPriority = 5;
    private boolean _threadPrioritySet = false;
    private long _resetCount;
    private final ArrayList<Item> _threads = new ArrayList();
    private final ArrayList<Runnable> _taskQueue = new ArrayList();
    private final ArrayList<ClassLoader> _loaderQueue = new ArrayList();
    private final Object _idleLock = new Object();
    private final ThreadLauncher _launcher = new ThreadLauncher();
    private final ScheduleThread _scheduler = new ScheduleThread();
    private boolean _isQueuePriority;
    private Item _idleHead;
    private int _threadCount;
    private int _idleCount;
    private int _startCount;
    private final Object _executorLock = new Object();
    private int _executorTaskCount;
    private ExecutorQueueItem _executorQueueHead;
    private ExecutorQueueItem _executorQueueTail;
    private int _scheduleWaitCount;

    private ThreadPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadPool getThreadPool() {
        Class<ThreadPool> clazz = ThreadPool.class;
        synchronized (ThreadPool.class) {
            if (_globalThreadPool == null) {
                _globalThreadPool = new ThreadPool();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _globalThreadPool;
        }
    }

    public void setThreadMax(int max) {
        if (max < this._threadIdleMax) {
            throw new ConfigException(L.l("lt;thread-max> ({0}) must be less than &lt;thread-idle-max> ({1})", max, this._threadIdleMax));
        }
        this._threadMax = max;
    }

    public int getThreadMax() {
        return this._threadMax;
    }

    public void setThreadIdleMin(int min) {
        if (this._threadIdleMax < min) {
            throw new ConfigException(L.l("lt;thread-idle-min> ({0}) must be less than &lt;thread-idle-max> ({1})", min, this._threadIdleMax));
        }
        this._threadIdleMin = min;
    }

    public int getThreadIdleMin() {
        return this._threadIdleMin;
    }

    public void setThreadIdleMax(int max) {
        if (max < this._threadIdleMin) {
            throw new ConfigException(L.l("lt;thread-idle-max> ({0}) must be greater than &lt;thread-idle-min> ({1})", max, this._threadIdleMin));
        }
        if (this._threadMax < max) {
            throw new ConfigException(L.l("lt;thread-idle-max> ({0}) must be less than &lt;thread-max> ({1})", max, this._threadMax));
        }
        this._threadIdleMax = max;
        if (!this._threadPrioritySet) {
            this._threadPriority = this._threadIdleMin <= 2 ? this._threadIdleMin : (this._threadIdleMin + 1) / 2;
        }
    }

    public int getThreadIdleMax() {
        return this._threadIdleMax;
    }

    public void setExecutorTaskMax(int max) {
        if (this._threadMax < max) {
            throw new ConfigException(L.l("lt;thread-executor-max> ({0}) must be less than &lt;thread-max> ({1})", max, this._threadMax));
        }
        if (max == 0) {
            throw new ConfigException(L.l("lt;thread-executor-max> must not be zero."));
        }
        this._executorTaskMax = max;
    }

    public int getExecutorTaskMax() {
        return this._executorTaskMax;
    }

    public void setThreadPriority(int priority) {
        this._threadPriority = priority;
        this._threadPrioritySet = true;
    }

    private int getDefaultPriority() {
        return this._threadPriority;
    }

    public int getThreadCount() {
        return this._threadCount;
    }

    public int getThreadIdleCount() {
        return this._idleCount;
    }

    public int getThreadActiveCount() {
        return this.getThreadCount() - this.getThreadIdleCount();
    }

    public int getFreeThreadCount() {
        return this._threadMax - this._threadCount;
    }

    public void reset() {
        ++this._resetCount;
    }

    public void closeEnvironment(ClassLoader env) {
        this.reset();
    }

    public boolean schedule(Runnable task) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return this.schedule(task, loader, this.getDefaultPriority(), 0x3FFFFFFFFFFFFFFFL, true);
    }

    public boolean schedule(Runnable task, long timeout) {
        long expire = timeout < 0L || timeout > 0x3FFFFFFFFFFFFFFFL ? 0x3FFFFFFFFFFFFFFFL : Alarm.getCurrentTime() + timeout;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return this.schedule(task, loader, this.getDefaultPriority(), expire, true);
    }

    public void schedulePriority(Runnable task) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        this.schedule(task, loader, 0, 0x3FFFFFFFFFFFFFFFL, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleExecutorTask(Runnable task) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Object object = this._executorLock;
        synchronized (object) {
            ++this._executorTaskCount;
            if (this._executorTaskCount <= this._executorTaskMax || this._executorTaskMax < 0) {
                return this.schedule(task, loader, this.getDefaultPriority(), 0x3FFFFFFFFFFFFFFFL, true);
            }
            ExecutorQueueItem item = new ExecutorQueueItem(task, loader);
            if (this._executorQueueTail != null) {
                this._executorQueueTail._next = item;
            } else {
                this._executorQueueHead = item;
            }
            this._executorQueueTail = item;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeExecutorTask() {
        Object object = this._executorLock;
        synchronized (object) {
            --this._executorTaskCount;
            assert (this._executorTaskCount >= 0);
            if (this._executorQueueHead != null) {
                ExecutorQueueItem item = this._executorQueueHead;
                this._executorQueueHead = item._next;
                if (this._executorQueueHead == null) {
                    this._executorQueueTail = null;
                }
                Runnable task = item.getRunnable();
                ClassLoader loader = item.getLoader();
                this.schedule(task, loader, this.getDefaultPriority(), 0x3FFFFFFFFFFFFFFFL, true);
            }
        }
    }

    public boolean start(Runnable task) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return this.schedule(task, loader, this.getDefaultPriority(), 0x3FFFFFFFFFFFFFFFL, false);
    }

    public boolean start(Runnable task, long timeout) {
        long expire = timeout < 0L || timeout > 0x3FFFFFFFFFFFFFFFL ? 0x3FFFFFFFFFFFFFFFL : Alarm.getCurrentTime() + timeout;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return this.schedule(task, loader, this.getDefaultPriority(), expire, false);
    }

    public void startPriority(Runnable task) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        this.schedule(task, loader, 0, 0x3FFFFFFFFFFFFFFFL, false);
    }

    public boolean startPriority(Runnable task, long timeout) {
        long expire = timeout < 0L || timeout > 0x3FFFFFFFFFFFFFFFL ? 0x3FFFFFFFFFFFFFFFL : Alarm.getCurrentTime() + timeout;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return this.schedule(task, loader, 0, expire, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        Object object = this._idleLock;
        synchronized (object) {
            Item item = this._idleHead;
            while (item != null) {
                Thread thread = item.getThread();
                if (thread != null) {
                    try {
                        thread.interrupt();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                item = item._next;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean schedule(Runnable task, ClassLoader loader, int freeThreads, long expireTime, boolean queueIfFull) {
        Item poolItem = null;
        while (poolItem == null) {
            try {
                Object object = this._idleLock;
                synchronized (object) {
                    int idleCount = this._idleCount;
                    int freeCount = idleCount + this._threadMax - this._threadCount;
                    boolean startNew = false;
                    if (idleCount > 0 && freeThreads < freeCount) {
                        poolItem = this._idleHead;
                        this._idleHead = poolItem._next;
                        poolItem._next = null;
                        poolItem._prev = null;
                        poolItem._isIdle = false;
                        if (this._idleHead != null) {
                            this._idleHead._prev = null;
                        }
                        --this._idleCount;
                        if (idleCount < this._threadIdleMin) {
                            startNew = true;
                        }
                    } else {
                        startNew = true;
                    }
                    if (startNew) {
                        Object object2 = this._launcher;
                        synchronized (object2) {
                            this._launcher.notifyAll();
                        }
                        if (poolItem == null) {
                            if (queueIfFull) {
                                object2 = this._taskQueue;
                                synchronized (object2) {
                                    this._taskQueue.add(task);
                                    this._loaderQueue.add(loader);
                                    this._taskQueue.notifyAll();
                                }
                                return false;
                            }
                            if (expireTime < Alarm.getCurrentTime()) {
                                return false;
                            }
                            ++this._scheduleWaitCount;
                            try {
                                Thread.interrupted();
                                this._idleLock.wait(5000L);
                            }
                            finally {
                                --this._scheduleWaitCount;
                            }
                        }
                    }
                }
            }
            catch (OutOfMemoryError e) {
                try {
                    System.err.println("Exiting due to OutOfMemoryError");
                }
                finally {
                    System.exit(11);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        poolItem.start(task, loader);
        return true;
    }

    static class ExecutorQueueItem {
        private Runnable _runnable;
        private ClassLoader _loader;
        ExecutorQueueItem _next;

        ExecutorQueueItem(Runnable runnable, ClassLoader loader) {
            this._runnable = runnable;
            this._loader = loader;
        }

        Runnable getRunnable() {
            return this._runnable;
        }

        ClassLoader getLoader() {
            return this._loader;
        }
    }

    class ScheduleThread
    implements Runnable {
        private ScheduleThread() {
            Thread thread = new Thread(this);
            thread.setName("resin-thread-scheduler");
            thread.setDaemon(true);
            thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
            Thread thread = Thread.currentThread();
            thread.setContextClassLoader(systemLoader);
            while (true) {
                try {
                    while (true) {
                        Runnable task = null;
                        ClassLoader loader = null;
                        Thread.interrupted();
                        ArrayList arrayList = ThreadPool.this._taskQueue;
                        synchronized (arrayList) {
                            if (ThreadPool.this._taskQueue.size() > 0) {
                                task = (Runnable)ThreadPool.this._taskQueue.remove(0);
                                loader = (ClassLoader)ThreadPool.this._loaderQueue.remove(0);
                            } else {
                                try {
                                    ThreadPool.this._taskQueue.wait(60000L);
                                }
                                catch (Throwable e) {
                                    thread.interrupted();
                                    log.finer(e.toString());
                                }
                            }
                        }
                        if (task == null) continue;
                        ThreadPool.this.schedule(task, loader, ThreadPool.this._threadIdleMin, 0x3FFFFFFFFFFFFFFFL, false);
                    }
                }
                catch (OutOfMemoryError e) {
                    System.exit(10);
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    class ThreadLauncher
    implements Runnable {
        private ThreadLauncher() {
            Thread thread = new Thread(this);
            thread.setName("resin-thread-launcher");
            thread.setDaemon(true);
            thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean startConnection(long waitTime) throws InterruptedException {
            boolean doStart = true;
            Object object = ThreadPool.this._idleLock;
            synchronized (object) {
                int idleCount = ThreadPool.this._idleCount;
                if (ThreadPool.this._threadMax < ThreadPool.this._threadCount + ThreadPool.this._startCount) {
                    doStart = false;
                } else if (ThreadPool.this._threadIdleMin < idleCount + ThreadPool.this._startCount) {
                    doStart = false;
                }
                if (doStart) {
                    ThreadPool.this._startCount++;
                }
            }
            if (doStart) {
                try {
                    Item poolItem = new Item();
                    Thread thread = new Thread((Runnable)poolItem, poolItem.getName());
                    thread.setDaemon(true);
                    thread.start();
                }
                catch (Throwable e) {
                    ThreadPool.this._startCount--;
                    e.printStackTrace();
                    if (ThreadPool.this._startCount < 0) {
                        Thread.dumpStack();
                        ThreadPool.this._startCount = 0;
                    }
                }
            } else {
                Thread.interrupted();
                object = this;
                synchronized (object) {
                    this.wait(waitTime);
                    return false;
                }
            }
            return true;
        }

        public void run() {
            ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
            Thread.currentThread().setContextClassLoader(systemLoader);
            try {
                for (int i = 0; i < ThreadPool.this._threadIdleMin; ++i) {
                    this.startConnection(0L);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            while (true) {
                try {
                    while (true) {
                        this.startConnection(10000L);
                        Thread.currentThread();
                        Thread.yield();
                    }
                }
                catch (OutOfMemoryError e) {
                    System.exit(10);
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    class Item
    implements Runnable {
        private final int _id;
        private final String _name;
        private Thread _thread;
        private Thread _queueThread;
        private Item _prev;
        private Item _next;
        private boolean _isIdle;
        private long _threadResetCount;
        private Runnable _task;
        private ClassLoader _classLoader;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Item() {
            Class<Item> clazz = Item.class;
            synchronized (Item.class) {
                this._id = ThreadPool.this._g_id++;
                this._name = "resin-" + this._id;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        int getId() {
            return this._id;
        }

        public String getName() {
            return this._name;
        }

        public long getThreadId() {
            return this._thread.getId();
        }

        Thread getThread() {
            return this._thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean start(Runnable task, ClassLoader loader) {
            Item item = this;
            synchronized (item) {
                this._task = task;
                this._classLoader = loader;
                this.notifyAll();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this._thread = Thread.currentThread();
            Object object = ThreadPool.this._idleLock;
            synchronized (object) {
                ThreadPool.this._threadCount++;
                ThreadPool.this._startCount--;
                ThreadPool.this._threads.add(this);
                if (ThreadPool.this._startCount < 0) {
                    System.out.println("ThreadPool start count is negative: " + ThreadPool.this._startCount);
                    ThreadPool.this._startCount = 0;
                }
            }
            try {
                this.runTasks();
            }
            finally {
                object = ThreadPool.this._idleLock;
                synchronized (object) {
                    ThreadPool.this._threadCount--;
                    ThreadPool.this._threads.remove(this);
                }
                if (ThreadPool.this._threadCount < ThreadPool.this._threadIdleMin) {
                    object = ThreadPool.this._launcher;
                    synchronized (object) {
                        ThreadPool.this._launcher.notifyAll();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTasks() {
            this._threadResetCount = ThreadPool.this._resetCount;
            Thread thread = Thread.currentThread();
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            boolean isIdle = false;
            while (true) {
                try {
                    while (true) {
                        if (!isIdle) {
                            ThreadPool.this._isQueuePriority = true;
                            isIdle = true;
                            Object object = ThreadPool.this._idleLock;
                            synchronized (object) {
                                if (ThreadPool.this._threadIdleMax < ThreadPool.this._idleCount) {
                                    return;
                                }
                                this._next = ThreadPool.this._idleHead;
                                this._prev = null;
                                this._isIdle = true;
                                if (ThreadPool.this._idleHead != null) {
                                    ((ThreadPool)ThreadPool.this)._idleHead._prev = this;
                                }
                                ThreadPool.this._idleHead = this;
                                ThreadPool.this._idleCount++;
                                if (ThreadPool.this._scheduleWaitCount > 0) {
                                    ThreadPool.this._idleLock.notifyAll();
                                }
                            }
                        }
                        Runnable task = null;
                        ClassLoader classLoader = null;
                        Thread.interrupted();
                        Item item = this;
                        synchronized (item) {
                            if (this._task == null) {
                                thread.setContextClassLoader(systemClassLoader);
                                this.wait(60000L);
                            }
                            task = this._task;
                            this._task = null;
                            classLoader = this._classLoader;
                            this._classLoader = null;
                        }
                        if (task != null) {
                            isIdle = false;
                            thread.setContextClassLoader(classLoader);
                            try {
                                task.run();
                            }
                            catch (Throwable e) {
                                log.log(Level.WARNING, e.toString(), e);
                            }
                            finally {
                                thread.setContextClassLoader(ClassLoader.getSystemClassLoader());
                            }
                            continue;
                        }
                        boolean isDead = false;
                        boolean isReset = false;
                        Object object = ThreadPool.this._idleLock;
                        synchronized (object) {
                            if (this._isIdle && (ThreadPool.this._threadIdleMax < ThreadPool.this._idleCount || ThreadPool.this._resetCount != this._threadResetCount)) {
                                isDead = true;
                                isReset = ThreadPool.this._resetCount != this._threadResetCount;
                                Item next = this._next;
                                Item prev = this._prev;
                                this._next = null;
                                this._prev = null;
                                this._isIdle = false;
                                if (next != null) {
                                    next._prev = prev;
                                }
                                if (prev != null) {
                                    prev._next = next;
                                } else {
                                    ThreadPool.this._idleHead = next;
                                }
                                ThreadPool.this._idleCount--;
                            }
                        }
                        if (isReset) {
                            object = ThreadPool.this._launcher;
                            synchronized (object) {
                                ThreadPool.this._launcher.notifyAll();
                            }
                        }
                        if (isDead) break;
                    }
                    return;
                }
                catch (Throwable e) {
                    continue;
                }
                break;
            }
        }
    }
}

