/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CacheListener;
import com.caucho.util.LruCache;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempReadStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachePath
extends FilesystemPath {
    private static final int BLOCK_SIZE = 1024;
    private Path _backingRoot;
    private LruCache<String, Cache> _cache;
    private long _maxSize;
    private long _maxEntrySize;
    private long _size;
    private Path _file;
    private Cache _item;
    private boolean _removeOnRelease;
    private long _readTotalCount;
    private long _readHitCount;

    public CachePath(Path root, int entries, long capacity) {
        super(null, "/", "/");
        this._root = this;
        this._backingRoot = root.createRoot();
        this._cache = new LruCache(entries);
        this._maxSize = capacity;
        this._maxEntrySize = this._maxSize / 64L;
        this._maxEntrySize += 1023L;
        this._maxEntrySize -= this._maxEntrySize % 1024L;
        if (this._maxEntrySize > 0x100000L) {
            this._maxEntrySize = 0x100000L;
        }
        this.clear();
    }

    protected CachePath(FilesystemPath root, String userPath, String path) {
        super(root, userPath, path);
    }

    public void setRemoveOnRelease(boolean remove) {
        ((CachePath)this._root)._removeOnRelease = remove;
    }

    @Override
    public Path fsWalk(String userPath, Map<String, Object> attributes, String path) {
        return new CachePath(this._root, userPath, path);
    }

    @Override
    public String getScheme() {
        return "cache";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        CachePath cRoot;
        CachePath cachePath = cRoot = (CachePath)this._root;
        synchronized (cachePath) {
            cRoot._cache.clear();
            cRoot._size = 0L;
        }
    }

    @Override
    public boolean exists() {
        return this.getFile().exists();
    }

    @Override
    public boolean isDirectory() {
        return this.getFile().isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.getFile().isFile();
    }

    @Override
    public long getLength() {
        return this.getFile().getLength();
    }

    @Override
    public long getLastModified() {
        return this.getFile().getLastModified();
    }

    @Override
    public void setLastModified(long time) {
        this.getFile().setLastModified(time);
    }

    @Override
    public boolean canRead() {
        return this.getFile().canRead();
    }

    @Override
    public boolean canWrite() {
        return this.getFile().canWrite();
    }

    @Override
    public String[] list() throws IOException {
        return this.getFile().list();
    }

    @Override
    public boolean mkdir() throws IOException {
        return this.getFile().mkdir();
    }

    @Override
    public boolean mkdirs() throws IOException {
        return this.getFile().mkdirs();
    }

    @Override
    public boolean remove() throws IOException {
        if (this.getFile().remove()) {
            CachePath root = (CachePath)this._root;
            root._cache.remove(this.getPath());
            return true;
        }
        return false;
    }

    @Override
    public boolean renameTo(Path path) throws IOException {
        if (this.getFile().renameTo(path)) {
            CachePath root = (CachePath)this._root;
            root._cache.remove(this.getPath());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToStream(OutputStream os) throws IOException {
        TempBuffer head;
        CachePath root = (CachePath)this._root;
        LruCache<String, Cache> cache = root._cache;
        String path = this.getPath();
        if (this._item == null) {
            this._item = cache.get(path);
        }
        if (this._item != null && (head = this._item.getHead()) != null) {
            while (head != null) {
                os.write(head.getBuffer(), 0, head.getLength());
                head = head.getNext();
            }
            return;
        }
        Path file = this.getFile();
        long length = file.getLength();
        if (length <= root._maxEntrySize && length > 0L) {
            TempBuffer head2;
            ReadStream is = file.openRead();
            try {
                head2 = this.copyFromStream(is, os, length);
            }
            finally {
                is.close();
            }
            this._item = new Cache(root, file, head2);
            CachePath cachePath = root;
            synchronized (cachePath) {
                long size = this._item.getSize();
                root._size += this._item.getSize();
                cache.put(path, this._item);
            }
            int i = 16;
            while (root._maxSize < root._size && i-- > 0) {
                root._cache.removeTail();
            }
        } else {
            this.getFile().writeToStream(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamImpl openReadImpl() throws IOException {
        CachePath root = (CachePath)this._root;
        LruCache<String, Cache> cache = root._cache;
        String path = this.getPath();
        Cache item = cache.get(path);
        ++root._readTotalCount;
        if (item != null) {
            ++root._readHitCount;
            TempReadStream rs = new TempReadStream(item.getHead());
            rs.setFreeWhenDone(false);
            return rs;
        }
        Path file = this.getFile();
        long length = file.getLength();
        if (length <= root._maxEntrySize && length > 0L) {
            try {
                ReadStream is = file.openRead();
                TempBuffer head = null;
                try {
                    head = this.copyFromStream(is, null, length);
                }
                finally {
                    is.close();
                }
                item = new Cache(root, file, head);
                CachePath cachePath = root;
                synchronized (cachePath) {
                    root._size += item.getSize();
                    root._cache.put(path, item);
                }
                while (root._size > root._maxSize) {
                    root._cache.removeTail();
                }
                TempReadStream rs = new TempReadStream(head);
                rs.setFreeWhenDone(false);
                return rs;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return file.openReadImpl();
    }

    private TempBuffer copyFromStream(ReadStream is, OutputStream os, long length) throws IOException {
        int len;
        TempBuffer head;
        TempBuffer tail = head = new TempBuffer(1024);
        while ((len = is.readAll(tail.getBuffer(), 0, tail.getCapacity())) > 0) {
            length -= (long)len;
            tail.setLength(len);
            if (os != null) {
                os.write(tail.getBuffer(), 0, len);
            }
            if (length <= 0L) break;
            tail.setNext(new TempBuffer(1024));
            tail = tail.getNext();
        }
        return head;
    }

    @Override
    public StreamImpl openWriteImpl() throws IOException {
        String path = this.getPath();
        LruCache<String, Cache> cache = ((CachePath)this._root)._cache;
        cache.remove(path);
        return this.getFile().openWriteImpl();
    }

    @Override
    public StreamImpl openAppendImpl() throws IOException {
        return this.getFile().openAppendImpl();
    }

    @Override
    public StreamImpl openReadWriteImpl() throws IOException {
        return this.getFile().openReadWriteImpl();
    }

    @Override
    public int hashCode() {
        return this.getFile().hashCode();
    }

    @Override
    public boolean equals(Object b) {
        if (b instanceof CachePath) {
            CachePath test = (CachePath)b;
            return this.getFile().equals(test.getFile());
        }
        return this.getFile().equals(b);
    }

    private Path getFile() {
        if (this._file == null) {
            this._file = ((CachePath)this._root)._backingRoot.lookup(this.getPath());
        }
        return this._file;
    }

    static class Cache
    implements CacheListener {
        private CachePath _root;
        private Path _path;
        private TempBuffer _head;
        private long _size;

        Cache(CachePath root, Path path, TempBuffer head) {
            this._root = root;
            this._path = path;
            this._head = head;
            for (TempBuffer ptr = head; ptr != null; ptr = ptr.getNext()) {
                this._size += (long)ptr.getCapacity();
            }
        }

        TempBuffer getHead() {
            return this._head;
        }

        long getSize() {
            return this._size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeEvent() {
            CachePath cachePath = this._root;
            synchronized (cachePath) {
                this._root._size -= this._size;
                this._size = 0L;
            }
            this._head = null;
            if (this._root._removeOnRelease) {
                try {
                    this._path.remove();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

