/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.RandomAccessStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class FileRandomAccessStream
extends RandomAccessStream {
    private RandomAccessFile _file;
    private OutputStream _os;
    private InputStream _is;

    public FileRandomAccessStream(RandomAccessFile file) {
        this._file = file;
    }

    public RandomAccessFile getRandomAccessFile() {
        return this._file;
    }

    public long getLength() throws IOException {
        return this._file.length();
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        return this._file.read(buffer, offset, length);
    }

    public int read(char[] buffer, int offset, int length) throws IOException {
        byte[] bytes = new byte[length];
        int count = this._file.read(bytes, 0, length);
        for (int i = 0; i < count; ++i) {
            buffer[offset + i] = (char)bytes[i];
        }
        return count;
    }

    public int read(long fileOffset, byte[] buffer, int offset, int length) throws IOException {
        this._file.seek(fileOffset);
        return this._file.read(buffer, offset, length);
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        this._file.write(buffer, offset, length);
    }

    public void write(long fileOffset, byte[] buffer, int offset, int length) throws IOException {
        this._file.seek(fileOffset);
        this._file.write(buffer, offset, length);
    }

    public boolean seek(long position) {
        try {
            this._file.seek(position);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public OutputStream getOutputStream() throws IOException {
        if (this._os == null) {
            this._os = new FileOutputStream(this._file.getFD());
        }
        return this._os;
    }

    public InputStream getInputStream() throws IOException {
        if (this._is == null) {
            this._is = new FileInputStream(this._file.getFD());
        }
        return this._is;
    }

    public int read() throws IOException {
        return this._file.read();
    }

    public void write(int b) throws IOException {
        this._file.write(b);
    }

    public long getFilePointer() throws IOException {
        return this._file.getFilePointer();
    }

    public void close() throws IOException {
        RandomAccessFile file = this._file;
        this._file = null;
        if (file != null) {
            file.close();
        }
    }
}

