/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.Log;
import com.caucho.vfs.HttpPath;
import com.caucho.vfs.HttpStreamWrapper;
import com.caucho.vfs.HttpsPath;
import com.caucho.vfs.MemoryStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

class HttpStream
extends StreamImpl {
    private static final Logger log = Log.open(HttpStream.class);
    private static HashMap<String, String> _reserved;
    private static final Object LOCK;
    private static HttpStream _savedStream;
    private static long _saveTime;
    private long _socketTimeout = 30000L;
    private boolean _isSSL;
    private Socket _s;
    private InputStream _is;
    private OutputStream _os;
    private ReadStream _rs;
    private WriteStream _ws;
    private String _host;
    private int _port;
    private String _virtualHost;
    private String _method;
    private boolean _isHead;
    private boolean _isPost;
    private MemoryStream _tempStream;
    private boolean _isKeepalive = true;
    private boolean _didGet;
    private int _contentLength;
    private boolean _isChunked;
    private int _chunkLength;
    private boolean _isRequestDone;
    private HashMap<String, Object> _attributes;
    private byte[] _tempBuffer;

    private HttpStream(Path path, String host, int port, Socket s) throws IOException {
        this._s = s;
        this._host = host;
        this._port = port;
        this._is = this._s.getInputStream();
        this._os = this._s.getOutputStream();
        this._ws = VfsStream.openWrite(this._os);
        this._rs = VfsStream.openRead(this._is, this._ws);
        this._attributes = new HashMap();
        this.init(path);
    }

    static HttpStreamWrapper openRead(HttpPath path) throws IOException {
        HttpStream stream = HttpStream.createStream(path);
        stream._isPost = false;
        return new HttpStreamWrapper(stream);
    }

    static HttpStreamWrapper openReadWrite(HttpPath path) throws IOException {
        HttpStream stream = HttpStream.createStream(path);
        stream._isPost = true;
        return new HttpStreamWrapper(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpStream createStream(HttpPath path) throws IOException {
        Socket s;
        String host = path.getHost();
        int port = path.getPort();
        HttpStream stream = null;
        long streamTime = 0L;
        Object object = LOCK;
        synchronized (object) {
            if (_savedStream != null && host.equals(_savedStream.getHost()) && port == _savedStream.getPort()) {
                stream = _savedStream;
                streamTime = _saveTime;
                _savedStream = null;
            }
        }
        if (stream != null) {
            if (Alarm.getCurrentTime() < streamTime + 5000L) {
                stream.init(path);
                return stream;
            }
            try {
                stream._isKeepalive = false;
                stream.close();
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        try {
            s = new Socket(host, port);
            if (path instanceof HttpsPath) {
                SSLContext context = SSLContext.getInstance("TLS");
                X509TrustManager tm = new X509TrustManager(){

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    public void checkClientTrusted(X509Certificate[] cert, String foo) {
                    }

                    public void checkServerTrusted(X509Certificate[] cert, String foo) {
                    }
                };
                context.init(null, new TrustManager[]{tm}, null);
                SSLSocketFactory factory = context.getSocketFactory();
                s = factory.createSocket(s, host, port, true);
            }
        }
        catch (ConnectException e) {
            throw new ConnectException(path.getURL() + ": " + e.getMessage());
        }
        catch (Exception e) {
            throw new ConnectException(path.getURL() + ": " + e.toString());
        }
        int socketTimeout = 300000;
        try {
            s.setSoTimeout(socketTimeout);
        }
        catch (Exception e) {
            // empty catch block
        }
        return new HttpStream(path, host, port, s);
    }

    private void init(Path path) {
        this._contentLength = -1;
        this._isChunked = false;
        this._isRequestDone = false;
        this._didGet = false;
        this._isPost = false;
        this._isHead = false;
        this._method = null;
        this._attributes.clear();
        this.setPath(path);
        if (path instanceof HttpPath) {
            this._virtualHost = ((HttpPath)path).getVirtualHost();
        }
    }

    public void setSSL(boolean isSSL) {
        this._isSSL = isSSL;
    }

    public boolean isSSL() {
        return this._isSSL;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public void setHead(boolean isHead) {
        this._isHead = isHead;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public Object getAttribute(String name) throws IOException {
        if (!this._didGet) {
            this.getConnInput();
        }
        return this._attributes.get(name.toLowerCase());
    }

    public Iterator getAttributeNames() throws IOException {
        if (!this._didGet) {
            this.getConnInput();
        }
        return this._attributes.keySet().iterator();
    }

    public void setAttribute(String name, Object value) {
        if (name.equals("method")) {
            this.setMethod((String)value);
        } else if (name.equals("socket-timeout")) {
            int socketTimeout;
            if (value instanceof Integer && (socketTimeout = ((Integer)value).intValue()) > 0) {
                try {
                    if (this._s != null) {
                        this._s.setSoTimeout(socketTimeout);
                    }
                }
                catch (Exception e) {}
            }
        } else {
            this._attributes.put(name.toLowerCase(), value);
        }
    }

    public void removeAttribute(String name) {
        this._attributes.remove(name.toLowerCase());
    }

    public void setSocketTimeout(long timeout) throws SocketException {
        if (this._s != null) {
            this._s.setSoTimeout((int)timeout);
        }
    }

    public boolean canWrite() {
        return true;
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        if (!this._isPost) {
            return;
        }
        if (this._tempStream == null) {
            this._tempStream = new MemoryStream();
        }
        this._tempStream.write(buf, offset, length, isEnd);
    }

    public boolean canRead() {
        return true;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        try {
            return this.readInt(buf, offset, length);
        }
        catch (IOException e) {
            this._isKeepalive = false;
            throw e;
        }
        catch (RuntimeException e) {
            this._isKeepalive = false;
            throw e;
        }
    }

    public int readInt(byte[] buf, int offset, int length) throws IOException {
        if (!this._didGet) {
            this.getConnInput();
        }
        if (this._isRequestDone) {
            return -1;
        }
        try {
            int len = length;
            if (this._isChunked) {
                if (this._chunkLength == 0) {
                    int ch = this._rs.read();
                    while (ch >= 0 && (ch == 13 || ch == 10 || ch == 32)) {
                        ch = this._rs.read();
                    }
                    while (ch >= 0 && ch != 10) {
                        if (ch >= 48 && ch <= 57) {
                            this._chunkLength = 16 * this._chunkLength + ch - 48;
                        } else if (ch >= 97 && ch <= 102) {
                            this._chunkLength = 16 * this._chunkLength + ch - 97 + 10;
                        } else if (ch >= 65 && ch <= 70) {
                            this._chunkLength = 16 * this._chunkLength + ch - 65 + 10;
                        }
                        ch = this._rs.read();
                    }
                    if (this._chunkLength == 0) {
                        this._isRequestDone = true;
                        return -1;
                    }
                } else if (this._chunkLength < 0) {
                    return -1;
                }
                if (this._chunkLength < len) {
                    len = this._chunkLength;
                }
            } else if (this._contentLength >= 0) {
                if (this._contentLength == 0) {
                    this._isRequestDone = true;
                    return -1;
                }
                if (this._contentLength < len) {
                    len = this._contentLength;
                }
            }
            if ((len = this._rs.read(buf, offset, len)) >= 0) {
                if (this._isChunked) {
                    this._chunkLength -= len;
                } else if (this._contentLength > 0) {
                    this._contentLength -= len;
                }
            }
            return len;
        }
        catch (IOException e) {
            this._isKeepalive = false;
            throw e;
        }
        catch (RuntimeException e) {
            this._isKeepalive = false;
            throw e;
        }
    }

    private void getConnInput() throws IOException {
        if (this._didGet) {
            return;
        }
        try {
            this.getConnInputImpl();
        }
        catch (IOException e) {
            this._isKeepalive = false;
            throw e;
        }
        catch (RuntimeException e) {
            this._isKeepalive = false;
            throw e;
        }
    }

    private void getConnInputImpl() throws IOException {
        if (this._didGet) {
            return;
        }
        this._didGet = true;
        if (this._method != null) {
            this._ws.print(this._method);
            this._ws.print(' ');
        } else if (this._isPost) {
            this._ws.print("POST ");
        } else if (this._isHead) {
            this._ws.print("HEAD ");
        } else {
            this._ws.print("GET ");
        }
        this._ws.print(this._path.getPath());
        if (this._path.getQuery() != null) {
            this._ws.print("?");
            this._ws.print(this._path.getQuery());
        }
        this._ws.print(" HTTP/1.1\r\n");
        this._ws.print("Host: ");
        if (this._virtualHost != null) {
            this._ws.print(this._virtualHost);
        } else {
            this._ws.print(this._path.getHost());
            if (this._path.getPort() != 80) {
                this._ws.print(":");
                this._ws.print(String.valueOf(this._path.getPort()));
            }
        }
        this._ws.print("\r\n");
        Object userAgent = this.getAttribute("User-Agent");
        if (userAgent == null) {
            this._ws.print("User-Agent: Mozilla/4.0 (compatible; Resin 1.0; JDK)\r\n");
        } else {
            this._ws.print("User-Agent: " + userAgent + "\r\n");
        }
        Iterator iter = this.getAttributeNames();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (_reserved.get(name.toLowerCase()) != null) continue;
            this._ws.print(name + ": " + this.getAttribute(name) + "\r\n");
        }
        if (!this._isKeepalive) {
            this._ws.print("Connection: close\r\n");
        }
        if (this._isPost) {
            int length = 0;
            if (this._tempStream != null) {
                length = this._tempStream.getLength();
            }
            this._ws.print("Content-Length: ");
            this._ws.print(length);
            this._ws.print("\r\n");
        }
        this._ws.print("\r\n");
        if (this._isPost) {
            MemoryStream tempStream = this._tempStream;
            this._tempStream = null;
            if (tempStream != null) {
                tempStream.writeToStream(this._ws);
                tempStream.destroy();
            }
        }
        this._attributes.clear();
        this.parseHeaders();
        if (this._isHead) {
            this._isRequestDone = true;
        }
    }

    private void parseHeaders() throws IOException {
        char ch;
        CharBuffer line = new CharBuffer();
        int count = 0;
        do {
            line.clear();
            if (this._rs.readln(line)) continue;
            this._isKeepalive = false;
            return;
        } while (line.length() == 0 && ++count < 10);
        if (line.length() == 0) {
            this._isKeepalive = false;
            return;
        }
        if (line.startsWith("HTTP/1.1 100")) {
            count = 100;
            do {
                line.clear();
                if (this._rs.readln(line)) continue;
                this._isKeepalive = false;
                return;
            } while (line.length() != 0 && count-- > 0);
            count = 100;
            do {
                line.clear();
                if (this._rs.readln(line)) continue;
                this._isKeepalive = false;
                return;
            } while (line.length() == 0 && count-- > 0);
        }
        if (line.length() == 0) {
            this._isKeepalive = false;
            return;
        }
        int i = 0;
        for (i = 0; i < line.length() && line.charAt(i) != ' '; ++i) {
        }
        while (i < line.length() && line.charAt(i) == ' ') {
            ++i;
        }
        int status = 0;
        while (i < line.length() && (ch = line.charAt(i)) >= '0' && ch <= '9') {
            status = 10 * status + ch - 48;
            ++i;
        }
        if (status != 200) {
            this._isKeepalive = false;
        } else if (!line.startsWith("HTTP/1.1 ")) {
            this._isKeepalive = false;
        }
        this._attributes.put("status", String.valueOf(status));
        CharBuffer key = new CharBuffer();
        while (true) {
            line.clear();
            if (!this._rs.readln(line) || line.length() == 0) break;
            int lineLength = line.length();
            for (i = 0; i < lineLength && Character.isWhitespace(line.charAt(i)); ++i) {
            }
            key.clear();
            while (i < lineLength && !Character.isWhitespace(line.charAt(i)) && line.charAt(i) != ':') {
                key.append(line.charAt(i));
                ++i;
            }
            while (i < lineLength && Character.isWhitespace(line.charAt(i))) {
                ++i;
            }
            if (key.length() == 0 || lineLength <= i || line.charAt(i) != ':') continue;
            ++i;
            while (i < lineLength && Character.isWhitespace(line.charAt(i))) {
                ++i;
            }
            key.toLowerCase();
            String value = line.substring(i);
            if (log.isLoggable(Level.FINE)) {
                log.fine(key + ": " + value);
            }
            if (key.matchesIgnoreCase("content-length")) {
                this._contentLength = Integer.parseInt(value);
            } else if (key.matchesIgnoreCase("connection") && value.equalsIgnoreCase("close")) {
                this._isKeepalive = false;
            } else if (key.matchesIgnoreCase("transfer-encoding") && value.equalsIgnoreCase("chunked")) {
                this._isChunked = true;
                this._chunkLength = 0;
            }
            this._attributes.put(key.toLowerCase().toString(), value);
        }
    }

    public int getAvailable() throws IOException {
        if (!this._didGet) {
            this.getConnInput();
        }
        if (this._contentLength > 0) {
            return this._contentLength;
        }
        return this._rs.getAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this._isKeepalive) {
            if (!this._didGet) {
                this.getConnInput();
            }
            if (!this._isRequestDone) {
                if (this._tempBuffer == null) {
                    this._tempBuffer = new byte[256];
                }
                try {
                    while (this.read(this._tempBuffer, 0, this._tempBuffer.length) > 0) {
                    }
                }
                catch (IOException e) {
                    this._isKeepalive = false;
                }
            }
        }
        if (Alarm.isTest()) {
            this._isKeepalive = false;
        }
        if (this._isKeepalive) {
            HttpStream oldSaved;
            long now = Alarm.getCurrentTime();
            Object object = LOCK;
            synchronized (object) {
                oldSaved = _savedStream;
                _savedStream = this;
                _saveTime = now;
            }
            if (oldSaved != null && oldSaved != this) {
                oldSaved._isKeepalive = false;
                oldSaved.close();
            }
            return;
        }
        try {
            try {
                if (this._ws != null) {
                    this._ws.close();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            this._ws = null;
            try {
                if (this._rs != null) {
                    this._rs.close();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            this._rs = null;
            try {
                if (this._os != null) {
                    this._os.close();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            this._os = null;
            try {
                if (this._is != null) {
                    this._is.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this._is = null;
        }
        finally {
            if (this._s != null) {
                this._s.close();
            }
            this._s = null;
        }
    }

    static {
        LOCK = new Object();
        _reserved = new HashMap();
        _reserved.put("user-agent", "");
        _reserved.put("content-length", "");
        _reserved.put("content-encoding", "");
        _reserved.put("connection", "");
        _reserved.put("host", "");
    }
}

