/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class SocketStream
extends StreamImpl {
    private static byte[] UNIX_NEWLINE = new byte[]{10};
    private Socket _s;
    private InputStream _is;
    private OutputStream _os;
    private boolean _needsFlush;
    private byte[] _newline = UNIX_NEWLINE;
    private boolean _throwReadInterrupts = false;
    private int _socketTimeout;
    private long _totalReadBytes;
    private long _totalWriteBytes;

    public SocketStream() {
    }

    public SocketStream(Socket s) {
        this.init(s);
    }

    public void init(Socket s) {
        this._s = s;
        this._is = null;
        this._os = null;
        this._needsFlush = false;
    }

    public void init(InputStream is, OutputStream os) {
        this._is = is;
        this._os = os;
        this._needsFlush = false;
    }

    public void setThrowReadInterrupts(boolean allowThrow) {
        this._throwReadInterrupts = allowThrow;
    }

    public boolean getThrowReadInterrupts() {
        return this._throwReadInterrupts;
    }

    public void setNewline(byte[] newline) {
        this._newline = newline;
    }

    public byte[] getNewline() {
        return this._newline;
    }

    public boolean canRead() {
        return this._is != null || this._s != null;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        try {
            int readLength;
            if (this._is == null) {
                if (this._s == null) {
                    return -1;
                }
                this._is = this._s.getInputStream();
            }
            if ((readLength = this._is.read(buf, offset, length)) >= 0) {
                this._totalReadBytes += (long)readLength;
            }
            return readLength;
        }
        catch (IOException e) {
            if (this._throwReadInterrupts) {
                throw e;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readTimeout(byte[] buf, int offset, int length, long timeout) throws IOException {
        Socket s = this._s;
        if (s == null) {
            return -1;
        }
        int oldTimeout = s.getSoTimeout();
        try {
            s.setSoTimeout((int)timeout);
            int n = this.read(buf, offset, length);
            return n;
        }
        finally {
            s.setSoTimeout(oldTimeout);
        }
    }

    public int getAvailable() throws IOException {
        if (this._is == null) {
            if (this._s == null) {
                return -1;
            }
            this._is = this._s.getInputStream();
        }
        return this._is.available();
    }

    public boolean canWrite() {
        return this._os != null || this._s != null;
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        if (this._os == null) {
            if (this._s == null) {
                return;
            }
            this._os = this._s.getOutputStream();
        }
        try {
            this._needsFlush = true;
            this._os.write(buf, offset, length);
            this._totalWriteBytes += (long)length;
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw ClientDisconnectException.create(e);
        }
    }

    public void flush() throws IOException {
        if (this._os == null || !this._needsFlush) {
            return;
        }
        this._needsFlush = false;
        try {
            this._os.flush();
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ClientDisconnectException.create(e);
        }
    }

    public void resetTotalBytes() {
        this._totalReadBytes = 0L;
        this._totalWriteBytes = 0L;
    }

    public long getTotalReadBytes() {
        return this._totalReadBytes;
    }

    public long getTotalWriteBytes() {
        return this._totalWriteBytes;
    }

    public void closeWrite() throws IOException {
        OutputStream os = this._os;
        this._os = null;
        if (this._s != null) {
            this._s.shutdownOutput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Socket s = this._s;
        this._s = null;
        OutputStream os = this._os;
        this._os = null;
        InputStream is = this._is;
        this._is = null;
        try {
            if (os != null) {
                os.close();
            }
            if (is != null) {
                is.close();
            }
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }
}

