/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TcpPath;
import com.caucho.vfs.TcpsPath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

class TcpStream
extends StreamImpl {
    private Socket _s;
    private InputStream _is;
    private OutputStream _os;

    private TcpStream(TcpPath path, long timeout) throws IOException {
        this.setPath(path);
        this._s = new Socket();
        if (timeout > 0L) {
            this._s.connect(path.getSocketAddress(), (int)timeout);
        } else {
            this._s.connect(path.getSocketAddress());
        }
        if (!this._s.isConnected()) {
            throw new IOException("connection timeout");
        }
        if (timeout < 0L) {
            timeout = 120000L;
        }
        this._s.setSoTimeout((int)timeout);
        try {
            if (path instanceof TcpsPath) {
                SSLContext context = SSLContext.getInstance("TLS");
                X509TrustManager tm = new X509TrustManager(){

                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    public void checkClientTrusted(X509Certificate[] cert, String foo) {
                    }

                    public void checkServerTrusted(X509Certificate[] cert, String foo) {
                    }
                };
                context.init(null, new TrustManager[]{tm}, null);
                SSLSocketFactory factory = context.getSocketFactory();
                this._s = factory.createSocket(this._s, path.getHost(), path.getPort(), true);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(e);
        }
        this._is = this._s.getInputStream();
        this._os = this._s.getOutputStream();
    }

    public void setAttribute(String name, Object value) {
        if (name.equals("timeout")) {
            try {
                if (value instanceof Number) {
                    this._s.setSoTimeout(((Number)value).intValue());
                } else {
                    this._s.setSoTimeout(Integer.parseInt(String.valueOf(value)));
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    static TcpStream openRead(TcpPath path, long timeout) throws IOException {
        return new TcpStream(path, timeout);
    }

    static TcpStream openReadWrite(TcpPath path, long timeout) throws IOException {
        return new TcpStream(path, timeout);
    }

    public boolean canWrite() {
        return this._os != null;
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        if (this._os != null) {
            this._os.write(buf, offset, length);
        }
    }

    public boolean canRead() {
        return this._is != null;
    }

    public int getAvailable() throws IOException {
        if (this._is != null) {
            return this._is.available();
        }
        return -1;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        if (this._is != null) {
            return this._is.read(buf, offset, length);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWrite() throws IOException {
        OutputStream os = this._os;
        this._os = null;
        try {
            if (os != null) {
                this._s.shutdownOutput();
            }
        }
        finally {
            if (this._is == null) {
                Socket s = this._s;
                this._s = null;
                if (s != null) {
                    s.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        InputStream is = this._is;
        this._is = null;
        OutputStream os = this._os;
        this._os = null;
        Socket s = this._s;
        this._s = null;
        try {
            if (os != null) {
                os.close();
            }
            if (is != null) {
                is.close();
            }
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }
}

