/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempReadStream;
import java.io.IOException;
import java.io.OutputStream;

public class TempOutputStream
extends OutputStream {
    private TempBuffer _head;
    private TempBuffer _tail;

    public byte[] getTail() {
        return this._tail.getBuffer();
    }

    public void write(int ch) throws IOException {
        if (this._tail == null) {
            this.addBuffer(TempBuffer.allocate());
        } else if (this._tail._buf.length <= this._tail._length) {
            this.addBuffer(TempBuffer.allocate());
        }
        this._tail.getBuffer()[this._tail._length++] = (byte)ch;
    }

    public void write(byte[] buf, int offset, int length) throws IOException {
        int index = 0;
        while (index < length) {
            if (this._tail == null) {
                this.addBuffer(TempBuffer.allocate());
            } else if (this._tail._buf.length <= this._tail._length) {
                this.addBuffer(TempBuffer.allocate());
            }
            int sublen = this._tail._buf.length - this._tail._length;
            if (length - index < sublen) {
                sublen = length - index;
            }
            System.arraycopy(buf, index + offset, this._tail._buf, this._tail._length, sublen);
            index += sublen;
            this._tail._length += sublen;
        }
    }

    private void addBuffer(TempBuffer buf) {
        buf._next = null;
        if (this._tail != null) {
            this._tail._next = buf;
            this._tail = buf;
        } else {
            this._tail = buf;
            this._head = buf;
        }
        ++this._head._bufferCount;
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
    }

    public ReadStream openRead() throws IOException {
        return this.openRead(false);
    }

    public ReadStream openRead(boolean free) throws IOException {
        this.close();
        TempReadStream read = new TempReadStream(this._head);
        read.setFreeWhenDone(free);
        if (free) {
            this._head = null;
            this._tail = null;
        }
        return new ReadStream(read);
    }

    public void openRead(ReadStream rs, boolean free) throws IOException {
        TempReadStream tempReadStream = new TempReadStream();
        tempReadStream.init(this._head);
        tempReadStream.setFreeWhenDone(free);
        if (free) {
            this._head = null;
            this._tail = null;
        }
        rs.init(tempReadStream, null);
    }

    public TempBuffer getHead() {
        return this._head;
    }

    public void writeToStream(OutputStream os) throws IOException {
        TempBuffer ptr = this._head;
        while (ptr != null) {
            os.write(ptr.getBuffer(), 0, ptr.getLength());
            ptr = ptr._next;
        }
    }

    public int getLength() {
        int length = 0;
        TempBuffer ptr = this._head;
        while (ptr != null) {
            length += ptr.getLength();
            ptr = ptr._next;
        }
        return length;
    }

    public void destroy() {
        TempBuffer ptr = this._head;
        this._head = null;
        this._tail = null;
        TempBuffer.freeAll(ptr);
    }
}

