/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;

public class TempReadStream
extends StreamImpl {
    private TempBuffer _cursor;
    private int _offset;
    private boolean _freeWhenDone = true;

    public TempReadStream(TempBuffer cursor) {
        this.init(cursor);
    }

    public TempReadStream() {
    }

    public void init(TempBuffer cursor) {
        this._cursor = cursor;
        this._offset = 0;
        this._freeWhenDone = true;
    }

    public void setFreeWhenDone(boolean free) {
        this._freeWhenDone = free;
    }

    public boolean canRead() {
        return true;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        if (this._cursor == null) {
            return -1;
        }
        int sublen = this._cursor._length - this._offset;
        if (length < sublen) {
            sublen = length;
        }
        System.arraycopy(this._cursor._buf, this._offset, buf, offset, sublen);
        if (this._cursor._length <= this._offset + sublen) {
            TempBuffer next = this._cursor._next;
            if (this._freeWhenDone) {
                TempBuffer.free(this._cursor);
            }
            this._cursor = next;
            this._offset = 0;
        } else {
            this._offset += sublen;
        }
        return sublen;
    }

    public int getAvailable() throws IOException {
        if (this._cursor != null) {
            return this._cursor._length - this._offset;
        }
        return 0;
    }

    public void close() throws IOException {
        if (this._freeWhenDone && this._cursor != null) {
            TempBuffer.freeAll(this._cursor);
        }
        this._cursor = null;
    }

    public String toString() {
        return "TempReadStream[]";
    }
}

