/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempReadStream;
import java.io.IOException;
import java.io.OutputStream;

public class TempStream
extends StreamImpl {
    private String _encoding;
    private TempBuffer _head;
    private TempBuffer _tail;
    private boolean _useBackingFile;
    private TempReadStream _tempReadStream;

    public void openWrite() {
        TempBuffer ptr = this._head;
        this._head = null;
        this._tail = null;
        this._encoding = null;
        TempBuffer.freeAll(ptr);
    }

    public byte[] getTail() {
        return this._tail.getBuffer();
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public boolean canWrite() {
        return true;
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        while (length > 0) {
            if (this._tail == null) {
                this.addBuffer(TempBuffer.allocate());
            } else if (this._tail._buf.length <= this._tail._length) {
                this.addBuffer(TempBuffer.allocate());
            }
            int sublen = this._tail._buf.length - this._tail._length;
            if (length < sublen) {
                sublen = length;
            }
            System.arraycopy(buf, offset, this._tail._buf, this._tail._length, sublen);
            length -= sublen;
            offset += sublen;
            this._tail._length += sublen;
        }
    }

    private void addBuffer(TempBuffer buf) {
        buf._next = null;
        if (this._tail != null) {
            this._tail._next = buf;
            this._tail = buf;
        } else {
            this._tail = buf;
            this._head = buf;
        }
        ++this._head._bufferCount;
    }

    public void flush() throws IOException {
    }

    public ReadStream openRead() throws IOException {
        return this.openRead(false);
    }

    public ReadStream openRead(boolean free) throws IOException {
        this.close();
        TempReadStream read = new TempReadStream(this._head);
        read.setFreeWhenDone(free);
        if (free) {
            this._head = null;
            this._tail = null;
        }
        return new ReadStream(read);
    }

    public void openRead(ReadStream rs, boolean free) throws IOException {
        this.close();
        if (this._tempReadStream == null) {
            this._tempReadStream = new TempReadStream();
            this._tempReadStream.setPath(this.getPath());
        }
        this._tempReadStream.init(this._head);
        this._tempReadStream.setFreeWhenDone(free);
        if (free) {
            this._head = null;
            this._tail = null;
        }
        rs.init(this._tempReadStream, null);
    }

    public TempBuffer getHead() {
        return this._head;
    }

    public void writeToStream(OutputStream os) throws IOException {
        TempBuffer ptr = this._head;
        while (ptr != null) {
            os.write(ptr.getBuffer(), 0, ptr.getLength());
            ptr = ptr._next;
        }
    }

    public int getLength() {
        int length = 0;
        TempBuffer ptr = this._head;
        while (ptr != null) {
            length += ptr.getLength();
            ptr = ptr._next;
        }
        return length;
    }

    public ReadStream openRead(ReadStream s) throws IOException {
        this.close();
        TempReadStream read = new TempReadStream(this._head);
        read.setFreeWhenDone(false);
        read.setPath(this.getPath());
        s.init(read, null);
        return s;
    }

    public void clearWrite() {
        TempBuffer ptr = this._head;
        this._head = null;
        this._tail = null;
        TempBuffer.freeAll(ptr);
    }

    public void discard() {
        this._head = null;
        this._tail = null;
    }

    public TempStream copy() {
        TempStream newStream = new TempStream();
        for (TempBuffer ptr = this._head; ptr != null; ptr = ptr.getNext()) {
            TempBuffer newPtr = TempBuffer.allocate();
            if (newStream._tail != null) {
                newStream._tail.setNext(newPtr);
            } else {
                newStream._head = newPtr;
            }
            newStream._tail = newPtr;
            newPtr.write(ptr.getBuffer(), 0, ptr.getLength());
        }
        return newStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.close();
        }
        catch (IOException e) {
        }
        finally {
            TempBuffer ptr = this._head;
            this._head = null;
            this._tail = null;
            TempBuffer.freeAll(ptr);
        }
    }
}

