/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CharSegment;
import com.caucho.vfs.EnclosedWriteStream;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.FlushBuffer;
import com.caucho.vfs.OutputStreamWithBuffer;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReaderWriterStream;
import com.caucho.vfs.StreamFilter;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.StreamPrintWriter;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.VfsWriteObject;
import com.caucho.vfs.i18n.EncodingWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Locale;

public class WriteStream
extends OutputStreamWithBuffer {
    private static byte[] lfBytes = new byte[]{10};
    private static byte[] crBytes = new byte[]{13};
    private static byte[] crlfBytes = new byte[]{13, 10};
    private static String _sysNewline = Path.getNewlineString();
    private static byte[] _sysNewlineBytes = _sysNewline.getBytes();
    private TempBuffer _tempWrite;
    private byte[] _writeBuffer;
    private int _writeLength;
    private StreamImpl _source;
    private char[] chars;
    private byte[] _bytes;
    private EncodingWriter _writeEncoding;
    private String _writeEncodingName;
    private boolean _implicitFlush = false;
    private boolean flushOnNewline;
    private boolean _disableClose;
    private boolean _isDisableCloseSource;
    private boolean _disableFlush;
    private boolean reuseBuffer;
    private StreamWriter _writer;
    private StreamPrintWriter _printWriter;
    private String newline = "\n";
    private byte[] newlineBytes = lfBytes;

    public WriteStream() {
    }

    public WriteStream(StreamImpl source) {
        this.init(source);
    }

    public void init(StreamImpl source) {
        this._disableClose = false;
        this._isDisableCloseSource = false;
        if (this._source != null && this._source != source) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (source == null) {
            throw new IllegalArgumentException();
        }
        if (this._tempWrite == null) {
            this._tempWrite = TempBuffer.allocate();
            this._writeBuffer = this._tempWrite._buf;
        }
        this._source = source;
        this._writeLength = 0;
        this.flushOnNewline = source.getFlushOnNewline();
        this.newline = _sysNewline;
        this.newlineBytes = _sysNewlineBytes;
        this._writeEncoding = null;
        this._writeEncodingName = "ISO-8859-1";
    }

    public StreamImpl getSource() {
        return this._source;
    }

    public void pushFilter(StreamFilter filter) {
        filter.init(this._source);
        this._source = filter;
    }

    public boolean canWrite() {
        return this._source != null && this._source.canWrite();
    }

    public void clearWrite() {
        if (this._source != null) {
            this._source.clearWrite();
        }
    }

    public void setReuseBuffer(boolean reuse) {
        this.reuseBuffer = reuse;
    }

    public byte[] getBuffer() {
        return this._writeBuffer;
    }

    public int getBufferOffset() {
        return this._writeLength;
    }

    public void setBufferOffset(int offset) {
        this._writeLength = offset;
    }

    public int getBufferSize() {
        return this._writeBuffer.length;
    }

    public int getRemaining() {
        if (this._source == null) {
            return 0;
        }
        return this._writeBuffer.length - this._writeLength;
    }

    public void setImplicitFlush(boolean implicitFlush) {
        this._implicitFlush = implicitFlush;
    }

    public void write(int ch) throws IOException {
        if (this._source == null) {
            return;
        }
        int len = this._writeLength;
        if (this._writeBuffer.length <= len) {
            this._writeLength = 0;
            this._source.write(this._writeBuffer, 0, len, false);
        }
        this._writeBuffer[this._writeLength++] = (byte)ch;
        if (this._implicitFlush) {
            this.flush();
        }
    }

    public void write(byte[] buf, int offset, int length) throws IOException {
        byte[] buffer = this._writeBuffer;
        if (this._source == null) {
            return;
        }
        int bufferLength = buffer.length;
        int writeLength = this._writeLength;
        if (bufferLength <= length && this._source.write(buffer, 0, writeLength, buf, offset, length, false)) {
            this._writeLength = 0;
            return;
        }
        while (length > 0) {
            int sublen = bufferLength - writeLength;
            if (length < sublen) {
                sublen = length;
            }
            System.arraycopy(buf, offset, buffer, writeLength, sublen);
            offset += sublen;
            length -= sublen;
            if (bufferLength > (writeLength += sublen)) continue;
            int len = writeLength;
            writeLength = 0;
            this._source.write(buffer, 0, len, false);
        }
        this._writeLength = writeLength;
        if (this._implicitFlush) {
            this.flush();
        }
    }

    public byte[] nextBuffer(int offset) throws IOException {
        this._writeLength = 0;
        this._source.write(this._writeBuffer, 0, offset, false);
        if (this._implicitFlush) {
            this.flush();
        }
        return this._writeBuffer;
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void flush() throws IOException {
        if (this._disableFlush || this._source == null) {
            return;
        }
        int len = this._writeLength;
        if (len > 0) {
            this._writeLength = 0;
            this._source.write(this._writeBuffer, 0, len, false);
        }
        if (this._source != null) {
            this._source.flush();
        }
    }

    public void flushToDisk() throws IOException {
        StreamImpl source = this._source;
        if (this._disableFlush || source == null) {
            return;
        }
        int len = this._writeLength;
        if (len > 0) {
            this._writeLength = 0;
            source.write(this._writeBuffer, 0, len, false);
        }
        source.flushToDisk();
    }

    public void flushBuffer() throws IOException {
        if (this._disableFlush || this._source == null) {
            return;
        }
        int len = this._writeLength;
        if (len > 0) {
            this._writeLength = 0;
            this._source.write(this._writeBuffer, 0, len, false);
            this._source.flushBuffer();
        }
    }

    public void seekStart(long offset) throws IOException {
        this.flushBuffer();
        StreamImpl source = this._source;
        if (source != null) {
            source.seekStart(offset);
        }
    }

    public void seekEnd(long offset) throws IOException {
        this.flushBuffer();
        StreamImpl source = this._source;
        if (source != null) {
            source.seekEnd(offset);
        }
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        String mimeName;
        if (this._source instanceof ReaderWriterStream) {
            encoding = "UTF-8";
        }
        if ((mimeName = Encoding.getMimeName(encoding)) != null && mimeName.equals(this._writeEncodingName)) {
            return;
        }
        if (this._source != null) {
            this._source.setWriteEncoding(encoding);
        }
        this._writeEncoding = Encoding.getWriteEncoding(encoding);
        this._writeEncodingName = mimeName;
    }

    public void setLocale(Locale locale) throws UnsupportedEncodingException {
        if (this._writeEncoding == null && locale != null) {
            this.setEncoding(Encoding.getMimeName(locale));
        }
    }

    public String getEncoding() {
        if (this._source instanceof ReaderWriterStream) {
            return ((ReaderWriterStream)this._source).getEncoding();
        }
        return this._writeEncodingName;
    }

    public String getJavaEncoding() {
        return Encoding.getJavaName(this.getEncoding());
    }

    public void setFlushOnNewline(boolean flushOnNewline) {
        this.flushOnNewline = flushOnNewline;
    }

    public String getNewlineString() {
        return this.newline;
    }

    public void setNewlineString(String newline) {
        if (newline != null) {
            if (this.newline != newline && !newline.equals(this.newline)) {
                this.newlineBytes = newline == "\n" || newline.equals("\n") ? lfBytes : (newline == "\r\n" || newline.equals("\r\n") ? crlfBytes : (newline == "\r" || newline.equals("\r") ? crBytes : newline.getBytes()));
            }
            this.newline = newline;
        }
    }

    public final void print(char[] buffer, int offset, int length) throws IOException {
        byte[] writeBuffer = this._writeBuffer;
        if (this._source == null) {
            return;
        }
        if (this._writeEncoding != null) {
            this._disableFlush = true;
            this._writeEncoding.write(this, buffer, offset, length);
            this._disableFlush = false;
            return;
        }
        while (length > 0) {
            int writeLength = this._writeLength;
            int sublen = writeBuffer.length - writeLength;
            if (sublen <= 0) {
                this._source.write(writeBuffer, 0, writeLength, false);
                writeLength = 0;
                sublen = writeBuffer.length - writeLength;
            }
            if (length < sublen) {
                sublen = length;
            }
            for (int i = sublen - 1; i >= 0; --i) {
                writeBuffer[writeLength + i] = (byte)buffer[offset + i];
            }
            this._writeLength = writeLength + sublen;
            offset += sublen;
            length -= sublen;
        }
        if (this._implicitFlush) {
            this.flush();
        }
    }

    public final void print(char ch) throws IOException {
        if (this._writeEncoding != null) {
            this._disableFlush = true;
            this._writeEncoding.write(this, ch);
            this._disableFlush = false;
            return;
        }
        this.write((byte)ch);
    }

    public final void print(char[] buffer) throws IOException {
        this.print(buffer, 0, buffer.length);
    }

    public final void print(CharSegment segment) throws IOException {
        this.print(segment.getBuffer(), segment.getOffset(), segment.getLength());
    }

    public final void print(String string) throws IOException {
        if (string == null) {
            string = "null";
        }
        int length = string.length();
        int offset = 0;
        while (length > 0) {
            int sublen;
            int n = sublen = length < 1024 ? length : 1024;
            if (this.chars == null || this.chars.length < sublen) {
                this.chars = new char[sublen < 32 ? 32 : sublen];
            }
            string.getChars(offset, offset + sublen, this.chars, 0);
            this.print(this.chars, 0, sublen);
            length -= sublen;
            offset += sublen;
        }
    }

    public final void print(String string, int offset, int length) throws IOException {
        if (string == null) {
            string = "null";
        }
        while (length > 0) {
            int sublen;
            int n = sublen = length < 1024 ? length : 1024;
            if (this.chars == null || this.chars.length < sublen) {
                this.chars = new char[sublen < 32 ? 32 : sublen];
            }
            string.getChars(offset, offset + sublen, this.chars, 0);
            this.print(this.chars, 0, sublen);
            length -= sublen;
            offset += sublen;
        }
    }

    public final void print(boolean b) throws IOException {
        this.print(b ? "true" : "false");
    }

    public final void print(int i) throws IOException {
        if (i == Integer.MIN_VALUE) {
            this.print("-2147483648");
            return;
        }
        if (i < 0) {
            this.write(45);
            i = -i;
        } else if (i < 9) {
            this.write(48 + i);
            return;
        }
        int length = 0;
        int exp = 10;
        if (i >= 1000000000) {
            length = 9;
        } else {
            while (i >= exp) {
                exp = 10 * exp;
                ++length;
            }
        }
        byte[] buffer = this._writeBuffer;
        int writeLength = this._writeLength;
        if (writeLength + length < buffer.length) {
            this._writeLength = (writeLength += length) + 1;
            for (int j = 0; j <= length; ++j) {
                buffer[writeLength - j] = (byte)(i % 10 + 48);
                i /= 10;
            }
            return;
        }
        if (this._bytes == null) {
            this._bytes = new byte[32];
        }
        int j = 31;
        while (i > 0) {
            this._bytes[--j] = (byte)(i % 10 + 48);
            i /= 10;
        }
        this.write(this._bytes, j, 31 - j);
    }

    public final void print(long i) throws IOException {
        if (i == Long.MIN_VALUE) {
            this.print("-9223372036854775808");
            return;
        }
        if (this._bytes == null) {
            this._bytes = new byte[32];
        }
        if (i < 0L) {
            this.write(45);
            i = -i;
        } else if (i == 0L) {
            this.write(48);
            return;
        }
        int j = 31;
        while (i > 0L) {
            this._bytes[--j] = (byte)(i % 10L + 48L);
            i /= 10L;
        }
        this.write(this._bytes, j, 31 - j);
    }

    public final void print(float f) throws IOException {
        this.print(String.valueOf(f));
    }

    public final void print(double d) throws IOException {
        this.print(String.valueOf(d));
    }

    public final void print(Object o) throws IOException {
        if (o == null) {
            this.print("null");
        } else if (o instanceof VfsWriteObject) {
            ((VfsWriteObject)o).print(this);
        } else {
            this.print(o.toString());
        }
    }

    public final void println() throws IOException {
        this.write(this.newlineBytes, 0, this.newlineBytes.length);
        if (this.flushOnNewline) {
            this.flush();
        }
    }

    public final void println(char[] buf, int offset, int length) throws IOException {
        this.print(buf, offset, length);
        this.write(this.newlineBytes, 0, this.newlineBytes.length);
        if (this.flushOnNewline) {
            this.flush();
        }
    }

    public final void println(String string) throws IOException {
        this.print(string);
        this.write(this.newlineBytes, 0, this.newlineBytes.length);
        if (this.flushOnNewline) {
            this.flush();
        }
    }

    public final void println(boolean b) throws IOException {
        this.println(b ? "true" : "false");
    }

    public final void println(char ch) throws IOException {
        this.write(ch);
        this.write(this.newlineBytes, 0, this.newlineBytes.length);
        if (this.flushOnNewline) {
            this.flush();
        }
    }

    public final void println(int i) throws IOException {
        this.print(i);
        this.write(this.newlineBytes, 0, this.newlineBytes.length);
        if (this.flushOnNewline) {
            this.flush();
        }
    }

    public final void println(long l) throws IOException {
        this.print(l);
        this.write(this.newlineBytes, 0, this.newlineBytes.length);
        if (this.flushOnNewline) {
            this.flush();
        }
    }

    public final void println(float f) throws IOException {
        this.println(String.valueOf(f));
    }

    public final void println(double d) throws IOException {
        this.println(String.valueOf(d));
    }

    public final void println(Object o) throws IOException {
        if (o == null) {
            this.println("null");
        } else {
            this.println(o.toString());
        }
    }

    public PrintWriter getPrintWriter() {
        if (this._printWriter == null) {
            this._printWriter = new StreamPrintWriter(this);
        }
        return this._printWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void log(String string) {
        try {
            WriteStream writeStream = this;
            synchronized (writeStream) {
                this.println(string);
                this.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void log(Throwable exn) {
        try {
            PrintWriter out = this.getPrintWriter();
            WriteStream writeStream = this;
            synchronized (writeStream) {
                if (exn != null) {
                    exn.printStackTrace(out);
                    this.flush();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public long writeStream(InputStream source) throws IOException {
        int len;
        int tmplen;
        if (source == null) {
            return 0L;
        }
        int length = this._writeBuffer.length;
        long outputLength = 0L;
        if (this._writeLength >= length) {
            tmplen = this._writeLength;
            this._writeLength = 0;
            this._source.write(this._writeBuffer, 0, tmplen, false);
            outputLength += (long)tmplen;
        }
        while ((len = source.read(this._writeBuffer, this._writeLength, length - this._writeLength)) >= 0) {
            this._writeLength += len;
            outputLength += (long)len;
            if (length > this._writeLength) continue;
            tmplen = this._writeLength;
            this._writeLength = 0;
            this._source.write(this._writeBuffer, 0, tmplen, false);
        }
        if (this.flushOnNewline || this._implicitFlush) {
            this.flush();
        }
        return outputLength;
    }

    public void writeStream(Reader reader) throws IOException {
        int len;
        if (reader == null) {
            return;
        }
        if (this.chars == null) {
            this.chars = new char[256];
        }
        while ((len = reader.read(this.chars, 0, this.chars.length)) > 0) {
            this.print(this.chars, 0, len);
        }
    }

    public void writeStream(InputStream source, int totalLength) throws IOException {
        if (source == null) {
            return;
        }
        int length = this._writeBuffer.length;
        if (this._writeLength >= length) {
            int tmplen = this._writeLength;
            this._writeLength = 0;
            this._source.write(this._writeBuffer, 0, tmplen, false);
        }
        while (totalLength > 0) {
            int sublen = length - this._writeLength;
            if (sublen > totalLength) {
                sublen = totalLength;
            }
            if ((sublen = source.read(this._writeBuffer, this._writeLength, sublen)) < 0) break;
            this._writeLength += sublen;
            totalLength -= sublen;
            if (this._writeLength < length) continue;
            int tmplen = this._writeLength;
            this._writeLength = 0;
            this._source.write(this._writeBuffer, 0, tmplen, false);
        }
        if (this.flushOnNewline || this._implicitFlush) {
            this.flush();
        }
    }

    public void writeStream(StreamImpl source) throws IOException {
        int len;
        int tmplen;
        if (source == null) {
            return;
        }
        int length = this._writeBuffer.length;
        if (this._writeLength >= length) {
            tmplen = this._writeLength;
            this._writeLength = 0;
            this._source.write(this._writeBuffer, 0, tmplen, false);
        }
        while ((len = source.read(this._writeBuffer, this._writeLength, length - this._writeLength)) >= 0) {
            this._writeLength += len;
            if (this._writeLength < length) continue;
            tmplen = this._writeLength;
            this._writeLength = 0;
            this._source.write(this._writeBuffer, 0, tmplen, false);
        }
        if (this.flushOnNewline || this._implicitFlush) {
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(Path path) throws IOException {
        StreamImpl is = path.openReadImpl();
        try {
            if (is != null) {
                this.writeStream(is);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public void setDisableClose(boolean disableClose) {
        this._disableClose = disableClose;
    }

    public boolean getDisableClose() {
        return this._disableClose;
    }

    public void setDisableCloseSource(boolean disableClose) {
        this._isDisableCloseSource = disableClose;
    }

    public final boolean isClosed() {
        return this._source != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws IOException {
        StreamImpl s;
        block12: {
            block13: {
                s = this._source;
                try {
                    int len = this._writeLength;
                    if (len > 0) {
                        this._writeLength = 0;
                        if (s != null) {
                            s.write(this._writeBuffer, 0, len, true);
                        }
                    }
                    Object var4_3 = null;
                    if (this._disableClose) {
                        return;
                    }
                    this._source = null;
                    if (this._writeEncoding != null) {
                        this._writeEncoding = null;
                    }
                    if (this.reuseBuffer) break block12;
                    if (this._tempWrite == null) break block13;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (this._disableClose) {
                        return;
                    }
                    this._source = null;
                    if (this._writeEncoding != null) {
                        this._writeEncoding = null;
                    }
                    if (!this.reuseBuffer) {
                        if (this._tempWrite != null) {
                            TempBuffer.free(this._tempWrite);
                        }
                        this._tempWrite = null;
                        this._writeBuffer = null;
                    }
                    if (s != null && !this._isDisableCloseSource) {
                        s.closeWrite();
                    }
                    throw throwable;
                }
                TempBuffer.free(this._tempWrite);
            }
            this._tempWrite = null;
            this._writeBuffer = null;
        }
        if (s != null && !this._isDisableCloseSource) {
            s.closeWrite();
        }
    }

    public final void free() {
        this._source = null;
        if (this._tempWrite != null) {
            TempBuffer.free(this._tempWrite);
        }
        this._tempWrite = null;
        this._writeBuffer = null;
    }

    public Object getAttribute(String name) throws IOException {
        return this._source.getAttribute(name);
    }

    public void setAttribute(String name, Object value) throws IOException {
        this._source.setAttribute(name, value);
    }

    public void removeAttribute(String name) throws IOException {
        this._source.removeAttribute(name);
    }

    public Iterator getAttributeNames() throws IOException {
        return this._source.getAttributeNames();
    }

    public Path getPath() {
        if (this._source != null) {
            return this._source.getPath();
        }
        return null;
    }

    public String getUserPath() {
        return this._source.getPath().getUserPath();
    }

    public void setPath(Path path) {
        this._source.setPath(path);
    }

    public static void setSystemNewline(String newline) {
        _sysNewline = newline;
        _sysNewlineBytes = _sysNewline.getBytes();
    }

    private class StreamWriter
    extends Writer
    implements EnclosedWriteStream,
    FlushBuffer {
        private StreamWriter() {
        }

        public final void write(char ch) throws IOException {
            WriteStream.this.print(ch);
        }

        public final void write(char[] buffer, int offset, int length) throws IOException {
            WriteStream.this.print(buffer, offset, length);
        }

        public final void write(char[] buffer) throws IOException {
            WriteStream.this.print(buffer, 0, buffer.length);
        }

        public final void write(String string) throws IOException {
            WriteStream.this.print(string);
        }

        public final void write(String string, int off, int len) throws IOException {
            WriteStream.this.print(string, off, len);
        }

        public final void flush() throws IOException {
            WriteStream.this.flush();
        }

        public final void flushBuffer() throws IOException {
            WriteStream.this.flushBuffer();
        }

        public final void close() throws IOException {
        }

        public WriteStream getWriteStream() {
            return WriteStream.this;
        }
    }
}

