/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.html;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.compare.internal.LCSSettings;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.outerj.daisy.diff.html.HtmlSaxDiffOutput;
import org.outerj.daisy.diff.html.TextNodeComparator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLDiffer {
    private HtmlSaxDiffOutput output;

    public HTMLDiffer(HtmlSaxDiffOutput dm) {
        this.output = dm;
    }

    public void diff(TextNodeComparator leftComparator, TextNodeComparator rightComparator) throws SAXException {
        LCSSettings settings = new LCSSettings();
        settings.setUseGreedyMethod(false);
        RangeDifference[] differences = RangeDifferencer.findDifferences(settings, leftComparator, rightComparator);
        List<RangeDifference> pdifferences = this.preProcess(differences);
        int currentIndexLeft = 0;
        int currentIndexRight = 0;
        for (RangeDifference d : pdifferences) {
            if (d.leftStart() > currentIndexLeft) {
                rightComparator.handlePossibleChangedPart(currentIndexLeft, d.leftStart(), currentIndexRight, d.rightStart(), leftComparator);
            }
            if (d.leftLength() > 0) {
                rightComparator.markAsDeleted(d.leftStart(), d.leftEnd(), leftComparator, d.rightStart());
            }
            rightComparator.markAsNew(d.rightStart(), d.rightEnd());
            currentIndexLeft = d.leftEnd();
            currentIndexRight = d.rightEnd();
        }
        if (currentIndexLeft < leftComparator.getRangeCount()) {
            rightComparator.handlePossibleChangedPart(currentIndexLeft, leftComparator.getRangeCount(), currentIndexRight, rightComparator.getRangeCount(), leftComparator);
        }
        rightComparator.expandWhiteSpace();
        this.output.toHTML(rightComparator.getBodyNode());
    }

    private List<RangeDifference> preProcess(RangeDifference[] differences) {
        LinkedList<RangeDifference> newRanges = new LinkedList<RangeDifference>();
        for (int i = 0; i < differences.length; ++i) {
            int leftStart = differences[i].leftStart();
            int leftEnd = differences[i].leftEnd();
            int rightStart = differences[i].rightStart();
            int rightEnd = differences[i].rightEnd();
            int kind = differences[i].kind();
            int leftLength = leftEnd - leftStart;
            int rightLength = rightEnd - rightStart;
            while (i + 1 < differences.length && differences[i + 1].kind() == kind) {
                int[] nArray = new int[]{leftLength, differences[i + 1].leftLength(), rightLength, differences[i + 1].rightLength()};
                if (!(HTMLDiffer.score(nArray) > (double)(differences[i + 1].leftStart() - leftEnd))) break;
                leftEnd = differences[i + 1].leftEnd();
                rightEnd = differences[i + 1].rightEnd();
                leftLength = leftEnd - leftStart;
                rightLength = rightEnd - rightStart;
                ++i;
            }
            newRanges.add(new RangeDifference(kind, rightStart, rightLength, leftStart, leftLength));
        }
        return newRanges;
    }

    public static double score(int ... numbers) {
        if (numbers[0] == 0 && numbers[1] == 0 || numbers[2] == 0 && numbers[3] == 0) {
            return 0.0;
        }
        double d = 0.0;
        int[] arr$ = numbers;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double number;
            for (number = (double)arr$[i$]; number > 3.0; number *= 0.5) {
                d += 3.0;
                number -= 3.0;
            }
            d += number;
        }
        return d / (1.5 * (double)numbers.length);
    }
}

