/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.html.dom;

import java.util.ArrayList;
import java.util.List;
import org.outerj.daisy.diff.html.dom.TagNode;
import org.outerj.daisy.diff.html.dom.helper.LastCommonParentResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node {
    protected TagNode parent;
    private boolean whiteBefore = false;
    private boolean whiteAfter = false;

    public Node(TagNode parent) {
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public TagNode getParent() {
        return this.parent;
    }

    public List<TagNode> getParentTree() {
        ArrayList<TagNode> parentTree = new ArrayList<TagNode>(5);
        if (this.getParent() != null) {
            parentTree.addAll(this.getParent().getParentTree());
            parentTree.add(this.getParent());
        }
        return parentTree;
    }

    public TagNode getRoot() {
        TagNode ancestor = this.getParent();
        if (ancestor != null) {
            return ancestor.getRoot();
        }
        if (this instanceof TagNode) {
            return (TagNode)this;
        }
        return null;
    }

    public abstract List<Node> getMinimalDeletedSet(long var1);

    public void detectIgnorableWhiteSpace() {
    }

    public LastCommonParentResult getLastCommonParent(Node other) {
        if (other == null) {
            throw new IllegalArgumentException("The given TextNode is null");
        }
        LastCommonParentResult result = new LastCommonParentResult();
        List<TagNode> myParents = this.getParentTree();
        List<TagNode> otherParents = other.getParentTree();
        int i = 1;
        boolean isSame = true;
        while (isSame && i < myParents.size() && i < otherParents.size()) {
            if (!myParents.get(i).isSameTag(otherParents.get(i))) {
                isSame = false;
                continue;
            }
            ++i;
        }
        result.setLastCommonParentDepth(i - 1);
        result.setLastCommonParent(myParents.get(i - 1));
        if (!isSame) {
            result.setIndexInLastCommonParent(myParents.get(i - 1).getIndexOf(myParents.get(i)));
            result.setSplittingNeeded();
        } else if (myParents.size() < otherParents.size()) {
            result.setIndexInLastCommonParent(myParents.get(i - 1).getIndexOf(this));
        } else if (myParents.size() > otherParents.size()) {
            result.setIndexInLastCommonParent(myParents.get(i - 1).getIndexOf(myParents.get(i)));
            result.setSplittingNeeded();
        } else {
            result.setIndexInLastCommonParent(myParents.get(i - 1).getIndexOf(this));
        }
        return result;
    }

    public void setParent(TagNode parent) {
        this.parent = parent;
    }

    public abstract Node copyTree();

    public boolean inPre() {
        for (TagNode ancestor : this.getParentTree()) {
            if (!ancestor.isPre()) continue;
            return true;
        }
        return false;
    }

    public boolean isWhiteBefore() {
        return this.whiteBefore;
    }

    public void setWhiteBefore(boolean whiteBefore) {
        this.whiteBefore = whiteBefore;
    }

    public boolean isWhiteAfter() {
        return this.whiteAfter;
    }

    public void setWhiteAfter(boolean whiteAfter) {
        this.whiteAfter = whiteAfter;
    }

    public abstract Node getLeftMostChild();

    public abstract Node getRightMostChild();
}

