/*
 * Decompiled with CFR 0.152.
 */
package com.p6spy.engine.spy;

import com.p6spy.engine.common.P6LogQuery;
import com.p6spy.engine.spy.P6Base;
import com.p6spy.engine.spy.P6Factory;
import com.p6spy.engine.spy.P6Statement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class P6ResultSet
extends P6Base
implements ResultSet {
    protected ResultSet passthru;
    protected P6Statement statement;
    protected String query;
    protected String preparedQuery;
    private Map resultMap = new TreeMap();
    private int currRow = -1;

    public P6ResultSet(P6Factory factory, ResultSet resultSet, P6Statement statement, String preparedQuery, String query) {
        this.setP6Factory(factory);
        this.passthru = resultSet;
        this.statement = statement;
        this.query = query;
        this.preparedQuery = preparedQuery;
    }

    public boolean next() throws SQLException {
        if (this.currRow > -1) {
            StringBuffer buffer = new StringBuffer();
            String comma = "";
            Iterator itr = this.resultMap.keySet().iterator();
            while (itr.hasNext()) {
                String index = (String)itr.next();
                buffer.append(comma);
                buffer.append(index);
                buffer.append(" = ");
                buffer.append((String)this.resultMap.get(index));
                comma = ", ";
            }
            P6LogQuery.log("resultset", this.query, buffer.toString());
            this.resultMap.clear();
        }
        ++this.currRow;
        return this.passthru.next();
    }

    public int getRow() throws SQLException {
        return this.passthru.getRow();
    }

    public byte[] getBytes(String p0) throws SQLException {
        return this.passthru.getBytes(p0);
    }

    public byte[] getBytes(int p0) throws SQLException {
        return this.getBytes(this.passthru.getMetaData().getColumnName(p0));
    }

    public boolean getBoolean(int p0) throws SQLException {
        return this.getBoolean(this.passthru.getMetaData().getColumnName(p0));
    }

    public boolean getBoolean(String p0) throws SQLException {
        return this.passthru.getBoolean(p0);
    }

    public int getType() throws SQLException {
        return this.passthru.getType();
    }

    public long getLong(int p0) throws SQLException {
        return this.getLong(this.passthru.getMetaData().getColumnName(p0));
    }

    public long getLong(String p0) throws SQLException {
        return this.passthru.getLong(p0);
    }

    public boolean previous() throws SQLException {
        return this.passthru.previous();
    }

    public void close() throws SQLException {
        this.passthru.close();
    }

    public Object getObject(String p0, Map p1) throws SQLException {
        return this.passthru.getObject(p0, p1);
    }

    public Object getObject(int p0) throws SQLException {
        return this.getObject(this.passthru.getMetaData().getColumnName(p0));
    }

    public Object getObject(String p0) throws SQLException {
        return this.passthru.getObject(p0);
    }

    public Object getObject(int p0, Map p1) throws SQLException {
        return this.passthru.getObject(p0, p1);
    }

    public Ref getRef(String p0) throws SQLException {
        return this.passthru.getRef(p0);
    }

    public Ref getRef(int p0) throws SQLException {
        return this.getRef(this.passthru.getMetaData().getColumnName(p0));
    }

    public Time getTime(int p0, Calendar p1) throws SQLException {
        return this.passthru.getTime(p0, p1);
    }

    public Time getTime(String p0, Calendar p1) throws SQLException {
        return this.passthru.getTime(p0, p1);
    }

    public Time getTime(String p0) throws SQLException {
        return this.passthru.getTime(p0);
    }

    public Time getTime(int p0) throws SQLException {
        return this.getTime(this.passthru.getMetaData().getColumnName(p0));
    }

    public Date getDate(int p0) throws SQLException {
        return this.getDate(this.passthru.getMetaData().getColumnName(p0));
    }

    public Date getDate(String p0, Calendar p1) throws SQLException {
        return this.passthru.getDate(p0);
    }

    public Date getDate(String p0) throws SQLException {
        return this.passthru.getDate(p0);
    }

    public Date getDate(int p0, Calendar p1) throws SQLException {
        return this.passthru.getDate(p0, p1);
    }

    public boolean wasNull() throws SQLException {
        return this.passthru.wasNull();
    }

    public String getString(String p0) throws SQLException {
        String result = this.passthru.getString(p0);
        this.resultMap.put(p0, result);
        return result;
    }

    public String getString(int p0) throws SQLException {
        return this.getString(this.passthru.getMetaData().getColumnName(p0));
    }

    public byte getByte(String p0) throws SQLException {
        return this.passthru.getByte(p0);
    }

    public byte getByte(int p0) throws SQLException {
        return this.getByte(this.passthru.getMetaData().getColumnName(p0));
    }

    public short getShort(String p0) throws SQLException {
        short result = this.passthru.getShort(p0);
        this.resultMap.put(p0, String.valueOf(result));
        return result;
    }

    public short getShort(int p0) throws SQLException {
        return this.getShort(this.passthru.getMetaData().getColumnName(p0));
    }

    public int getInt(int p0) throws SQLException {
        return this.getInt(this.passthru.getMetaData().getColumnName(p0));
    }

    public int getInt(String p0) throws SQLException {
        int result = this.passthru.getInt(p0);
        this.resultMap.put(p0, String.valueOf(result));
        return result;
    }

    public float getFloat(String p0) throws SQLException {
        return this.passthru.getFloat(p0);
    }

    public float getFloat(int p0) throws SQLException {
        return this.getFloat(this.passthru.getMetaData().getColumnName(p0));
    }

    public double getDouble(int p0) throws SQLException {
        return this.getDouble(this.passthru.getMetaData().getColumnName(p0));
    }

    public double getDouble(String p0) throws SQLException {
        return this.passthru.getDouble(p0);
    }

    public BigDecimal getBigDecimal(String p0) throws SQLException {
        return this.passthru.getBigDecimal(p0);
    }

    public BigDecimal getBigDecimal(int p0) throws SQLException {
        return this.getBigDecimal(this.passthru.getMetaData().getColumnName(p0));
    }

    public BigDecimal getBigDecimal(int p0, int p1) throws SQLException {
        return this.passthru.getBigDecimal(p0, p1);
    }

    public BigDecimal getBigDecimal(String p0, int p1) throws SQLException {
        return this.passthru.getBigDecimal(p0, p1);
    }

    public Timestamp getTimestamp(String p0) throws SQLException {
        return this.passthru.getTimestamp(p0);
    }

    public Timestamp getTimestamp(String p0, Calendar p1) throws SQLException {
        return this.passthru.getTimestamp(p0, p1);
    }

    public Timestamp getTimestamp(int p0) throws SQLException {
        return this.getTimestamp(this.passthru.getMetaData().getColumnName(p0));
    }

    public Timestamp getTimestamp(int p0, Calendar p1) throws SQLException {
        return this.passthru.getTimestamp(p0, p1);
    }

    public InputStream getAsciiStream(String p0) throws SQLException {
        return this.passthru.getAsciiStream(p0);
    }

    public InputStream getAsciiStream(int p0) throws SQLException {
        return this.getAsciiStream(this.passthru.getMetaData().getColumnName(p0));
    }

    public InputStream getUnicodeStream(int p0) throws SQLException {
        return this.passthru.getUnicodeStream(p0);
    }

    public InputStream getUnicodeStream(String p0) throws SQLException {
        return this.passthru.getUnicodeStream(p0);
    }

    public InputStream getBinaryStream(int p0) throws SQLException {
        return this.getBinaryStream(this.passthru.getMetaData().getColumnName(p0));
    }

    public InputStream getBinaryStream(String p0) throws SQLException {
        return this.passthru.getBinaryStream(p0);
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.passthru.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.passthru.clearWarnings();
    }

    public String getCursorName() throws SQLException {
        return this.passthru.getCursorName();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.getP6Factory().getResultSetMetaData(this.passthru.getMetaData());
    }

    public int findColumn(String p0) throws SQLException {
        return this.passthru.findColumn(p0);
    }

    public Reader getCharacterStream(String p0) throws SQLException {
        return this.passthru.getCharacterStream(p0);
    }

    public Reader getCharacterStream(int p0) throws SQLException {
        return this.getCharacterStream(this.passthru.getMetaData().getColumnName(p0));
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.passthru.isBeforeFirst();
    }

    public boolean isAfterLast() throws SQLException {
        return this.passthru.isAfterLast();
    }

    public boolean isFirst() throws SQLException {
        return this.passthru.isFirst();
    }

    public boolean isLast() throws SQLException {
        return this.passthru.isLast();
    }

    public void beforeFirst() throws SQLException {
        this.passthru.beforeFirst();
    }

    public void afterLast() throws SQLException {
        this.passthru.afterLast();
    }

    public boolean first() throws SQLException {
        return this.passthru.first();
    }

    public boolean last() throws SQLException {
        return this.passthru.last();
    }

    public boolean absolute(int p0) throws SQLException {
        return this.passthru.absolute(p0);
    }

    public boolean relative(int p0) throws SQLException {
        return this.passthru.relative(p0);
    }

    public void setFetchDirection(int p0) throws SQLException {
        this.passthru.setFetchDirection(p0);
    }

    public int getFetchDirection() throws SQLException {
        return this.passthru.getFetchDirection();
    }

    public void setFetchSize(int p0) throws SQLException {
        this.passthru.setFetchSize(p0);
    }

    public int getFetchSize() throws SQLException {
        return this.passthru.getFetchSize();
    }

    public int getConcurrency() throws SQLException {
        return this.passthru.getConcurrency();
    }

    public boolean rowUpdated() throws SQLException {
        return this.passthru.rowUpdated();
    }

    public boolean rowInserted() throws SQLException {
        return this.passthru.rowInserted();
    }

    public boolean rowDeleted() throws SQLException {
        return this.passthru.rowDeleted();
    }

    public void updateNull(int p0) throws SQLException {
        this.passthru.updateNull(p0);
    }

    public void updateNull(String p0) throws SQLException {
        this.passthru.updateNull(p0);
    }

    public void updateBoolean(int p0, boolean p1) throws SQLException {
        this.passthru.updateBoolean(p0, p1);
    }

    public void updateBoolean(String p0, boolean p1) throws SQLException {
        this.passthru.updateBoolean(p0, p1);
    }

    public void updateByte(String p0, byte p1) throws SQLException {
        this.passthru.updateByte(p0, p1);
    }

    public void updateByte(int p0, byte p1) throws SQLException {
        this.passthru.updateByte(p0, p1);
    }

    public void updateShort(int p0, short p1) throws SQLException {
        this.passthru.updateShort(p0, p1);
    }

    public void updateShort(String p0, short p1) throws SQLException {
        this.passthru.updateShort(p0, p1);
    }

    public void updateInt(int p0, int p1) throws SQLException {
        this.passthru.updateInt(p0, p1);
    }

    public void updateInt(String p0, int p1) throws SQLException {
        this.passthru.updateInt(p0, p1);
    }

    public void updateLong(int p0, long p1) throws SQLException {
        this.passthru.updateLong(p0, p1);
    }

    public void updateLong(String p0, long p1) throws SQLException {
        this.passthru.updateLong(p0, p1);
    }

    public void updateFloat(String p0, float p1) throws SQLException {
        this.passthru.updateFloat(p0, p1);
    }

    public void updateFloat(int p0, float p1) throws SQLException {
        this.passthru.updateFloat(p0, p1);
    }

    public void updateDouble(int p0, double p1) throws SQLException {
        this.passthru.updateDouble(p0, p1);
    }

    public void updateDouble(String p0, double p1) throws SQLException {
        this.passthru.updateDouble(p0, p1);
    }

    public void updateBigDecimal(String p0, BigDecimal p1) throws SQLException {
        this.passthru.updateBigDecimal(p0, p1);
    }

    public void updateBigDecimal(int p0, BigDecimal p1) throws SQLException {
        this.passthru.updateBigDecimal(p0, p1);
    }

    public void updateString(String p0, String p1) throws SQLException {
        this.passthru.updateString(p0, p1);
    }

    public void updateString(int p0, String p1) throws SQLException {
        this.passthru.updateString(p0, p1);
    }

    public void updateBytes(int p0, byte[] p1) throws SQLException {
        this.passthru.updateBytes(p0, p1);
    }

    public void updateBytes(String p0, byte[] p1) throws SQLException {
        this.passthru.updateBytes(p0, p1);
    }

    public void updateDate(int p0, Date p1) throws SQLException {
        this.passthru.updateDate(p0, p1);
    }

    public void updateDate(String p0, Date p1) throws SQLException {
        this.passthru.updateDate(p0, p1);
    }

    public void updateTime(String p0, Time p1) throws SQLException {
        this.passthru.updateTime(p0, p1);
    }

    public void updateTime(int p0, Time p1) throws SQLException {
        this.passthru.updateTime(p0, p1);
    }

    public void updateTimestamp(int p0, Timestamp p1) throws SQLException {
        this.passthru.updateTimestamp(p0, p1);
    }

    public void updateTimestamp(String p0, Timestamp p1) throws SQLException {
        this.passthru.updateTimestamp(p0, p1);
    }

    public void updateAsciiStream(int p0, InputStream p1, int p2) throws SQLException {
        this.passthru.updateAsciiStream(p0, p1, p2);
    }

    public void updateAsciiStream(String p0, InputStream p1, int p2) throws SQLException {
        this.passthru.updateAsciiStream(p0, p1, p2);
    }

    public void updateBinaryStream(int p0, InputStream p1, int p2) throws SQLException {
        this.passthru.updateBinaryStream(p0, p1, p2);
    }

    public void updateBinaryStream(String p0, InputStream p1, int p2) throws SQLException {
        this.passthru.updateBinaryStream(p0, p1, p2);
    }

    public void updateCharacterStream(int p0, Reader p1, int p2) throws SQLException {
        this.passthru.updateCharacterStream(p0, p1, p2);
    }

    public void updateCharacterStream(String p0, Reader p1, int p2) throws SQLException {
        this.passthru.updateCharacterStream(p0, p1, p2);
    }

    public void updateObject(int p0, Object p1) throws SQLException {
        this.passthru.updateObject(p0, p1);
    }

    public void updateObject(int p0, Object p1, int p2) throws SQLException {
        this.passthru.updateObject(p0, p1, p2);
    }

    public void updateObject(String p0, Object p1) throws SQLException {
        this.passthru.updateObject(p0, p1);
    }

    public void updateObject(String p0, Object p1, int p2) throws SQLException {
        this.passthru.updateObject(p0, p1, p2);
    }

    public void insertRow() throws SQLException {
        this.passthru.insertRow();
    }

    public void updateRow() throws SQLException {
        this.passthru.updateRow();
    }

    public void deleteRow() throws SQLException {
        this.passthru.deleteRow();
    }

    public void refreshRow() throws SQLException {
        this.passthru.refreshRow();
    }

    public void cancelRowUpdates() throws SQLException {
        this.passthru.cancelRowUpdates();
    }

    public void moveToInsertRow() throws SQLException {
        this.passthru.moveToInsertRow();
    }

    public void moveToCurrentRow() throws SQLException {
        this.passthru.moveToCurrentRow();
    }

    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    public Blob getBlob(int p0) throws SQLException {
        return this.getBlob(this.passthru.getMetaData().getColumnName(p0));
    }

    public Blob getBlob(String p0) throws SQLException {
        return this.passthru.getBlob(p0);
    }

    public Clob getClob(String p0) throws SQLException {
        return this.passthru.getClob(p0);
    }

    public Clob getClob(int p0) throws SQLException {
        return this.getClob(this.passthru.getMetaData().getColumnName(p0));
    }

    public Array getArray(int p0) throws SQLException {
        return this.getP6Factory().getArray(this.passthru.getArray(p0), this.statement, this.preparedQuery, this.query);
    }

    public Array getArray(String p0) throws SQLException {
        return this.getP6Factory().getArray(this.passthru.getArray(p0), this.statement, this.preparedQuery, this.query);
    }

    public URL getURL(int p0) throws SQLException {
        return this.passthru.getURL(p0);
    }

    public URL getURL(String p0) throws SQLException {
        return this.passthru.getURL(p0);
    }

    public void updateRef(int p0, Ref p1) throws SQLException {
        this.passthru.updateRef(p0, p1);
    }

    public void updateRef(String p0, Ref p1) throws SQLException {
        this.passthru.updateRef(p0, p1);
    }

    public void updateBlob(int p0, Blob p1) throws SQLException {
        this.passthru.updateBlob(p0, p1);
    }

    public void updateBlob(String p0, Blob p1) throws SQLException {
        this.passthru.updateBlob(p0, p1);
    }

    public void updateClob(int p0, Clob p1) throws SQLException {
        this.passthru.updateClob(p0, p1);
    }

    public void updateClob(String p0, Clob p1) throws SQLException {
        this.passthru.updateClob(p0, p1);
    }

    public void updateArray(int p0, Array p1) throws SQLException {
        this.passthru.updateArray(p0, p1);
    }

    public void updateArray(String p0, Array p1) throws SQLException {
        this.passthru.updateArray(p0, p1);
    }

    public ResultSet getJDBC() {
        ResultSet wrapped = this.passthru instanceof P6ResultSet ? ((P6ResultSet)this.passthru).getJDBC() : this.passthru;
        return wrapped;
    }
}

