/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.exceptions.JDBCDriverException;
import com.sap.dbtech.jdbc.exceptions.StreamIOException;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.AbstractGetval;
import com.sap.dbtech.jdbc.translators.BinaryDataTranslator;
import com.sap.dbtech.jdbc.translators.ConversionExceptionSapDB;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.Getval;
import com.sap.dbtech.jdbc.translators.GetvalLob;
import com.sap.dbtech.jdbc.translators.Putval;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredMem;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;

abstract class StreamTranslator
extends BinaryDataTranslator {
    protected StreamTranslator(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
    }

    public InputStream getAsciiStream(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        throw new ConversionExceptionSapDB(MessageTranslator.translate("error.asciireadfromlong"));
    }

    public InputStream getBinaryStream(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        throw new ConversionExceptionSapDB(MessageTranslator.translate("error.binaryreadfromlong"));
    }

    public Blob getBlob(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        return this.getLob(sQLParamController, structuredMem, structuredMem2);
    }

    public Reader getCharacterStream(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        InputStream inputStream = this.getAsciiStream(sQLParamController, structuredMem, structuredMem2);
        if (inputStream == null) {
            return null;
        }
        return new InputStreamReader(inputStream);
    }

    public Clob getClob(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        return this.getLob(sQLParamController, structuredMem, structuredMem2);
    }

    public int getColumnDisplaySize() {
        switch (this.dataType) {
            case 34: 
            case 35: {
                return 0x40000000;
            }
        }
        return Integer.MAX_VALUE;
    }

    public GetvalLob getLob(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        GetvalLob getvalLob = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            byte[] byArray = structuredMem.getBytes(this.bufpos, this.logicalLength);
            getvalLob = new GetvalLob(sQLParamController.getConnectionSapDB(), byArray, structuredMem2, this.dataType);
        }
        return getvalLob;
    }

    public int getPrecision() {
        return Integer.MAX_VALUE;
    }

    public InputStream getStream(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        InputStream inputStream = null;
        Getval getval = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            byte[] byArray = structuredMem.getBytes(this.bufpos, this.logicalLength);
            getval = DriverSapDB.isJDBC20 ? new GetvalLob(sQLParamController.getConnectionSapDB(), byArray, structuredMem2, this.dataType) : new Getval(sQLParamController.getConnectionSapDB(), byArray, structuredMem2, this.dataType);
            inputStream = ((AbstractGetval)getval).getAsciiStream();
        }
        return inputStream;
    }

    public Timestamp getTimestamp(SQLParamController sQLParamController, StructuredMem structuredMem, Calendar calendar) throws SQLException {
        String string = this.getString(sQLParamController, structuredMem);
        if (string == null) {
            return null;
        }
        try {
            Timestamp timestamp = Timestamp.valueOf(string);
            if (calendar == null) {
                return timestamp;
            }
            calendar.setTime(timestamp);
            Timestamp timestamp2 = DBTechTranslator.CalendarUtil.getTimestampFromCalendar(calendar, timestamp.getNanos());
            return timestamp2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                Date date = Date.valueOf(string);
                if (calendar == null) {
                    return new Timestamp(date.getTime());
                }
                calendar.setTime(date);
                return DBTechTranslator.CalendarUtil.getTimestampFromCalendar(calendar, 0);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                throw this.newParseException(string, "Timestamp");
            }
        }
    }

    public String getString(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        Reader reader = this.getCharacterStream(sQLParamController, structuredMem, sQLParamController.getReplyData());
        if (reader == null) {
            return null;
        }
        try {
            int n;
            char[] cArray = new char[4096];
            while ((n = reader.read(cArray)) > 0) {
                stringBuffer.append(new String(cArray, 0, n));
                if (n >= 4096) {
                    continue;
                }
                break;
            }
        }
        catch (StreamIOException streamIOException) {
            throw streamIOException.getSqlException();
        }
        catch (IOException iOException) {
            throw new JDBCDriverException(iOException.getMessage(), sQLParamController);
        }
        return stringBuffer.toString();
    }

    public boolean isCaseSensitive() {
        return true;
    }

    protected void putSpecific(DataPart dataPart, Object object) {
        Putval putval = (Putval)object;
        putval.putDescriptor(dataPart, this.bufpos);
    }

    public Object transAsciiStreamForInput(InputStream inputStream, int n) throws SQLException {
        throw new ConversionExceptionSapDB(MessageTranslator.translate("error.asciiputtolong"));
    }

    public Object transBinaryStreamForInput(InputStream inputStream, int n) throws SQLException {
        throw new ConversionExceptionSapDB(MessageTranslator.translate("error.binaryputtolong"));
    }

    public Object transBytesForInput(byte[] byArray) throws SQLException {
        if (byArray == null) {
            return null;
        }
        return this.transBinaryStreamForInput(new ByteArrayInputStream(byArray), -1);
    }

    public Object transBlobForInput(Blob blob) throws SQLException {
        if (blob == null) {
            return null;
        }
        return new Putval(blob.getBinaryStream(), -1);
    }

    public Object transClobForInput(Clob clob) throws SQLException {
        if (clob == null) {
            return null;
        }
        return new Putval(clob.getAsciiStream(), -1);
    }

    public Object transSpecificForInput(Object object) throws SQLException {
        Object object2 = null;
        if (object instanceof InputStream) {
            object2 = this.transAsciiStreamForInput((InputStream)object, -1);
        }
        return object2;
    }

    public Object transStreamForInput(InputStream inputStream, int n) throws SQLException {
        if (inputStream == null) {
            return null;
        }
        return new Putval(inputStream, n);
    }

    public Object transStringForInput(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        return this.transAsciiStreamForInput(new ByteArrayInputStream(string.getBytes()), -1);
    }
}

