/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.encodings;

import java.io.UnsupportedEncodingException;
import org.firebirdsql.encodings.Encoding;

public abstract class Encoding_OneByte
implements Encoding {
    byte[] bufferB = new byte[128];
    char[] bufferC = new char[128];

    protected static void Initialize(String encoding, char[] byteToChar, byte[] charToByte) {
        byte[] val = new byte[1];
        char[] charArray = null;
        int i = 0;
        while (i < 256) {
            val[0] = (byte)i;
            try {
                charArray = new String(val, 0, 1, encoding).toCharArray();
                byteToChar[i] = charArray[0];
                charToByte[byteToChar[i]] = (byte)i;
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
            }
            ++i;
        }
    }

    public String decodeFromCharset(byte[] in) {
        if (this.bufferC.length < in.length) {
            this.bufferC = new char[in.length];
        }
        int length = this.decodeFromCharset(in, 0, in.length, this.bufferC);
        return new String(this.bufferC, 0, length);
    }

    public abstract int decodeFromCharset(byte[] var1, int var2, int var3, char[] var4);

    public int decodeFromCharset(char[] byteToChar, byte[] in, int off, int len, char[] out) {
        int i = off;
        while (i < off + len) {
            out[i] = byteToChar[in[i] & 0xFF];
            ++i;
        }
        return len;
    }

    public byte[] encodeToCharset(String str) {
        if (this.bufferB.length < str.length()) {
            this.bufferB = new byte[str.length()];
        }
        int length = this.encodeToCharset(str.toCharArray(), 0, str.length(), this.bufferB);
        byte[] result = new byte[length];
        System.arraycopy(this.bufferB, 0, result, 0, length);
        return result;
    }

    public int encodeToCharset(byte[] charToByte, char[] in, int off, int len, byte[] out) {
        int i = off;
        while (i < off + len) {
            out[i] = charToByte[in[i]];
            ++i;
        }
        return len;
    }

    public abstract int encodeToCharset(char[] var1, int var2, int var3, byte[] var4);
}

