/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jca;

import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.LocalTransaction;
import javax.transaction.xa.Xid;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.jca.FBManagedConnection;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class FBLocalTransaction
implements LocalTransaction,
javax.resource.cci.LocalTransaction {
    private static final Logger log = LoggerFactory.getLogger(class$org$firebirdsql$jca$FBLocalTransaction != null ? class$org$firebirdsql$jca$FBLocalTransaction : (class$org$firebirdsql$jca$FBLocalTransaction = FBLocalTransaction.class$("org.firebirdsql.jca.FBLocalTransaction")), false);
    private final FBManagedConnection mc;
    private Xid xid = null;
    private final ConnectionEvent beginEvent;
    private final ConnectionEvent commitEvent;
    private final ConnectionEvent rollbackEvent;
    static /* synthetic */ Class class$org$firebirdsql$jca$FBLocalTransaction;

    public FBLocalTransaction(FBManagedConnection mc, FBConnection c) {
        this.mc = mc;
        if (c == null) {
            this.beginEvent = null;
            this.commitEvent = null;
            this.rollbackEvent = null;
        } else {
            this.beginEvent = new ConnectionEvent(mc, 2, null);
            this.beginEvent.setConnectionHandle(c);
            this.commitEvent = new ConnectionEvent(mc, 3, null);
            this.commitEvent.setConnectionHandle(c);
            this.rollbackEvent = new ConnectionEvent(mc, 4, null);
            this.rollbackEvent.setConnectionHandle(c);
        }
    }

    public void begin() throws ResourceException {
        try {
            this.internalBegin();
        }
        catch (GDSException ge) {
            throw new FBResourceException(ge);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void commit() throws ResourceException {
        try {
            this.internalCommit();
        }
        catch (GDSException ge) {
            throw new FBResourceException("Problem committing local tx: " + ge.getMessage(), ge);
        }
    }

    public void internalBegin() throws GDSException {
        if (this.xid != null) {
            throw new GDSException("local transaction active: can't begin another");
        }
        this.xid = new FBLocalXid();
        FBManagedConnection fBManagedConnection = this.mc;
        synchronized (fBManagedConnection) {
            this.mc.internalStart(this.xid, 0);
            if (this.beginEvent != null) {
                this.mc.notify(FBManagedConnection.localTransactionStartedNotifier, this.beginEvent);
            }
        }
    }

    public void internalCommit() throws GDSException {
        if (this.xid == null) {
            throw new GDSException("no local transaction active: can't commit");
        }
        FBManagedConnection fBManagedConnection = this.mc;
        synchronized (fBManagedConnection) {
            try {
                this.mc.internalEnd(this.xid, 0x4000000);
                this.mc.internalCommit(this.xid, true);
            }
            finally {
                Object var4_2 = null;
                this.xid = null;
            }
            if (this.commitEvent != null) {
                this.mc.notify(FBManagedConnection.localTransactionCommittedNotifier, this.commitEvent);
            }
        }
    }

    public void internalRollback() throws GDSException {
        if (this.xid == null) {
            throw new GDSException("no local transaction active: can't rollback");
        }
        FBManagedConnection fBManagedConnection = this.mc;
        synchronized (fBManagedConnection) {
            try {
                this.mc.internalEnd(this.xid, 0x4000000);
                this.mc.internalRollback(this.xid);
            }
            finally {
                Object var4_2 = null;
                this.xid = null;
            }
            if (this.rollbackEvent != null) {
                this.mc.notify(FBManagedConnection.localTransactionRolledbackNotifier, this.rollbackEvent);
            }
        }
    }

    public void rollback() throws ResourceException {
        try {
            this.internalRollback();
        }
        catch (GDSException ge) {
            throw new FBResourceException("Problem rolling back local tx: " + ge.getMessage(), ge);
        }
    }

    static class FBLocalXid
    implements Xid {
        private static final int formatId = 258;

        public byte[] getBranchQualifier() {
            return null;
        }

        public int getFormatId() {
            return 258;
        }

        public byte[] getGlobalTransactionId() {
            return null;
        }
    }
}

