/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBPreparedStatement;
import org.firebirdsql.jdbc.FBResultSet;

public class FBCallableStatement
extends FBPreparedStatement
implements CallableStatement {
    static final String NATIVE_CALL_COMMAND = "EXECUTE PROCEDURE";
    private ResultSet currentRs;

    FBCallableStatement(FBConnection c, String sql) throws SQLException {
        super(c, sql);
    }

    protected void assertHasData(ResultSet rs) throws SQLException {
        if (rs.getRow() != 0) {
            return;
        }
        rs.next();
        if (rs.getRow() == 0) {
            throw new SQLException("Current statement has not data to return.");
        }
    }

    public boolean execute() throws SQLException {
        boolean bl;
        try {
            this.currentRs = null;
            this.c.ensureInTransaction();
            boolean hasResultSet = this.internalExecute(true);
            if (hasResultSet && this.c.willEndTransaction()) {
                this.getCachedResultSet(false);
            }
            bl = hasResultSet;
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.c.checkEndTransaction();
            throw throwable;
        }
        this.c.checkEndTransaction();
        return bl;
    }

    public Array getArray(int i) throws SQLException {
        ResultSet rs = this.getCurrentResultSet();
        this.assertHasData(rs);
        return rs.getArray(i);
    }

    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.getCurrentResultSet().findColumn(colName));
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        ResultSet rs = this.getCurrentResultSet();
        this.assertHasData(rs);
        return rs.getBigDecimal(parameterIndex);
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        throw new UnsupportedOperationException("This method has been deprecated.");
    }

    public BigDecimal getBigDecimal(String colName) throws SQLException {
        return this.getBigDecimal(this.getCurrentResultSet().findColumn(colName));
    }

    public Blob getBlob(int i) throws SQLException {
        ResultSet rs = this.getCurrentResultSet();
        this.assertHasData(rs);
        return rs.getBlob(i);
    }

    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.getCurrentResultSet().findColumn(colName));
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        ResultSet rs = this.getCurrentResultSet();
        this.assertHasData(rs);
        return rs.getBoolean(parameterIndex);
    }

    public boolean getBoolean(String colName) throws SQLException {
        return this.getBoolean(this.getCurrentResultSet().findColumn(colName));
    }

    public byte getByte(int parameterIndex) throws SQLException {
        ResultSet rs = this.getCurrentResultSet();
        this.assertHasData(rs);
        return rs.getByte(parameterIndex);
    }

    public byte getByte(String colName) throws SQLException {
        return this.getByte(this.getCurrentResultSet().findColumn(colName));
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        ResultSet rs = this.getCurrentResultSet();
        this.assertHasData(rs);
        return rs.getBytes(parameterIndex);
    }

    public byte[] getBytes(String colName) throws SQLException {
        return this.getBytes(this.getCurrentResultSet().findColumn(colName));
    }

    public Clob getClob(int i) throws SQLException {
        ResultSet rs = this.getCurrentResultSet();
        this.assertHasData(rs);
        return rs.getClob(i);
    }

    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.getCurrentResultSet().findColumn(colName));
    }

    private ResultSet getCurrentResultSet() throws SQLException {
        if (this.currentRs == null) {
            this.currentRs = this.getResultSet();
        }
        return this.currentRs;
    }

    public Date getDate(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        return this.getCurrentResultSet().getDate(parameterIndex);
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        return this.getCurrentResultSet().getDate(parameterIndex, cal);
    }

    public Date getDate(String colName) throws SQLException {
        return this.getDate(this.getCurrentResultSet().findColumn(colName));
    }

    public Date getDate(String colName, Calendar cal) throws SQLException {
        return this.getDate(this.getCurrentResultSet().findColumn(colName), cal);
    }

    public double getDouble(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        return this.getCurrentResultSet().getDouble(parameterIndex);
    }

    public double getDouble(String colName) throws SQLException {
        return this.getDouble(this.getCurrentResultSet().findColumn(colName));
    }

    public float getFloat(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        return this.getCurrentResultSet().getFloat(parameterIndex);
    }

    public float getFloat(String colName) throws SQLException {
        return this.getFloat(this.getCurrentResultSet().findColumn(colName));
    }

    public int getInt(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        return this.getCurrentResultSet().getInt(parameterIndex);
    }

    public int getInt(String colName) throws SQLException {
        return this.getInt(this.getCurrentResultSet().findColumn(colName));
    }

    public long getLong(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        return this.getCurrentResultSet().getInt(parameterIndex);
    }

    public long getLong(String colName) throws SQLException {
        return this.getLong(this.getCurrentResultSet().findColumn(colName));
    }

    public Object getObject(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        return this.getCurrentResultSet().getObject(parameterIndex);
    }

    public Object getObject(int i, Map map) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        return this.getCurrentResultSet().getObject(i, map);
    }

    public Object getObject(String colName) throws SQLException {
        return this.getObject(this.getCurrentResultSet().findColumn(colName));
    }

    public Object getObject(String colName, Map map) throws SQLException {
        return this.getObject(this.getCurrentResultSet().findColumn(colName), map);
    }

    public Ref getRef(int i) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        return this.getCurrentResultSet().getRef(i);
    }

    public Ref getRef(String colName) throws SQLException {
        return this.getRef(this.getCurrentResultSet().findColumn(colName));
    }

    public short getShort(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        return this.getCurrentResultSet().getShort(parameterIndex);
    }

    public short getShort(String colName) throws SQLException {
        return this.getShort(this.getCurrentResultSet().findColumn(colName));
    }

    public String getString(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        return this.getCurrentResultSet().getString(parameterIndex);
    }

    public String getString(String colName) throws SQLException {
        return this.getString(this.getCurrentResultSet().findColumn(colName));
    }

    public Time getTime(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        return this.getCurrentResultSet().getTime(parameterIndex);
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        return this.getCurrentResultSet().getTime(parameterIndex, cal);
    }

    public Time getTime(String colName) throws SQLException {
        return this.getTime(this.getCurrentResultSet().findColumn(colName));
    }

    public Time getTime(String colName, Calendar cal) throws SQLException {
        return this.getTime(this.getCurrentResultSet().findColumn(colName), cal);
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        return this.getCurrentResultSet().getTimestamp(parameterIndex);
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        return this.getCurrentResultSet().getTimestamp(parameterIndex, cal);
    }

    public Timestamp getTimestamp(String colName) throws SQLException {
        return this.getTimestamp(this.getCurrentResultSet().findColumn(colName));
    }

    public Timestamp getTimestamp(String colName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.getCurrentResultSet().findColumn(colName), cal);
    }

    public URL getURL(int colIndex) throws SQLException {
        this.assertHasData(this.getCurrentResultSet());
        return ((FBResultSet)this.getCurrentResultSet()).getURL(colIndex);
    }

    public URL getURL(String colName) throws SQLException {
        return this.getURL(this.getCurrentResultSet().findColumn(colName));
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        throw new SQLException("Not yet implemented");
    }

    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
    }

    public void registerOutParameter(String param1, int param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void registerOutParameter(String param1, int param2, int param3) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void registerOutParameter(String param1, int param2, String param3) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setAsciiStream(String param1, InputStream param2, int param3) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setBigDecimal(String param1, BigDecimal param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setBinaryStream(String param1, InputStream param2, int param3) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setBoolean(String param1, boolean param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setByte(String param1, byte param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setBytes(String param1, byte[] param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setCharacterStream(String param1, Reader param2, int param3) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setDate(String param1, Date param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setDate(String param1, Date param2, Calendar param3) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setDouble(String param1, double param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setFloat(String param1, float param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setInt(String param1, int param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setLong(String param1, long param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setNull(String param1, int param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setNull(String param1, int param2, String param3) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setObject(String param1, Object param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setObject(String param1, Object param2, int param3) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setObject(String param1, Object param2, int param3, int param4) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setShort(String param1, short param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setString(String param1, String param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setTime(String param1, Time param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setTime(String param1, Time param2, Calendar param3) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setTimestamp(String param1, Timestamp param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setTimestamp(String param1, Timestamp param2, Calendar param3) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public void setURL(String param1, URL param2) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public boolean wasNull() throws SQLException {
        throw new SQLException("Not yet implemented");
    }
}

