/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.FBField;
import org.firebirdsql.jdbc.FBResultSet;

class FBFloatField
extends FBField {
    FBFloatField(XSQLVAR field, FBResultSet rs, int numCol) throws SQLException {
        super(field, rs, numCol);
    }

    BigDecimal getBigDecimal() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return new BigDecimal(XSQLVAR.decodeFloat(this.rs.row[this.numCol]));
    }

    boolean getBoolean() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return false;
        }
        return XSQLVAR.decodeFloat(this.rs.row[this.numCol]) == 1.0f;
    }

    byte getByte() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        Float value = new Float(XSQLVAR.decodeFloat(this.rs.row[this.numCol]));
        if (value.floatValue() > 127.0f || value.floatValue() < -128.0f) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.BYTE_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        return value.byteValue();
    }

    double getDouble() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0.0;
        }
        return XSQLVAR.decodeFloat(this.rs.row[this.numCol]);
    }

    float getFloat() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0.0f;
        }
        return XSQLVAR.decodeFloat(this.rs.row[this.numCol]);
    }

    int getInt() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        Float value = new Float(XSQLVAR.decodeFloat(this.rs.row[this.numCol]));
        if (value.floatValue() > 2.1474836E9f || value.floatValue() < -2.1474836E9f) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.INT_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        return value.intValue();
    }

    long getLong() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0L;
        }
        Float value = new Float(XSQLVAR.decodeFloat(this.rs.row[this.numCol]));
        if (value.floatValue() > 9.223372E18f || value.floatValue() < -9.223372E18f) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.LONG_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        return value.longValue();
    }

    Object getObject() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return new Float(XSQLVAR.decodeFloat(this.rs.row[this.numCol]));
    }

    short getShort() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return 0;
        }
        Float value = new Float(XSQLVAR.decodeFloat(this.rs.row[this.numCol]));
        if (value.floatValue() > 32767.0f || value.floatValue() < -32768.0f) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.SHORT_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        return value.shortValue();
    }

    String getString() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        return String.valueOf(XSQLVAR.decodeFloat(this.rs.row[this.numCol]));
    }

    void setBigDecimal(BigDecimal value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        if (value.compareTo(new BigDecimal(3.4028234663852886E38)) > 0 || value.compareTo(new BigDecimal(-3.4028234663852886E38)) < 0) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.BIGDECIMAL_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        this.setFloat(value.floatValue());
    }

    void setBoolean(boolean value) throws SQLException {
        this.setFloat(value ? 1.0f : 0.0f);
    }

    void setByte(byte value) throws SQLException {
        this.setFloat(value);
    }

    void setDouble(double value) throws SQLException {
        if (value > 3.4028234663852886E38 || value < -3.4028234663852886E38) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.DOUBLE_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        this.setFloat((float)value);
    }

    void setFloat(float value) throws SQLException {
        this.field.sqldata = XSQLVAR.encodeFloat(value);
    }

    void setInteger(int value) throws SQLException {
        this.setFloat(value);
    }

    void setLong(long value) throws SQLException {
        if ((float)value > Float.MAX_VALUE || (float)value < -3.4028235E38f) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.LONG_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
        this.setFloat(value);
    }

    void setShort(short value) throws SQLException {
        this.setFloat(value);
    }

    void setString(String value) throws SQLException {
        if (value == null) {
            this.field.sqldata = null;
            return;
        }
        try {
            this.setFloat(Float.parseFloat(value));
        }
        catch (NumberFormatException numberFormatException) {
            throw (SQLException)FBField.createException(String.valueOf(FBField.FLOAT_CONVERSION_ERROR) + " " + value).fillInStackTrace();
        }
    }
}

