/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jgds;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.firebirdsql.jgds.isc_stmt_handle_impl;

public final class XdrInputStream {
    private static final byte[] pad = new byte[8];
    private InputStream in = null;
    private static int defaultBufferSize = 16384;
    private byte[] buf = new byte[defaultBufferSize];
    private int count;
    private int pos;

    public XdrInputStream(InputStream in) {
        this.in = in;
    }

    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
        this.in = null;
        this.buf = null;
    }

    public int read() throws IOException {
        if (this.pos >= this.count) {
            this.count = 0;
            this.pos = 0;
            int readn = this.in.read(this.buf, 0, defaultBufferSize);
            if (readn > 0) {
                this.count = readn;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public byte[] readBuffer() throws IOException {
        int len = this.readInt();
        byte[] buffer = new byte[len];
        this.readFully(buffer, 0, len);
        this.readFully(pad, 0, 4 - len & 3);
        return buffer;
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        if (len <= this.count - this.pos) {
            System.arraycopy(this.buf, this.pos, b, off, len);
            this.pos += len;
        } else {
            int n = 0;
            while (n < len) {
                int lenN;
                int avail;
                if (this.count <= this.pos) {
                    this.count = 0;
                    this.pos = 0;
                    int readn = this.in.read(this.buf, 0, defaultBufferSize);
                    if (readn > 0) {
                        this.count = readn;
                    } else {
                        throw new EOFException();
                    }
                }
                int cnt = (avail = this.count - this.pos) < (lenN = len - n) ? avail : lenN;
                System.arraycopy(this.buf, this.pos, b, off + n, cnt);
                this.pos += cnt;
                n += cnt;
            }
        }
    }

    public int readInt() throws IOException {
        return this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
    }

    public final long readLong() throws IOException {
        return this.read() << 56 | this.read() << 48 | this.read() << 40 | this.read() << 32 | this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
    }

    public void readSQLData(int[] ioLength, isc_stmt_handle_impl stmt) throws IOException {
        int numCols = ioLength.length;
        byte[][] row = new byte[numCols][];
        int i = 0;
        while (i < numCols) {
            byte[] buffer;
            int len = ioLength[i];
            if (len == 0) {
                len = this.readInt();
                buffer = new byte[len];
                this.readFully(buffer, 0, len);
                this.readFully(pad, 0, 4 - len & 3);
            } else if (len < 0) {
                buffer = new byte[-len];
                this.readFully(buffer, 0, -len);
            } else {
                buffer = new byte[--len];
                this.readFully(buffer, 0, len);
                this.readFully(pad, 0, 4 - len & 3);
            }
            if (this.readInt() == -1) {
                buffer = null;
            }
            row[i] = buffer;
            ++i;
        }
        if (stmt != null) {
            stmt.addRow(row);
        }
    }

    public String readString() throws IOException {
        int len = this.readInt();
        byte[] buffer = new byte[len];
        this.readFully(buffer, 0, len);
        this.readFully(pad, 0, 4 - len & 3);
        return new String(buffer);
    }
}

