/*
 * Decompiled with CFR 0.152.
 */
package ymsg.support;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import ymsg.network.Session;
import ymsg.network.YahooChatLobby;
import ymsg.network.YahooChatUser;
import ymsg.network.YahooConference;
import ymsg.network.YahooGroup;
import ymsg.network.YahooUser;
import ymsg.network.event.SessionAdapter;
import ymsg.network.event.SessionChatEvent;
import ymsg.network.event.SessionConferenceEvent;
import ymsg.network.event.SessionEvent;
import ymsg.network.event.SessionFriendEvent;

public class SwingModelFactory
extends SessionAdapter {
    private Session session;
    private Hashtable models;
    private ReferenceQueue queue;
    private QueueHandler queueHandler;
    private ThreadGroup factoryThreads;
    private static UserComparator userComparator;
    private static GroupComparator groupComparator;
    private static DummyListModel dummyListModel;
    private static String ROOT;

    public SwingModelFactory(Session session) {
        this.session = session;
        this.session.addSessionListener(this);
        this.models = new Hashtable();
        this.factoryThreads = new ThreadGroup("Swing Model Threads");
        this.queue = new ReferenceQueue();
        this.queueHandler = new QueueHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.session.removeSessionListener(this);
            this.queueHandler.quit();
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    public void chatLogonReceived(SessionChatEvent sessionChatEvent) {
        UserListModel userListModel = (UserListModel)this.getReference(sessionChatEvent.getLobby());
        YahooChatUser[] yahooChatUserArray = sessionChatEvent.getChatUsers();
        if (userListModel != null) {
            for (int i = 0; i < yahooChatUserArray.length; ++i) {
                userListModel.addUser(yahooChatUserArray[i]);
            }
        }
    }

    public void chatLogoffReceived(SessionChatEvent sessionChatEvent) {
        UserListModel userListModel = (UserListModel)this.getReference(sessionChatEvent.getLobby());
        YahooChatUser yahooChatUser = sessionChatEvent.getChatUser();
        if (userListModel != null) {
            userListModel.removeUser(yahooChatUser);
        }
    }

    public void chatUserUpdateReceived(SessionChatEvent sessionChatEvent) {
        UserListModel userListModel = (UserListModel)this.getReference(sessionChatEvent.getLobby());
        YahooChatUser yahooChatUser = sessionChatEvent.getChatUser();
        if (userListModel != null) {
            userListModel.updateUser(yahooChatUser);
        }
    }

    public void conferenceInviteReceived(SessionConferenceEvent sessionConferenceEvent) {
        UserListModel userListModel = (UserListModel)this.getReference(sessionConferenceEvent.getRoom());
        YahooUser[] yahooUserArray = sessionConferenceEvent.getUsers();
        if (userListModel != null) {
            for (int i = 0; i < yahooUserArray.length; ++i) {
                userListModel.addUser(yahooUserArray[i]);
            }
        }
    }

    public void conferenceLogonReceived(SessionConferenceEvent sessionConferenceEvent) {
        UserListModel userListModel = (UserListModel)this.getReference(sessionConferenceEvent.getRoom());
        YahooUser yahooUser = sessionConferenceEvent.getUser();
        if (userListModel != null) {
            userListModel.removeUser(yahooUser);
        }
    }

    public void conferenceLogoffReceived(SessionConferenceEvent sessionConferenceEvent) {
        UserListModel userListModel = (UserListModel)this.getReference(sessionConferenceEvent.getRoom());
        YahooUser[] yahooUserArray = sessionConferenceEvent.getUsers();
        if (userListModel != null) {
            userListModel.removeUser(yahooUserArray);
        }
    }

    public void listReceived(SessionEvent sessionEvent) {
        UserTreeModel userTreeModel = (UserTreeModel)this.getReference(ROOT);
        if (userTreeModel != null) {
            userTreeModel.updateAll();
        }
    }

    public void friendsUpdateReceived(SessionFriendEvent sessionFriendEvent) {
        UserTreeModel userTreeModel = (UserTreeModel)this.getReference(ROOT);
        if (userTreeModel != null) {
            userTreeModel.updateUser(sessionFriendEvent.getFriend(), sessionFriendEvent.getGroup());
        }
    }

    public void friendAddedReceived(SessionFriendEvent sessionFriendEvent) {
        UserTreeModel userTreeModel = (UserTreeModel)this.getReference(ROOT);
        if (userTreeModel != null) {
            userTreeModel.addUser(sessionFriendEvent.getFriend(), sessionFriendEvent.getGroup());
        }
    }

    public void friendRemovedReceived(SessionFriendEvent sessionFriendEvent) {
        UserTreeModel userTreeModel = (UserTreeModel)this.getReference(ROOT);
        if (userTreeModel != null) {
            userTreeModel.removeUser(sessionFriendEvent.getFriend(), sessionFriendEvent.getGroup());
        }
    }

    private Object getReference(Object object) {
        Reference reference = (Reference)this.models.get(object);
        if (reference != null) {
            return reference.get();
        }
        return null;
    }

    private void addModel(Object object, Object object2) {
        this.models.put(object, new WeakReference<Object>(object2, this.queue));
    }

    public ListModel createListModel(YahooChatLobby yahooChatLobby, boolean bl) {
        UserListModel userListModel = new UserListModel(yahooChatLobby.getMembers(), bl);
        this.addModel(yahooChatLobby, userListModel);
        return userListModel;
    }

    public ListModel createListModel(YahooConference yahooConference, boolean bl) {
        UserListModel userListModel = new UserListModel(yahooConference.getMembers(), bl);
        this.addModel(yahooConference, userListModel);
        return userListModel;
    }

    public TreeModel createTreeModel(boolean bl) {
        YahooGroup[] yahooGroupArray = this.session.getGroups();
        UserTreeModel userTreeModel = new UserTreeModel(yahooGroupArray, bl);
        this.addModel(ROOT, userTreeModel);
        return userTreeModel;
    }

    public static ListModel getEmptyListModel() {
        return dummyListModel;
    }

    static {
        ROOT = "Groups";
        userComparator = new UserComparator();
        groupComparator = new GroupComparator();
        dummyListModel = new DummyListModel();
    }

    class QueueHandler
    extends Thread {
        private boolean quitFlag;

        QueueHandler() {
            super(SwingModelFactory.this.factoryThreads, "Weak Ref. Queue");
            this.quitFlag = false;
            this.setPriority(1);
            this.start();
        }

        public void run() {
            try {
                Reference reference = SwingModelFactory.this.queue.remove();
                while (!this.quitFlag && reference != null) {
                    Enumeration enumeration = SwingModelFactory.this.models.keys();
                    while (enumeration.hasMoreElements()) {
                        Object k = enumeration.nextElement();
                        if (SwingModelFactory.this.models.get(k) != reference) continue;
                        SwingModelFactory.this.models.remove(k);
                    }
                    reference = SwingModelFactory.this.queue.remove();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void quit() {
            this.quitFlag = true;
            this.interrupt();
        }
    }

    static class GroupComparator
    implements Comparator {
        GroupComparator() {
        }

        public int compare(Object object, Object object2) throws ClassCastException {
            String string = ((String)object).toLowerCase();
            String string2 = ((String)object2).toLowerCase();
            return string.compareTo(string2);
        }
    }

    static class UserComparator
    implements Comparator {
        UserComparator() {
        }

        public int compare(Object object, Object object2) throws ClassCastException {
            String string;
            String string2;
            if (object instanceof YahooUser) {
                string2 = ((YahooUser)object).getId();
            } else if (object instanceof YahooChatUser) {
                string2 = ((YahooChatUser)object).getId();
            } else {
                throw new ClassCastException("Incompatable types");
            }
            if (object2 instanceof YahooUser) {
                string = ((YahooUser)object2).getId();
            } else if (object2 instanceof YahooChatUser) {
                string = ((YahooChatUser)object2).getId();
            } else {
                throw new ClassCastException("Incompatable types");
            }
            string2 = string2.toLowerCase();
            string = string.toLowerCase();
            return string2.compareTo(string);
        }

        public boolean equals(Object object) {
            return object == this;
        }
    }

    static class DummyListModel
    implements ListModel {
        DummyListModel() {
        }

        public void addListDataListener(ListDataListener listDataListener) {
        }

        public void removeListDataListener(ListDataListener listDataListener) {
        }

        public int getSize() {
            return 0;
        }

        public Object getElementAt(int n) {
            return null;
        }
    }

    class UserTreeModel
    extends AbstractUserModel
    implements TreeModel {
        Hashtable groups;
        Vector groupOrder;

        UserTreeModel(YahooGroup[] yahooGroupArray, boolean bl) {
            super(bl);
            this.groups = new Hashtable();
            this.groupOrder = new Vector();
            for (int i = 0; i < yahooGroupArray.length; ++i) {
                Vector vector = yahooGroupArray[i].getMembers();
                if (this.sort) {
                    Collections.sort(vector, userComparator);
                }
                this.groups.put(yahooGroupArray[i].getName(), vector);
                this.groupOrder.addElement(yahooGroupArray[i].getName());
            }
            if (this.sort) {
                Collections.sort(this.groupOrder, groupComparator);
            }
        }

        void addUser(YahooUser yahooUser, String string) {
            Object[] objectArray;
            int[] nArray;
            Object[] objectArray2;
            Vector<YahooUser> vector = (Vector<YahooUser>)this.groups.get(string);
            if (vector == null) {
                vector = new Vector<YahooUser>();
                vector.addElement(yahooUser);
                this.groups.put(string, vector);
                this.groupOrder.addElement(string);
                Collections.sort(this.groupOrder, groupComparator);
                objectArray2 = new Object[]{ROOT};
                nArray = new int[]{this.groupOrder.indexOf(string)};
                objectArray = new Object[]{string};
            } else {
                vector.addElement(yahooUser);
                Collections.sort(vector, userComparator);
                objectArray2 = new Object[]{ROOT, string};
                nArray = new int[]{vector.indexOf(yahooUser)};
                objectArray = new Object[]{string};
            }
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, objectArray2, nArray, objectArray);
            new AbstractUserModel.FireEvent(treeModelEvent, 1);
        }

        void removeUser(YahooUser yahooUser, String string) {
            Object[] objectArray;
            int[] nArray;
            Object[] objectArray2;
            Vector vector = (Vector)this.groups.get(string);
            if (vector.size() <= 1) {
                objectArray2 = new Object[]{ROOT};
                nArray = new int[]{this.groupOrder.indexOf(string)};
                objectArray = new Object[]{string};
                this.groups.remove(string);
                this.groupOrder.removeElement(string);
            } else {
                objectArray2 = new Object[]{ROOT, string};
                nArray = new int[]{vector.indexOf(yahooUser)};
                objectArray = new Object[]{yahooUser};
                vector.removeElement(yahooUser);
            }
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, objectArray2, nArray, objectArray);
            new AbstractUserModel.FireEvent(treeModelEvent, 2);
        }

        void updateUser(YahooUser yahooUser, String string) {
            for (int i = 0; i < this.groupOrder.size(); ++i) {
                Vector vector = (Vector)this.groups.get(this.groupOrder.elementAt(i));
                int n = vector.indexOf(yahooUser);
                if (n < 0) continue;
                Object[] objectArray = new Object[]{ROOT, this.groupOrder.elementAt(i)};
                int[] nArray = new int[]{n};
                Object[] objectArray2 = new Object[]{yahooUser};
                TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, objectArray, nArray, objectArray2);
                new AbstractUserModel.FireEvent(treeModelEvent, 3);
            }
        }

        void updateAll() {
            Object[] objectArray = new Object[]{ROOT};
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, objectArray);
            new AbstractUserModel.FireEvent(treeModelEvent, 4);
        }

        void fireEvent(Object object, EventObject eventObject, int n) {
            TreeModelListener treeModelListener = (TreeModelListener)object;
            TreeModelEvent treeModelEvent = (TreeModelEvent)eventObject;
            switch (n) {
                case 1: {
                    treeModelListener.treeNodesInserted(treeModelEvent);
                    break;
                }
                case 2: {
                    treeModelListener.treeNodesRemoved(treeModelEvent);
                    break;
                }
                case 3: {
                    treeModelListener.treeNodesChanged(treeModelEvent);
                    break;
                }
                case 4: {
                    treeModelListener.treeStructureChanged(treeModelEvent);
                    break;
                }
                default: {
                    return;
                }
            }
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.addListener(treeModelListener);
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.removeListener(treeModelListener);
        }

        public Object getChild(Object object, int n) {
            if (object == ROOT) {
                return this.groupOrder.elementAt(n);
            }
            if (object instanceof String) {
                return this._get(object).elementAt(n);
            }
            return null;
        }

        public int getChildCount(Object object) {
            if (object == ROOT) {
                return this.groupOrder.size();
            }
            if (object instanceof String) {
                return this._get(object).size();
            }
            return -1;
        }

        public int getIndexOfChild(Object object, Object object2) {
            if (object == ROOT) {
                return this.groupOrder.indexOf(object2);
            }
            if (object instanceof String) {
                return this._get(object).indexOf(object2);
            }
            return -1;
        }

        public Object getRoot() {
            return ROOT;
        }

        public boolean isLeaf(Object object) {
            return object instanceof YahooUser;
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        private Vector _get(Object object) {
            return (Vector)this.groups.get(object);
        }
    }

    class UserListModel
    extends AbstractUserModel
    implements ListModel {
        private Vector members;

        UserListModel(Vector vector, boolean bl) {
            super(bl);
            this.members = vector;
            if (this.sort) {
                Collections.sort(this.members, userComparator);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addUser(Object object) {
            Vector vector = this.members;
            synchronized (vector) {
                int n = -1;
                this.members.addElement(object);
                if (this.sort) {
                    Collections.sort(this.members, userComparator);
                    n = this.members.indexOf(object);
                } else {
                    n = this.members.size() - 1;
                }
                ListDataEvent listDataEvent = new ListDataEvent(this, 1, n, n);
                new AbstractUserModel.FireEvent(listDataEvent, 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeUser(Object object) {
            Vector vector = this.members;
            synchronized (vector) {
                int n = this.members.indexOf(object);
                if (n > -1) {
                    this.members.removeElementAt(n);
                    ListDataEvent listDataEvent = new ListDataEvent(this, 2, n, n);
                    new AbstractUserModel.FireEvent(listDataEvent, 2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateUser(Object object) {
            Vector vector = this.members;
            synchronized (vector) {
                int n = this.members.indexOf(object);
                if (n > -1) {
                    ListDataEvent listDataEvent = new ListDataEvent(this, 0, n, n);
                    new AbstractUserModel.FireEvent(listDataEvent, 3);
                }
            }
        }

        void fireEvent(Object object, EventObject eventObject, int n) {
            ListDataListener listDataListener = (ListDataListener)object;
            ListDataEvent listDataEvent = (ListDataEvent)eventObject;
            switch (n) {
                case 1: {
                    listDataListener.intervalAdded(listDataEvent);
                    break;
                }
                case 2: {
                    listDataListener.intervalRemoved(listDataEvent);
                    break;
                }
                case 3: {
                    listDataListener.contentsChanged(listDataEvent);
                    break;
                }
                default: {
                    return;
                }
            }
        }

        public void addListDataListener(ListDataListener listDataListener) {
            this.addListener(listDataListener);
        }

        public void removeListDataListener(ListDataListener listDataListener) {
            this.removeListener(listDataListener);
        }

        public int getSize() {
            return this.members.size();
        }

        public Object getElementAt(int n) {
            return this.members.elementAt(n);
        }
    }

    abstract class AbstractUserModel {
        Vector listeners = new Vector();
        boolean sort;

        AbstractUserModel(boolean bl) {
            this.sort = bl;
        }

        void addListener(Object object) {
            if (!this.listeners.contains(object)) {
                this.listeners.addElement(object);
            }
        }

        void removeListener(Object object) {
            this.listeners.removeElement(object);
        }

        abstract void fireEvent(Object var1, EventObject var2, int var3);

        class FireEvent
        extends Thread {
            EventObject ev;
            int mode;

            FireEvent(EventObject eventObject, int n) {
                super(SwingModelFactory.this.factoryThreads, "Event Fired");
                this.mode = -1;
                this.ev = eventObject;
                this.mode = n;
                this.start();
            }

            public void run() {
                for (int i = 0; i < AbstractUserModel.this.listeners.size(); ++i) {
                    AbstractUserModel.this.fireEvent(AbstractUserModel.this.listeners.elementAt(i), this.ev, this.mode);
                }
            }
        }
    }
}

