/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.LuceneSettings;

public class LuceneSegmentsMerger {
    private static final Log log = LogFactory.getLog((Class)LuceneSegmentsMerger.class);
    private Directory directory;
    private SegmentInfos segmentInfos = new SegmentInfos();
    private Lock writeLock;
    private String newSegmentName;
    private Vector segmentsToDelete = new Vector();
    private boolean closeDir;
    private LuceneSettings luceneSettings;
    private SegmentInfos rollbackSegmentInfos;
    private IndexFileDeleter deleter;

    public LuceneSegmentsMerger(Directory dir, boolean closeDir, LuceneSearchEngineFactory searchEngineFactory) throws IOException {
        this.closeDir = closeDir;
        this.directory = dir;
        this.luceneSettings = searchEngineFactory.getLuceneSettings();
        Lock writeLock = this.directory.makeLock("write.lock");
        if (!writeLock.obtain(this.luceneSettings.getTransactionLockTimout())) {
            throw new IOException("Lock obtain failed: " + writeLock);
        }
        this.writeLock = writeLock;
        this.segmentInfos.read(this.directory);
        this.rollbackSegmentInfos = (SegmentInfos)this.segmentInfos.clone();
        this.deleter = new IndexFileDeleter(this.directory, searchEngineFactory.getIndexDeletionPolicyManager().createIndexDeletionPolicy(dir), this.segmentInfos, null);
    }

    public void mergeFromSegment(int fromSegment) throws IOException {
        this.newSegmentName = this.newSegmentName();
        SegmentMerger merger = new SegmentMerger(this.directory, this.newSegmentName);
        for (int i = fromSegment; i < this.segmentInfos.size(); ++i) {
            SegmentInfo si = this.segmentInfos.info(i);
            SegmentReader reader = SegmentReader.get((SegmentInfo)si, (int)4096);
            merger.add((IndexReader)reader);
            this.segmentsToDelete.addElement(reader);
        }
        int mergedDocCount = merger.merge();
        merger.closeReaders();
        this.segmentInfos.setSize(fromSegment);
        SegmentInfo newSegmentInfo = new SegmentInfo(this.newSegmentName, mergedDocCount, this.directory, false, true);
        this.segmentInfos.addElement((Object)newSegmentInfo);
        this.deleter.checkpoint(this.segmentInfos, false);
        if (this.luceneSettings.isUseCompoundFile()) {
            newSegmentInfo.setUseCompoundFile(true);
            merger.createCompoundFile(this.newSegmentName + ".cfs");
            this.deleter.checkpoint(this.segmentInfos, false);
        }
    }

    public void commit() throws IOException {
        this.segmentInfos.write(this.directory);
        this.deleter.checkpoint(this.segmentInfos, true);
    }

    public void rollback() throws IOException {
        this.segmentInfos.clear();
        this.segmentInfos.addAll((Collection)this.rollbackSegmentInfos);
        this.rollbackSegmentInfos = null;
        this.deleter.checkpoint(this.segmentInfos, false);
        this.deleter.refresh();
    }

    public void close() throws IOException {
        if (this.closeDir) {
            try {
                this.directory.close();
            }
            catch (IOException ex) {
                log.warn((Object)"Failed to close directory, ignoring", (Throwable)ex);
            }
            this.directory = null;
        }
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
    }

    private final synchronized String newSegmentName() {
        return "_" + Integer.toString(this.segmentInfos.counter++, 36);
    }

    protected void finalize() throws IOException {
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
    }
}

