/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.compass.core.CompassSession;
import org.compass.core.CompassTransaction;
import org.compass.core.lucene.engine.LuceneSearchEngine;
import org.compass.core.lucene.engine.manager.LuceneSearchEngineIndexManager;
import org.compass.core.spi.InternalCompassSession;

public class LuceneSubIndexInfo {
    private ArrayList segmentInfos;
    private long version;
    private String subIndex;

    protected LuceneSubIndexInfo(String subIndex, long version, ArrayList segmentInfos) {
        this.subIndex = subIndex;
        this.version = version;
        this.segmentInfos = segmentInfos;
    }

    public long version() {
        return this.version;
    }

    public int size() {
        return this.segmentInfos.size();
    }

    public LuceneSegmentInfo info(int segmentIndex) {
        return (LuceneSegmentInfo)this.segmentInfos.get(segmentIndex);
    }

    public String getSubIndex() {
        return this.subIndex;
    }

    public static LuceneSubIndexInfo getIndexInfo(String subIndex, CompassSession session) throws IOException {
        LuceneSearchEngine searchEngine = (LuceneSearchEngine)((InternalCompassSession)session).getSearchEngine();
        LuceneSearchEngineIndexManager indexManager = (LuceneSearchEngineIndexManager)searchEngine.getSearchEngineFactory().getIndexManager();
        CompassTransaction tx = null;
        try {
            tx = session.beginTransaction();
            LuceneSubIndexInfo info = LuceneSubIndexInfo.getIndexInfo(subIndex, indexManager);
            tx.commit();
            return info;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.rollback();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    public static LuceneSubIndexInfo getIndexInfo(String subIndex, LuceneSearchEngineIndexManager indexManager) throws IOException {
        Directory directory = indexManager.getStore().getDirectoryBySubIndex(subIndex, false);
        try {
            SegmentInfos segmentInfos = new SegmentInfos();
            segmentInfos.read(directory);
            ArrayList<LuceneSegmentInfo> segmentInfosList = new ArrayList<LuceneSegmentInfo>();
            for (int i = 0; i < segmentInfos.size(); ++i) {
                SegmentInfo segmentInfo = segmentInfos.info(i);
                LuceneSegmentInfo luceneSegmentInfo = new LuceneSegmentInfo(segmentInfo.name, segmentInfo.docCount);
                segmentInfosList.add(luceneSegmentInfo);
            }
            return new LuceneSubIndexInfo(subIndex, segmentInfos.getVersion(), segmentInfosList);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static class LuceneSegmentInfo {
        private String name;
        private int docCount;

        public LuceneSegmentInfo(String name, int docCount) {
            this.name = name;
            this.docCount = docCount;
        }

        public String name() {
            return this.name;
        }

        public int docCount() {
            return this.docCount;
        }
    }
}

